/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.BinaryOperatorNode;
import org.apache.derby.impl.sql.compile.CastNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;

public final class BinaryArithmeticOperatorNode
extends BinaryOperatorNode {
    static final int K_DIVIDE = 0;
    static final int K_MINUS = 1;
    static final int K_PLUS = 2;
    static final int K_TIMES = 3;
    static final int K_MOD = 4;
    final int kind;

    BinaryArithmeticOperatorNode(int n2, ValueNode valueNode, ValueNode valueNode2, ContextManager contextManager) {
        super(valueNode, valueNode2, "org.apache.derby.iapi.types.NumberDataValue", "org.apache.derby.iapi.types.NumberDataValue", contextManager);
        String string;
        String string2;
        this.kind = n2;
        switch (n2) {
            case 0: {
                string2 = "/";
                string = "divide";
                break;
            }
            case 1: {
                string2 = "-";
                string = "minus";
                break;
            }
            case 2: {
                string2 = "+";
                string = "plus";
                break;
            }
            case 3: {
                string2 = "*";
                string = "times";
                break;
            }
            case 4: {
                string2 = "mod";
                string = "mod";
                break;
            }
            default: {
                string2 = null;
                string = null;
            }
        }
        this.setOperator(string2);
        this.setMethodName(string);
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> list) throws StandardException {
        super.bindExpression(fromList, subqueryList, list);
        TypeId typeId = this.leftOperand.getTypeId();
        TypeId typeId2 = this.rightOperand.getTypeId();
        DataTypeDescriptor dataTypeDescriptor = this.leftOperand.getTypeServices();
        DataTypeDescriptor dataTypeDescriptor2 = this.rightOperand.getTypeServices();
        if (typeId.isStringTypeId() && typeId2.isNumericTypeId()) {
            boolean bl2 = dataTypeDescriptor.isNullable() || dataTypeDescriptor2.isNullable();
            int n2 = dataTypeDescriptor2.getPrecision();
            int n3 = dataTypeDescriptor2.getScale();
            int n4 = dataTypeDescriptor2.getMaximumWidth();
            if (typeId2.isDecimalTypeId()) {
                int n5 = dataTypeDescriptor.getMaximumWidth();
                n3 += n5;
                n4 = (n2 += 2 * n5) + 3;
            }
            this.leftOperand = new CastNode(this.leftOperand, new DataTypeDescriptor(typeId2, n2, n3, bl2, n4), this.getContextManager());
            ((CastNode)this.leftOperand).bindCastNodeOnly();
        } else if (typeId2.isStringTypeId() && typeId.isNumericTypeId()) {
            boolean bl3 = dataTypeDescriptor.isNullable() || dataTypeDescriptor2.isNullable();
            int n6 = dataTypeDescriptor.getPrecision();
            int n7 = dataTypeDescriptor.getScale();
            int n8 = dataTypeDescriptor.getMaximumWidth();
            if (typeId.isDecimalTypeId()) {
                int n9 = dataTypeDescriptor2.getMaximumWidth();
                n7 += n9;
                n8 = (n6 += 2 * n9) + 3;
            }
            this.rightOperand = new CastNode(this.rightOperand, new DataTypeDescriptor(typeId, n6, n7, bl3, n8), this.getContextManager());
            ((CastNode)this.rightOperand).bindCastNodeOnly();
        }
        this.setType(this.leftOperand.getTypeCompiler().resolveArithmeticOperation(this.leftOperand.getTypeServices(), this.rightOperand.getTypeServices(), this.operator));
        return this;
    }

    @Override
    boolean isSameNodeKind(ValueNode valueNode) {
        return super.isSameNodeKind(valueNode) && ((BinaryArithmeticOperatorNode)valueNode).kind == this.kind;
    }
}

