/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.impl.sql.compile.AndNode;
import org.apache.derby.impl.sql.compile.BinaryListOperatorNode;
import org.apache.derby.impl.sql.compile.BinaryRelationalOperatorNode;
import org.apache.derby.impl.sql.compile.BooleanConstantNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.OrNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.ValueNodeList;

class BetweenOperatorNode
extends BinaryListOperatorNode {
    BetweenOperatorNode(ValueNode valueNode, ValueNodeList valueNodeList, ContextManager contextManager) throws StandardException {
        super(valueNode, BetweenOperatorNode.vetValues(valueNodeList), "BETWEEN", null, contextManager);
    }

    private static ValueNodeList vetValues(ValueNodeList valueNodeList) {
        return valueNodeList;
    }

    @Override
    ValueNode eliminateNots(boolean bl2) throws StandardException {
        if (!bl2) {
            return this;
        }
        ContextManager contextManager = this.getContextManager();
        BinaryRelationalOperatorNode binaryRelationalOperatorNode = new BinaryRelationalOperatorNode(4, this.leftOperand, (ValueNode)this.rightOperandList.elementAt(0), false, contextManager);
        binaryRelationalOperatorNode.bindComparisonOperator();
        ValueNode valueNode = this.leftOperand instanceof ColumnReference ? this.leftOperand.getClone() : this.leftOperand;
        BinaryRelationalOperatorNode binaryRelationalOperatorNode2 = new BinaryRelationalOperatorNode(2, valueNode, (ValueNode)this.rightOperandList.elementAt(1), false, contextManager);
        binaryRelationalOperatorNode2.bindComparisonOperator();
        OrNode orNode = new OrNode(binaryRelationalOperatorNode, binaryRelationalOperatorNode2, contextManager);
        orNode.postBindFixup();
        binaryRelationalOperatorNode.setBetweenSelectivity();
        binaryRelationalOperatorNode2.setBetweenSelectivity();
        return orNode;
    }

    @Override
    ValueNode preprocess(int n2, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        super.preprocess(n2, fromList, subqueryList, predicateList);
        if (!(this.leftOperand instanceof ColumnReference)) {
            return this;
        }
        ValueNode valueNode = this.leftOperand.getClone();
        ContextManager contextManager = this.getContextManager();
        BooleanConstantNode booleanConstantNode = new BooleanConstantNode(true, contextManager);
        BinaryRelationalOperatorNode binaryRelationalOperatorNode = new BinaryRelationalOperatorNode(3, valueNode, (ValueNode)this.rightOperandList.elementAt(1), false, contextManager);
        binaryRelationalOperatorNode.bindComparisonOperator();
        AndNode andNode = new AndNode(binaryRelationalOperatorNode, booleanConstantNode, contextManager);
        andNode.postBindFixup();
        BinaryRelationalOperatorNode binaryRelationalOperatorNode2 = new BinaryRelationalOperatorNode(1, this.leftOperand, (ValueNode)this.rightOperandList.elementAt(0), false, contextManager);
        binaryRelationalOperatorNode2.bindComparisonOperator();
        andNode = new AndNode(binaryRelationalOperatorNode2, andNode, contextManager);
        andNode.postBindFixup();
        binaryRelationalOperatorNode.setBetweenSelectivity();
        binaryRelationalOperatorNode2.setBetweenSelectivity();
        return andNode;
    }

    @Override
    void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        ContextManager contextManager = this.getContextManager();
        BinaryRelationalOperatorNode binaryRelationalOperatorNode = new BinaryRelationalOperatorNode(1, this.leftOperand, (ValueNode)this.rightOperandList.elementAt(0), false, contextManager);
        binaryRelationalOperatorNode.bindComparisonOperator();
        BinaryRelationalOperatorNode binaryRelationalOperatorNode2 = new BinaryRelationalOperatorNode(3, this.leftOperand, (ValueNode)this.rightOperandList.elementAt(1), false, contextManager);
        binaryRelationalOperatorNode2.bindComparisonOperator();
        AndNode andNode = new AndNode(binaryRelationalOperatorNode, binaryRelationalOperatorNode2, contextManager);
        andNode.postBindFixup();
        andNode.generateExpression(expressionClassBuilder, methodBuilder);
    }
}

