/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.ColumnDefinitionNode;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.TableElementList;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.execute.ColumnInfo;
import org.apache.derby.impl.sql.execute.ConstraintConstantAction;
import org.apache.derby.impl.sql.execute.CreateConstraintConstantAction;

class AlterTableNode
extends DDLStatementNode {
    public TableElementList tableElementList = null;
    char lockGranularity;
    private boolean updateStatistics = false;
    private boolean updateStatisticsAll = false;
    private boolean dropStatistics;
    private boolean dropStatisticsAll;
    private String indexNameForStatistics;
    public boolean compressTable = false;
    public boolean sequential = false;
    public boolean purge = false;
    public boolean defragment = false;
    public boolean truncateEndOfTable = false;
    public int behavior;
    public TableDescriptor baseTable;
    protected int numConstraints;
    private int changeType = 0;
    private boolean truncateTable = false;
    protected SchemaDescriptor schemaDescriptor = null;
    protected ColumnInfo[] colInfos = null;
    protected ConstraintConstantAction[] conActions = null;

    AlterTableNode(TableName tableName, ContextManager contextManager) throws StandardException {
        super(tableName, contextManager);
        this.truncateTable = true;
        this.schemaDescriptor = this.getSchemaDescriptor();
    }

    AlterTableNode(TableName tableName, boolean bl2, ContextManager contextManager) throws StandardException {
        super(tableName, contextManager);
        this.sequential = bl2;
        this.compressTable = true;
        this.schemaDescriptor = this.getSchemaDescriptor();
    }

    AlterTableNode(TableName tableName, boolean bl2, boolean bl3, boolean bl4, ContextManager contextManager) throws StandardException {
        super(tableName, contextManager);
        this.purge = bl2;
        this.defragment = bl3;
        this.truncateEndOfTable = bl4;
        this.compressTable = true;
        this.schemaDescriptor = this.getSchemaDescriptor(true, false);
    }

    AlterTableNode(TableName tableName, int n2, boolean bl2, String string, ContextManager contextManager) throws StandardException {
        super(tableName, contextManager);
        this.changeType = n2;
        this.indexNameForStatistics = string;
        switch (n2) {
            case 5: {
                this.updateStatisticsAll = bl2;
                this.updateStatistics = true;
                break;
            }
            case 6: {
                this.dropStatisticsAll = bl2;
                this.dropStatistics = true;
                break;
            }
        }
        this.schemaDescriptor = this.getSchemaDescriptor();
    }

    AlterTableNode(TableName tableName, int n2, TableElementList tableElementList, char c2, int n3, ContextManager contextManager) throws StandardException {
        super(tableName, contextManager);
        this.changeType = n2;
        switch (n2) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.tableElementList = tableElementList;
                this.lockGranularity = c2;
                this.behavior = n3;
                break;
            }
        }
        this.schemaDescriptor = this.getSchemaDescriptor();
    }

    @Override
    public String toString() {
        return "";
    }

    @Override
    void printSubNodes(int n2) {
    }

    @Override
    public String statementToString() {
        if (this.truncateTable) {
            return "TRUNCATE TABLE";
        }
        return "ALTER TABLE";
    }

    public int getChangeType() {
        return this.changeType;
    }

    @Override
    public void bindStatement() throws StandardException {
        Object object;
        DataDictionary dataDictionary = this.getDataDictionary();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        this.baseTable = this.compressTable && (this.purge || this.defragment || this.truncateEndOfTable) ? this.getTableDescriptor(false) : this.getTableDescriptor();
        if (this.baseTable.getTableType() == 3) {
            throw StandardException.newException("42995", new Object[0]);
        }
        this.getCompilerContext().createDependency(this.baseTable);
        if (this.changeType == 1 && this.tableElementList != null) {
            for (int i2 = 0; i2 < this.tableElementList.size(); ++i2) {
                if (!(this.tableElementList.elementAt(i2) instanceof ColumnDefinitionNode) || ((ColumnDefinitionNode)(object = (ColumnDefinitionNode)this.tableElementList.elementAt(i2))).hasGenerationClause() && ((ColumnDefinitionNode)object).getType() == null) continue;
                if (((ColumnDefinitionNode)object).getType() == null) {
                    throw StandardException.newException("42XA9", ((ColumnDefinitionNode)object).getColumnName());
                }
                if (!((ColumnDefinitionNode)object).getType().getTypeId().isStringTypeId()) continue;
                ((ColumnDefinitionNode)object).setCollationType(this.schemaDescriptor.getCollationType());
            }
        }
        if (this.tableElementList != null) {
            this.tableElementList.validate(this, dataDictionary, this.baseTable);
            if (this.tableElementList.countNumberOfColumns() + this.baseTable.getNumberOfColumns() > 1012) {
                throw StandardException.newException("54011", String.valueOf(this.tableElementList.countNumberOfColumns() + this.baseTable.getNumberOfColumns()), this.getRelativeName(), String.valueOf(1012));
            }
            n5 = this.tableElementList.countConstraints(2) + this.tableElementList.countConstraints(6) + this.tableElementList.countConstraints(3);
            n2 = this.tableElementList.countConstraints(4);
            n3 = this.tableElementList.countConstraints(6);
            n4 = this.tableElementList.countGenerationClauses();
        }
        if (n5 + this.baseTable.getTotalNumberOfIndexes() > Short.MAX_VALUE) {
            throw StandardException.newException("42Z9F", String.valueOf(n5 + this.baseTable.getTotalNumberOfIndexes()), this.getRelativeName(), String.valueOf(Short.MAX_VALUE));
        }
        if (n2 > 0 || n4 > 0 || n3 > 0) {
            FromList fromList = this.makeFromList(dataDictionary, this.tableElementList, false);
            object = this.baseTable.makeColumnMap(this.baseTable.getGeneratedColumns());
            if (n4 > 0) {
                this.tableElementList.bindAndValidateGenerationClauses(this.schemaDescriptor, fromList, (FormatableBitSet)object, this.baseTable);
            }
            if (n2 > 0) {
                this.tableElementList.bindAndValidateCheckConstraints(fromList);
            }
            if (n3 > 0) {
                this.tableElementList.validateForeignKeysOnGenerationClauses(fromList, (FormatableBitSet)object);
            }
        }
        if (this.tableElementList != null) {
            this.tableElementList.validatePrimaryKeyNullability();
        }
        if (this.updateStatistics && !this.updateStatisticsAll || this.dropStatistics && !this.dropStatisticsAll) {
            ConglomerateDescriptor conglomerateDescriptor = null;
            if (this.schemaDescriptor.getUUID() != null) {
                conglomerateDescriptor = dataDictionary.getConglomerateDescriptor(this.indexNameForStatistics, this.schemaDescriptor, false);
            }
            if (conglomerateDescriptor == null) {
                throw StandardException.newException("42X65", this.schemaDescriptor.getSchemaName() + "." + this.indexNameForStatistics);
            }
        }
        this.getCompilerContext().createDependency(this.baseTable);
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        return AlterTableNode.isSessionSchema(this.baseTable.getSchemaName());
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        this.prepConstantAction();
        return this.getGenericConstantActionFactory().getAlterTableConstantAction(this.schemaDescriptor, this.getRelativeName(), this.baseTable.getUUID(), this.baseTable.getHeapConglomerateId(), 0, this.colInfos, this.conActions, this.lockGranularity, this.compressTable, this.behavior, this.sequential, this.truncateTable, this.purge, this.defragment, this.truncateEndOfTable, this.updateStatistics, this.updateStatisticsAll, this.dropStatistics, this.dropStatisticsAll, this.indexNameForStatistics);
    }

    private void prepConstantAction() throws StandardException {
        if (this.tableElementList != null) {
            this.genColumnInfo();
        }
        if (this.numConstraints > 0) {
            this.conActions = new ConstraintConstantAction[this.numConstraints];
            this.tableElementList.genConstraintActions(false, this.conActions, this.getRelativeName(), this.schemaDescriptor, this.getDataDictionary());
            for (int i2 = 0; i2 < this.conActions.length; ++i2) {
                DataDictionary dataDictionary;
                ConstraintDescriptorList constraintDescriptorList;
                int n2;
                ConstraintConstantAction constraintConstantAction = this.conActions[i2];
                if (!(constraintConstantAction instanceof CreateConstraintConstantAction) || (n2 = constraintConstantAction.getConstraintType()) != 2 || (constraintDescriptorList = (dataDictionary = this.getDataDictionary()).getConstraintDescriptors(this.baseTable)).getPrimaryKey() == null) continue;
                throw StandardException.newException("X0Y58.S", this.baseTable.getQualifiedName());
            }
        }
    }

    public void genColumnInfo() throws StandardException {
        this.colInfos = new ColumnInfo[this.tableElementList.countNumberOfColumns()];
        this.numConstraints = this.tableElementList.genColumnInfos(this.colInfos);
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.tableElementList != null) {
            this.tableElementList.accept(visitor);
        }
    }
}

