/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.AccessPath;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.JoinStrategy;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;

class AccessPathImpl
implements AccessPath {
    ConglomerateDescriptor cd = null;
    private CostEstimate costEstimate = null;
    boolean coveringIndexScan = false;
    boolean nonMatchingIndexScan = false;
    JoinStrategy joinStrategy = null;
    int lockMode;
    Optimizer optimizer;
    private String accessPathName = "";

    AccessPathImpl(Optimizer optimizer) {
        this.optimizer = optimizer;
    }

    @Override
    public void setConglomerateDescriptor(ConglomerateDescriptor conglomerateDescriptor) {
        this.cd = conglomerateDescriptor;
    }

    @Override
    public ConglomerateDescriptor getConglomerateDescriptor() {
        return this.cd;
    }

    @Override
    public void setCostEstimate(CostEstimate costEstimate) {
        if (this.costEstimate == null) {
            if (costEstimate != null) {
                this.costEstimate = costEstimate.cloneMe();
            }
        } else if (costEstimate == null) {
            this.costEstimate = null;
        } else {
            this.costEstimate.setCost(costEstimate);
        }
    }

    @Override
    public CostEstimate getCostEstimate() {
        return this.costEstimate;
    }

    @Override
    public void setCoveringIndexScan(boolean bl2) {
        this.coveringIndexScan = bl2;
    }

    @Override
    public boolean getCoveringIndexScan() {
        return this.coveringIndexScan;
    }

    @Override
    public void setNonMatchingIndexScan(boolean bl2) {
        this.nonMatchingIndexScan = bl2;
    }

    @Override
    public boolean getNonMatchingIndexScan() {
        return this.nonMatchingIndexScan;
    }

    @Override
    public void setJoinStrategy(JoinStrategy joinStrategy) {
        this.joinStrategy = joinStrategy;
    }

    @Override
    public JoinStrategy getJoinStrategy() {
        return this.joinStrategy;
    }

    @Override
    public void setLockMode(int n2) {
        this.lockMode = n2;
    }

    @Override
    public int getLockMode() {
        return this.lockMode;
    }

    @Override
    public void copy(AccessPath accessPath) {
        this.setConglomerateDescriptor(accessPath.getConglomerateDescriptor());
        this.setCostEstimate(accessPath.getCostEstimate());
        this.setCoveringIndexScan(accessPath.getCoveringIndexScan());
        this.setNonMatchingIndexScan(accessPath.getNonMatchingIndexScan());
        this.setJoinStrategy(accessPath.getJoinStrategy());
        this.setLockMode(accessPath.getLockMode());
    }

    @Override
    public Optimizer getOptimizer() {
        return this.optimizer;
    }

    public String toString() {
        return "";
    }

    @Override
    public void initializeAccessPathName(DataDictionary dataDictionary, TableDescriptor tableDescriptor) throws StandardException {
        if (this.cd == null) {
            return;
        }
        if (this.cd.isConstraint()) {
            ConstraintDescriptor constraintDescriptor = dataDictionary.getConstraintDescriptor(tableDescriptor, this.cd.getUUID());
            if (constraintDescriptor == null) {
                throw StandardException.newException("42X94", "CONSTRAINT on TABLE", tableDescriptor.getName());
            }
            this.accessPathName = constraintDescriptor.getConstraintName();
        } else {
            this.accessPathName = this.cd.isIndex() ? this.cd.getConglomerateName() : "";
        }
    }
}

