/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.StreamStorable;
import org.apache.derby.iapi.sql.dictionary.CatalogRowFactory;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.RowChanger;
import org.apache.derby.iapi.sql.execute.TupleFilter;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.catalog.IndexInfoImpl;

class TabInfoImpl {
    static final int ROWNOTDUPLICATE = -1;
    private IndexInfoImpl[] indexes;
    private long heapConglomerate = -1L;
    private int numIndexesSet;
    private boolean heapSet;
    private final CatalogRowFactory crf;
    private boolean computedStreamStorableHeapColIds = false;
    private int[] streamStorableHeapColIds;

    TabInfoImpl(CatalogRowFactory catalogRowFactory) {
        this.crf = catalogRowFactory;
        int n2 = catalogRowFactory.getNumIndexes();
        if (n2 > 0) {
            this.indexes = new IndexInfoImpl[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                this.indexes[i2] = new IndexInfoImpl(i2, catalogRowFactory);
            }
        }
    }

    long getHeapConglomerate() {
        return this.heapConglomerate;
    }

    void setHeapConglomerate(long l2) {
        this.heapConglomerate = l2;
        this.heapSet = true;
    }

    long getIndexConglomerate(int n2) {
        return this.indexes[n2].getConglomerateNumber();
    }

    void setIndexConglomerate(int n2, long l2) {
        this.indexes[n2].setConglomerateNumber(l2);
        ++this.numIndexesSet;
    }

    void setIndexConglomerate(ConglomerateDescriptor conglomerateDescriptor) {
        String string = conglomerateDescriptor.getConglomerateName();
        for (int i2 = 0; i2 < this.indexes.length; ++i2) {
            if (!this.indexes[i2].getIndexName().equals(string)) continue;
            this.indexes[i2].setConglomerateNumber(conglomerateDescriptor.getConglomerateNumber());
            break;
        }
        ++this.numIndexesSet;
    }

    String getTableName() {
        return this.crf.getCatalogName();
    }

    String getIndexName(int n2) {
        return this.indexes[n2].getIndexName();
    }

    CatalogRowFactory getCatalogRowFactory() {
        return this.crf;
    }

    boolean isComplete() {
        if (!this.heapSet) {
            return false;
        }
        return this.indexes == null || this.indexes.length == this.numIndexesSet;
    }

    int getIndexColumnCount(int n2) {
        return this.indexes[n2].getColumnCount();
    }

    IndexRowGenerator getIndexRowGenerator(int n2) {
        return this.indexes[n2].getIndexRowGenerator();
    }

    void setIndexRowGenerator(int n2, IndexRowGenerator indexRowGenerator) {
        this.indexes[n2].setIndexRowGenerator(indexRowGenerator);
    }

    int getNumberOfIndexes() {
        if (this.indexes == null) {
            return 0;
        }
        return this.indexes.length;
    }

    int getBaseColumnPosition(int n2, int n3) {
        return this.indexes[n2].getBaseColumnPosition(n3);
    }

    boolean isIndexUnique(int n2) {
        return this.indexes[n2].isIndexUnique();
    }

    int insertRow(ExecRow execRow, TransactionController transactionController) throws StandardException {
        RowLocation[] rowLocationArray = new RowLocation[1];
        return this.insertRowListImpl(new ExecRow[]{execRow}, transactionController, rowLocationArray);
    }

    int insertRowList(ExecRow[] execRowArray, TransactionController transactionController) throws StandardException {
        RowLocation[] rowLocationArray = new RowLocation[1];
        return this.insertRowListImpl(execRowArray, transactionController, rowLocationArray);
    }

    private int insertRowListImpl(ExecRow[] execRowArray, TransactionController transactionController, RowLocation[] rowLocationArray) throws StandardException {
        RowLocation rowLocation;
        int n2;
        int n3 = -1;
        int n4 = this.crf.getNumIndexes();
        ConglomerateController[] conglomerateControllerArray = new ConglomerateController[n4];
        ConglomerateController conglomerateController = transactionController.openConglomerate(this.getHeapConglomerate(), false, 4, 6, 4);
        for (n2 = 0; n2 < n4; ++n2) {
            long l2 = this.getIndexConglomerate(n2);
            if (l2 <= -1L) continue;
            conglomerateControllerArray[n2] = transactionController.openConglomerate(l2, false, 4, 6, 4);
        }
        rowLocationArray[0] = rowLocation = conglomerateController.newRowLocationTemplate();
        for (n2 = 0; n2 < execRowArray.length; ++n2) {
            ExecRow execRow = execRowArray[n2];
            conglomerateController.insertAndFetchLocation(execRow.getRowArray(), rowLocation);
            for (int i2 = 0; i2 < n4; ++i2) {
                ExecIndexRow execIndexRow;
                int n5;
                if (conglomerateControllerArray[i2] == null || (n5 = conglomerateControllerArray[i2].insert((execIndexRow = this.getIndexRowFromHeapRow(this.getIndexRowGenerator(i2), rowLocation, execRow)).getRowArray())) != 1) continue;
                n3 = n2;
            }
        }
        for (n2 = 0; n2 < n4; ++n2) {
            if (conglomerateControllerArray[n2] == null) continue;
            conglomerateControllerArray[n2].close();
        }
        conglomerateController.close();
        return n3;
    }

    int deleteRow(TransactionController transactionController, ExecIndexRow execIndexRow, int n2) throws StandardException {
        return this.deleteRows(transactionController, execIndexRow, 1, null, null, execIndexRow, -1, n2, true);
    }

    int deleteRow(TransactionController transactionController, ExecIndexRow execIndexRow, int n2, boolean bl2) throws StandardException {
        return this.deleteRows(transactionController, execIndexRow, 1, null, null, execIndexRow, -1, n2, bl2);
    }

    int deleteRows(TransactionController transactionController, ExecIndexRow execIndexRow, int n2, Qualifier[][] qualifierArray, TupleFilter tupleFilter, ExecIndexRow execIndexRow2, int n3, int n4) throws StandardException {
        return this.deleteRows(transactionController, execIndexRow, n2, qualifierArray, tupleFilter, execIndexRow2, n3, n4, true);
    }

    private int deleteRows(TransactionController transactionController, ExecIndexRow execIndexRow, int n2, Qualifier[][] qualifierArray, TupleFilter tupleFilter, ExecIndexRow execIndexRow2, int n3, int n4, boolean bl2) throws StandardException {
        ExecRow execRow = this.crf.makeEmptyRow();
        int n5 = 0;
        boolean bl3 = true;
        RowChanger rowChanger = this.getRowChanger(transactionController, null, execRow);
        int n6 = execIndexRow != null && execIndexRow2 != null ? 6 : 7;
        int n7 = execIndexRow != null && execIndexRow2 != null && execIndexRow == execIndexRow2 ? 4 : 5;
        rowChanger.open(n6, bl2);
        DataValueDescriptor[] dataValueDescriptorArray = execIndexRow == null ? null : execIndexRow.getRowArray();
        DataValueDescriptor[] dataValueDescriptorArray2 = execIndexRow2 == null ? null : execIndexRow2.getRowArray();
        ConglomerateController conglomerateController = transactionController.openConglomerate(this.getHeapConglomerate(), false, 4 | (bl2 ? 0 : 128), n6, 4);
        ScanController scanController = transactionController.openScan(this.getIndexConglomerate(n4), false, 4 | (bl2 ? 0 : 128), n6, n7, null, dataValueDescriptorArray, n2, qualifierArray, dataValueDescriptorArray2, n3);
        ExecIndexRow execIndexRow3 = this.getIndexRowFromHeapRow(this.getIndexRowGenerator(n4), conglomerateController.newRowLocationTemplate(), this.crf.makeEmptyRow());
        while (scanController.fetchNext(execIndexRow3.getRowArray())) {
            RowLocation rowLocation = (RowLocation)execIndexRow3.getColumn(execIndexRow3.nColumns());
            boolean bl4 = conglomerateController.fetch(rowLocation, execRow.getRowArray(), null);
            if (tupleFilter != null) {
                bl3 = tupleFilter.execute(execRow).equals(true);
            }
            if (!bl3) continue;
            rowChanger.deleteRow(execRow, rowLocation);
            ++n5;
        }
        conglomerateController.close();
        scanController.close();
        rowChanger.close();
        return n5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExecRow getRow(TransactionController transactionController, ExecIndexRow execIndexRow, int n2) throws StandardException {
        try (ConglomerateController conglomerateController = transactionController.openConglomerate(this.getHeapConglomerate(), false, 0, 6, 4);){
            ExecRow execRow = this.getRow(transactionController, conglomerateController, execIndexRow, n2);
            return execRow;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RowLocation getRowLocation(TransactionController transactionController, ExecIndexRow execIndexRow, int n2) throws StandardException {
        try (ConglomerateController conglomerateController = transactionController.openConglomerate(this.getHeapConglomerate(), false, 0, 6, 4);){
            RowLocation[] rowLocationArray = new RowLocation[1];
            ExecRow execRow = this.getRowInternal(transactionController, conglomerateController, execIndexRow, n2, rowLocationArray);
            RowLocation rowLocation = rowLocationArray[0];
            return rowLocation;
        }
    }

    ExecRow getRow(TransactionController transactionController, ConglomerateController conglomerateController, ExecIndexRow execIndexRow, int n2) throws StandardException {
        RowLocation[] rowLocationArray = new RowLocation[1];
        return this.getRowInternal(transactionController, conglomerateController, execIndexRow, n2, rowLocationArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecRow getRowInternal(TransactionController transactionController, ConglomerateController conglomerateController, ExecIndexRow execIndexRow, int n2, RowLocation[] rowLocationArray) throws StandardException {
        ExecRow execRow = this.crf.makeEmptyRow();
        ScanController scanController = transactionController.openScan(this.getIndexConglomerate(n2), false, 0, 6, 4, null, execIndexRow.getRowArray(), 1, null, execIndexRow.getRowArray(), -1);
        ExecIndexRow execIndexRow2 = this.getIndexRowFromHeapRow(this.getIndexRowGenerator(n2), conglomerateController.newRowLocationTemplate(), this.crf.makeEmptyRow());
        try {
            if (scanController.fetchNext(execIndexRow2.getRowArray())) {
                RowLocation rowLocation;
                rowLocationArray[0] = rowLocation = (RowLocation)execIndexRow2.getColumn(execIndexRow2.nColumns());
                boolean bl2 = conglomerateController.fetch(rowLocation, execRow.getRowArray(), null);
                ExecRow execRow2 = execRow;
                return execRow2;
            }
            ExecRow execRow3 = null;
            return execRow3;
        }
        finally {
            scanController.close();
        }
    }

    void updateRow(ExecIndexRow execIndexRow, ExecRow execRow, int n2, boolean[] blArray, int[] nArray, TransactionController transactionController) throws StandardException {
        ExecRow[] execRowArray = new ExecRow[]{execRow};
        this.updateRow(execIndexRow, execRowArray, n2, blArray, nArray, transactionController);
    }

    void updateRow(ExecIndexRow execIndexRow, ExecRow[] execRowArray, int n2, boolean[] blArray, int[] nArray, TransactionController transactionController) throws StandardException {
        ExecRow execRow = this.crf.makeEmptyRow();
        RowChanger rowChanger = this.getRowChanger(transactionController, nArray, execRow);
        rowChanger.openForUpdate(blArray, 6, true);
        ConglomerateController conglomerateController = transactionController.openConglomerate(this.getHeapConglomerate(), false, 4, 6, 4);
        ScanController scanController = transactionController.openScan(this.getIndexConglomerate(n2), false, 4, 6, 4, null, execIndexRow.getRowArray(), 1, null, execIndexRow.getRowArray(), -1);
        ExecIndexRow execIndexRow2 = this.getIndexRowFromHeapRow(this.getIndexRowGenerator(n2), conglomerateController.newRowLocationTemplate(), this.crf.makeEmptyRow());
        int n3 = 0;
        while (scanController.fetchNext(execIndexRow2.getRowArray())) {
            RowLocation rowLocation = (RowLocation)execIndexRow2.getColumn(execIndexRow2.nColumns());
            boolean bl2 = conglomerateController.fetch(rowLocation, execRow.getRowArray(), null);
            rowChanger.updateRow(execRow, n3 == execRowArray.length - 1 ? execRowArray[n3] : execRowArray[n3++], rowLocation);
        }
        rowChanger.finish();
        conglomerateController.close();
        scanController.close();
        rowChanger.close();
    }

    Properties getCreateHeapProperties() {
        return this.crf.getCreateHeapProperties();
    }

    Properties getCreateIndexProperties(int n2) {
        return this.crf.getCreateIndexProperties(n2);
    }

    private RowChanger getRowChanger(TransactionController transactionController, int[] nArray, ExecRow execRow) throws StandardException {
        int n2 = this.crf.getNumIndexes();
        IndexRowGenerator[] indexRowGeneratorArray = new IndexRowGenerator[n2];
        long[] lArray = new long[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            indexRowGeneratorArray[i2] = this.getIndexRowGenerator(i2);
            lArray[i2] = this.getIndexConglomerate(i2);
        }
        RowChanger rowChanger = this.crf.getExecutionFactory().getRowChanger(this.getHeapConglomerate(), null, null, indexRowGeneratorArray, lArray, null, null, this.crf.getHeapColumnCount(), transactionController, nArray, this.getStreamStorableHeapColIds(execRow), null);
        return rowChanger;
    }

    private int[] getStreamStorableHeapColIds(ExecRow execRow) throws StandardException {
        if (!this.computedStreamStorableHeapColIds) {
            int n2;
            int n3 = 0;
            DataValueDescriptor[] dataValueDescriptorArray = execRow.getRowArray();
            for (n2 = 0; n2 < dataValueDescriptorArray.length; ++n2) {
                if (!(dataValueDescriptorArray[n2] instanceof StreamStorable)) continue;
                ++n3;
            }
            if (n3 > 0) {
                this.streamStorableHeapColIds = new int[n3];
                n2 = 0;
                for (int i2 = 0; i2 < dataValueDescriptorArray.length; ++i2) {
                    if (!(dataValueDescriptorArray[i2] instanceof StreamStorable)) continue;
                    this.streamStorableHeapColIds[n2++] = i2;
                }
            }
            this.computedStreamStorableHeapColIds = true;
        }
        return this.streamStorableHeapColIds;
    }

    private ExecIndexRow getIndexRowFromHeapRow(IndexRowGenerator indexRowGenerator, RowLocation rowLocation, ExecRow execRow) throws StandardException {
        ExecIndexRow execIndexRow = indexRowGenerator.getIndexRowTemplate();
        indexRowGenerator.getIndexRow(execRow, rowLocation, execIndexRow, null);
        return execIndexRow;
    }

    public String toString() {
        return "";
    }
}

