/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import org.apache.derby.catalog.SequencePreallocator;
import org.apache.derby.iapi.error.StandardException;

public class SequenceGenerator {
    private static final int PREALLOCATION_THRESHHOLD = 1;
    public static final int RET_I_AM_CONFUSED = 0;
    public static final int RET_OK = 1;
    public static final int RET_MARK_EXHAUSTED = 2;
    public static final int RET_ALLOCATE_NEW_VALUES = 3;
    public static final int CVAA_STATUS = 0;
    public static final int CVAA_CURRENT_VALUE = 1;
    public static final int CVAA_LAST_ALLOCATED_VALUE = 2;
    public static final int CVAA_NUMBER_OF_VALUES_ALLOCATED = 3;
    public static final int CVAA_LENGTH = 4;
    private final boolean _CAN_CYCLE;
    private final boolean _STEP_INCREASES;
    private final long _INCREMENT;
    private final long _MAX_VALUE;
    private final long _MIN_VALUE;
    private final long _RESTART_VALUE;
    private final String _SCHEMA_NAME;
    private final String _SEQUENCE_NAME;
    private final SequencePreallocator _PREALLOCATOR;
    private boolean _isExhausted;
    private long _currentValue;
    private long _remainingPreallocatedValues;

    public SequenceGenerator(Long l2, boolean bl2, long l3, long l4, long l5, long l6, String string, String string2, SequencePreallocator sequencePreallocator) {
        if (l2 == null) {
            this._isExhausted = true;
            this._currentValue = 0L;
        } else {
            this._isExhausted = false;
            this._currentValue = l2;
        }
        this._CAN_CYCLE = bl2;
        this._INCREMENT = l3;
        this._MAX_VALUE = l4;
        this._MIN_VALUE = l5;
        this._RESTART_VALUE = l6;
        this._STEP_INCREASES = this._INCREMENT > 0L;
        this._SCHEMA_NAME = string;
        this._SEQUENCE_NAME = string2;
        this._PREALLOCATOR = sequencePreallocator;
        this._remainingPreallocatedValues = 1L;
    }

    public synchronized SequenceGenerator clone(boolean bl2) {
        Object object = bl2 ? Long.valueOf(this._RESTART_VALUE) : (this._isExhausted ? null : Long.valueOf(this._currentValue));
        return new SequenceGenerator((Long)object, this._CAN_CYCLE, this._INCREMENT, this._MAX_VALUE, this._MIN_VALUE, this._RESTART_VALUE, this._SCHEMA_NAME, this._SEQUENCE_NAME, this._PREALLOCATOR);
    }

    public synchronized SequenceGenerator clone(Long l2) {
        return new SequenceGenerator(l2, this._CAN_CYCLE, this._INCREMENT, this._MAX_VALUE, this._MIN_VALUE, this._RESTART_VALUE, this._SCHEMA_NAME, this._SEQUENCE_NAME, this._PREALLOCATOR);
    }

    public synchronized String getSchemaName() {
        return this._SCHEMA_NAME;
    }

    public synchronized String getName() {
        return this._SEQUENCE_NAME;
    }

    public synchronized void allocateNewRange(long l2, long l3) {
        if (this._currentValue == l2) {
            this._remainingPreallocatedValues = l3;
        }
    }

    public synchronized Long peekAtCurrentValue() {
        Long l2 = null;
        if (!this._isExhausted) {
            l2 = this._currentValue;
        }
        return l2;
    }

    public synchronized long[] getCurrentValueAndAdvance() throws StandardException {
        if (this._isExhausted) {
            throw StandardException.newException("2200H.S", this._SCHEMA_NAME, this._SEQUENCE_NAME);
        }
        long[] lArray = new long[4];
        lArray[0] = 0L;
        lArray[1] = this._currentValue;
        this.advanceValue(lArray);
        return lArray;
    }

    private void advanceValue(long[] lArray) throws StandardException {
        long l2 = this._currentValue + this._INCREMENT;
        if (this.overflowed(this._currentValue, l2)) {
            if (!this._CAN_CYCLE) {
                this.markExhausted(lArray);
                return;
            }
            l2 = this._INCREMENT > 0L ? this._MIN_VALUE : this._MAX_VALUE;
        }
        --this._remainingPreallocatedValues;
        if (this._remainingPreallocatedValues < 1L) {
            this.computeNewAllocation(this._currentValue, lArray);
            return;
        }
        this._currentValue = l2;
        lArray[0] = 1L;
    }

    private void markExhausted(long[] lArray) {
        this._isExhausted = true;
        lArray[0] = 2L;
    }

    private boolean overflowed(long l2, long l3) {
        boolean bl2;
        boolean bl3 = bl2 = this._STEP_INCREASES == l3 < l2;
        if (!bl2) {
            bl2 = this._STEP_INCREASES ? l3 > this._MAX_VALUE : l3 < this._MIN_VALUE;
        }
        return bl2;
    }

    private void computeNewAllocation(long l2, long[] lArray) throws StandardException {
        long l3;
        long l4;
        int n2 = this.computePreAllocationCount();
        long l5 = this.computeRemainingValues(l2);
        if (l5 >= (long)n2) {
            l4 = l2 + (long)n2 * this._INCREMENT;
            l3 = n2;
        } else if (this._CAN_CYCLE) {
            long l6 = (long)n2 - l5;
            l4 = this._RESTART_VALUE + --l6 * this._INCREMENT;
            l3 = n2;
        } else {
            if (l5 <= 0L) {
                this.markExhausted(lArray);
                return;
            }
            l3 = l5;
            l4 = l2 + l3 * this._INCREMENT;
        }
        lArray[3] = l3 + 1L;
        lArray[2] = l4;
        lArray[0] = 3L;
    }

    private long computeRemainingValues(long l2) {
        long l3;
        long l4 = l3 = this._STEP_INCREASES ? this._MAX_VALUE - l2 : -(this._MIN_VALUE - l2);
        if (l3 < 0L) {
            l3 = Long.MAX_VALUE;
        }
        long l5 = this._STEP_INCREASES ? this._INCREMENT : -this._INCREMENT;
        return l3 / l5;
    }

    private int computePreAllocationCount() {
        double d2;
        int n2;
        int n3 = this._PREALLOCATOR.nextRangeSize(this._SCHEMA_NAME, this._SEQUENCE_NAME);
        if (n3 < (n2 = 1)) {
            return n2;
        }
        double d3 = this._MIN_VALUE;
        double d4 = this._MAX_VALUE;
        double d5 = d4 - d3;
        double d6 = this._INCREMENT;
        if (d6 < 0.0) {
            d6 = -d6;
        }
        if ((d2 = d6 * (double)n3) > 9.223372036854776E18) {
            return n2;
        }
        if (d2 > d5) {
            return n2;
        }
        return n3;
    }
}

