/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import java.sql.Timestamp;
import org.apache.derby.catalog.Statistics;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.dictionary.CatalogRowFactory;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.StatisticsDescriptor;
import org.apache.derby.iapi.sql.dictionary.SystemColumn;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.SQLBoolean;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.iapi.types.SQLInteger;
import org.apache.derby.iapi.types.SQLTimestamp;
import org.apache.derby.iapi.types.UserType;
import org.apache.derby.impl.sql.catalog.SystemColumnImpl;

public class SYSSTATISTICSRowFactory
extends CatalogRowFactory {
    static final String TABLENAME_STRING = "SYSSTATISTICS";
    protected static final int SYSSTATISTICS_ID = 1;
    protected static final int SYSSTATISTICS_REFERENCEID = 2;
    protected static final int SYSSTATISTICS_TABLEID = 3;
    protected static final int SYSSTATISTICS_TIMESTAMP = 4;
    protected static final int SYSSTATISTICS_TYPE = 5;
    protected static final int SYSSTATISTICS_VALID = 6;
    protected static final int SYSSTATISTICS_COLCOUNT = 7;
    protected static final int SYSSTATISTICS_STAT = 8;
    protected static final int SYSSTATISTICS_COLUMN_COUNT = 8;
    protected static final int SYSSTATISTICS_INDEX1_ID = 0;
    private static final boolean[] uniqueness = new boolean[]{false};
    private static final int[][] indexColumnPositions = new int[][]{{3, 2}};
    private static final String[] uuids = new String[]{"f81e0010-00e3-6612-5a96-009e3a3b5e00", "08264012-00e3-6612-5a96-009e3a3b5e00", "c013800d-00e3-ffbe-37c6-009e3a3b5e00"};

    SYSSTATISTICSRowFactory(UUIDFactory uUIDFactory, ExecutionFactory executionFactory, DataValueFactory dataValueFactory) {
        super(uUIDFactory, executionFactory, dataValueFactory);
        this.initInfo(8, TABLENAME_STRING, indexColumnPositions, uniqueness, uuids);
    }

    @Override
    public ExecRow makeRow(TupleDescriptor tupleDescriptor, TupleDescriptor tupleDescriptor2) throws StandardException {
        String string = null;
        String string2 = null;
        String string3 = null;
        Object var6_6 = null;
        Object var7_7 = null;
        String string4 = null;
        Timestamp timestamp = null;
        int n2 = 0;
        Statistics statistics = null;
        boolean bl2 = false;
        ExecRow execRow = this.getExecutionFactory().getValueRow(8);
        if (tupleDescriptor != null) {
            StatisticsDescriptor statisticsDescriptor = (StatisticsDescriptor)tupleDescriptor;
            string = statisticsDescriptor.getUUID().toString();
            string3 = statisticsDescriptor.getTableUUID().toString();
            string2 = statisticsDescriptor.getReferenceID().toString();
            timestamp = statisticsDescriptor.getUpdateTimestamp();
            string4 = statisticsDescriptor.getStatType();
            bl2 = statisticsDescriptor.isValid();
            statistics = statisticsDescriptor.getStatistic();
            n2 = statisticsDescriptor.getColumnCount();
        }
        execRow.setColumn(1, new SQLChar(string));
        execRow.setColumn(2, new SQLChar(string2));
        execRow.setColumn(3, new SQLChar(string3));
        execRow.setColumn(4, new SQLTimestamp(timestamp));
        execRow.setColumn(5, new SQLChar(string4));
        execRow.setColumn(6, new SQLBoolean(bl2));
        execRow.setColumn(7, new SQLInteger(n2));
        execRow.setColumn(8, new UserType(statistics));
        return execRow;
    }

    @Override
    public TupleDescriptor buildDescriptor(ExecRow execRow, TupleDescriptor tupleDescriptor, DataDictionary dataDictionary) throws StandardException {
        UUIDFactory uUIDFactory = this.getUUIDFactory();
        DataValueDescriptor dataValueDescriptor = execRow.getColumn(1);
        String string = dataValueDescriptor.getString();
        UUID uUID = uUIDFactory.recreateUUID(string);
        dataValueDescriptor = execRow.getColumn(2);
        string = dataValueDescriptor.getString();
        UUID uUID2 = uUIDFactory.recreateUUID(string);
        dataValueDescriptor = execRow.getColumn(3);
        string = dataValueDescriptor.getString();
        UUID uUID3 = uUIDFactory.recreateUUID(string);
        dataValueDescriptor = execRow.getColumn(4);
        Timestamp timestamp = (Timestamp)dataValueDescriptor.getObject();
        dataValueDescriptor = execRow.getColumn(5);
        String string2 = dataValueDescriptor.getString();
        dataValueDescriptor = execRow.getColumn(6);
        boolean bl2 = dataValueDescriptor.getBoolean();
        dataValueDescriptor = execRow.getColumn(7);
        int n2 = dataValueDescriptor.getInt();
        dataValueDescriptor = execRow.getColumn(8);
        Statistics statistics = (Statistics)dataValueDescriptor.getObject();
        return new StatisticsDescriptor(dataDictionary, uUID, uUID2, uUID3, string2, statistics, n2);
    }

    @Override
    public SystemColumn[] buildColumnList() throws StandardException {
        return new SystemColumn[]{SystemColumnImpl.getUUIDColumn("STATID", false), SystemColumnImpl.getUUIDColumn("REFERENCEID", false), SystemColumnImpl.getUUIDColumn("TABLEID", false), SystemColumnImpl.getColumn("CREATIONTIMESTAMP", 93, false), SystemColumnImpl.getIndicatorColumn("TYPE"), SystemColumnImpl.getColumn("VALID", 16, false), SystemColumnImpl.getColumn("COLCOUNT", 4, false), SystemColumnImpl.getJavaColumn("STATISTICS", "org.apache.derby.catalog.Statistics", false)};
    }
}

