/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.iapi.sql.conn.ConnectionUtil;
import org.apache.derby.iapi.sql.dictionary.ColPermsDescriptor;
import org.apache.derby.iapi.sql.dictionary.PermDescriptor;
import org.apache.derby.iapi.sql.dictionary.PermissionsDescriptor;
import org.apache.derby.iapi.sql.dictionary.RoutinePermsDescriptor;
import org.apache.derby.iapi.sql.dictionary.TablePermsDescriptor;
import org.apache.derby.impl.sql.catalog.DataDictionaryImpl;

class PermissionsCacheable
implements Cacheable {
    protected final DataDictionaryImpl dd;
    private PermissionsDescriptor permissions;

    PermissionsCacheable(DataDictionaryImpl dataDictionaryImpl) {
        this.dd = dataDictionaryImpl;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Cacheable setIdentity(Object var1_1) throws StandardException {
        if (var1_1 instanceof TablePermsDescriptor) {
            var2_2 = (TablePermsDescriptor)var1_1;
            this.permissions = this.dd.getUncachedTablePermsDescriptor(var2_2);
            if (this.permissions == null) {
                var3_6 = this.dd.getTableDescriptor(var2_2.getTableUUID());
                var4_10 = var3_6.getSchemaDescriptor();
                if (var4_10.isSystemSchema()) {
                    this.permissions = new TablePermsDescriptor(this.dd, var2_2.getGrantee(), null, var2_2.getTableUUID(), "Y", "N", "N", "N", "N", "N");
                    ((TablePermsDescriptor)this.permissions).setUUID(var2_2.getTableUUID());
                } else {
                    this.permissions = var2_2.getGrantee().equals(var4_10.getAuthorizationId()) ? new TablePermsDescriptor(this.dd, var2_2.getGrantee(), "_SYSTEM", var2_2.getTableUUID(), "Y", "Y", "Y", "Y", "Y", "Y") : new TablePermsDescriptor(this.dd, var2_2.getGrantee(), null, var2_2.getTableUUID(), "N", "N", "N", "N", "N", "N");
                }
            }
        } else if (var1_1 instanceof ColPermsDescriptor) {
            var2_3 = (ColPermsDescriptor)var1_1;
            this.permissions = this.dd.getUncachedColPermsDescriptor(var2_3);
            if (this.permissions == null) {
                this.permissions = new ColPermsDescriptor(this.dd, var2_3.getGrantee(), null, var2_3.getTableUUID(), var2_3.getType(), null);
            }
        } else if (var1_1 instanceof RoutinePermsDescriptor) {
            var2_4 = (RoutinePermsDescriptor)var1_1;
            this.permissions = this.dd.getUncachedRoutinePermsDescriptor(var2_4);
            if (this.permissions == null) {
                try {
                    var3_7 = this.dd.getAliasDescriptor(var2_4.getRoutineUUID());
                    var4_11 = this.dd.getSchemaDescriptor(var3_7.getSchemaUUID(), ConnectionUtil.getCurrentLCC().getTransactionExecute());
                    if (var4_11.isSystemSchema() && !var4_11.isSchemaWithGrantableRoutines()) {
                        this.permissions = new RoutinePermsDescriptor(this.dd, var2_4.getGrantee(), null, var2_4.getRoutineUUID(), true);
                    }
                    if (!var2_4.getGrantee().equals(var4_11.getAuthorizationId())) ** GOTO lbl48
                    this.permissions = new RoutinePermsDescriptor(this.dd, var2_4.getGrantee(), "_SYSTEM", var2_4.getRoutineUUID(), true);
                }
                catch (SQLException var3_8) {
                    throw StandardException.plainWrapException(var3_8);
                }
            }
        } else if (var1_1 instanceof PermDescriptor) {
            var2_5 = (PermDescriptor)var1_1;
            this.permissions = this.dd.getUncachedGenericPermDescriptor(var2_5);
            if (this.permissions == null) {
                var3_9 = var2_5.getObjectType();
                var4_12 = var2_5.getPermission();
                var5_13 = var2_5.getPermObjectId();
                var6_14 = PermDescriptor.getProtectedObject(this.dd, var5_13, var3_9);
                var7_15 = var6_14.getSchemaDescriptor();
                if (var2_5.getGrantee().equals(var7_15.getAuthorizationId())) {
                    this.permissions = new PermDescriptor(this.dd, null, var3_9, var6_14.getUUID(), var4_12, "_SYSTEM", var2_5.getGrantee(), true);
                }
            }
        } else {
            return null;
        }
lbl48:
        // 8 sources

        if (this.permissions != null) {
            return this;
        }
        return null;
    }

    @Override
    public Cacheable createIdentity(Object object, Object object2) throws StandardException {
        if (object == null) {
            return null;
        }
        this.permissions = (PermissionsDescriptor)((PermissionsDescriptor)object).clone();
        return this;
    }

    @Override
    public void clearIdentity() {
        this.permissions = null;
    }

    @Override
    public Object getIdentity() {
        return this.permissions;
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public void clean(boolean bl2) throws StandardException {
    }
}

