/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.SortedSet;
import org.apache.derby.catalog.DefaultInfo;
import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.BaseTypeIdImpl;
import org.apache.derby.catalog.types.RoutineAliasInfo;
import org.apache.derby.iapi.db.Database;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.CacheFactory;
import org.apache.derby.iapi.services.cache.CacheManager;
import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.iapi.services.cache.CacheableFactory;
import org.apache.derby.iapi.services.context.Context;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.daemon.IndexStatisticsDaemon;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.locks.CompatibilitySpace;
import org.apache.derby.iapi.services.locks.LockFactory;
import org.apache.derby.iapi.services.locks.ShExLockable;
import org.apache.derby.iapi.services.locks.ShExQual;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.ModuleSupportable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.LanguageConnectionFactory;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.BulkInsertCounter;
import org.apache.derby.iapi.sql.dictionary.CatalogRowFactory;
import org.apache.derby.iapi.sql.dictionary.ColPermsDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.DependencyDescriptor;
import org.apache.derby.iapi.sql.dictionary.FileInfoDescriptor;
import org.apache.derby.iapi.sql.dictionary.ForeignKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.dictionary.KeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.PasswordHasher;
import org.apache.derby.iapi.sql.dictionary.PermDescriptor;
import org.apache.derby.iapi.sql.dictionary.PermissionsDescriptor;
import org.apache.derby.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.RoleClosureIterator;
import org.apache.derby.iapi.sql.dictionary.RoleGrantDescriptor;
import org.apache.derby.iapi.sql.dictionary.RoutinePermsDescriptor;
import org.apache.derby.iapi.sql.dictionary.SPSDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.SequenceDescriptor;
import org.apache.derby.iapi.sql.dictionary.StatisticsDescriptor;
import org.apache.derby.iapi.sql.dictionary.SubCheckConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SubConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SubKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SystemColumn;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TablePermsDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptorList;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.dictionary.UserDescriptor;
import org.apache.derby.iapi.sql.dictionary.ViewDescriptor;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.sql.execute.ScanQualifier;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.FileResource;
import org.apache.derby.iapi.store.access.GenericScanController;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.types.SQLBoolean;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.iapi.types.SQLLongint;
import org.apache.derby.iapi.types.SQLVarchar;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.types.UserType;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.impl.services.daemon.IndexStatisticsDaemonImpl;
import org.apache.derby.impl.sql.catalog.DDColumnDependableFinder;
import org.apache.derby.impl.sql.catalog.DD_Version;
import org.apache.derby.impl.sql.catalog.DDdependableFinder;
import org.apache.derby.impl.sql.catalog.DropDependencyFilter;
import org.apache.derby.impl.sql.catalog.NameTDCacheable;
import org.apache.derby.impl.sql.catalog.OIDTDCacheable;
import org.apache.derby.impl.sql.catalog.PermissionsCacheable;
import org.apache.derby.impl.sql.catalog.PermissionsCatalogRowFactory;
import org.apache.derby.impl.sql.catalog.RoleClosureIteratorImpl;
import org.apache.derby.impl.sql.catalog.SPSNameCacheable;
import org.apache.derby.impl.sql.catalog.SYSALIASESRowFactory;
import org.apache.derby.impl.sql.catalog.SYSCHECKSRowFactory;
import org.apache.derby.impl.sql.catalog.SYSCOLPERMSRowFactory;
import org.apache.derby.impl.sql.catalog.SYSCOLUMNSRowFactory;
import org.apache.derby.impl.sql.catalog.SYSCONGLOMERATESRowFactory;
import org.apache.derby.impl.sql.catalog.SYSCONSTRAINTSRowFactory;
import org.apache.derby.impl.sql.catalog.SYSDEPENDSRowFactory;
import org.apache.derby.impl.sql.catalog.SYSDUMMY1RowFactory;
import org.apache.derby.impl.sql.catalog.SYSFILESRowFactory;
import org.apache.derby.impl.sql.catalog.SYSFOREIGNKEYSRowFactory;
import org.apache.derby.impl.sql.catalog.SYSKEYSRowFactory;
import org.apache.derby.impl.sql.catalog.SYSPERMSRowFactory;
import org.apache.derby.impl.sql.catalog.SYSROLESRowFactory;
import org.apache.derby.impl.sql.catalog.SYSROUTINEPERMSRowFactory;
import org.apache.derby.impl.sql.catalog.SYSSCHEMASRowFactory;
import org.apache.derby.impl.sql.catalog.SYSSEQUENCESRowFactory;
import org.apache.derby.impl.sql.catalog.SYSSTATEMENTSRowFactory;
import org.apache.derby.impl.sql.catalog.SYSSTATISTICSRowFactory;
import org.apache.derby.impl.sql.catalog.SYSTABLEPERMSRowFactory;
import org.apache.derby.impl.sql.catalog.SYSTABLESRowFactory;
import org.apache.derby.impl.sql.catalog.SYSTRIGGERSRowFactory;
import org.apache.derby.impl.sql.catalog.SYSUSERSRowFactory;
import org.apache.derby.impl.sql.catalog.SYSVIEWSRowFactory;
import org.apache.derby.impl.sql.catalog.SequenceUpdater;
import org.apache.derby.impl.sql.catalog.TDCacheable;
import org.apache.derby.impl.sql.catalog.TabInfoImpl;
import org.apache.derby.impl.sql.catalog.TableKey;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.depend.BasicDependencyManager;
import org.apache.derby.impl.sql.execute.JarUtil;

public final class DataDictionaryImpl
implements PrivilegedAction<Properties>,
CacheableFactory,
ModuleControl,
ModuleSupportable,
DataDictionary {
    private static final String CFG_SYSTABLES_ID = "SystablesIdentifier";
    private static final String CFG_SYSTABLES_INDEX1_ID = "SystablesIndex1Identifier";
    private static final String CFG_SYSTABLES_INDEX2_ID = "SystablesIndex2Identifier";
    private static final String CFG_SYSCOLUMNS_ID = "SyscolumnsIdentifier";
    private static final String CFG_SYSCOLUMNS_INDEX1_ID = "SyscolumnsIndex1Identifier";
    private static final String CFG_SYSCOLUMNS_INDEX2_ID = "SyscolumnsIndex2Identifier";
    private static final String CFG_SYSCONGLOMERATES_ID = "SysconglomeratesIdentifier";
    private static final String CFG_SYSCONGLOMERATES_INDEX1_ID = "SysconglomeratesIndex1Identifier";
    private static final String CFG_SYSCONGLOMERATES_INDEX2_ID = "SysconglomeratesIndex2Identifier";
    private static final String CFG_SYSCONGLOMERATES_INDEX3_ID = "SysconglomeratesIndex3Identifier";
    private static final String CFG_SYSSCHEMAS_ID = "SysschemasIdentifier";
    private static final String CFG_SYSSCHEMAS_INDEX1_ID = "SysschemasIndex1Identifier";
    private static final String CFG_SYSSCHEMAS_INDEX2_ID = "SysschemasIndex2Identifier";
    private static final int SYSCONGLOMERATES_CORE_NUM = 0;
    private static final int SYSTABLES_CORE_NUM = 1;
    private static final int SYSCOLUMNS_CORE_NUM = 2;
    private static final int SYSSCHEMAS_CORE_NUM = 3;
    private static final int NUM_CORE = 4;
    private static final String[][] SYSFUN_FUNCTIONS = new String[][]{{"ACOS", "DOUBLE", "java.lang.StrictMath", "acos(double)", "true", "false", "DOUBLE"}, {"ASIN", "DOUBLE", "java.lang.StrictMath", "asin(double)", "true", "false", "DOUBLE"}, {"ATAN", "DOUBLE", "java.lang.StrictMath", "atan(double)", "true", "false", "DOUBLE"}, {"ATAN2", "DOUBLE", "java.lang.StrictMath", "atan2(double,double)", "true", "false", "DOUBLE", "DOUBLE"}, {"COS", "DOUBLE", "java.lang.StrictMath", "cos(double)", "true", "false", "DOUBLE"}, {"SIN", "DOUBLE", "java.lang.StrictMath", "sin(double)", "true", "false", "DOUBLE"}, {"TAN", "DOUBLE", "java.lang.StrictMath", "tan(double)", "true", "false", "DOUBLE"}, {"PI", "DOUBLE", "org.apache.derby.catalog.SystemProcedures", "PI()", "true", "false"}, {"DEGREES", "DOUBLE", "java.lang.StrictMath", "toDegrees(double)", "true", "false", "DOUBLE"}, {"RADIANS", "DOUBLE", "java.lang.StrictMath", "toRadians(double)", "true", "false", "DOUBLE"}, {"LN", "DOUBLE", "java.lang.StrictMath", "log(double)", "true", "false", "DOUBLE"}, {"LOG", "DOUBLE", "java.lang.StrictMath", "log(double)", "true", "false", "DOUBLE"}, {"LOG10", "DOUBLE", "java.lang.StrictMath", "log10(double)", "true", "false", "DOUBLE"}, {"EXP", "DOUBLE", "java.lang.StrictMath", "exp(double)", "true", "false", "DOUBLE"}, {"CEIL", "DOUBLE", "java.lang.StrictMath", "ceil(double)", "true", "false", "DOUBLE"}, {"CEILING", "DOUBLE", "java.lang.StrictMath", "ceil(double)", "true", "false", "DOUBLE"}, {"FLOOR", "DOUBLE", "java.lang.StrictMath", "floor(double)", "true", "false", "DOUBLE"}, {"SIGN", "INTEGER", "org.apache.derby.catalog.SystemProcedures", "SIGN(double)", "true", "false", "DOUBLE"}, {"RANDOM", "DOUBLE", "java.lang.StrictMath", "random()", "false", "false"}, {"RAND", "DOUBLE", "org.apache.derby.catalog.SystemProcedures", "RAND(int)", "false", "false", "INTEGER"}, {"COT", "DOUBLE", "org.apache.derby.catalog.SystemProcedures", "COT(double)", "true", "false", "DOUBLE"}, {"COSH", "DOUBLE", "java.lang.StrictMath", "cosh(double)", "true", "false", "DOUBLE"}, {"SINH", "DOUBLE", "java.lang.StrictMath", "sinh(double)", "true", "false", "DOUBLE"}, {"TANH", "DOUBLE", "java.lang.StrictMath", "tanh(double)", "true", "false", "DOUBLE"}};
    private static final int SYSFUN_DETERMINISTIC_INDEX = 4;
    private static final int SYSFUN_VARARGS_INDEX = 5;
    private static final int SYSFUN_FIRST_PARAMETER_INDEX = 6;
    private final AliasDescriptor[] sysfunDescriptors = new AliasDescriptor[SYSFUN_FUNCTIONS.length];
    private TabInfoImpl[] coreInfo;
    private SchemaDescriptor systemSchemaDesc;
    private SchemaDescriptor sysIBMSchemaDesc;
    private SchemaDescriptor declaredGlobalTemporaryTablesSchemaDesc;
    private SchemaDescriptor systemUtilSchemaDesc;
    private static final String[] nonCoreNames = new String[]{"SYSCONSTRAINTS", "SYSKEYS", "SYSDEPENDS", "SYSALIASES", "SYSVIEWS", "SYSCHECKS", "SYSFOREIGNKEYS", "SYSSTATEMENTS", "SYSFILES", "SYSTRIGGERS", "SYSSTATISTICS", "SYSDUMMY1", "SYSTABLEPERMS", "SYSCOLPERMS", "SYSROUTINEPERMS", "SYSROLES", "SYSSEQUENCES", "SYSPERMS", "SYSUSERS"};
    private static final int NUM_NONCORE = nonCoreNames.length;
    private static final String[] systemSchemaNames = new String[]{"SYSCAT", "SYSFUN", "SYSPROC", "SYSSTAT", "NULLID", "SYSCS_DIAG", "SYSCS_UTIL", "SYSIBM", "SQLJ", "SYS"};
    private DD_Version dictionaryVersion;
    private DD_Version softwareVersion;
    private String authorizationDatabaseOwner;
    private boolean usesSqlAuthorization;
    private TabInfoImpl[] noncoreInfo;
    public DataDescriptorGenerator dataDescriptorGenerator;
    private DataValueFactory dvf;
    AccessFactory af;
    private ExecutionFactory exFactory;
    protected UUIDFactory uuidFactory;
    private IndexStatisticsDaemon indexRefresher;
    Properties startupParameters;
    int engineType;
    protected boolean booting;
    private TransactionController bootingTC;
    protected DependencyManager dmgr;
    CacheManager OIDTdCache;
    CacheManager nameTdCache;
    private CacheManager spsNameCache;
    private CacheManager sequenceGeneratorCache;
    private Hashtable<UUID, SPSDescriptor> spsIdHash;
    int tdCacheSize;
    int stmtCacheSize;
    private int seqgenCacheSize;
    CacheManager permissionsCache;
    int permissionsCacheSize;
    ShExLockable cacheCoordinator;
    public LockFactory lockFactory;
    volatile int cacheMode = 0;
    volatile int ddlUsers;
    volatile int readersInDDLMode;
    private HashMap<String, HashMap<String, String>> sequenceIDs;
    private boolean readOnlyUpgrade;
    private boolean indexStatsUpdateDisabled;
    private boolean indexStatsUpdateLogging;
    private String indexStatsUpdateTracing;
    private int systemSQLNameNumber;
    private GregorianCalendar calendarForLastSystemSQLName = new GregorianCalendar();
    private long timeForLastSystemSQLName;
    private static final String[] sysUtilProceduresWithPublicAccess = new String[]{"SYSCS_SET_RUNTIMESTATISTICS", "SYSCS_SET_STATISTICS_TIMING", "SYSCS_INPLACE_COMPRESS_TABLE", "SYSCS_COMPRESS_TABLE", "SYSCS_UPDATE_STATISTICS", "SYSCS_MODIFY_PASSWORD", "SYSCS_DROP_STATISTICS"};
    private static final String[] sysUtilFunctionsWithPublicAccess = new String[]{"SYSCS_GET_RUNTIMESTATISTICS", "SYSCS_PEEK_AT_SEQUENCE", "SYSCS_PEEK_AT_IDENTITY", "SYSCS_GET_DATABASE_NAME"};
    private int collationTypeOfSystemSchemas;
    private int collationTypeOfUserSchemas;
    static final int DROP = 0;
    static final int EXISTS = 1;
    private String spsSet;
    private static final String[] colPrivTypeMap = new String[9];
    private static final String[] colPrivTypeMapForGrant = new String[9];
    private String[][] DIAG_VTI_TABLE_CLASSES = new String[][]{{"LOCK_TABLE", "org.apache.derby.diag.LockTable"}, {"STATEMENT_CACHE", "org.apache.derby.diag.StatementCache"}, {"TRANSACTION_TABLE", "org.apache.derby.diag.TransactionTable"}, {"ERROR_MESSAGES", "org.apache.derby.diag.ErrorMessages"}};
    private String[][] DIAG_VTI_TABLE_FUNCTION_CLASSES = new String[][]{{"SPACE_TABLE", "org.apache.derby.diag.SpaceTable"}, {"ERROR_LOG_READER", "org.apache.derby.diag.ErrorLogReader"}, {"STATEMENT_DURATION", "org.apache.derby.diag.StatementDuration"}, {"CONTAINED_ROLES", "org.apache.derby.diag.ContainedRoles"}};

    @Override
    public boolean canSupport(Properties properties) {
        return Monitor.isDesiredType(properties, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void boot(boolean bl2, Properties properties) throws StandardException {
        this.softwareVersion = new DD_Version(this, 250);
        this.startupParameters = properties;
        this.uuidFactory = DataDictionaryImpl.getMonitor().getUUIDFactory();
        this.engineType = Monitor.getEngineType(properties);
        this.collationTypeOfSystemSchemas = 0;
        this.getBuiltinSystemSchemas();
        LanguageConnectionFactory languageConnectionFactory = (LanguageConnectionFactory)DataDictionaryImpl.bootServiceModule(bl2, this, "org.apache.derby.iapi.sql.conn.LanguageConnectionFactory", properties);
        this.dvf = languageConnectionFactory.getDataValueFactory();
        this.exFactory = (ExecutionFactory)DataDictionaryImpl.bootServiceModule(bl2, this, "org.apache.derby.iapi.sql.execute.ExecutionFactory", properties);
        this.initializeCatalogInfo();
        this.booting = true;
        if (this.dataDescriptorGenerator == null) {
            this.dataDescriptorGenerator = new DataDescriptorGenerator(this);
        }
        if (!bl2) {
            this.coreInfo[1].setHeapConglomerate(this.getBootParameter(properties, CFG_SYSTABLES_ID, true));
            this.coreInfo[1].setIndexConglomerate(0, this.getBootParameter(properties, CFG_SYSTABLES_INDEX1_ID, true));
            this.coreInfo[1].setIndexConglomerate(1, this.getBootParameter(properties, CFG_SYSTABLES_INDEX2_ID, true));
            this.coreInfo[2].setHeapConglomerate(this.getBootParameter(properties, CFG_SYSCOLUMNS_ID, true));
            this.coreInfo[2].setIndexConglomerate(0, this.getBootParameter(properties, CFG_SYSCOLUMNS_INDEX1_ID, true));
            this.coreInfo[2].setIndexConglomerate(1, this.getBootParameter(properties, CFG_SYSCOLUMNS_INDEX2_ID, false));
            this.coreInfo[0].setHeapConglomerate(this.getBootParameter(properties, CFG_SYSCONGLOMERATES_ID, true));
            this.coreInfo[0].setIndexConglomerate(0, this.getBootParameter(properties, CFG_SYSCONGLOMERATES_INDEX1_ID, true));
            this.coreInfo[0].setIndexConglomerate(1, this.getBootParameter(properties, CFG_SYSCONGLOMERATES_INDEX2_ID, true));
            this.coreInfo[0].setIndexConglomerate(2, this.getBootParameter(properties, CFG_SYSCONGLOMERATES_INDEX3_ID, true));
            this.coreInfo[3].setHeapConglomerate(this.getBootParameter(properties, CFG_SYSSCHEMAS_ID, true));
            this.coreInfo[3].setIndexConglomerate(0, this.getBootParameter(properties, CFG_SYSSCHEMAS_INDEX1_ID, true));
            this.coreInfo[3].setIndexConglomerate(1, this.getBootParameter(properties, CFG_SYSSCHEMAS_INDEX2_ID, true));
        }
        String string = properties.getProperty("derby.language.tableDescriptorCacheSize");
        this.tdCacheSize = PropertyUtil.intPropertyValue("derby.language.tableDescriptorCacheSize", (Serializable)((Object)string), 0, Integer.MAX_VALUE, 64);
        string = properties.getProperty("derby.language.spsCacheSize");
        this.stmtCacheSize = PropertyUtil.intPropertyValue("derby.language.spsCacheSize", (Serializable)((Object)string), 0, Integer.MAX_VALUE, 32);
        string = properties.getProperty("derby.language.sequenceGeneratorCacheSize");
        this.seqgenCacheSize = PropertyUtil.intPropertyValue("derby.language.sequenceGeneratorCacheSize", (Serializable)((Object)string), 0, Integer.MAX_VALUE, 1000);
        string = properties.getProperty("derby.language.permissionsCacheSize");
        this.permissionsCacheSize = PropertyUtil.intPropertyValue("derby.language.permissionsCacheSize", (Serializable)((Object)string), 0, Integer.MAX_VALUE, 64);
        this.indexStatsUpdateDisabled = !PropertyUtil.getSystemBoolean("derby.storage.indexStats.auto", true);
        this.indexStatsUpdateLogging = PropertyUtil.getSystemBoolean("derby.storage.indexStats.log");
        this.indexStatsUpdateTracing = PropertyUtil.getSystemProperty("derby.storage.indexStats.trace", "off");
        CacheFactory cacheFactory = (CacheFactory)DataDictionaryImpl.startSystemModule("org.apache.derby.iapi.services.cache.CacheFactory");
        this.OIDTdCache = cacheFactory.newCacheManager(this, "TableDescriptorOIDCache", this.tdCacheSize, this.tdCacheSize);
        this.nameTdCache = cacheFactory.newCacheManager(this, "TableDescriptorNameCache", this.tdCacheSize, this.tdCacheSize);
        if (this.stmtCacheSize > 0) {
            this.spsNameCache = cacheFactory.newCacheManager(this, "SPSNameDescriptorCache", this.stmtCacheSize, this.stmtCacheSize);
            this.spsIdHash = new Hashtable(this.stmtCacheSize);
        }
        this.sequenceGeneratorCache = cacheFactory.newCacheManager(this, "SequenceGeneratorCache", this.seqgenCacheSize, this.seqgenCacheSize);
        this.sequenceIDs = new HashMap();
        this.cacheCoordinator = new ShExLockable();
        this.af = (AccessFactory)DataDictionaryImpl.findServiceModule(this, "org.apache.derby.iapi.store.access.AccessFactory");
        this.lockFactory = this.af.getLockFactory();
        ContextService contextService = DataDictionaryImpl.getContextService();
        ContextManager contextManager = contextService.getCurrentContextManager();
        this.bootingTC = null;
        try {
            String string2;
            this.bootingTC = this.af.getTransaction(contextManager);
            this.exFactory.newExecutionContext(contextManager);
            DataDescriptorGenerator dataDescriptorGenerator = this.getDataDescriptorGenerator();
            if (bl2) {
                string2 = properties.getProperty("collation", "UCS_BASIC");
                this.bootingTC.setProperty("derby.database.collation", (Serializable)((Object)string2), true);
            } else {
                string2 = properties.getProperty("derby.database.collation", "UCS_BASIC");
            }
            this.collationTypeOfUserSchemas = DataTypeDescriptor.getCollationType(string2);
            this.declaredGlobalTemporaryTablesSchemaDesc = this.newDeclaredGlobalTemporaryTablesSchemaDesc("SESSION");
            boolean bl3 = PropertyUtil.nativeAuthenticationEnabled(properties);
            if (bl2) {
                String string3 = IdUtil.getUserNameFromURLProps(properties);
                this.authorizationDatabaseOwner = IdUtil.getUserAuthorizationId(string3);
                HashSet<String> hashSet = new HashSet<String>();
                this.createDictionaryTables(properties, this.bootingTC, dataDescriptorGenerator);
                this.create_SYSIBM_procedures(this.bootingTC, hashSet);
                this.createSystemSps(this.bootingTC);
                this.create_SYSCS_procedures(this.bootingTC, hashSet);
                this.grantPublicAccessToSystemRoutines(hashSet, this.bootingTC, this.authorizationDatabaseOwner);
                this.dictionaryVersion = this.softwareVersion;
                this.bootingTC.setProperty("DataDictionaryVersion", this.dictionaryVersion, true);
                this.bootingTC.setProperty("CreateDataDictionaryVersion", this.dictionaryVersion, true);
                if (PropertyUtil.getSystemBoolean("derby.database.sqlAuthorization")) {
                    this.bootingTC.setProperty("derby.database.sqlAuthorization", (Serializable)((Object)"true"), true);
                }
                if (PropertyUtil.getSystemBoolean("derby.database.sqlAuthorization") || bl3) {
                    this.usesSqlAuthorization = true;
                }
                this.bootingTC.setProperty("derby.authentication.builtin.algorithm", (Serializable)((Object)this.findDefaultBuiltinAlgorithm()), false);
            } else {
                String string4;
                String string5;
                this.loadDictionaryTables(this.bootingTC, properties);
                String string6 = PropertyUtil.getDatabaseProperty(this.bootingTC, "derby.storage.indexStats.auto");
                if (string6 != null) {
                    boolean bl4 = this.indexStatsUpdateDisabled = Boolean.valueOf(string6) == false;
                }
                if ((string5 = PropertyUtil.getDatabaseProperty(this.bootingTC, "derby.storage.indexStats.log")) != null) {
                    this.indexStatsUpdateLogging = Boolean.valueOf(string5);
                }
                if ((string4 = PropertyUtil.getDatabaseProperty(this.bootingTC, "derby.storage.indexStats.trace")) != null) {
                    this.indexStatsUpdateTracing = !string4.equalsIgnoreCase("off") && !string4.equalsIgnoreCase("log") && !string4.equalsIgnoreCase("stdout") && !string4.equalsIgnoreCase("both") ? "off" : string4;
                }
                String string7 = PropertyUtil.getDatabaseProperty(this.bootingTC, "derby.database.sqlAuthorization");
                if (Boolean.valueOf(properties.getProperty("softUpgradeNoFeatureCheck")).booleanValue()) {
                    if (this.dictionaryVersion.majorVersionNumber >= 140) {
                        this.usesSqlAuthorization = Boolean.valueOf(string7) != false || bl3;
                    }
                } else if (Boolean.valueOf(string7).booleanValue() || bl3) {
                    this.checkVersion(140, "sqlAuthorization");
                    this.usesSqlAuthorization = true;
                }
            }
            this.bootingTC.commit();
            contextManager.getContext("ExecutionContext").popMe();
        }
        finally {
            if (this.bootingTC != null) {
                this.bootingTC.destroy();
                this.bootingTC = null;
            }
        }
        this.setDependencyManager();
        this.booting = false;
    }

    private String findDefaultBuiltinAlgorithm() {
        try {
            MessageDigest.getInstance("SHA-256");
            return "SHA-256";
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return "SHA-1";
        }
    }

    private CacheManager getPermissionsCache() throws StandardException {
        if (this.permissionsCache == null) {
            CacheFactory cacheFactory = (CacheFactory)DataDictionaryImpl.startSystemModule("org.apache.derby.iapi.services.cache.CacheFactory");
            LanguageConnectionContext languageConnectionContext = DataDictionaryImpl.getLCC();
            TransactionController transactionController = languageConnectionContext.getTransactionExecute();
            this.permissionsCacheSize = PropertyUtil.getServiceInt(transactionController, "derby.language.permissionsCacheSize", 40, Integer.MAX_VALUE, this.permissionsCacheSize);
            this.permissionsCache = cacheFactory.newCacheManager(this, "PermissionsCache", this.permissionsCacheSize, this.permissionsCacheSize);
        }
        return this.permissionsCache;
    }

    protected void setDependencyManager() {
        this.dmgr = new BasicDependencyManager(this);
    }

    @Override
    public DependencyManager getDependencyManager() {
        return this.dmgr;
    }

    @Override
    public void stop() {
        if (this.indexRefresher != null) {
            this.indexRefresher.stop();
        }
    }

    @Override
    public Cacheable newCacheable(CacheManager cacheManager) {
        if (cacheManager == this.OIDTdCache) {
            return new OIDTDCacheable(this);
        }
        if (cacheManager == this.nameTdCache) {
            return new NameTDCacheable(this);
        }
        if (cacheManager == this.permissionsCache) {
            return new PermissionsCacheable(this);
        }
        if (cacheManager == this.sequenceGeneratorCache) {
            return new SequenceUpdater.SyssequenceUpdater(this);
        }
        return new SPSNameCacheable(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int startReading(LanguageConnectionContext languageConnectionContext) throws StandardException {
        int n2;
        int n3 = languageConnectionContext.incrementBindCount();
        boolean bl2 = false;
        do {
            if (bl2) {
                try {
                    this.lockFactory.zeroDurationlockObject(languageConnectionContext.getTransactionExecute().getLockSpace(), this.cacheCoordinator, ShExQual.SH, -1);
                }
                catch (StandardException standardException) {
                    languageConnectionContext.decrementBindCount();
                    throw standardException;
                }
                bl2 = false;
            }
            DataDictionaryImpl dataDictionaryImpl = this;
            synchronized (dataDictionaryImpl) {
                n2 = this.getCacheMode();
                if (n3 == 1) {
                    if (n2 == 0) {
                        boolean bl3 = false;
                        try {
                            CompatibilitySpace compatibilitySpace = languageConnectionContext.getTransactionExecute().getLockSpace();
                            bl3 = this.lockFactory.lockObject(compatibilitySpace, compatibilitySpace.getOwner(), this.cacheCoordinator, ShExQual.SH, 0);
                        }
                        catch (StandardException standardException) {
                            languageConnectionContext.decrementBindCount();
                            throw standardException;
                        }
                        if (!bl3) {
                            bl2 = true;
                        }
                    } else {
                        ++this.readersInDDLMode;
                    }
                }
            }
        } while (bl2);
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doneReading(int n2, LanguageConnectionContext languageConnectionContext) throws StandardException {
        int n3 = languageConnectionContext.decrementBindCount();
        DataDictionaryImpl dataDictionaryImpl = this;
        synchronized (dataDictionaryImpl) {
            if (n3 == 0) {
                if (n2 == 0) {
                    if (languageConnectionContext.getStatementContext() != null && languageConnectionContext.getStatementContext().inUse()) {
                        CompatibilitySpace compatibilitySpace = languageConnectionContext.getTransactionExecute().getLockSpace();
                        int n4 = this.lockFactory.unlock(compatibilitySpace, compatibilitySpace.getOwner(), this.cacheCoordinator, ShExQual.SH);
                    }
                } else {
                    --this.readersInDDLMode;
                    if (this.ddlUsers == 0 && this.readersInDDLMode == 0) {
                        this.clearCaches(false);
                        this.setCacheMode(0);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startWriting(LanguageConnectionContext languageConnectionContext) throws StandardException {
        boolean bl2 = true;
        if (languageConnectionContext.getBindCount() != 0) {
            throw StandardException.newException("XCL21.S", new Object[0]);
        }
        if (!languageConnectionContext.dataDictionaryInWriteMode()) {
            int n2 = 0;
            while (bl2) {
                block12: {
                    if (n2 > 4 && this.getCacheMode() == 0) {
                        this.lockFactory.zeroDurationlockObject(languageConnectionContext.getTransactionExecute().getLockSpace(), this.cacheCoordinator, ShExQual.EX, -2);
                        n2 = 1;
                    }
                    if (n2 > 0) {
                        try {
                            Thread.sleep((long)(Math.random() * 1131.0 % 20.0));
                        }
                        catch (InterruptedException interruptedException) {
                            throw StandardException.interrupt(interruptedException);
                        }
                    }
                    DataDictionaryImpl dataDictionaryImpl = this;
                    synchronized (dataDictionaryImpl) {
                        if (this.getCacheMode() == 0) {
                            boolean bl3 = this.lockFactory.zeroDurationlockObject(languageConnectionContext.getTransactionExecute().getLockSpace(), this.cacheCoordinator, ShExQual.EX, 0);
                            if (!bl3) {
                                break block12;
                            }
                            this.setCacheMode(1);
                            this.clearCaches(false);
                        }
                        ++this.ddlUsers;
                    }
                    languageConnectionContext.setDataDictionaryWriteMode();
                    bl2 = false;
                }
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transactionFinished() throws StandardException {
        DataDictionaryImpl dataDictionaryImpl = this;
        synchronized (dataDictionaryImpl) {
            --this.ddlUsers;
            if (this.ddlUsers == 0 && this.readersInDDLMode == 0) {
                this.clearCaches();
                this.setCacheMode(0);
            }
        }
    }

    @Override
    public int getCacheMode() {
        return this.cacheMode;
    }

    private void setCacheMode(int n2) {
        this.cacheMode = n2;
    }

    @Override
    public DataDescriptorGenerator getDataDescriptorGenerator() {
        return this.dataDescriptorGenerator;
    }

    @Override
    public String getAuthorizationDatabaseOwner() {
        return this.authorizationDatabaseOwner;
    }

    @Override
    public boolean usesSqlAuthorization() {
        return this.usesSqlAuthorization;
    }

    @Override
    public int getCollationTypeOfSystemSchemas() {
        return this.collationTypeOfSystemSchemas;
    }

    @Override
    public int getCollationTypeOfUserSchemas() {
        return this.collationTypeOfUserSchemas;
    }

    @Override
    public DataValueFactory getDataValueFactory() {
        return this.dvf;
    }

    @Override
    public ExecutionFactory getExecutionFactory() {
        return this.exFactory;
    }

    private void getBuiltinSystemSchemas() {
        if (this.systemSchemaDesc != null) {
            return;
        }
        this.systemSchemaDesc = this.newSystemSchemaDesc("SYS", "8000000d-00d0-fd77-3ed8-000a0a0b1900");
        this.sysIBMSchemaDesc = this.newSystemSchemaDesc("SYSIBM", "c013800d-00f8-5b53-28a9-00000019ed88");
        this.systemUtilSchemaDesc = this.newSystemSchemaDesc("SYSCS_UTIL", "c013800d-00fb-2649-07ec-000000134f30");
    }

    @Override
    public PasswordHasher makePasswordHasher(Dictionary<?, ?> dictionary) throws StandardException {
        boolean bl2 = this.checkVersion(180, null);
        boolean bl3 = this.checkVersion(210, null);
        if (!bl2) {
            return null;
        }
        String string = (String)((Object)PropertyUtil.getPropertyFromSet(dictionary, "derby.authentication.builtin.algorithm"));
        if (string == null) {
            return null;
        }
        byte[] byArray = null;
        int n2 = 1;
        if (string.length() > 0 && bl3) {
            byArray = this.generateRandomSalt(dictionary);
            n2 = this.getIntProperty(dictionary, "derby.authentication.builtin.iterations", 1000, 1, Integer.MAX_VALUE);
        }
        return new PasswordHasher(string, byArray, n2);
    }

    private byte[] generateRandomSalt(Dictionary dictionary) {
        int n2 = this.getIntProperty(dictionary, "derby.authentication.builtin.saltLength", 16, 0, Integer.MAX_VALUE);
        SecureRandom secureRandom = new SecureRandom();
        byte[] byArray = new byte[n2];
        secureRandom.nextBytes(byArray);
        return byArray;
    }

    private int getIntProperty(Dictionary dictionary, String string, int n2, int n3, int n4) {
        String string2 = (String)((Object)PropertyUtil.getPropertyFromSet(dictionary, string));
        if (string2 != null) {
            try {
                int n5 = Integer.parseInt(string2);
                if (n5 >= n3 && n5 <= n4) {
                    return n5;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n2;
    }

    @Override
    public SchemaDescriptor getSystemSchemaDescriptor() throws StandardException {
        return this.systemSchemaDesc;
    }

    public SchemaDescriptor getSystemUtilSchemaDescriptor() throws StandardException {
        return this.systemUtilSchemaDesc;
    }

    @Override
    public SchemaDescriptor getSysIBMSchemaDescriptor() throws StandardException {
        return this.sysIBMSchemaDesc;
    }

    @Override
    public SchemaDescriptor getDeclaredGlobalTemporaryTablesSchemaDescriptor() throws StandardException {
        return this.declaredGlobalTemporaryTablesSchemaDesc;
    }

    @Override
    public boolean isSystemSchemaName(String string) throws StandardException {
        boolean bl2 = false;
        int n2 = systemSchemaNames.length - 1;
        while (n2 >= 0 && !(bl2 = systemSchemaNames[n2--].equals(string))) {
        }
        return bl2;
    }

    @Override
    public SchemaDescriptor getSchemaDescriptor(String string, TransactionController transactionController, boolean bl2) throws StandardException {
        if (transactionController == null) {
            transactionController = this.getTransactionCompile();
        }
        if (this.getSystemSchemaDescriptor().getSchemaName().equals(string)) {
            return this.getSystemSchemaDescriptor();
        }
        if (this.getSysIBMSchemaDescriptor().getSchemaName().equals(string) && this.dictionaryVersion.checkVersion(100, null)) {
            return this.getSysIBMSchemaDescriptor();
        }
        SchemaDescriptor schemaDescriptor = this.locateSchemaRow(string, transactionController);
        if (schemaDescriptor == null && this.getDeclaredGlobalTemporaryTablesSchemaDescriptor().getSchemaName().equals(string)) {
            return this.getDeclaredGlobalTemporaryTablesSchemaDescriptor();
        }
        if (schemaDescriptor == null && bl2) {
            throw StandardException.newException("42Y07", string);
        }
        return schemaDescriptor;
    }

    private SchemaDescriptor locateSchemaRow(UUID uUID, TransactionController transactionController) throws StandardException {
        return this.locateSchemaRowBody(uUID, 4, transactionController);
    }

    private SchemaDescriptor locateSchemaRow(UUID uUID, int n2, TransactionController transactionController) throws StandardException {
        return this.locateSchemaRowBody(uUID, n2, transactionController);
    }

    private SchemaDescriptor locateSchemaRowBody(UUID uUID, int n2, TransactionController transactionController) throws StandardException {
        TabInfoImpl tabInfoImpl = this.coreInfo[3];
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(uUID);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        return this.getDescriptorViaIndex(1, execIndexRow, null, tabInfoImpl, null, null, SchemaDescriptor.class, false, n2, transactionController);
    }

    private SchemaDescriptor locateSchemaRow(String string, TransactionController transactionController) throws StandardException {
        TabInfoImpl tabInfoImpl = this.coreInfo[3];
        SQLVarchar sQLVarchar = new SQLVarchar(string);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLVarchar);
        return this.getDescriptorViaIndex(0, execIndexRow, null, tabInfoImpl, null, null, SchemaDescriptor.class, false, 4, transactionController);
    }

    @Override
    public SchemaDescriptor getSchemaDescriptor(UUID uUID, TransactionController transactionController) throws StandardException {
        return this.getSchemaDescriptorBody(uUID, 4, transactionController);
    }

    @Override
    public SchemaDescriptor getSchemaDescriptor(UUID uUID, int n2, TransactionController transactionController) throws StandardException {
        return this.getSchemaDescriptorBody(uUID, n2, transactionController);
    }

    private SchemaDescriptor getSchemaDescriptorBody(UUID uUID, int n2, TransactionController transactionController) throws StandardException {
        SchemaDescriptor schemaDescriptor;
        LanguageConnectionContext languageConnectionContext;
        if (transactionController == null) {
            transactionController = this.getTransactionCompile();
        }
        if (uUID != null) {
            if (this.getSystemSchemaDescriptor().getUUID().equals(uUID)) {
                return this.getSystemSchemaDescriptor();
            }
            if (this.getSysIBMSchemaDescriptor().getUUID().equals(uUID)) {
                return this.getSysIBMSchemaDescriptor();
            }
        }
        if (!this.booting && (languageConnectionContext = DataDictionaryImpl.getLCC()) != null && (schemaDescriptor = languageConnectionContext.getDefaultSchema()) != null && (uUID == null || uUID.equals(schemaDescriptor.getUUID()))) {
            return schemaDescriptor;
        }
        return this.locateSchemaRow(uUID, n2, transactionController);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean existsSchemaOwnedBy(String string, TransactionController transactionController) throws StandardException {
        TabInfoImpl tabInfoImpl = this.coreInfo[3];
        SYSSCHEMASRowFactory sYSSCHEMASRowFactory = (SYSSCHEMASRowFactory)tabInfoImpl.getCatalogRowFactory();
        ConglomerateController conglomerateController = transactionController.openConglomerate(tabInfoImpl.getHeapConglomerate(), false, 0, 6, 4);
        SQLVarchar sQLVarchar = new SQLVarchar(string);
        Qualifier[][] qualifierArray = this.exFactory.getScanQualifier(1);
        qualifierArray[0][0].setQualifier(2, sQLVarchar, 2, false, false, false);
        ScanController scanController = transactionController.openScan(tabInfoImpl.getHeapConglomerate(), false, 0, 6, 4, null, null, 0, qualifierArray, null, 0);
        boolean bl2 = false;
        try {
            ExecRow execRow = sYSSCHEMASRowFactory.makeEmptyRow();
            if (scanController.fetchNext(execRow.getRowArray())) {
                bl2 = true;
            }
        }
        finally {
            if (scanController != null) {
                scanController.close();
            }
            if (conglomerateController != null) {
                conglomerateController.close();
            }
        }
        return bl2;
    }

    @Override
    public void addDescriptor(TupleDescriptor tupleDescriptor, TupleDescriptor tupleDescriptor2, int n2, boolean bl2, TransactionController transactionController) throws StandardException {
        TabInfoImpl tabInfoImpl = n2 < 4 ? this.coreInfo[n2] : this.getNonCoreTI(n2);
        ExecRow execRow = tabInfoImpl.getCatalogRowFactory().makeRow(tupleDescriptor, tupleDescriptor2);
        int n3 = tabInfoImpl.insertRow(execRow, transactionController);
        if (!bl2 && n3 != -1) {
            throw this.duplicateDescriptorException(tupleDescriptor, tupleDescriptor2);
        }
    }

    private StandardException duplicateDescriptorException(TupleDescriptor tupleDescriptor, TupleDescriptor tupleDescriptor2) {
        if (tupleDescriptor2 != null) {
            return StandardException.newException("X0Y32.S", tupleDescriptor.getDescriptorType(), tupleDescriptor.getDescriptorName(), tupleDescriptor2.getDescriptorType(), tupleDescriptor2.getDescriptorName());
        }
        return StandardException.newException("X0Y68.S", tupleDescriptor.getDescriptorType(), tupleDescriptor.getDescriptorName());
    }

    @Override
    public void addDescriptorArray(TupleDescriptor[] tupleDescriptorArray, TupleDescriptor tupleDescriptor, int n2, boolean bl2, TransactionController transactionController) throws StandardException {
        int n3;
        TabInfoImpl tabInfoImpl = n2 < 4 ? this.coreInfo[n2] : this.getNonCoreTI(n2);
        CatalogRowFactory catalogRowFactory = tabInfoImpl.getCatalogRowFactory();
        ExecRow[] execRowArray = new ExecRow[tupleDescriptorArray.length];
        for (n3 = 0; n3 < tupleDescriptorArray.length; ++n3) {
            ExecRow execRow;
            execRowArray[n3] = execRow = catalogRowFactory.makeRow(tupleDescriptorArray[n3], tupleDescriptor);
        }
        n3 = tabInfoImpl.insertRowList(execRowArray, transactionController);
        if (!bl2 && n3 != -1) {
            throw this.duplicateDescriptorException(tupleDescriptorArray[n3], tupleDescriptor);
        }
    }

    @Override
    public void dropRoleGrant(String string, String string2, String string3, TransactionController transactionController) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(19);
        SQLVarchar sQLVarchar = new SQLVarchar(string);
        SQLVarchar sQLVarchar2 = new SQLVarchar(string2);
        SQLVarchar sQLVarchar3 = new SQLVarchar(string3);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(3);
        execIndexRow.setColumn(1, sQLVarchar);
        execIndexRow.setColumn(2, sQLVarchar2);
        execIndexRow.setColumn(3, sQLVarchar3);
        tabInfoImpl.deleteRow(transactionController, execIndexRow, 0);
    }

    @Override
    public void dropSchemaDescriptor(String string, TransactionController transactionController) throws StandardException {
        ExecIndexRow execIndexRow = null;
        TabInfoImpl tabInfoImpl = this.coreInfo[3];
        SQLVarchar sQLVarchar = new SQLVarchar(string);
        execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLVarchar);
        tabInfoImpl.deleteRow(transactionController, execIndexRow, 0);
    }

    @Override
    public TableDescriptor getTableDescriptor(String string, SchemaDescriptor schemaDescriptor, TransactionController transactionController) throws StandardException {
        Object object;
        TableDescriptor tableDescriptor = null;
        SchemaDescriptor schemaDescriptor2 = schemaDescriptor == null ? this.getSystemSchemaDescriptor() : schemaDescriptor;
        UUID uUID = schemaDescriptor2.getUUID();
        if ("SYSCS_DIAG".equals(schemaDescriptor2.getSchemaName()) && this.getVTIClass((TableDescriptor)(object = new TableDescriptor(this, string, schemaDescriptor2, 5, 'R')), false) != null) {
            return object;
        }
        object = new TableKey(uUID, string);
        if (this.getCacheMode() == 0) {
            NameTDCacheable nameTDCacheable = (NameTDCacheable)this.nameTdCache.find(object);
            if (nameTDCacheable != null) {
                tableDescriptor = nameTDCacheable.getTableDescriptor();
                tableDescriptor.setReferencedColumnMap(null);
                this.nameTdCache.release(nameTDCacheable);
            }
            return tableDescriptor;
        }
        return this.getTableDescriptorIndex1Scan(string, uUID.toString());
    }

    private TableDescriptor getTableDescriptorIndex1Scan(String string, String string2) throws StandardException {
        TabInfoImpl tabInfoImpl = this.coreInfo[1];
        SQLVarchar sQLVarchar = new SQLVarchar(string);
        SQLChar sQLChar = new SQLChar(string2);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(2);
        execIndexRow.setColumn(1, sQLVarchar);
        execIndexRow.setColumn(2, sQLChar);
        TableDescriptor tableDescriptor = this.getDescriptorViaIndex(0, execIndexRow, null, tabInfoImpl, null, null, TableDescriptor.class, false);
        return this.finishTableDescriptor(tableDescriptor);
    }

    TableDescriptor getUncachedTableDescriptor(TableKey tableKey) throws StandardException {
        return this.getTableDescriptorIndex1Scan(tableKey.getTableName(), tableKey.getSchemaId().toString());
    }

    @Override
    public TableDescriptor getTableDescriptor(UUID uUID) throws StandardException {
        TableDescriptor tableDescriptor = null;
        if (this.getCacheMode() == 0) {
            OIDTDCacheable oIDTDCacheable = (OIDTDCacheable)this.OIDTdCache.find(uUID);
            if (oIDTDCacheable != null) {
                tableDescriptor = oIDTDCacheable.getTableDescriptor();
                tableDescriptor.setReferencedColumnMap(null);
                this.OIDTdCache.release(oIDTDCacheable);
            }
            return tableDescriptor;
        }
        return this.getTableDescriptorIndex2Scan(uUID.toString());
    }

    protected TableDescriptor getUncachedTableDescriptor(UUID uUID) throws StandardException {
        return this.getTableDescriptorIndex2Scan(uUID.toString());
    }

    private TableDescriptor getTableDescriptorIndex2Scan(String string) throws StandardException {
        TabInfoImpl tabInfoImpl = this.coreInfo[1];
        SQLChar sQLChar = new SQLChar(string);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        TableDescriptor tableDescriptor = this.getDescriptorViaIndex(1, execIndexRow, null, tabInfoImpl, null, null, TableDescriptor.class, false);
        return this.finishTableDescriptor(tableDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableDescriptor finishTableDescriptor(TableDescriptor tableDescriptor) throws StandardException {
        if (tableDescriptor != null) {
            TableDescriptor tableDescriptor2 = tableDescriptor;
            synchronized (tableDescriptor2) {
                this.getColumnDescriptorsScan(tableDescriptor);
                this.getConglomerateDescriptorsScan(tableDescriptor);
            }
        }
        return tableDescriptor;
    }

    @Override
    public boolean isSchemaEmpty(SchemaDescriptor schemaDescriptor) throws StandardException {
        SQLChar sQLChar;
        TransactionController transactionController = this.getTransactionCompile();
        if (this.isSchemaReferenced(transactionController, this.coreInfo[1], 0, 2, sQLChar = DataDictionaryImpl.getIDValueAsCHAR(schemaDescriptor.getUUID()))) {
            return false;
        }
        if (this.isSchemaReferenced(transactionController, this.getNonCoreTI(4), 1, 2, sQLChar)) {
            return false;
        }
        if (this.isSchemaReferenced(transactionController, this.getNonCoreTI(11), 1, 2, sQLChar)) {
            return false;
        }
        if (this.isSchemaReferenced(transactionController, this.getNonCoreTI(13), 1, 2, sQLChar)) {
            return false;
        }
        if (this.isSchemaReferenced(transactionController, this.getNonCoreTI(7), 0, 1, sQLChar)) {
            return false;
        }
        return this.dictionaryVersion.majorVersionNumber < 180 || !this.isSchemaReferenced(transactionController, this.getNonCoreTI(20), 1, 1, sQLChar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isSchemaReferenced(TransactionController transactionController, TabInfoImpl tabInfoImpl, int n2, int n3, DataValueDescriptor dataValueDescriptor) throws StandardException {
        boolean bl2;
        ConglomerateController conglomerateController = null;
        GenericScanController genericScanController = null;
        FormatableBitSet formatableBitSet = new FormatableBitSet(n3);
        formatableBitSet.set(n3 - 1);
        Qualifier[][] qualifierArray = this.exFactory.getScanQualifier(1);
        qualifierArray[0][0].setQualifier(n3 - 1, dataValueDescriptor, 2, false, false, false);
        try {
            conglomerateController = transactionController.openConglomerate(tabInfoImpl.getHeapConglomerate(), false, 0, 6, 4);
            genericScanController = transactionController.openScan(tabInfoImpl.getIndexConglomerate(n2), false, 0, 6, 4, formatableBitSet, null, 1, qualifierArray, null, -1);
            bl2 = genericScanController.next();
        }
        finally {
            if (genericScanController != null) {
                genericScanController.close();
            }
            if (conglomerateController != null) {
                conglomerateController.close();
            }
        }
        return bl2;
    }

    @Override
    public void dropTableDescriptor(TableDescriptor tableDescriptor, SchemaDescriptor schemaDescriptor, TransactionController transactionController) throws StandardException {
        ExecIndexRow execIndexRow = null;
        TabInfoImpl tabInfoImpl = this.coreInfo[1];
        SQLVarchar sQLVarchar = new SQLVarchar(tableDescriptor.getName());
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(schemaDescriptor.getUUID());
        execIndexRow = this.exFactory.getIndexableRow(2);
        execIndexRow.setColumn(1, sQLVarchar);
        execIndexRow.setColumn(2, sQLChar);
        tabInfoImpl.deleteRow(transactionController, execIndexRow, 0);
    }

    @Override
    public void updateLockGranularity(TableDescriptor tableDescriptor, SchemaDescriptor schemaDescriptor, char c2, TransactionController transactionController) throws StandardException {
        TabInfoImpl tabInfoImpl = this.coreInfo[1];
        SYSTABLESRowFactory sYSTABLESRowFactory = (SYSTABLESRowFactory)tabInfoImpl.getCatalogRowFactory();
        SQLVarchar sQLVarchar = new SQLVarchar(tableDescriptor.getName());
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(schemaDescriptor.getUUID());
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(2);
        execIndexRow.setColumn(1, sQLVarchar);
        execIndexRow.setColumn(2, sQLChar);
        ExecRow execRow = sYSTABLESRowFactory.makeRow(tableDescriptor, schemaDescriptor);
        boolean[] blArray = new boolean[2];
        for (int i2 = 0; i2 < 2; ++i2) {
            blArray[i2] = false;
        }
        tabInfoImpl.updateRow(execIndexRow, execRow, 0, blArray, (int[])null, transactionController);
    }

    void upgradeCLOBGETSUBSTRING_10_6(TransactionController transactionController) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(7);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(3);
        SQLVarchar sQLVarchar = new SQLVarchar("CLOBGETSUBSTRING");
        SQLChar sQLChar = new SQLChar(new String(new char[]{'F'}));
        execIndexRow.setColumn(1, new SQLChar("c013800d-00f8-5b53-28a9-00000019ed88"));
        execIndexRow.setColumn(2, sQLVarchar);
        execIndexRow.setColumn(3, sQLChar);
        AliasDescriptor aliasDescriptor = this.getDescriptorViaIndex(0, execIndexRow, null, tabInfoImpl, null, null, AliasDescriptor.class, true, 4, transactionController);
        RoutineAliasInfo routineAliasInfo = (RoutineAliasInfo)aliasDescriptor.getAliasInfo();
        TypeDescriptor typeDescriptor = DataTypeDescriptor.getCatalogType(12, 10890);
        RoutineAliasInfo routineAliasInfo2 = new RoutineAliasInfo(routineAliasInfo.getMethodName(), routineAliasInfo.getParameterCount(), routineAliasInfo.getParameterNames(), routineAliasInfo.getParameterTypes(), routineAliasInfo.getParameterModes(), routineAliasInfo.getMaxDynamicResultSets(), routineAliasInfo.getParameterStyle(), routineAliasInfo.getSQLAllowed(), routineAliasInfo.isDeterministic(), routineAliasInfo.hasVarargs(), routineAliasInfo.hasDefinersRights(), routineAliasInfo.calledOnNullInput(), typeDescriptor);
        AliasDescriptor aliasDescriptor2 = new AliasDescriptor(this, aliasDescriptor.getUUID(), aliasDescriptor.getObjectName(), aliasDescriptor.getSchemaUUID(), aliasDescriptor.getJavaClassName(), aliasDescriptor.getAliasType(), aliasDescriptor.getNameSpace(), aliasDescriptor.getSystemAlias(), routineAliasInfo2, aliasDescriptor.getSpecificName());
        ExecRow execRow = tabInfoImpl.getCatalogRowFactory().makeRow(aliasDescriptor2, null);
        tabInfoImpl.updateRow(execIndexRow, execRow, 0, new boolean[]{false, false, false}, (int[])null, transactionController);
    }

    void upgradeSYSROUTINEPERMS_10_6(TransactionController transactionController) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(7);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(3);
        SQLVarchar sQLVarchar = new SQLVarchar("SYSCS_INPLACE_COMPRESS_TABLE");
        SQLChar sQLChar = new SQLChar(new String(new char[]{'P'}));
        execIndexRow.setColumn(1, new SQLChar("c013800d-00fb-2649-07ec-000000134f30"));
        execIndexRow.setColumn(2, sQLVarchar);
        execIndexRow.setColumn(3, sQLChar);
        AliasDescriptor aliasDescriptor = this.getDescriptorViaIndex(0, execIndexRow, null, tabInfoImpl, null, null, AliasDescriptor.class, true, 4, transactionController);
        UUID uUID = aliasDescriptor.getUUID();
        TabInfoImpl tabInfoImpl2 = this.getNonCoreTI(18);
        ExecIndexRow execIndexRow2 = this.exFactory.getIndexableRow(3);
        execIndexRow2.setColumn(1, new SQLVarchar("PUBLIC"));
        execIndexRow2.setColumn(2, new SQLChar(uUID.toString()));
        execIndexRow2.setColumn(3, new SQLVarchar((String)null));
        int n2 = tabInfoImpl2.deleteRow(transactionController, execIndexRow2, 0);
    }

    @Override
    public ColumnDescriptor getColumnDescriptorByDefaultId(UUID uUID) throws StandardException {
        TabInfoImpl tabInfoImpl = this.coreInfo[2];
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(uUID);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        return this.getDescriptorViaIndex(1, execIndexRow, null, tabInfoImpl, null, null, ColumnDescriptor.class, false);
    }

    private void getColumnDescriptorsScan(TableDescriptor tableDescriptor) throws StandardException {
        this.getColumnDescriptorsScan(tableDescriptor.getUUID(), tableDescriptor.getColumnDescriptorList(), tableDescriptor);
    }

    private void getColumnDescriptorsScan(UUID uUID, ColumnDescriptorList columnDescriptorList, TupleDescriptor tupleDescriptor) throws StandardException {
        int n2;
        ColumnDescriptorList columnDescriptorList2 = new ColumnDescriptorList();
        SQLChar sQLChar = null;
        TabInfoImpl tabInfoImpl = this.coreInfo[2];
        sQLChar = DataDictionaryImpl.getIDValueAsCHAR(uUID);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        this.getDescriptorViaIndex(0, execIndexRow, null, tabInfoImpl, tupleDescriptor, columnDescriptorList, ColumnDescriptor.class, false);
        int n3 = columnDescriptorList.size();
        for (n2 = 0; n2 < n3; ++n2) {
            columnDescriptorList2.add(columnDescriptorList.get(n2));
        }
        for (n2 = 0; n2 < n3; ++n2) {
            ColumnDescriptor columnDescriptor = columnDescriptorList2.elementAt(n2);
            columnDescriptorList.set(columnDescriptor.getPosition() - 1, columnDescriptor);
        }
    }

    @Override
    public void dropColumnDescriptor(UUID uUID, String string, TransactionController transactionController) throws StandardException {
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(uUID);
        SQLVarchar sQLVarchar = new SQLVarchar(string);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(2);
        execIndexRow.setColumn(1, sQLChar);
        execIndexRow.setColumn(2, sQLVarchar);
        this.dropColumnDescriptorCore(transactionController, execIndexRow);
    }

    @Override
    public void dropAllColumnDescriptors(UUID uUID, TransactionController transactionController) throws StandardException {
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(uUID);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        this.dropColumnDescriptorCore(transactionController, execIndexRow);
    }

    @Override
    public void dropAllTableAndColPermDescriptors(UUID uUID, TransactionController transactionController) throws StandardException {
        if (!this.usesSqlAuthorization) {
            return;
        }
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(uUID);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        this.dropTablePermDescriptor(transactionController, execIndexRow);
        this.dropColumnPermDescriptor(transactionController, execIndexRow);
    }

    @Override
    public void updateSYSCOLPERMSforAddColumnToUserTable(UUID uUID, TransactionController transactionController) throws StandardException {
        this.rewriteSYSCOLPERMSforAlterTable(uUID, transactionController, null);
    }

    @Override
    public void updateSYSCOLPERMSforDropColumn(UUID uUID, TransactionController transactionController, ColumnDescriptor columnDescriptor) throws StandardException {
        this.rewriteSYSCOLPERMSforAlterTable(uUID, transactionController, columnDescriptor);
    }

    private void rewriteSYSCOLPERMSforAlterTable(UUID uUID, TransactionController transactionController, ColumnDescriptor columnDescriptor) throws StandardException {
        if (!this.usesSqlAuthorization) {
            return;
        }
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(uUID);
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(17);
        SYSCOLPERMSRowFactory sYSCOLPERMSRowFactory = (SYSCOLPERMSRowFactory)tabInfoImpl.getCatalogRowFactory();
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        List<ColPermsDescriptor> list = DataDictionaryImpl.newSList();
        this.getDescriptorViaIndex(2, execIndexRow, null, tabInfoImpl, null, list, ColPermsDescriptor.class, false);
        boolean[] blArray = new boolean[3];
        int[] nArray = new int[]{6};
        for (ColPermsDescriptor colPermsDescriptor : list) {
            this.removePermEntryInCache(colPermsDescriptor);
            ExecIndexRow execIndexRow2 = sYSCOLPERMSRowFactory.buildIndexKeyRow(1, colPermsDescriptor);
            ExecRow execRow = tabInfoImpl.getRow(transactionController, execIndexRow2, 1);
            FormatableBitSet formatableBitSet = (FormatableBitSet)execRow.getColumn(6).getObject();
            if (columnDescriptor == null) {
                int n2 = formatableBitSet.getLength();
                formatableBitSet.grow(n2 + 1);
            } else {
                FormatableBitSet formatableBitSet2 = new FormatableBitSet(formatableBitSet);
                formatableBitSet2.shrink(formatableBitSet.getLength() - 1);
                for (int i2 = columnDescriptor.getPosition() - 1; i2 < formatableBitSet2.getLength(); ++i2) {
                    if (formatableBitSet.isSet(i2 + 1)) {
                        formatableBitSet2.set(i2);
                        continue;
                    }
                    formatableBitSet2.clear(i2);
                }
                formatableBitSet = formatableBitSet2;
            }
            execRow.setColumn(6, new UserType(formatableBitSet));
            tabInfoImpl.updateRow(execIndexRow2, execRow, 1, blArray, nArray, transactionController);
        }
    }

    private void removePermEntryInCache(PermissionsDescriptor permissionsDescriptor) throws StandardException {
        Cacheable cacheable = this.getPermissionsCache().findCached(permissionsDescriptor);
        if (cacheable != null) {
            this.getPermissionsCache().remove(cacheable);
        }
    }

    @Override
    public void dropAllRoutinePermDescriptors(UUID uUID, TransactionController transactionController) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(18);
        SYSROUTINEPERMSRowFactory sYSROUTINEPERMSRowFactory = (SYSROUTINEPERMSRowFactory)tabInfoImpl.getCatalogRowFactory();
        if (!this.usesSqlAuthorization) {
            return;
        }
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(uUID);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        while (true) {
            ExecRow execRow = tabInfoImpl.getRow(transactionController, execIndexRow, 2);
            if (execRow == null) break;
            PermissionsDescriptor permissionsDescriptor = (PermissionsDescriptor)sYSROUTINEPERMSRowFactory.buildDescriptor(execRow, null, this);
            this.removePermEntryInCache(permissionsDescriptor);
            ExecIndexRow execIndexRow2 = sYSROUTINEPERMSRowFactory.buildIndexKeyRow(1, permissionsDescriptor);
            tabInfoImpl.deleteRow(transactionController, execIndexRow2, 1);
        }
    }

    @Override
    public void dropRoleGrantsByGrantee(String string, TransactionController transactionController) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(19);
        SYSROLESRowFactory sYSROLESRowFactory = (SYSROLESRowFactory)tabInfoImpl.getCatalogRowFactory();
        this.visitRoleGrants(tabInfoImpl, sYSROLESRowFactory, 2, string, transactionController, 0);
    }

    private boolean existsRoleGrantByGrantee(String string, TransactionController transactionController) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(19);
        SYSROLESRowFactory sYSROLESRowFactory = (SYSROLESRowFactory)tabInfoImpl.getCatalogRowFactory();
        return this.visitRoleGrants(tabInfoImpl, sYSROLESRowFactory, 2, string, transactionController, 1);
    }

    @Override
    public void dropRoleGrantsByName(String string, TransactionController transactionController) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(19);
        SYSROLESRowFactory sYSROLESRowFactory = (SYSROLESRowFactory)tabInfoImpl.getCatalogRowFactory();
        this.visitRoleGrants(tabInfoImpl, sYSROLESRowFactory, 1, string, transactionController, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean visitRoleGrants(TabInfoImpl tabInfoImpl, SYSROLESRowFactory sYSROLESRowFactory, int n2, String string, TransactionController transactionController, int n3) throws StandardException {
        ConglomerateController conglomerateController = transactionController.openConglomerate(tabInfoImpl.getHeapConglomerate(), false, 0, 6, 4);
        SQLVarchar sQLVarchar = new SQLVarchar(string);
        Qualifier[][] qualifierArray = this.exFactory.getScanQualifier(1);
        qualifierArray[0][0].setQualifier(n2 - 1, sQLVarchar, 2, false, false, false);
        ScanController scanController = transactionController.openScan(tabInfoImpl.getIndexConglomerate(0), false, 0, 6, 4, null, null, 0, qualifierArray, null, 0);
        try {
            ExecRow execRow = sYSROLESRowFactory.makeEmptyRow();
            ExecIndexRow execIndexRow = DataDictionaryImpl.getIndexRowFromHeapRow(tabInfoImpl.getIndexRowGenerator(0), conglomerateController.newRowLocationTemplate(), execRow);
            while (scanController.fetchNext(execIndexRow.getRowArray())) {
                if (n3 == 1) {
                    boolean bl2 = true;
                    return bl2;
                }
                if (n3 != 0) continue;
                tabInfoImpl.deleteRow(transactionController, execIndexRow, 0);
            }
        }
        finally {
            if (scanController != null) {
                scanController.close();
            }
            if (conglomerateController != null) {
                conglomerateController.close();
            }
        }
        return false;
    }

    HashMap<String, List<RoleGrantDescriptor>> getRoleGrantGraph(TransactionController transactionController, boolean bl2) throws StandardException {
        HashMap<String, List<RoleGrantDescriptor>> hashMap = new HashMap<String, List<RoleGrantDescriptor>>();
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(19);
        SYSROLESRowFactory sYSROLESRowFactory = (SYSROLESRowFactory)tabInfoImpl.getCatalogRowFactory();
        SQLVarchar sQLVarchar = new SQLVarchar("N");
        Qualifier[][] qualifierArray = this.exFactory.getScanQualifier(1);
        qualifierArray[0][0].setQualifier(5, sQLVarchar, 2, false, false, false);
        ScanController scanController = transactionController.openScan(tabInfoImpl.getHeapConglomerate(), false, 0, 6, 4, null, null, 0, qualifierArray, null, 0);
        ExecRow execRow = sYSROLESRowFactory.makeEmptyRow();
        while (scanController.fetchNext(execRow.getRowArray())) {
            RoleGrantDescriptor roleGrantDescriptor = (RoleGrantDescriptor)sYSROLESRowFactory.buildDescriptor(execRow, null, this);
            RoleGrantDescriptor roleGrantDescriptor2 = this.getRoleDefinitionDescriptor(roleGrantDescriptor.getGrantee());
            if (roleGrantDescriptor2 == null) continue;
            String string = bl2 ? roleGrantDescriptor2.getRoleName() : roleGrantDescriptor.getRoleName();
            List<RoleGrantDescriptor> list = hashMap.get(string);
            if (list == null) {
                list = new LinkedList<RoleGrantDescriptor>();
            }
            list.add(roleGrantDescriptor);
            hashMap.put(string, list);
        }
        scanController.close();
        return hashMap;
    }

    @Override
    public RoleClosureIterator createRoleClosureIterator(TransactionController transactionController, String string, boolean bl2) throws StandardException {
        return new RoleClosureIteratorImpl(string, bl2, this, transactionController);
    }

    @Override
    public void dropAllPermsByGrantee(String string, TransactionController transactionController) throws StandardException {
        this.dropPermsByGrantee(string, transactionController, 16, 0, 1);
        this.dropPermsByGrantee(string, transactionController, 17, 0, 1);
        this.dropPermsByGrantee(string, transactionController, 18, 0, 1);
    }

    private void dropPermsByGrantee(String string, TransactionController transactionController, int n2, int n3, int n4) throws StandardException {
        this.visitPermsByGrantee(string, transactionController, n2, n3, n4, 0);
    }

    private boolean existsPermByGrantee(String string, TransactionController transactionController, int n2, int n3, int n4) throws StandardException {
        return this.visitPermsByGrantee(string, transactionController, n2, n3, n4, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean visitPermsByGrantee(String string, TransactionController transactionController, int n2, int n3, int n4, int n5) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(n2);
        PermissionsCatalogRowFactory permissionsCatalogRowFactory = (PermissionsCatalogRowFactory)tabInfoImpl.getCatalogRowFactory();
        ConglomerateController conglomerateController = transactionController.openConglomerate(tabInfoImpl.getHeapConglomerate(), false, 0, 6, 4);
        SQLVarchar sQLVarchar = new SQLVarchar(string);
        Qualifier[][] qualifierArray = this.exFactory.getScanQualifier(1);
        qualifierArray[0][0].setQualifier(n4 - 1, sQLVarchar, 2, false, false, false);
        ScanController scanController = transactionController.openScan(tabInfoImpl.getIndexConglomerate(n3), false, 0, 6, 4, null, null, 0, qualifierArray, null, 0);
        try {
            ExecRow execRow = permissionsCatalogRowFactory.makeEmptyRow();
            ExecIndexRow execIndexRow = DataDictionaryImpl.getIndexRowFromHeapRow(tabInfoImpl.getIndexRowGenerator(n3), conglomerateController.newRowLocationTemplate(), execRow);
            while (scanController.fetchNext(execIndexRow.getRowArray())) {
                RowLocation rowLocation = (RowLocation)execIndexRow.getColumn(execIndexRow.nColumns());
                boolean bl2 = conglomerateController.fetch(rowLocation, execRow.getRowArray(), null);
                if (n5 == 1) {
                    boolean bl3 = true;
                    return bl3;
                }
                if (n5 != 0) continue;
                PermissionsDescriptor permissionsDescriptor = (PermissionsDescriptor)permissionsCatalogRowFactory.buildDescriptor(execRow, null, this);
                this.removePermEntryInCache(permissionsDescriptor);
                tabInfoImpl.deleteRow(transactionController, execIndexRow, n3);
            }
        }
        finally {
            if (scanController != null) {
                scanController.close();
            }
            if (conglomerateController != null) {
                conglomerateController.close();
            }
        }
        return false;
    }

    private void dropColumnDescriptorCore(TransactionController transactionController, ExecIndexRow execIndexRow) throws StandardException {
        TabInfoImpl tabInfoImpl = this.coreInfo[2];
        tabInfoImpl.deleteRow(transactionController, execIndexRow, 0);
    }

    private void dropTablePermDescriptor(TransactionController transactionController, ExecIndexRow execIndexRow) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(16);
        SYSTABLEPERMSRowFactory sYSTABLEPERMSRowFactory = (SYSTABLEPERMSRowFactory)tabInfoImpl.getCatalogRowFactory();
        while (true) {
            ExecRow execRow = tabInfoImpl.getRow(transactionController, execIndexRow, 2);
            if (execRow == null) break;
            PermissionsDescriptor permissionsDescriptor = (PermissionsDescriptor)sYSTABLEPERMSRowFactory.buildDescriptor(execRow, null, this);
            this.removePermEntryInCache(permissionsDescriptor);
            ExecIndexRow execIndexRow2 = sYSTABLEPERMSRowFactory.buildIndexKeyRow(1, permissionsDescriptor);
            tabInfoImpl.deleteRow(transactionController, execIndexRow2, 1);
        }
    }

    private void dropColumnPermDescriptor(TransactionController transactionController, ExecIndexRow execIndexRow) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(17);
        SYSCOLPERMSRowFactory sYSCOLPERMSRowFactory = (SYSCOLPERMSRowFactory)tabInfoImpl.getCatalogRowFactory();
        while (true) {
            ExecRow execRow = tabInfoImpl.getRow(transactionController, execIndexRow, 2);
            if (execRow == null) break;
            PermissionsDescriptor permissionsDescriptor = (PermissionsDescriptor)sYSCOLPERMSRowFactory.buildDescriptor(execRow, null, this);
            this.removePermEntryInCache(permissionsDescriptor);
            ExecIndexRow execIndexRow2 = sYSCOLPERMSRowFactory.buildIndexKeyRow(1, permissionsDescriptor);
            tabInfoImpl.deleteRow(transactionController, execIndexRow2, 1);
        }
    }

    private void updateColumnDescriptor(ColumnDescriptor columnDescriptor, UUID uUID, String string, int[] nArray, TransactionController transactionController) throws StandardException {
        boolean[] blArray;
        ExecRow execRow;
        TabInfoImpl tabInfoImpl;
        ExecIndexRow execIndexRow;
        block4: {
            block3: {
                execIndexRow = null;
                tabInfoImpl = this.coreInfo[2];
                SYSCOLUMNSRowFactory sYSCOLUMNSRowFactory = (SYSCOLUMNSRowFactory)tabInfoImpl.getCatalogRowFactory();
                SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(uUID);
                SQLVarchar sQLVarchar = new SQLVarchar(string);
                execIndexRow = this.exFactory.getIndexableRow(2);
                execIndexRow.setColumn(1, sQLChar);
                execIndexRow.setColumn(2, sQLVarchar);
                execRow = sYSCOLUMNSRowFactory.makeRow(columnDescriptor, null);
                blArray = new boolean[sYSCOLUMNSRowFactory.getNumIndexes()];
                if (nArray != null) break block3;
                blArray[0] = true;
                blArray[1] = true;
                break block4;
            }
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                block6: {
                    block5: {
                        if (nArray[i2] == 2) break block5;
                        if (nArray[i2] != 1) break block6;
                    }
                    blArray[0] = true;
                    break;
                }
                if (nArray[i2] != 6) continue;
                blArray[1] = true;
                break;
            }
        }
        tabInfoImpl.updateRow(execIndexRow, execRow, 0, blArray, nArray, transactionController);
    }

    @Override
    public ViewDescriptor getViewDescriptor(UUID uUID) throws StandardException {
        return this.getViewDescriptor(this.getTableDescriptor(uUID));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ViewDescriptor getViewDescriptor(TableDescriptor tableDescriptor) throws StandardException {
        TableDescriptor tableDescriptor2 = tableDescriptor;
        if (tableDescriptor2.getViewDescriptor() != null) {
            return tableDescriptor2.getViewDescriptor();
        }
        TableDescriptor tableDescriptor3 = tableDescriptor2;
        synchronized (tableDescriptor3) {
            if (tableDescriptor2.getViewDescriptor() != null) {
                return tableDescriptor2.getViewDescriptor();
            }
            tableDescriptor2.setViewDescriptor(this.getViewDescriptorScan(tableDescriptor2));
        }
        return tableDescriptor2.getViewDescriptor();
    }

    private ViewDescriptor getViewDescriptorScan(TableDescriptor tableDescriptor) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(8);
        UUID uUID = tableDescriptor.getUUID();
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(uUID);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        ViewDescriptor viewDescriptor = this.getDescriptorViaIndex(0, execIndexRow, null, tabInfoImpl, null, null, ViewDescriptor.class, false);
        if (viewDescriptor != null) {
            viewDescriptor.setViewName(tableDescriptor.getName());
        }
        return viewDescriptor;
    }

    @Override
    public void dropViewDescriptor(ViewDescriptor viewDescriptor, TransactionController transactionController) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(8);
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(viewDescriptor.getUUID());
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        tabInfoImpl.deleteRow(transactionController, execIndexRow, 0);
    }

    private FileInfoDescriptor getFileInfoDescriptorIndex2Scan(UUID uUID) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(12);
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(uUID);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        return this.getDescriptorViaIndex(1, execIndexRow, null, tabInfoImpl, null, null, FileInfoDescriptor.class, false);
    }

    @Override
    public FileInfoDescriptor getFileInfoDescriptor(UUID uUID) throws StandardException {
        return this.getFileInfoDescriptorIndex2Scan(uUID);
    }

    private FileInfoDescriptor getFileInfoDescriptorIndex1Scan(UUID uUID, String string) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(12);
        SQLVarchar sQLVarchar = new SQLVarchar(string);
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(uUID);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(2);
        execIndexRow.setColumn(1, sQLVarchar);
        execIndexRow.setColumn(2, sQLChar);
        FileInfoDescriptor fileInfoDescriptor = this.getDescriptorViaIndex(0, execIndexRow, null, tabInfoImpl, null, null, FileInfoDescriptor.class, false);
        return fileInfoDescriptor;
    }

    @Override
    public FileInfoDescriptor getFileInfoDescriptor(SchemaDescriptor schemaDescriptor, String string) throws StandardException {
        return this.getFileInfoDescriptorIndex1Scan(schemaDescriptor.getUUID(), string);
    }

    @Override
    public void dropFileInfoDescriptor(FileInfoDescriptor fileInfoDescriptor) throws StandardException {
        ExecIndexRow execIndexRow = null;
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(12);
        TransactionController transactionController = this.getTransactionExecute();
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(fileInfoDescriptor.getUUID());
        execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        tabInfoImpl.deleteRow(transactionController, execIndexRow, 1);
    }

    @Override
    public SPSDescriptor getSPSDescriptor(UUID uUID) throws StandardException {
        SPSDescriptor sPSDescriptor;
        this.getNonCoreTI(11);
        if (this.spsNameCache != null && this.getCacheMode() == 0) {
            sPSDescriptor = this.spsIdHash.get(uUID);
            if (sPSDescriptor != null) {
                return sPSDescriptor;
            }
            sPSDescriptor = this.getSPSDescriptorIndex2Scan(uUID.toString());
            TableKey tableKey = new TableKey(sPSDescriptor.getSchemaDescriptor().getUUID(), sPSDescriptor.getName());
            try {
                SPSNameCacheable sPSNameCacheable = (SPSNameCacheable)this.spsNameCache.create(tableKey, sPSDescriptor);
                this.spsNameCache.release(sPSNameCacheable);
            }
            catch (StandardException standardException) {
                if ("XBCA0.S".equals(standardException.getMessageId())) {
                    return sPSDescriptor;
                }
                throw standardException;
            }
        } else {
            sPSDescriptor = this.getSPSDescriptorIndex2Scan(uUID.toString());
        }
        return sPSDescriptor;
    }

    void spsCacheEntryAdded(SPSDescriptor sPSDescriptor) {
        this.spsIdHash.put(sPSDescriptor.getUUID(), sPSDescriptor);
    }

    void spsCacheEntryRemoved(SPSDescriptor sPSDescriptor) {
        this.spsIdHash.remove(sPSDescriptor.getUUID());
    }

    SPSDescriptor getUncachedSPSDescriptor(TableKey tableKey) throws StandardException {
        return this.getSPSDescriptorIndex1Scan(tableKey.getTableName(), tableKey.getSchemaId().toString());
    }

    protected SPSDescriptor getUncachedSPSDescriptor(UUID uUID) throws StandardException {
        return this.getSPSDescriptorIndex2Scan(uUID.toString());
    }

    private SPSDescriptor getSPSDescriptorIndex2Scan(String string) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(11);
        SQLChar sQLChar = new SQLChar(string);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        SPSDescriptor sPSDescriptor = this.getDescriptorViaIndex(0, execIndexRow, null, tabInfoImpl, null, null, SPSDescriptor.class, false);
        return sPSDescriptor;
    }

    @Override
    public SPSDescriptor getSPSDescriptor(String string, SchemaDescriptor schemaDescriptor) throws StandardException {
        SPSDescriptor sPSDescriptor = null;
        UUID uUID = schemaDescriptor.getUUID();
        if (this.spsNameCache != null && this.getCacheMode() == 0) {
            TableKey tableKey = new TableKey(uUID, string);
            SPSNameCacheable sPSNameCacheable = (SPSNameCacheable)this.spsNameCache.find(tableKey);
            if (sPSNameCacheable != null) {
                sPSDescriptor = sPSNameCacheable.getSPSDescriptor();
                this.spsNameCache.release(sPSNameCacheable);
            }
            return sPSDescriptor;
        }
        return this.getSPSDescriptorIndex1Scan(string, uUID.toString());
    }

    private SPSDescriptor getSPSDescriptorIndex1Scan(String string, String string2) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(11);
        SQLVarchar sQLVarchar = new SQLVarchar(string);
        SQLChar sQLChar = new SQLChar(string2);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(2);
        execIndexRow.setColumn(1, sQLVarchar);
        execIndexRow.setColumn(2, sQLChar);
        SPSDescriptor sPSDescriptor = this.getDescriptorViaIndex(1, execIndexRow, null, tabInfoImpl, null, null, SPSDescriptor.class, false);
        if (sPSDescriptor != null) {
            ArrayList<DataValueDescriptor> arrayList = new ArrayList<DataValueDescriptor>();
            sPSDescriptor.setParams(this.getSPSParams(sPSDescriptor, arrayList));
            Object[] objectArray = arrayList.toArray();
            sPSDescriptor.setParameterDefaults(objectArray);
        }
        return sPSDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSPSDescriptor(SPSDescriptor sPSDescriptor, TransactionController transactionController) throws StandardException {
        int n2;
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(11);
        SYSSTATEMENTSRowFactory sYSSTATEMENTSRowFactory = (SYSSTATEMENTSRowFactory)tabInfoImpl.getCatalogRowFactory();
        SPSDescriptor sPSDescriptor2 = sPSDescriptor;
        synchronized (sPSDescriptor2) {
            boolean bl2 = sPSDescriptor.initiallyCompilable();
            ExecRow execRow = sYSSTATEMENTSRowFactory.makeSYSSTATEMENTSrow(bl2, sPSDescriptor);
            n2 = tabInfoImpl.insertRow(execRow, transactionController);
        }
        if (n2 != -1) {
            throw StandardException.newException("X0Y32.S", sPSDescriptor.getDescriptorType(), sPSDescriptor.getDescriptorName(), sPSDescriptor.getSchemaDescriptor().getDescriptorType(), sPSDescriptor.getSchemaDescriptor().getSchemaName());
        }
        this.addSPSParams(sPSDescriptor, transactionController);
    }

    private void addSPSParams(SPSDescriptor sPSDescriptor, TransactionController transactionController) throws StandardException {
        UUID uUID = sPSDescriptor.getUUID();
        DataTypeDescriptor[] dataTypeDescriptorArray = sPSDescriptor.getParams();
        Object[] objectArray = sPSDescriptor.getParameterDefaults();
        if (dataTypeDescriptorArray == null) {
            return;
        }
        int n2 = dataTypeDescriptorArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = i2 + 1;
            ColumnDescriptor columnDescriptor = new ColumnDescriptor("PARAM" + n3, n3, dataTypeDescriptorArray[i2], objectArray == null || i2 >= objectArray.length ? (DataValueDescriptor)null : (DataValueDescriptor)objectArray[i2], (DefaultInfo)null, uUID, (UUID)null, 0L, 0L, 0L);
            this.addDescriptor(columnDescriptor, null, 2, false, transactionController);
        }
    }

    @Override
    public DataTypeDescriptor[] getSPSParams(SPSDescriptor sPSDescriptor, List<DataValueDescriptor> list) throws StandardException {
        ColumnDescriptorList columnDescriptorList = new ColumnDescriptorList();
        this.getColumnDescriptorsScan(sPSDescriptor.getUUID(), columnDescriptorList, sPSDescriptor);
        int n2 = columnDescriptorList.size();
        DataTypeDescriptor[] dataTypeDescriptorArray = new DataTypeDescriptor[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            ColumnDescriptor columnDescriptor = columnDescriptorList.elementAt(i2);
            dataTypeDescriptorArray[i2] = columnDescriptor.getType();
            if (list == null) continue;
            list.add(columnDescriptor.getDefaultValue());
        }
        return dataTypeDescriptorArray;
    }

    @Override
    public void updateSPS(SPSDescriptor sPSDescriptor, TransactionController transactionController, boolean bl2) throws StandardException {
        ExecIndexRow execIndexRow = null;
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(11);
        SYSSTATEMENTSRowFactory sYSSTATEMENTSRowFactory = (SYSSTATEMENTSRowFactory)tabInfoImpl.getCatalogRowFactory();
        int[] nArray = bl2 ? new int[]{5, 6, 7, 9, 10} : new int[]{5, 10};
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(sPSDescriptor.getUUID());
        execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        ExecRow execRow = sYSSTATEMENTSRowFactory.makeSYSSTATEMENTSrow(false, sPSDescriptor);
        boolean[] blArray = new boolean[2];
        tabInfoImpl.updateRow(execIndexRow, execRow, 0, blArray, nArray, transactionController);
        if (!bl2) {
            return;
        }
        DataTypeDescriptor[] dataTypeDescriptorArray = sPSDescriptor.getParams();
        if (dataTypeDescriptorArray == null) {
            return;
        }
        this.dropAllColumnDescriptors(sPSDescriptor.getUUID(), transactionController);
        this.addSPSParams(sPSDescriptor, transactionController);
    }

    @Override
    public void invalidateAllSPSPlans() throws StandardException {
        LanguageConnectionContext languageConnectionContext = (LanguageConnectionContext)DataDictionaryImpl.getContext("LanguageConnectionContext");
        this.invalidateAllSPSPlans(languageConnectionContext);
    }

    @Override
    public void invalidateAllSPSPlans(LanguageConnectionContext languageConnectionContext) throws StandardException {
        this.startWriting(languageConnectionContext);
        for (SPSDescriptor sPSDescriptor : this.getAllSPSDescriptors()) {
            sPSDescriptor.makeInvalid(14, languageConnectionContext);
        }
    }

    void clearSPSPlans() throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(11);
        this.faultInTabInfo(tabInfoImpl);
        TransactionController transactionController = this.getTransactionExecute();
        FormatableBitSet formatableBitSet = new FormatableBitSet(11);
        FormatableBitSet formatableBitSet2 = new FormatableBitSet(11);
        formatableBitSet2.set(4);
        formatableBitSet2.set(9);
        DataValueDescriptor[] dataValueDescriptorArray = new DataValueDescriptor[11];
        dataValueDescriptorArray[4] = new SQLBoolean(false);
        dataValueDescriptorArray[9] = new UserType(null);
        ScanController scanController = transactionController.openScan(tabInfoImpl.getHeapConglomerate(), false, 4, 7, 4, formatableBitSet, null, 0, null, null, 0);
        while (scanController.fetchNext(null)) {
            scanController.replace(dataValueDescriptorArray, formatableBitSet2);
        }
        scanController.close();
    }

    @Override
    public void dropSPSDescriptor(SPSDescriptor sPSDescriptor, TransactionController transactionController) throws StandardException {
        this.dropSPSDescriptor(sPSDescriptor.getUUID(), transactionController);
    }

    @Override
    public void dropSPSDescriptor(UUID uUID, TransactionController transactionController) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(11);
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(uUID);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        tabInfoImpl.deleteRow(transactionController, execIndexRow, 0);
        this.dropAllColumnDescriptors(uUID, transactionController);
    }

    @Override
    public List<SPSDescriptor> getAllSPSDescriptors() throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(11);
        List<SPSDescriptor> list = DataDictionaryImpl.newSList();
        FormatableBitSet formatableBitSet = new FormatableBitSet(tabInfoImpl.getCatalogRowFactory().getHeapColumnCount());
        for (int i2 = 0; i2 < formatableBitSet.size(); ++i2) {
            if (i2 + 1 == 10) {
                formatableBitSet.clear(i2);
                continue;
            }
            formatableBitSet.set(i2);
        }
        this.getDescriptorViaHeap(formatableBitSet, null, tabInfoImpl, null, list, SPSDescriptor.class);
        return list;
    }

    private ConstraintDescriptorList getAllConstraintDescriptors() throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(4);
        ConstraintDescriptorList constraintDescriptorList = new ConstraintDescriptorList();
        this.getConstraintDescriptorViaHeap(null, tabInfoImpl, null, constraintDescriptorList);
        return constraintDescriptorList;
    }

    @Override
    public int[] examineTriggerNodeAndCols(Visitable visitable, String string, String string2, String string3, int[] nArray, int[] nArray2, int n2, TableDescriptor tableDescriptor, int n3, boolean bl2, List<int[]> list) throws StandardException {
        int n4;
        boolean bl3 = this.checkVersion(210, null);
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl4 = false;
        int n5 = tableDescriptor.getNumberOfColumns();
        int[] nArray3 = new int[n5];
        int[] nArray4 = new int[n5];
        Arrays.fill(nArray4, -1);
        if (nArray == null) {
            for (n4 = 0; n4 < n5; ++n4) {
                nArray3[n4] = n4 + 1;
            }
        } else {
            Arrays.fill(nArray3, -1);
            for (n4 = 0; n4 < nArray.length; ++n4) {
                nArray3[nArray[n4] - 1] = nArray[n4];
            }
        }
        if (nArray2 != null) {
            for (n4 = 0; n4 < nArray2.length; ++n4) {
                if (nArray2[n4] <= 0) continue;
                nArray3[nArray2[n4] - 1] = nArray2[n4];
            }
        }
        SortedSet<ColumnReference> sortedSet = DataDictionaryImpl.getTransitionVariables(visitable, string, string2);
        if (bl2) {
            for (ColumnReference columnReference : sortedSet) {
                int n6;
                TableName tableName = columnReference.getQualifiedTableName();
                this.checkInvalidTriggerReference(tableName.getTableName(), string, string2, n3);
                String string4 = columnReference.getColumnName();
                ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(string4);
                if (columnDescriptor == null) {
                    throw StandardException.newException("42X04", tableName + "." + string4);
                }
                if (!bl3) continue;
                nArray3[n6 - 1] = n6 = columnDescriptor.getPosition();
                nArray4[n6 - 1] = n6;
                nArray2[n6 - 1] = n6;
            }
        } else if (nArray != null && nArray2 != null) {
            for (int i2 = 0; i2 < nArray2.length; ++i2) {
                nArray3[nArray2[i2] - 1] = nArray2[i2];
            }
        }
        Arrays.sort(nArray3);
        nArray3 = this.justTheRequiredColumns(nArray3, tableDescriptor);
        return nArray3;
    }

    @Override
    public String getTriggerActionString(Visitable visitable, String string, String string2, String string3, int[] nArray, int[] nArray2, int n2, TableDescriptor tableDescriptor, int n3, boolean bl2, List<int[]> list, int[] nArray3) throws StandardException {
        boolean bl3 = this.checkVersion(210, null);
        StringBuilder stringBuilder = new StringBuilder();
        int n4 = 0;
        int n5 = tableDescriptor.getNumberOfColumns();
        int[] nArray4 = new int[n5];
        SortedSet<ColumnReference> sortedSet = DataDictionaryImpl.getTransitionVariables(visitable, string, string2);
        nArray4 = nArray3;
        for (ColumnReference columnReference : sortedSet) {
            int n6;
            TableName tableName = columnReference.getQualifiedTableName();
            int n7 = tableName.getBeginOffset() - n2;
            String string4 = columnReference.getColumnName();
            stringBuilder.append(string3, n4, n7);
            int n8 = -1;
            ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(string4);
            if (columnDescriptor == null) {
                throw StandardException.newException("42X04", tableName + "." + string4);
            }
            int n9 = columnDescriptor.getPosition();
            if (bl3 && nArray4 != null) {
                for (n6 = 0; n6 < nArray4.length; ++n6) {
                    if (nArray4[n6] != n9) continue;
                    n8 = n6 + 1;
                }
            } else {
                n8 = n9;
            }
            n6 = stringBuilder.length();
            stringBuilder.append(this.genColumnReferenceSQL(tableDescriptor, string4, tableName.getTableName(), tableName.getTableName().equals(string), n8));
            n4 = columnReference.getEndOffset() + 1 - n2;
            if (list == null) continue;
            list.add(new int[]{n7, n4, n6, stringBuilder.length()});
        }
        stringBuilder.append(string3, n4, string3.length());
        return stringBuilder.toString();
    }

    private static SortedSet<ColumnReference> getTransitionVariables(Visitable visitable, String string, String string2) throws StandardException {
        SortedSet<ColumnReference> sortedSet = ((QueryTreeNode)visitable).getOffsetOrderedNodes(ColumnReference.class);
        Iterator iterator = sortedSet.iterator();
        while (iterator.hasNext()) {
            TableName tableName = ((ColumnReference)iterator.next()).getQualifiedTableName();
            if (DataDictionaryImpl.isTransitionVariable(tableName, string, string2)) continue;
            iterator.remove();
        }
        return sortedSet;
    }

    private static boolean isTransitionVariable(TableName tableName, String string, String string2) {
        if (tableName != null) {
            if (tableName.hasSchema()) {
                return false;
            }
            String string3 = tableName.getTableName();
            if (string3 != null) {
                return string3.equals(string) || string3.equals(string2);
            }
        }
        return false;
    }

    private int[] justTheRequiredColumns(int[] nArray, TableDescriptor tableDescriptor) {
        int n2 = 0;
        int n3 = tableDescriptor.getNumberOfColumns();
        for (int i2 = 0; i2 < n3; ++i2) {
            if (nArray[i2] == -1) continue;
            ++n2;
        }
        if (n2 > 0) {
            int[] nArray2 = new int[n2];
            int n4 = 0;
            for (int i3 = 0; i3 < n3; ++i3) {
                if (nArray[i3] == -1) continue;
                nArray2[n4++] = nArray[i3];
            }
            return nArray2;
        }
        return null;
    }

    private void checkInvalidTriggerReference(String string, String string2, String string3, int n2) throws StandardException {
        if (string.equals(string2) && (n2 & 4) == 4) {
            throw StandardException.newException("42Y92", "INSERT", "new");
        }
        if (string.equals(string3) && (n2 & 2) == 2) {
            throw StandardException.newException("42Y92", "DELETE", "old");
        }
    }

    private String genColumnReferenceSQL(TableDescriptor tableDescriptor, String string, String string2, boolean bl2, int n2) throws StandardException {
        ColumnDescriptor columnDescriptor = null;
        columnDescriptor = tableDescriptor.getColumnDescriptor(string);
        if (columnDescriptor == null) {
            throw StandardException.newException("42X04", string2 + "." + string);
        }
        DataTypeDescriptor dataTypeDescriptor = columnDescriptor.getType();
        TypeId typeId = dataTypeDescriptor.getTypeId();
        if (!typeId.isXMLTypeId()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("CAST (org.apache.derby.iapi.db.Factory::getTriggerExecutionContext().");
            stringBuffer.append(bl2 ? "getOldRow()" : "getNewRow()");
            stringBuffer.append(".getObject(");
            stringBuffer.append(n2);
            stringBuffer.append(") AS ");
            stringBuffer.append(typeId.userType() ? typeId.getSQLTypeName() : dataTypeDescriptor.getSQLstring());
            stringBuffer.append(") ");
            return stringBuffer.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("XMLPARSE(DOCUMENT CAST( ");
        stringBuffer.append("org.apache.derby.iapi.db.Factory::getTriggerExecutionContext().");
        stringBuffer.append(bl2 ? "getOldRow()" : "getNewRow()");
        stringBuffer.append(".getString(");
        stringBuffer.append(n2);
        stringBuffer.append(") AS CLOB) PRESERVE WHITESPACE ) ");
        return stringBuffer.toString();
    }

    @Override
    public TriggerDescriptor getTriggerDescriptor(UUID uUID) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(13);
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(uUID);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        return this.getDescriptorViaIndex(0, execIndexRow, null, tabInfoImpl, null, null, TriggerDescriptor.class, false);
    }

    @Override
    public TriggerDescriptor getTriggerDescriptor(String string, SchemaDescriptor schemaDescriptor) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(13);
        SQLVarchar sQLVarchar = new SQLVarchar(string);
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(schemaDescriptor.getUUID());
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(2);
        execIndexRow.setColumn(1, sQLVarchar);
        execIndexRow.setColumn(2, sQLChar);
        return this.getDescriptorViaIndex(1, execIndexRow, null, tabInfoImpl, null, null, TriggerDescriptor.class, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TriggerDescriptorList getTriggerDescriptors(TableDescriptor tableDescriptor) throws StandardException {
        TriggerDescriptorList triggerDescriptorList;
        TriggerDescriptorList triggerDescriptorList2 = triggerDescriptorList = tableDescriptor.getTriggerDescriptorList();
        synchronized (triggerDescriptorList2) {
            if (!triggerDescriptorList.getScanned()) {
                this.getTriggerDescriptorsScan(tableDescriptor, false);
            }
        }
        return triggerDescriptorList;
    }

    private void getTriggerDescriptorsScan(TableDescriptor tableDescriptor, boolean bl2) throws StandardException {
        TriggerDescriptorList triggerDescriptorList = tableDescriptor.getTriggerDescriptorList();
        SQLChar sQLChar = null;
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(13);
        sQLChar = DataDictionaryImpl.getIDValueAsCHAR(tableDescriptor.getUUID());
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        this.getDescriptorViaIndex(2, execIndexRow, null, tabInfoImpl, null, triggerDescriptorList, TriggerDescriptor.class, bl2);
        triggerDescriptorList.setScanned(true);
    }

    @Override
    public void dropTriggerDescriptor(TriggerDescriptor triggerDescriptor, TransactionController transactionController) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(13);
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(triggerDescriptor.getUUID());
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        tabInfoImpl.deleteRow(transactionController, execIndexRow, 0);
    }

    @Override
    public void updateTriggerDescriptor(TriggerDescriptor triggerDescriptor, UUID uUID, int[] nArray, TransactionController transactionController) throws StandardException {
        ExecIndexRow execIndexRow = null;
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(13);
        SYSTRIGGERSRowFactory sYSTRIGGERSRowFactory = (SYSTRIGGERSRowFactory)tabInfoImpl.getCatalogRowFactory();
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(uUID);
        execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        ExecRow execRow = sYSTRIGGERSRowFactory.makeRow((TupleDescriptor)triggerDescriptor, null);
        boolean[] blArray = new boolean[3];
        if (nArray == null) {
            blArray[0] = true;
            blArray[1] = true;
            blArray[2] = true;
        } else {
            block5: for (int i2 = 0; i2 < nArray.length; ++i2) {
                switch (nArray[i2]) {
                    case 1: {
                        blArray[0] = true;
                        continue block5;
                    }
                    case 2: 
                    case 3: {
                        blArray[1] = true;
                        continue block5;
                    }
                    case 9: {
                        blArray[2] = true;
                    }
                }
            }
        }
        tabInfoImpl.updateRow(execIndexRow, execRow, 0, blArray, nArray, transactionController);
    }

    @Override
    public ConstraintDescriptor getConstraintDescriptor(UUID uUID) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(4);
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(uUID);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        return this.getConstraintDescriptorViaIndex(0, execIndexRow, tabInfoImpl, null, null, false);
    }

    @Override
    public ConstraintDescriptor getConstraintDescriptor(String string, UUID uUID) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(4);
        SQLVarchar sQLVarchar = new SQLVarchar(string);
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(uUID);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(2);
        execIndexRow.setColumn(1, sQLVarchar);
        execIndexRow.setColumn(2, sQLChar);
        return this.getConstraintDescriptorViaIndex(1, execIndexRow, tabInfoImpl, null, null, false);
    }

    @Override
    public List<StatisticsDescriptor> getStatisticsDescriptors(TableDescriptor tableDescriptor) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(14);
        List<StatisticsDescriptor> list = DataDictionaryImpl.newSList();
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(tableDescriptor.getUUID());
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        this.getDescriptorViaIndex(0, execIndexRow, null, tabInfoImpl, null, list, StatisticsDescriptor.class, false, 1, this.getTransactionCompile());
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConstraintDescriptorList getConstraintDescriptors(TableDescriptor tableDescriptor) throws StandardException {
        ConstraintDescriptorList constraintDescriptorList;
        if (tableDescriptor == null) {
            return this.getAllConstraintDescriptors();
        }
        ConstraintDescriptorList constraintDescriptorList2 = constraintDescriptorList = tableDescriptor.getConstraintDescriptorList();
        synchronized (constraintDescriptorList2) {
            if (!constraintDescriptorList.getScanned()) {
                this.getConstraintDescriptorsScan(tableDescriptor, false);
            }
        }
        return constraintDescriptorList;
    }

    @Override
    public ConstraintDescriptorList getActiveConstraintDescriptors(ConstraintDescriptorList constraintDescriptorList) throws StandardException {
        return constraintDescriptorList;
    }

    @Override
    public boolean activeConstraint(ConstraintDescriptor constraintDescriptor) throws StandardException {
        return true;
    }

    @Override
    public ConstraintDescriptor getConstraintDescriptor(TableDescriptor tableDescriptor, UUID uUID) throws StandardException {
        return this.getConstraintDescriptors(tableDescriptor).getConstraintDescriptor(uUID);
    }

    @Override
    public ConstraintDescriptor getConstraintDescriptorById(TableDescriptor tableDescriptor, UUID uUID) throws StandardException {
        return this.getConstraintDescriptors(tableDescriptor).getConstraintDescriptorById(uUID);
    }

    @Override
    public ConstraintDescriptor getConstraintDescriptorByName(TableDescriptor tableDescriptor, SchemaDescriptor schemaDescriptor, String string, boolean bl2) throws StandardException {
        if (bl2) {
            tableDescriptor.emptyConstraintDescriptorList();
            this.getConstraintDescriptorsScan(tableDescriptor, true);
        }
        return this.getConstraintDescriptors(tableDescriptor).getConstraintDescriptorByName(schemaDescriptor, string);
    }

    private void getConstraintDescriptorsScan(TableDescriptor tableDescriptor, boolean bl2) throws StandardException {
        ConstraintDescriptorList constraintDescriptorList = tableDescriptor.getConstraintDescriptorList();
        SQLChar sQLChar = null;
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(4);
        sQLChar = DataDictionaryImpl.getIDValueAsCHAR(tableDescriptor.getUUID());
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        this.getConstraintDescriptorViaIndex(2, execIndexRow, tabInfoImpl, tableDescriptor, constraintDescriptorList, bl2);
        constraintDescriptorList.setScanned(true);
    }

    protected ConstraintDescriptor getConstraintDescriptorViaIndex(int n2, ExecIndexRow execIndexRow, TabInfoImpl tabInfoImpl, TableDescriptor tableDescriptor, ConstraintDescriptorList constraintDescriptorList, boolean bl2) throws StandardException {
        SYSCONSTRAINTSRowFactory sYSCONSTRAINTSRowFactory = (SYSCONSTRAINTSRowFactory)tabInfoImpl.getCatalogRowFactory();
        ConstraintDescriptor constraintDescriptor = null;
        TransactionController transactionController = this.getTransactionCompile();
        ExecRow execRow = sYSCONSTRAINTSRowFactory.makeEmptyRow();
        ConglomerateController conglomerateController = transactionController.openConglomerate(tabInfoImpl.getHeapConglomerate(), false, 0, 6, 4);
        ScanController scanController = transactionController.openScan(tabInfoImpl.getIndexConglomerate(n2), false, bl2 ? 4 : 0, 6, 4, null, execIndexRow.getRowArray(), 1, null, execIndexRow.getRowArray(), -1);
        while (scanController.next()) {
            SubConstraintDescriptor subConstraintDescriptor = null;
            ExecIndexRow execIndexRow2 = DataDictionaryImpl.getIndexRowFromHeapRow(tabInfoImpl.getIndexRowGenerator(n2), conglomerateController.newRowLocationTemplate(), execRow);
            scanController.fetch(execIndexRow2.getRowArray());
            RowLocation rowLocation = (RowLocation)execIndexRow2.getColumn(execIndexRow2.nColumns());
            boolean bl3 = conglomerateController.fetch(rowLocation, execRow.getRowArray(), null);
            switch (sYSCONSTRAINTSRowFactory.getConstraintType(execRow)) {
                case 2: 
                case 3: 
                case 6: {
                    subConstraintDescriptor = this.getSubKeyConstraint(sYSCONSTRAINTSRowFactory.getConstraintId(execRow), sYSCONSTRAINTSRowFactory.getConstraintType(execRow));
                    break;
                }
                case 4: {
                    subConstraintDescriptor = this.getSubCheckConstraint(sYSCONSTRAINTSRowFactory.getConstraintId(execRow));
                    break;
                }
            }
            subConstraintDescriptor.setTableDescriptor(tableDescriptor);
            constraintDescriptor = (ConstraintDescriptor)sYSCONSTRAINTSRowFactory.buildDescriptor(execRow, subConstraintDescriptor, this);
            if (constraintDescriptorList == null) break;
            constraintDescriptorList.add(constraintDescriptor);
        }
        scanController.close();
        conglomerateController.close();
        return constraintDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TupleDescriptor getConstraintDescriptorViaHeap(ScanQualifier[][] scanQualifierArray, TabInfoImpl tabInfoImpl, TupleDescriptor tupleDescriptor, ConstraintDescriptorList constraintDescriptorList) throws StandardException {
        SYSCONSTRAINTSRowFactory sYSCONSTRAINTSRowFactory = (SYSCONSTRAINTSRowFactory)tabInfoImpl.getCatalogRowFactory();
        ConstraintDescriptor constraintDescriptor = null;
        TransactionController transactionController = this.getTransactionCompile();
        ExecRow execRow = sYSCONSTRAINTSRowFactory.makeEmptyRow();
        try (ScanController scanController = transactionController.openScan(tabInfoImpl.getHeapConglomerate(), false, 0, 7, 4, null, null, 0, scanQualifierArray, null, 0);){
            while (scanController.fetchNext(execRow.getRowArray())) {
                SubConstraintDescriptor subConstraintDescriptor = null;
                switch (sYSCONSTRAINTSRowFactory.getConstraintType(execRow)) {
                    case 2: 
                    case 3: 
                    case 6: {
                        subConstraintDescriptor = this.getSubKeyConstraint(sYSCONSTRAINTSRowFactory.getConstraintId(execRow), sYSCONSTRAINTSRowFactory.getConstraintType(execRow));
                        break;
                    }
                    case 4: {
                        subConstraintDescriptor = this.getSubCheckConstraint(sYSCONSTRAINTSRowFactory.getConstraintId(execRow));
                        break;
                    }
                }
                constraintDescriptor = (ConstraintDescriptor)sYSCONSTRAINTSRowFactory.buildDescriptor(execRow, subConstraintDescriptor, this);
                if (constraintDescriptorList == null) {
                    break;
                }
                constraintDescriptorList.add(constraintDescriptor);
            }
        }
        return constraintDescriptor;
    }

    @Override
    public TableDescriptor getConstraintTableDescriptor(UUID uUID) throws StandardException {
        List<UUID> list = this.getConstraints(uUID, 0, 2);
        if (list.size() == 0) {
            return null;
        }
        return this.getTableDescriptor(list.get(0));
    }

    @Override
    public ConstraintDescriptorList getForeignKeys(UUID uUID) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(10);
        List<SubKeyConstraintDescriptor> list = DataDictionaryImpl.newSList();
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(uUID);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        this.getDescriptorViaIndex(1, execIndexRow, null, tabInfoImpl, null, list, SubKeyConstraintDescriptor.class, false);
        ConstraintDescriptorList constraintDescriptorList = new ConstraintDescriptorList();
        for (SubKeyConstraintDescriptor subKeyConstraintDescriptor : list) {
            TableDescriptor tableDescriptor = this.getConstraintTableDescriptor(subKeyConstraintDescriptor.getUUID());
            constraintDescriptorList.add(this.getConstraintDescriptors(tableDescriptor).getConstraintDescriptorById(subKeyConstraintDescriptor.getUUID()));
        }
        return constraintDescriptorList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<UUID> getConstraints(UUID uUID, int n2, int n3) throws StandardException {
        ConglomerateController conglomerateController = null;
        GenericScanController genericScanController = null;
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(4);
        SYSCONSTRAINTSRowFactory sYSCONSTRAINTSRowFactory = (SYSCONSTRAINTSRowFactory)tabInfoImpl.getCatalogRowFactory();
        Object var12_8 = null;
        ArrayList<UUID> arrayList = new ArrayList<UUID>();
        try {
            SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(uUID);
            ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
            execIndexRow.setColumn(1, sQLChar);
            TransactionController transactionController = this.getTransactionCompile();
            ExecRow execRow = sYSCONSTRAINTSRowFactory.makeEmptyRow();
            conglomerateController = transactionController.openConglomerate(tabInfoImpl.getHeapConglomerate(), false, 0, 6, 4);
            ExecIndexRow execIndexRow2 = DataDictionaryImpl.getIndexRowFromHeapRow(tabInfoImpl.getIndexRowGenerator(n2), conglomerateController.newRowLocationTemplate(), execRow);
            DataValueDescriptor[] dataValueDescriptorArray = new DataValueDescriptor[7];
            FormatableBitSet formatableBitSet = new FormatableBitSet(7);
            formatableBitSet.set(n3 - 1);
            dataValueDescriptorArray[n3 - 1] = new SQLChar();
            genericScanController = transactionController.openScan(tabInfoImpl.getIndexConglomerate(n2), false, 0, 6, 4, null, execIndexRow.getRowArray(), 1, null, execIndexRow.getRowArray(), -1);
            while (genericScanController.fetchNext(execIndexRow2.getRowArray())) {
                RowLocation rowLocation = (RowLocation)execIndexRow2.getColumn(execIndexRow2.nColumns());
                boolean bl2 = conglomerateController.fetch(rowLocation, dataValueDescriptorArray, formatableBitSet);
                arrayList.add(this.uuidFactory.recreateUUID((String)dataValueDescriptorArray[n3 - 1].getObject()));
            }
        }
        finally {
            if (conglomerateController != null) {
                conglomerateController.close();
            }
            if (genericScanController != null) {
                genericScanController.close();
            }
        }
        return arrayList;
    }

    @Override
    public void addConstraintDescriptor(ConstraintDescriptor constraintDescriptor, TransactionController transactionController) throws StandardException {
        int n2 = constraintDescriptor.getConstraintType();
        this.addDescriptor(constraintDescriptor, constraintDescriptor.getSchemaDescriptor(), 4, false, transactionController);
        switch (n2) {
            case 2: 
            case 3: 
            case 6: {
                this.addSubKeyConstraint((KeyConstraintDescriptor)constraintDescriptor, transactionController);
                break;
            }
            case 4: {
                this.addDescriptor(constraintDescriptor, null, 9, true, transactionController);
            }
        }
    }

    @Override
    public void updateConstraintDescriptor(ConstraintDescriptor constraintDescriptor, UUID uUID, int[] nArray, TransactionController transactionController) throws StandardException {
        ExecIndexRow execIndexRow = null;
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(4);
        SYSCONSTRAINTSRowFactory sYSCONSTRAINTSRowFactory = (SYSCONSTRAINTSRowFactory)tabInfoImpl.getCatalogRowFactory();
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(uUID);
        execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        ExecRow execRow = sYSCONSTRAINTSRowFactory.makeRow(constraintDescriptor, null);
        boolean[] blArray = new boolean[3];
        if (nArray == null) {
            blArray[0] = true;
            blArray[1] = true;
            blArray[2] = true;
        } else {
            block5: for (int i2 = 0; i2 < nArray.length; ++i2) {
                switch (nArray[i2]) {
                    case 1: {
                        blArray[0] = true;
                        continue block5;
                    }
                    case 3: 
                    case 5: {
                        blArray[1] = true;
                        continue block5;
                    }
                    case 2: {
                        blArray[2] = true;
                    }
                }
            }
        }
        tabInfoImpl.updateRow(execIndexRow, execRow, 0, blArray, nArray, transactionController);
    }

    @Override
    public void dropConstraintDescriptor(ConstraintDescriptor constraintDescriptor, TransactionController transactionController) throws StandardException {
        ExecIndexRow execIndexRow = null;
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(4);
        switch (constraintDescriptor.getConstraintType()) {
            case 2: 
            case 3: 
            case 6: {
                this.dropSubKeyConstraint(constraintDescriptor, transactionController);
                break;
            }
            case 4: {
                this.dropSubCheckConstraint(constraintDescriptor.getUUID(), transactionController);
            }
        }
        SQLVarchar sQLVarchar = new SQLVarchar(constraintDescriptor.getConstraintName());
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(constraintDescriptor.getSchemaDescriptor().getUUID());
        execIndexRow = this.exFactory.getIndexableRow(2);
        execIndexRow.setColumn(1, sQLVarchar);
        execIndexRow.setColumn(2, sQLChar);
        tabInfoImpl.deleteRow(transactionController, execIndexRow, 1);
    }

    @Override
    public void dropAllConstraintDescriptors(TableDescriptor tableDescriptor, TransactionController transactionController) throws StandardException {
        ConstraintDescriptorList constraintDescriptorList = this.getConstraintDescriptors(tableDescriptor);
        for (ConstraintDescriptor constraintDescriptor : constraintDescriptorList) {
            this.dropConstraintDescriptor(constraintDescriptor, transactionController);
        }
        tableDescriptor.setConstraintDescriptorList(null);
    }

    @Override
    public SubKeyConstraintDescriptor getSubKeyConstraint(UUID uUID, int n2) throws StandardException {
        int n3;
        int n4;
        SQLChar sQLChar = null;
        if (n2 == 6) {
            n4 = 10;
            n3 = 0;
        } else {
            n4 = 5;
            n3 = 0;
        }
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(n4);
        sQLChar = DataDictionaryImpl.getIDValueAsCHAR(uUID);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        return this.getDescriptorViaIndex(n3, execIndexRow, null, tabInfoImpl, null, null, SubKeyConstraintDescriptor.class, false);
    }

    private void addSubKeyConstraint(KeyConstraintDescriptor keyConstraintDescriptor, TransactionController transactionController) throws StandardException {
        ExecRow execRow;
        TabInfoImpl tabInfoImpl;
        if (keyConstraintDescriptor.getConstraintType() == 6) {
            ForeignKeyConstraintDescriptor foreignKeyConstraintDescriptor = (ForeignKeyConstraintDescriptor)keyConstraintDescriptor;
            tabInfoImpl = this.getNonCoreTI(10);
            SYSFOREIGNKEYSRowFactory sYSFOREIGNKEYSRowFactory = (SYSFOREIGNKEYSRowFactory)tabInfoImpl.getCatalogRowFactory();
            execRow = sYSFOREIGNKEYSRowFactory.makeRow(foreignKeyConstraintDescriptor, null);
            ReferencedKeyConstraintDescriptor referencedKeyConstraintDescriptor = foreignKeyConstraintDescriptor.getReferencedConstraint();
            referencedKeyConstraintDescriptor.incrementReferenceCount();
            int[] nArray = new int[]{7};
            this.updateConstraintDescriptor(referencedKeyConstraintDescriptor, referencedKeyConstraintDescriptor.getUUID(), nArray, transactionController);
        } else {
            tabInfoImpl = this.getNonCoreTI(5);
            SYSKEYSRowFactory sYSKEYSRowFactory = (SYSKEYSRowFactory)tabInfoImpl.getCatalogRowFactory();
            execRow = sYSKEYSRowFactory.makeRow(keyConstraintDescriptor, null);
        }
        tabInfoImpl.insertRow(execRow, transactionController);
    }

    private void dropSubKeyConstraint(ConstraintDescriptor constraintDescriptor, TransactionController transactionController) throws StandardException {
        int n2;
        int n3;
        ExecIndexRow execIndexRow = null;
        if (constraintDescriptor.getConstraintType() == 6) {
            ReferencedKeyConstraintDescriptor referencedKeyConstraintDescriptor;
            n3 = 10;
            n2 = 0;
            if (constraintDescriptor.getConstraintType() == 6 && (referencedKeyConstraintDescriptor = (ReferencedKeyConstraintDescriptor)this.getConstraintDescriptor(((ForeignKeyConstraintDescriptor)constraintDescriptor).getReferencedConstraintId())) != null) {
                referencedKeyConstraintDescriptor.decrementReferenceCount();
                int[] nArray = new int[]{7};
                this.updateConstraintDescriptor(referencedKeyConstraintDescriptor, referencedKeyConstraintDescriptor.getUUID(), nArray, transactionController);
            }
        } else {
            n3 = 5;
            n2 = 0;
        }
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(n3);
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(constraintDescriptor.getUUID());
        execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        tabInfoImpl.deleteRow(transactionController, execIndexRow, n2);
    }

    private SubCheckConstraintDescriptor getSubCheckConstraint(UUID uUID) throws StandardException {
        SQLChar sQLChar = null;
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(9);
        sQLChar = DataDictionaryImpl.getIDValueAsCHAR(uUID);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        return this.getDescriptorViaIndex(0, execIndexRow, null, tabInfoImpl, null, null, SubCheckConstraintDescriptor.class, false);
    }

    private void dropSubCheckConstraint(UUID uUID, TransactionController transactionController) throws StandardException {
        ExecIndexRow execIndexRow = null;
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(9);
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(uUID);
        execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        tabInfoImpl.deleteRow(transactionController, execIndexRow, 0);
    }

    @Override
    public Hashtable<Long, ConglomerateDescriptor> hashAllConglomerateDescriptorsByNumber(TransactionController transactionController) throws StandardException {
        Hashtable<Long, ConglomerateDescriptor> hashtable = new Hashtable<Long, ConglomerateDescriptor>();
        ConglomerateDescriptor conglomerateDescriptor = null;
        TabInfoImpl tabInfoImpl = this.coreInfo[0];
        SYSCONGLOMERATESRowFactory sYSCONGLOMERATESRowFactory = (SYSCONGLOMERATESRowFactory)tabInfoImpl.getCatalogRowFactory();
        ExecRow execRow = sYSCONGLOMERATESRowFactory.makeEmptyRow();
        ScanController scanController = transactionController.openScan(tabInfoImpl.getHeapConglomerate(), false, 0, 6, 1, null, null, 1, null, null, -1);
        while (scanController.fetchNext(execRow.getRowArray())) {
            conglomerateDescriptor = (ConglomerateDescriptor)sYSCONGLOMERATESRowFactory.buildDescriptor(execRow, null, this);
            Long l2 = conglomerateDescriptor.getConglomerateNumber();
            hashtable.put(l2, conglomerateDescriptor);
        }
        scanController.close();
        return hashtable;
    }

    @Override
    public Hashtable<UUID, TableDescriptor> hashAllTableDescriptorsByTableId(TransactionController transactionController) throws StandardException {
        Hashtable<UUID, TableDescriptor> hashtable = new Hashtable<UUID, TableDescriptor>();
        TabInfoImpl tabInfoImpl = this.coreInfo[1];
        SYSTABLESRowFactory sYSTABLESRowFactory = (SYSTABLESRowFactory)tabInfoImpl.getCatalogRowFactory();
        ExecRow execRow = sYSTABLESRowFactory.makeEmptyRow();
        ScanController scanController = transactionController.openScan(tabInfoImpl.getHeapConglomerate(), false, 0, 6, 1, null, null, 1, null, null, -1);
        while (scanController.fetchNext(execRow.getRowArray())) {
            TableDescriptor tableDescriptor = (TableDescriptor)sYSTABLESRowFactory.buildDescriptor(execRow, null, this, 1);
            hashtable.put(tableDescriptor.getUUID(), tableDescriptor);
        }
        scanController.close();
        return hashtable;
    }

    @Override
    public ConglomerateDescriptor getConglomerateDescriptor(UUID uUID) throws StandardException {
        ConglomerateDescriptor[] conglomerateDescriptorArray = this.getConglomerateDescriptors(uUID);
        if (conglomerateDescriptorArray.length == 0) {
            return null;
        }
        return conglomerateDescriptorArray[0];
    }

    @Override
    public ConglomerateDescriptor[] getConglomerateDescriptors(UUID uUID) throws StandardException {
        TabInfoImpl tabInfoImpl = this.coreInfo[0];
        List<ConglomerateDescriptor> list = DataDictionaryImpl.newSList();
        if (uUID != null) {
            SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(uUID);
            ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
            execIndexRow.setColumn(1, sQLChar);
            this.getDescriptorViaIndex(0, execIndexRow, null, tabInfoImpl, null, list, ConglomerateDescriptor.class, false);
        } else {
            this.getDescriptorViaHeap(null, null, tabInfoImpl, null, list, ConglomerateDescriptor.class);
        }
        return list.toArray(new ConglomerateDescriptor[list.size()]);
    }

    @Override
    public ConglomerateDescriptor getConglomerateDescriptor(long l2) throws StandardException {
        ConglomerateDescriptor[] conglomerateDescriptorArray = this.getConglomerateDescriptors(l2);
        if (conglomerateDescriptorArray.length == 0) {
            return null;
        }
        return conglomerateDescriptorArray[0];
    }

    @Override
    public ConglomerateDescriptor[] getConglomerateDescriptors(long l2) throws StandardException {
        SQLLongint sQLLongint = null;
        TabInfoImpl tabInfoImpl = this.coreInfo[0];
        SYSCONGLOMERATESRowFactory sYSCONGLOMERATESRowFactory = (SYSCONGLOMERATESRowFactory)tabInfoImpl.getCatalogRowFactory();
        sQLLongint = new SQLLongint(l2);
        ScanQualifier[][] scanQualifierArray = this.exFactory.getScanQualifier(1);
        scanQualifierArray[0][0].setQualifier(3 - 1, sQLLongint, 2, false, false, false);
        ConglomerateDescriptorList conglomerateDescriptorList = new ConglomerateDescriptorList();
        this.getDescriptorViaHeap(null, scanQualifierArray, tabInfoImpl, null, conglomerateDescriptorList, ConglomerateDescriptor.class);
        return conglomerateDescriptorList.toArray(new ConglomerateDescriptor[conglomerateDescriptorList.size()]);
    }

    private void getConglomerateDescriptorsScan(TableDescriptor tableDescriptor) throws StandardException {
        ConglomerateDescriptorList conglomerateDescriptorList = tableDescriptor.getConglomerateDescriptorList();
        ExecIndexRow execIndexRow = null;
        TabInfoImpl tabInfoImpl = this.coreInfo[0];
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(tableDescriptor.getUUID());
        execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        this.getDescriptorViaIndex(2, execIndexRow, null, tabInfoImpl, null, conglomerateDescriptorList, ConglomerateDescriptor.class, false);
    }

    @Override
    public ConglomerateDescriptor getConglomerateDescriptor(String string, SchemaDescriptor schemaDescriptor, boolean bl2) throws StandardException {
        ExecIndexRow execIndexRow = null;
        SQLChar sQLChar = null;
        TabInfoImpl tabInfoImpl = this.coreInfo[0];
        SQLVarchar sQLVarchar = new SQLVarchar(string);
        sQLChar = DataDictionaryImpl.getIDValueAsCHAR(schemaDescriptor.getUUID());
        execIndexRow = this.exFactory.getIndexableRow(2);
        execIndexRow.setColumn(1, sQLVarchar);
        execIndexRow.setColumn(2, sQLChar);
        return this.getDescriptorViaIndex(1, execIndexRow, null, tabInfoImpl, null, null, ConglomerateDescriptor.class, bl2);
    }

    @Override
    public void dropConglomerateDescriptor(ConglomerateDescriptor conglomerateDescriptor, TransactionController transactionController) throws StandardException {
        ExecIndexRow execIndexRow = null;
        SQLChar sQLChar = null;
        TabInfoImpl tabInfoImpl = this.coreInfo[0];
        SQLVarchar sQLVarchar = new SQLVarchar(conglomerateDescriptor.getConglomerateName());
        sQLChar = DataDictionaryImpl.getIDValueAsCHAR(conglomerateDescriptor.getSchemaID());
        execIndexRow = this.exFactory.getIndexableRow(2);
        execIndexRow.setColumn(1, sQLVarchar);
        execIndexRow.setColumn(2, sQLChar);
        tabInfoImpl.deleteRow(transactionController, execIndexRow, 1);
    }

    @Override
    public void dropAllConglomerateDescriptors(TableDescriptor tableDescriptor, TransactionController transactionController) throws StandardException {
        ExecIndexRow execIndexRow = null;
        TabInfoImpl tabInfoImpl = this.coreInfo[0];
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(tableDescriptor.getUUID());
        execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        tabInfoImpl.deleteRow(transactionController, execIndexRow, 2);
    }

    @Override
    public void updateConglomerateDescriptor(ConglomerateDescriptor conglomerateDescriptor, long l2, TransactionController transactionController) throws StandardException {
        ConglomerateDescriptor[] conglomerateDescriptorArray = new ConglomerateDescriptor[]{conglomerateDescriptor};
        this.updateConglomerateDescriptor(conglomerateDescriptorArray, l2, transactionController);
    }

    public void updateSystemSchemaAuthorization(String string, TransactionController transactionController) throws StandardException {
        this.updateSchemaAuth("SYS", string, transactionController);
        this.updateSchemaAuth("SYSIBM", string, transactionController);
        this.updateSchemaAuth("SYSCAT", string, transactionController);
        this.updateSchemaAuth("SYSFUN", string, transactionController);
        this.updateSchemaAuth("SYSPROC", string, transactionController);
        this.updateSchemaAuth("SYSSTAT", string, transactionController);
        this.updateSchemaAuth("NULLID", string, transactionController);
        this.updateSchemaAuth("SQLJ", string, transactionController);
        this.updateSchemaAuth("SYSCS_DIAG", string, transactionController);
        this.updateSchemaAuth("SYSCS_UTIL", string, transactionController);
        this.resetDatabaseOwner(transactionController);
    }

    public void updateSchemaAuth(String string, String string2, TransactionController transactionController) throws StandardException {
        TabInfoImpl tabInfoImpl = this.coreInfo[3];
        SQLVarchar sQLVarchar = new SQLVarchar(string);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLVarchar);
        SYSSCHEMASRowFactory sYSSCHEMASRowFactory = (SYSSCHEMASRowFactory)tabInfoImpl.getCatalogRowFactory();
        ExecRow execRow = sYSSCHEMASRowFactory.makeEmptyRow();
        execRow.setColumn(3, new SQLVarchar(string2));
        boolean[] blArray = new boolean[]{false, false};
        int[] nArray = new int[]{3};
        tabInfoImpl.updateRow(execIndexRow, execRow, 0, blArray, nArray, transactionController);
    }

    @Override
    public void updateConglomerateDescriptor(ConglomerateDescriptor[] conglomerateDescriptorArray, long l2, TransactionController transactionController) throws StandardException {
        ExecIndexRow execIndexRow = null;
        TabInfoImpl tabInfoImpl = this.coreInfo[0];
        SYSCONGLOMERATESRowFactory sYSCONGLOMERATESRowFactory = (SYSCONGLOMERATESRowFactory)tabInfoImpl.getCatalogRowFactory();
        boolean[] blArray = new boolean[]{false, false, false};
        for (int i2 = 0; i2 < conglomerateDescriptorArray.length; ++i2) {
            SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(conglomerateDescriptorArray[i2].getUUID());
            execIndexRow = this.exFactory.getIndexableRow(1);
            execIndexRow.setColumn(1, sQLChar);
            conglomerateDescriptorArray[i2].setConglomerateNumber(l2);
            ExecRow execRow = sYSCONGLOMERATESRowFactory.makeRow(conglomerateDescriptorArray[i2], null);
            tabInfoImpl.updateRow(execIndexRow, execRow, 0, blArray, (int[])null, transactionController);
        }
    }

    @Override
    public List<DependencyDescriptor> getDependentsDescriptorList(String string) throws StandardException {
        List<DependencyDescriptor> list = DataDictionaryImpl.newSList();
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(6);
        SQLChar sQLChar = new SQLChar(string);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        this.getDescriptorViaIndex(0, execIndexRow, null, tabInfoImpl, null, list, DependencyDescriptor.class, false);
        return list;
    }

    @Override
    public List<DependencyDescriptor> getProvidersDescriptorList(String string) throws StandardException {
        List<DependencyDescriptor> list = DataDictionaryImpl.newSList();
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(6);
        SQLChar sQLChar = new SQLChar(string);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        this.getDescriptorViaIndex(1, execIndexRow, null, tabInfoImpl, null, list, DependencyDescriptor.class, false);
        return list;
    }

    @Override
    public List<TupleDescriptor> getAllDependencyDescriptorsList() throws StandardException {
        List<TupleDescriptor> list = DataDictionaryImpl.newSList();
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(6);
        SYSDEPENDSRowFactory sYSDEPENDSRowFactory = (SYSDEPENDSRowFactory)tabInfoImpl.getCatalogRowFactory();
        TransactionController transactionController = this.getTransactionCompile();
        ExecRow execRow = sYSDEPENDSRowFactory.makeEmptyRow();
        ScanController scanController = transactionController.openScan(tabInfoImpl.getHeapConglomerate(), false, 0, 7, 4, null, null, 1, null, null, -1);
        while (scanController.fetchNext(execRow.getRowArray())) {
            DependencyDescriptor dependencyDescriptor = (DependencyDescriptor)sYSDEPENDSRowFactory.buildDescriptor(execRow, null, this);
            list.add(dependencyDescriptor);
        }
        scanController.close();
        return list;
    }

    @Override
    public void dropStoredDependency(DependencyDescriptor dependencyDescriptor, TransactionController transactionController) throws StandardException {
        ExecIndexRow execIndexRow = null;
        UUID uUID = dependencyDescriptor.getUUID();
        UUID uUID2 = dependencyDescriptor.getProviderID();
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(uUID);
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(6);
        execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        DropDependencyFilter dropDependencyFilter = new DropDependencyFilter(uUID2);
        tabInfoImpl.deleteRows(transactionController, execIndexRow, 1, null, dropDependencyFilter, execIndexRow, -1, 0);
    }

    @Override
    public void dropDependentsStoredDependencies(UUID uUID, TransactionController transactionController) throws StandardException {
        this.dropDependentsStoredDependencies(uUID, transactionController, true);
    }

    @Override
    public void dropDependentsStoredDependencies(UUID uUID, TransactionController transactionController, boolean bl2) throws StandardException {
        ExecIndexRow execIndexRow = null;
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(6);
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(uUID);
        execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        tabInfoImpl.deleteRow(transactionController, execIndexRow, 0, bl2);
    }

    @Override
    public UUIDFactory getUUIDFactory() {
        return this.uuidFactory;
    }

    @Override
    public AliasDescriptor getAliasDescriptorForUDT(TransactionController transactionController, DataTypeDescriptor dataTypeDescriptor) throws StandardException {
        if (transactionController == null) {
            transactionController = this.getTransactionCompile();
        }
        if (dataTypeDescriptor == null) {
            return null;
        }
        BaseTypeIdImpl baseTypeIdImpl = dataTypeDescriptor.getTypeId().getBaseTypeId();
        if (!baseTypeIdImpl.isAnsiUDT()) {
            return null;
        }
        SchemaDescriptor schemaDescriptor = this.getSchemaDescriptor(baseTypeIdImpl.getSchemaName(), transactionController, true);
        AliasDescriptor aliasDescriptor = this.getAliasDescriptor(schemaDescriptor.getUUID().toString(), baseTypeIdImpl.getUnqualifiedName(), 'A');
        return aliasDescriptor;
    }

    @Override
    public AliasDescriptor getAliasDescriptor(UUID uUID) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(7);
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(uUID);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        return this.getDescriptorViaIndex(1, execIndexRow, null, tabInfoImpl, null, null, AliasDescriptor.class, false);
    }

    @Override
    public AliasDescriptor getAliasDescriptor(String string, String string2, char c2) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(7);
        SQLVarchar sQLVarchar = new SQLVarchar(string2);
        char[] cArray = new char[]{c2};
        SQLChar sQLChar = new SQLChar(new String(cArray));
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(3);
        execIndexRow.setColumn(1, new SQLChar(string));
        execIndexRow.setColumn(2, sQLVarchar);
        execIndexRow.setColumn(3, sQLChar);
        return this.getDescriptorViaIndex(0, execIndexRow, null, tabInfoImpl, null, null, AliasDescriptor.class, false);
    }

    @Override
    public List<AliasDescriptor> getRoutineList(String string, String string2, char c2) throws StandardException {
        ArrayList<AliasDescriptor> arrayList = new ArrayList<AliasDescriptor>(1);
        if (string.equals("c013800d-00fb-2642-07ec-000000134f30") && c2 == 'F') {
            for (int i2 = 0; i2 < SYSFUN_FUNCTIONS.length; ++i2) {
                String[] stringArray = SYSFUN_FUNCTIONS[i2];
                String string3 = stringArray[0];
                if (!string3.equals(string2)) continue;
                AliasDescriptor aliasDescriptor = this.sysfunDescriptors[i2];
                if (aliasDescriptor == null) {
                    TypeDescriptor typeDescriptor = DataTypeDescriptor.getBuiltInDataTypeDescriptor(stringArray[1]).getCatalogType();
                    boolean bl2 = Boolean.valueOf(stringArray[4]);
                    boolean bl3 = Boolean.valueOf(stringArray[5]);
                    int n2 = stringArray.length - 6;
                    TypeDescriptor[] typeDescriptorArray = new TypeDescriptor[n2];
                    String[] stringArray2 = new String[n2];
                    int[] nArray = new int[n2];
                    for (int i3 = 0; i3 < n2; ++i3) {
                        typeDescriptorArray[i3] = DataTypeDescriptor.getBuiltInDataTypeDescriptor(stringArray[6 + i3]).getCatalogType();
                        stringArray2[i3] = "P" + (i3 + 1);
                        nArray[i3] = 1;
                    }
                    RoutineAliasInfo routineAliasInfo = new RoutineAliasInfo(stringArray[3], n2, stringArray2, typeDescriptorArray, nArray, 0, 0, 3, bl2, bl3, false, false, typeDescriptor);
                    this.sysfunDescriptors[i2] = aliasDescriptor = new AliasDescriptor(this, this.uuidFactory.createUUID(), string3, this.uuidFactory.recreateUUID(string), stringArray[2], 'F', 'F', true, routineAliasInfo, null);
                }
                arrayList.add(aliasDescriptor);
            }
            return arrayList;
        }
        AliasDescriptor aliasDescriptor = this.getAliasDescriptor(string, string2, c2);
        if (aliasDescriptor != null) {
            arrayList.add(aliasDescriptor);
        }
        return arrayList;
    }

    @Override
    public void dropAliasDescriptor(AliasDescriptor aliasDescriptor, TransactionController transactionController) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(7);
        char[] cArray = new char[]{aliasDescriptor.getNameSpace()};
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(3);
        execIndexRow.setColumn(1, DataDictionaryImpl.getIDValueAsCHAR(aliasDescriptor.getSchemaUUID()));
        execIndexRow.setColumn(2, new SQLVarchar(aliasDescriptor.getDescriptorName()));
        execIndexRow.setColumn(3, new SQLChar(new String(cArray)));
        tabInfoImpl.deleteRow(transactionController, execIndexRow, 0);
    }

    @Override
    public void updateUser(UserDescriptor userDescriptor, TransactionController transactionController) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(22);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, new SQLVarchar(userDescriptor.getUserName()));
        ExecRow execRow = tabInfoImpl.getCatalogRowFactory().makeRow(userDescriptor, null);
        boolean[] blArray = new boolean[]{false};
        int[] nArray = new int[]{2, 3, 4};
        tabInfoImpl.updateRow(execIndexRow, execRow, 0, blArray, nArray, transactionController);
    }

    @Override
    public UserDescriptor getUser(String string) throws StandardException {
        this.dictionaryVersion.checkVersion(210, "NATIVE AUTHENTICATION");
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(22);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, new SQLVarchar(string));
        return this.getDescriptorViaIndex(0, execIndexRow, null, tabInfoImpl, null, null, UserDescriptor.class, false);
    }

    @Override
    public void dropUser(String string, TransactionController transactionController) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(22);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, new SQLVarchar(string));
        tabInfoImpl.deleteRow(transactionController, execIndexRow, 0);
    }

    private void loadDictionaryTables(TransactionController transactionController, Properties properties) throws StandardException {
        this.loadCatalogs(this.coreInfo);
        this.dictionaryVersion = (DD_Version)transactionController.getProperty("DataDictionaryVersion");
        boolean bl2 = PropertyUtil.nativeAuthenticationEnabled(properties);
        if (bl2) {
            this.dictionaryVersion.checkVersion(210, "NATIVE AUTHENTICATION");
        }
        this.resetDatabaseOwner(transactionController);
        this.softwareVersion.upgradeIfNeeded(this.dictionaryVersion, transactionController, properties);
    }

    public void resetDatabaseOwner(TransactionController transactionController) throws StandardException {
        SchemaDescriptor schemaDescriptor = this.locateSchemaRow("SYSIBM", transactionController);
        this.authorizationDatabaseOwner = schemaDescriptor.getAuthorizationId();
        this.systemSchemaDesc.setAuthorizationId(this.authorizationDatabaseOwner);
        this.sysIBMSchemaDesc.setAuthorizationId(this.authorizationDatabaseOwner);
        this.systemUtilSchemaDesc.setAuthorizationId(this.authorizationDatabaseOwner);
    }

    private void loadCatalogs(TabInfoImpl[] tabInfoImplArray) throws StandardException {
        for (TabInfoImpl tabInfoImpl : tabInfoImplArray) {
            int n2 = tabInfoImpl.getNumberOfIndexes();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.initSystemIndexVariables(tabInfoImpl, i2);
            }
        }
    }

    protected void createDictionaryTables(Properties properties, TransactionController transactionController, DataDescriptorGenerator dataDescriptorGenerator) throws StandardException {
        TabInfoImpl tabInfoImpl;
        int n2;
        this.systemSchemaDesc = this.newSystemSchemaDesc("SYS", "8000000d-00d0-fd77-3ed8-000a0a0b1900");
        for (n2 = 0; n2 < 4; ++n2) {
            tabInfoImpl = this.coreInfo[n2];
            Properties properties2 = tabInfoImpl.getCreateHeapProperties();
            tabInfoImpl.setHeapConglomerate(this.createConglomerate(tabInfoImpl.getTableName(), transactionController, tabInfoImpl.getCatalogRowFactory().makeEmptyRow(), properties2));
            if (this.coreInfo[n2].getNumberOfIndexes() <= 0) continue;
            this.bootStrapSystemIndexes(this.systemSchemaDesc, transactionController, dataDescriptorGenerator, tabInfoImpl);
        }
        for (n2 = 0; n2 < 4; ++n2) {
            tabInfoImpl = this.coreInfo[n2];
            this.addSystemTableToDictionary(tabInfoImpl, this.systemSchemaDesc, transactionController, dataDescriptorGenerator);
        }
        properties.put(CFG_SYSTABLES_ID, Long.toString(this.coreInfo[1].getHeapConglomerate()));
        SYSTABLESRowFactory cfr_ignored_0 = (SYSTABLESRowFactory)this.coreInfo[1].getCatalogRowFactory();
        properties.put(CFG_SYSTABLES_INDEX1_ID, Long.toString(this.coreInfo[1].getIndexConglomerate(0)));
        SYSTABLESRowFactory cfr_ignored_1 = (SYSTABLESRowFactory)this.coreInfo[1].getCatalogRowFactory();
        properties.put(CFG_SYSTABLES_INDEX2_ID, Long.toString(this.coreInfo[1].getIndexConglomerate(1)));
        properties.put(CFG_SYSCOLUMNS_ID, Long.toString(this.coreInfo[2].getHeapConglomerate()));
        SYSCOLUMNSRowFactory cfr_ignored_2 = (SYSCOLUMNSRowFactory)this.coreInfo[2].getCatalogRowFactory();
        properties.put(CFG_SYSCOLUMNS_INDEX1_ID, Long.toString(this.coreInfo[2].getIndexConglomerate(0)));
        SYSCOLUMNSRowFactory cfr_ignored_3 = (SYSCOLUMNSRowFactory)this.coreInfo[2].getCatalogRowFactory();
        properties.put(CFG_SYSCOLUMNS_INDEX2_ID, Long.toString(this.coreInfo[2].getIndexConglomerate(1)));
        properties.put(CFG_SYSCONGLOMERATES_ID, Long.toString(this.coreInfo[0].getHeapConglomerate()));
        SYSCONGLOMERATESRowFactory cfr_ignored_4 = (SYSCONGLOMERATESRowFactory)this.coreInfo[0].getCatalogRowFactory();
        properties.put(CFG_SYSCONGLOMERATES_INDEX1_ID, Long.toString(this.coreInfo[0].getIndexConglomerate(0)));
        SYSCONGLOMERATESRowFactory cfr_ignored_5 = (SYSCONGLOMERATESRowFactory)this.coreInfo[0].getCatalogRowFactory();
        properties.put(CFG_SYSCONGLOMERATES_INDEX2_ID, Long.toString(this.coreInfo[0].getIndexConglomerate(1)));
        SYSCONGLOMERATESRowFactory cfr_ignored_6 = (SYSCONGLOMERATESRowFactory)this.coreInfo[0].getCatalogRowFactory();
        properties.put(CFG_SYSCONGLOMERATES_INDEX3_ID, Long.toString(this.coreInfo[0].getIndexConglomerate(2)));
        properties.put(CFG_SYSSCHEMAS_ID, Long.toString(this.coreInfo[3].getHeapConglomerate()));
        SYSSCHEMASRowFactory cfr_ignored_7 = (SYSSCHEMASRowFactory)this.coreInfo[3].getCatalogRowFactory();
        properties.put(CFG_SYSSCHEMAS_INDEX1_ID, Long.toString(this.coreInfo[3].getIndexConglomerate(0)));
        SYSSCHEMASRowFactory cfr_ignored_8 = (SYSSCHEMASRowFactory)this.coreInfo[3].getCatalogRowFactory();
        properties.put(CFG_SYSSCHEMAS_INDEX2_ID, Long.toString(this.coreInfo[3].getIndexConglomerate(1)));
        this.sysIBMSchemaDesc = this.addSystemSchema("SYSIBM", "c013800d-00f8-5b53-28a9-00000019ed88", transactionController);
        for (n2 = 0; n2 < NUM_NONCORE; ++n2) {
            int n3 = n2 + 4;
            boolean bl2 = n3 == 15;
            TabInfoImpl tabInfoImpl2 = this.getNonCoreTIByNumber(n3);
            this.makeCatalog(tabInfoImpl2, bl2 ? this.sysIBMSchemaDesc : this.systemSchemaDesc, transactionController);
            if (bl2) {
                this.populateSYSDUMMY1(transactionController);
            }
            this.clearNoncoreTable(n2);
        }
        this.addDescriptor(this.systemSchemaDesc, null, 3, false, transactionController);
        this.addSystemSchema("SYSCAT", "c013800d-00fb-2641-07ec-000000134f30", transactionController);
        this.addSystemSchema("SYSFUN", "c013800d-00fb-2642-07ec-000000134f30", transactionController);
        this.addSystemSchema("SYSPROC", "c013800d-00fb-2643-07ec-000000134f30", transactionController);
        this.addSystemSchema("SYSSTAT", "c013800d-00fb-2644-07ec-000000134f30", transactionController);
        this.addSystemSchema("NULLID", "c013800d-00fb-2647-07ec-000000134f30", transactionController);
        this.addSystemSchema("SQLJ", "c013800d-00fb-2648-07ec-000000134f30", transactionController);
        this.addSystemSchema("SYSCS_DIAG", "c013800d-00fb-2646-07ec-000000134f30", transactionController);
        this.addSystemSchema("SYSCS_UTIL", "c013800d-00fb-2649-07ec-000000134f30", transactionController);
        SchemaDescriptor schemaDescriptor = new SchemaDescriptor(this, "APP", "APP", this.uuidFactory.recreateUUID("80000000-00d2-b38f-4cda-000a0a412c00"), false);
        this.addDescriptor(schemaDescriptor, null, 3, false, transactionController);
    }

    private SchemaDescriptor addSystemSchema(String string, String string2, TransactionController transactionController) throws StandardException {
        SchemaDescriptor schemaDescriptor = new SchemaDescriptor(this, string, this.authorizationDatabaseOwner, this.uuidFactory.recreateUUID(string2), true);
        this.addDescriptor(schemaDescriptor, null, 3, false, transactionController);
        return schemaDescriptor;
    }

    protected void upgradeMakeCatalog(TransactionController transactionController, int n2) throws StandardException {
        TabInfoImpl tabInfoImpl = n2 >= 4 ? this.getNonCoreTIByNumber(n2) : this.coreInfo[n2];
        this.makeCatalog(tabInfoImpl, n2 == 15 ? this.getSysIBMSchemaDescriptor() : this.getSystemSchemaDescriptor(), transactionController);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void upgradeJarStorage(TransactionController transactionController) throws StandardException {
        Object object;
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(12);
        SYSFILESRowFactory sYSFILESRowFactory = (SYSFILESRowFactory)tabInfoImpl.getCatalogRowFactory();
        ExecRow execRow = sYSFILESRowFactory.makeEmptyRow();
        HashMap hashMap = new HashMap();
        try (ScanController scanController = transactionController.openScan(tabInfoImpl.getHeapConglomerate(), false, 0, 7, 4, null, null, 0, null, null, 0);){
            while (scanController.fetchNext(execRow.getRowArray())) {
                object = (FileInfoDescriptor)sYSFILESRowFactory.buildDescriptor(execRow, null, this);
                hashMap.put(((FileInfoDescriptor)object).getSchemaDescriptor().getSchemaName(), null);
                JarUtil.upgradeJar(transactionController, (FileInfoDescriptor)object);
            }
        }
        object = hashMap.keySet().iterator();
        FileResource fileResource = transactionController.getFileHandler();
        while (object.hasNext()) {
            fileResource.removeJarDir("jar" + File.separatorChar + (String)object.next());
        }
    }

    private void makeCatalog(TabInfoImpl tabInfoImpl, SchemaDescriptor schemaDescriptor, TransactionController transactionController) throws StandardException {
        DataDescriptorGenerator dataDescriptorGenerator = this.getDataDescriptorGenerator();
        Properties properties = tabInfoImpl.getCreateHeapProperties();
        tabInfoImpl.setHeapConglomerate(this.createConglomerate(tabInfoImpl.getTableName(), transactionController, tabInfoImpl.getCatalogRowFactory().makeEmptyRowForCurrentVersion(), properties));
        if (tabInfoImpl.getNumberOfIndexes() > 0) {
            this.bootStrapSystemIndexes(schemaDescriptor, transactionController, dataDescriptorGenerator, tabInfoImpl);
        }
        this.addSystemTableToDictionary(tabInfoImpl, schemaDescriptor, transactionController, dataDescriptorGenerator);
    }

    public void upgradeFixSystemColumnDefinition(CatalogRowFactory catalogRowFactory, int n2, TransactionController transactionController) throws StandardException {
        SystemColumn[] systemColumnArray = catalogRowFactory.buildColumnList();
        SchemaDescriptor schemaDescriptor = this.getSystemSchemaDescriptor();
        TableDescriptor tableDescriptor = this.getTableDescriptor(catalogRowFactory.getCatalogName(), schemaDescriptor, transactionController);
        SystemColumn systemColumn = systemColumnArray[n2 - 1];
        ColumnDescriptor columnDescriptor = this.makeColumnDescriptor(systemColumn, n2, tableDescriptor);
        String string = columnDescriptor.getColumnName();
        int[] nArray = new int[]{4};
        this.updateColumnDescriptor(columnDescriptor, tableDescriptor.getUUID(), string, nArray, transactionController);
    }

    public void upgrade_addColumns(CatalogRowFactory catalogRowFactory, int[] nArray, TransactionController transactionController) throws StandardException {
        long l2;
        TableDescriptor tableDescriptor;
        SystemColumn[] systemColumnArray = catalogRowFactory.buildColumnList();
        ExecRow execRow = catalogRowFactory.makeEmptyRowForCurrentVersion();
        int n2 = nArray.length;
        SchemaDescriptor schemaDescriptor = this.getSystemSchemaDescriptor();
        if (catalogRowFactory instanceof SYSTABLESRowFactory) {
            tableDescriptor = this.dataDescriptorGenerator.newTableDescriptor("SYSTABLES", schemaDescriptor, 0, 'R');
            tableDescriptor.setUUID(this.getUUIDForCoreTable("SYSTABLES", schemaDescriptor.getUUID().toString(), transactionController));
            l2 = this.coreInfo[1].getHeapConglomerate();
        } else if (catalogRowFactory instanceof SYSCOLUMNSRowFactory) {
            tableDescriptor = this.dataDescriptorGenerator.newTableDescriptor("SYSCOLUMNS", schemaDescriptor, 0, 'R');
            tableDescriptor.setUUID(this.getUUIDForCoreTable("SYSCOLUMNS", schemaDescriptor.getUUID().toString(), transactionController));
            l2 = this.coreInfo[2].getHeapConglomerate();
        } else {
            tableDescriptor = this.getTableDescriptor(catalogRowFactory.getCatalogName(), schemaDescriptor, transactionController);
            l2 = tableDescriptor.getHeapConglomerateId();
        }
        this.widenConglomerate(execRow, nArray, l2, transactionController);
        TupleDescriptor[] tupleDescriptorArray = new ColumnDescriptor[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = nArray[i2];
            SystemColumn systemColumn = systemColumnArray[n3 - 1];
            tupleDescriptorArray[i2] = this.makeColumnDescriptor(systemColumn, n3, tableDescriptor);
        }
        this.addDescriptorArray(tupleDescriptorArray, tableDescriptor, 2, false, transactionController);
    }

    public void upgrade_addInvisibleColumns(CatalogRowFactory catalogRowFactory, int[] nArray, TransactionController transactionController) throws StandardException {
        ExecRow execRow = catalogRowFactory.makeEmptyRowForCurrentVersion();
        SchemaDescriptor schemaDescriptor = this.getSystemSchemaDescriptor();
        long l2 = this.getTableDescriptor(catalogRowFactory.getCatalogName(), schemaDescriptor, transactionController).getHeapConglomerateId();
        this.widenConglomerate(execRow, nArray, l2, transactionController);
    }

    private void widenConglomerate(ExecRow execRow, int[] nArray, long l2, TransactionController transactionController) throws StandardException {
        for (int n2 : nArray) {
            int n3 = n2 - 1;
            transactionController.addColumnToConglomerate(l2, n3, execRow.getColumn(n2), 0);
        }
    }

    private UUID getUUIDForCoreTable(String string, String string2, TransactionController transactionController) throws StandardException {
        TabInfoImpl tabInfoImpl = this.coreInfo[1];
        SYSTABLESRowFactory sYSTABLESRowFactory = (SYSTABLESRowFactory)tabInfoImpl.getCatalogRowFactory();
        ExecRow execRow = this.exFactory.getValueRow(1);
        SQLVarchar sQLVarchar = new SQLVarchar(string);
        SQLChar sQLChar = new SQLChar(string2);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(2);
        execIndexRow.setColumn(1, sQLVarchar);
        execIndexRow.setColumn(2, sQLChar);
        ConglomerateController conglomerateController = transactionController.openConglomerate(tabInfoImpl.getHeapConglomerate(), false, 0, 6, 4);
        ExecIndexRow execIndexRow2 = sYSTABLESRowFactory.buildEmptyIndexRow(0, conglomerateController.newRowLocationTemplate());
        ScanController scanController = transactionController.openScan(tabInfoImpl.getIndexConglomerate(0), false, 0, 6, 4, null, execIndexRow.getRowArray(), 1, null, execIndexRow.getRowArray(), -1);
        if (scanController.fetchNext(execIndexRow2.getRowArray())) {
            RowLocation rowLocation = (RowLocation)execIndexRow2.getColumn(execIndexRow2.nColumns());
            execRow.setColumn(1, new SQLChar());
            FormatableBitSet formatableBitSet = new FormatableBitSet(1);
            formatableBitSet.set(0);
            boolean bl2 = conglomerateController.fetch(rowLocation, execRow.getRowArray(), null);
        }
        scanController.close();
        conglomerateController.close();
        return this.uuidFactory.recreateUUID(execRow.getColumn(1).toString());
    }

    void upgrade_initSystemTableCols(TransactionController transactionController, boolean bl2, int n2, FormatableBitSet formatableBitSet, DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        TabInfoImpl tabInfoImpl;
        TabInfoImpl tabInfoImpl2 = tabInfoImpl = bl2 ? this.coreInfo[n2] : this.getNonCoreTIByNumber(n2);
        if (!bl2) {
            this.faultInTabInfo(tabInfoImpl);
        }
        ScanController scanController = transactionController.openScan(tabInfoImpl.getHeapConglomerate(), false, 4, 7, 4, RowUtil.EMPTY_ROW_BITSET, null, 0, null, null, 0);
        while (scanController.next()) {
            scanController.replace(dataValueDescriptorArray, formatableBitSet);
        }
        scanController.close();
    }

    private void bootStrapSystemIndexes(SchemaDescriptor schemaDescriptor, TransactionController transactionController, DataDescriptorGenerator dataDescriptorGenerator, TabInfoImpl tabInfoImpl) throws StandardException {
        int n2;
        ConglomerateDescriptor[] conglomerateDescriptorArray = new ConglomerateDescriptor[tabInfoImpl.getNumberOfIndexes()];
        for (n2 = 0; n2 < tabInfoImpl.getNumberOfIndexes(); ++n2) {
            conglomerateDescriptorArray[n2] = this.bootstrapOneIndex(schemaDescriptor, transactionController, dataDescriptorGenerator, tabInfoImpl, n2, tabInfoImpl.getHeapConglomerate());
        }
        for (n2 = 0; n2 < tabInfoImpl.getNumberOfIndexes(); ++n2) {
            this.addDescriptor(conglomerateDescriptorArray[n2], schemaDescriptor, 0, false, transactionController);
        }
    }

    @Override
    public RowLocation[] computeAutoincRowLocations(TransactionController transactionController, TableDescriptor tableDescriptor) throws StandardException {
        if (!tableDescriptor.tableHasAutoincrement()) {
            return null;
        }
        int n2 = tableDescriptor.getNumberOfColumns();
        RowLocation[] rowLocationArray = new RowLocation[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(i2 + 1);
            if (!columnDescriptor.isAutoincrement()) continue;
            rowLocationArray[i2] = this.computeRowLocation(transactionController, tableDescriptor, columnDescriptor.getColumnName());
        }
        return rowLocationArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NumberDataValue getSetAutoincrementValue(RowLocation rowLocation, TransactionController transactionController, boolean bl2, NumberDataValue numberDataValue, boolean bl3) throws StandardException {
        int n2 = 7;
        TabInfoImpl tabInfoImpl = this.coreInfo[2];
        ConglomerateController conglomerateController = null;
        SYSCOLUMNSRowFactory sYSCOLUMNSRowFactory = (SYSCOLUMNSRowFactory)tabInfoImpl.getCatalogRowFactory();
        ExecRow execRow = sYSCOLUMNSRowFactory.makeEmptyRow();
        FormatableBitSet formatableBitSet = new FormatableBitSet(9);
        formatableBitSet.set(n2 - 1);
        formatableBitSet.set(n2);
        formatableBitSet.set(n2 + 1);
        try {
            NumberDataValue numberDataValue2;
            conglomerateController = transactionController.openConglomerate(tabInfoImpl.getHeapConglomerate(), false, 4 | (bl3 ? 0 : 128), 6, 4);
            boolean bl4 = conglomerateController.fetch(rowLocation, execRow.getRowArray(), formatableBitSet, bl3);
            NumberDataValue numberDataValue3 = (NumberDataValue)execRow.getColumn(n2);
            long l2 = numberDataValue3.getLong();
            if (bl2) {
                numberDataValue2 = (NumberDataValue)execRow.getColumn(n2 + 2);
                numberDataValue3 = numberDataValue3.plus(numberDataValue3, numberDataValue2, numberDataValue3);
                execRow.setColumn(n2, numberDataValue3);
                FormatableBitSet formatableBitSet2 = new FormatableBitSet(9);
                formatableBitSet2.set(n2 - 1);
                conglomerateController.replace(rowLocation, execRow.getRowArray(), formatableBitSet2);
            }
            if (numberDataValue != null) {
                numberDataValue.setValue(l2);
                numberDataValue2 = numberDataValue;
                return numberDataValue2;
            }
            numberDataValue3.setValue(l2);
            numberDataValue2 = numberDataValue3;
            return numberDataValue2;
        }
        finally {
            if (conglomerateController != null) {
                conglomerateController.close();
            }
        }
    }

    private ConglomerateDescriptor bootstrapOneIndex(SchemaDescriptor schemaDescriptor, TransactionController transactionController, DataDescriptorGenerator dataDescriptorGenerator, TabInfoImpl tabInfoImpl, int n2, long l2) throws StandardException {
        CatalogRowFactory catalogRowFactory = tabInfoImpl.getCatalogRowFactory();
        this.initSystemIndexVariables(tabInfoImpl, n2);
        IndexRowGenerator indexRowGenerator = tabInfoImpl.getIndexRowGenerator(n2);
        int n3 = tabInfoImpl.getIndexColumnCount(n2);
        boolean bl2 = tabInfoImpl.isIndexUnique(n2);
        ExecIndexRow execIndexRow = indexRowGenerator.getIndexRowTemplate();
        ExecRow execRow = catalogRowFactory.makeEmptyRowForCurrentVersion();
        ConglomerateController conglomerateController = transactionController.openConglomerate(l2, false, 0, 6, 4);
        RowLocation rowLocation = conglomerateController.newRowLocationTemplate();
        conglomerateController.close();
        indexRowGenerator.getIndexRow(execRow, rowLocation, execIndexRow, null);
        Properties properties = tabInfoImpl.getCreateIndexProperties(n2);
        properties.put("baseConglomerateId", Long.toString(l2));
        properties.put("nUniqueColumns", Integer.toString(bl2 ? n3 : n3 + 1));
        properties.put("rowLocationColumn", Integer.toString(n3));
        properties.put("nKeyFields", Integer.toString(n3 + 1));
        long l3 = transactionController.createConglomerate("BTREE", execIndexRow.getRowArray(), null, null, properties, 0);
        ConglomerateDescriptor conglomerateDescriptor = dataDescriptorGenerator.newConglomerateDescriptor(l3, catalogRowFactory.getIndexName(n2), true, indexRowGenerator, false, catalogRowFactory.getCanonicalIndexUUID(n2), catalogRowFactory.getCanonicalTableUUID(), schemaDescriptor.getUUID());
        tabInfoImpl.setIndexConglomerate(conglomerateDescriptor);
        return conglomerateDescriptor;
    }

    private void initSystemIndexVariables(TabInfoImpl tabInfoImpl, int n2) throws StandardException {
        int n3 = tabInfoImpl.getIndexColumnCount(n2);
        int[] nArray = new int[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            nArray[i2] = tabInfoImpl.getBaseColumnPosition(n2, i2);
        }
        boolean[] blArray = new boolean[nArray.length];
        for (int i3 = 0; i3 < nArray.length; ++i3) {
            blArray[i3] = true;
        }
        IndexRowGenerator indexRowGenerator = null;
        indexRowGenerator = new IndexRowGenerator("BTREE", tabInfoImpl.isIndexUnique(n2), false, false, false, nArray, blArray, nArray.length);
        tabInfoImpl.setIndexRowGenerator(n2, indexRowGenerator);
    }

    protected void populateSYSDUMMY1(TransactionController transactionController) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(15);
        ExecRow execRow = tabInfoImpl.getCatalogRowFactory().makeRow(null, null);
        int n2 = tabInfoImpl.insertRow(execRow, transactionController);
    }

    @Override
    public void clearCaches() throws StandardException {
        this.clearCaches(true);
    }

    @Override
    public void clearCaches(boolean bl2) throws StandardException {
        this.nameTdCache.cleanAll();
        this.nameTdCache.ageOut();
        this.OIDTdCache.cleanAll();
        this.OIDTdCache.ageOut();
        if (bl2) {
            this.clearSequenceCaches();
        }
        if (this.spsNameCache != null) {
            this.spsNameCache.cleanAll();
            this.spsNameCache.ageOut();
            this.spsIdHash.clear();
        }
    }

    @Override
    public void clearSequenceCaches() throws StandardException {
        this.sequenceGeneratorCache.cleanAll();
        this.sequenceGeneratorCache.ageOut();
    }

    private void addSystemTableToDictionary(TabInfoImpl tabInfoImpl, SchemaDescriptor schemaDescriptor, TransactionController transactionController, DataDescriptorGenerator dataDescriptorGenerator) throws StandardException {
        CatalogRowFactory catalogRowFactory = tabInfoImpl.getCatalogRowFactory();
        String string = tabInfoImpl.getTableName();
        long l2 = tabInfoImpl.getHeapConglomerate();
        SystemColumn[] systemColumnArray = catalogRowFactory.buildColumnList();
        UUID uUID = catalogRowFactory.getCanonicalHeapUUID();
        String string2 = catalogRowFactory.getCanonicalHeapName();
        int n2 = systemColumnArray.length;
        TableDescriptor tableDescriptor = dataDescriptorGenerator.newTableDescriptor(string, schemaDescriptor, 1, 'R');
        tableDescriptor.setUUID(catalogRowFactory.getCanonicalTableUUID());
        this.addDescriptor(tableDescriptor, schemaDescriptor, 1, false, transactionController);
        UUID uUID2 = tableDescriptor.getUUID();
        ConglomerateDescriptor conglomerateDescriptor = dataDescriptorGenerator.newConglomerateDescriptor(l2, string2, false, null, false, uUID, uUID2, schemaDescriptor.getUUID());
        this.addDescriptor(conglomerateDescriptor, schemaDescriptor, 0, false, transactionController);
        TupleDescriptor[] tupleDescriptorArray = new ColumnDescriptor[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            SystemColumn systemColumn = systemColumnArray[i2];
            tupleDescriptorArray[i2] = this.makeColumnDescriptor(systemColumn, i2 + 1, tableDescriptor);
        }
        this.addDescriptorArray(tupleDescriptorArray, tableDescriptor, 2, false, transactionController);
        ColumnDescriptorList columnDescriptorList = tableDescriptor.getColumnDescriptorList();
        for (int i3 = 0; i3 < n2; ++i3) {
            columnDescriptorList.add(tupleDescriptorArray[i3]);
        }
    }

    private ColumnDescriptor makeColumnDescriptor(SystemColumn systemColumn, int n2, TableDescriptor tableDescriptor) throws StandardException {
        return new ColumnDescriptor(systemColumn.getName(), n2, systemColumn.getType(), null, null, tableDescriptor, null, 0L, 0L);
    }

    private long createConglomerate(String string, TransactionController transactionController, ExecRow execRow, Properties properties) throws StandardException {
        long l2 = transactionController.createConglomerate("heap", execRow.getRowArray(), null, null, properties, 0);
        return l2;
    }

    private static SQLChar getIDValueAsCHAR(UUID uUID) {
        String string = uUID.toString();
        return new SQLChar(string);
    }

    public void initializeCatalogInfo() throws StandardException {
        this.initializeCoreInfo();
        this.initializeNoncoreInfo();
    }

    private void initializeCoreInfo() throws StandardException {
        this.coreInfo = new TabInfoImpl[4];
        TabInfoImpl[] tabInfoImplArray = this.coreInfo;
        UUIDFactory uUIDFactory = this.uuidFactory;
        tabInfoImplArray[1] = new TabInfoImpl(new SYSTABLESRowFactory(uUIDFactory, this.exFactory, this.dvf));
        tabInfoImplArray[2] = new TabInfoImpl(new SYSCOLUMNSRowFactory(uUIDFactory, this.exFactory, this.dvf));
        tabInfoImplArray[0] = new TabInfoImpl(new SYSCONGLOMERATESRowFactory(uUIDFactory, this.exFactory, this.dvf));
        tabInfoImplArray[3] = new TabInfoImpl(new SYSSCHEMASRowFactory(uUIDFactory, this.exFactory, this.dvf));
    }

    private void initializeNoncoreInfo() {
        this.noncoreInfo = new TabInfoImpl[NUM_NONCORE];
    }

    public TransactionController getTransactionCompile() throws StandardException {
        if (this.bootingTC != null) {
            return this.bootingTC;
        }
        LanguageConnectionContext languageConnectionContext = DataDictionaryImpl.getLCC();
        return languageConnectionContext.getTransactionCompile();
    }

    public TransactionController getTransactionExecute() throws StandardException {
        if (this.bootingTC != null) {
            return this.bootingTC;
        }
        LanguageConnectionContext languageConnectionContext = DataDictionaryImpl.getLCC();
        return languageConnectionContext.getTransactionExecute();
    }

    private <T extends TupleDescriptor> T getDescriptorViaIndex(int n2, ExecIndexRow execIndexRow, ScanQualifier[][] scanQualifierArray, TabInfoImpl tabInfoImpl, TupleDescriptor tupleDescriptor, List<? super T> list, Class<T> clazz, boolean bl2) throws StandardException {
        TransactionController transactionController = this.getTransactionCompile();
        return this.getDescriptorViaIndexMinion(n2, execIndexRow, scanQualifierArray, tabInfoImpl, tupleDescriptor, list, clazz, bl2, 4, transactionController);
    }

    private <T extends TupleDescriptor> T getDescriptorViaIndex(int n2, ExecIndexRow execIndexRow, ScanQualifier[][] scanQualifierArray, TabInfoImpl tabInfoImpl, TupleDescriptor tupleDescriptor, List<? super T> list, Class<T> clazz, boolean bl2, int n3, TransactionController transactionController) throws StandardException {
        if (transactionController == null) {
            transactionController = this.getTransactionCompile();
        }
        return this.getDescriptorViaIndexMinion(n2, execIndexRow, scanQualifierArray, tabInfoImpl, tupleDescriptor, list, clazz, bl2, n3, transactionController);
    }

    private <T extends TupleDescriptor> T getDescriptorViaIndexMinion(int n2, ExecIndexRow execIndexRow, ScanQualifier[][] scanQualifierArray, TabInfoImpl tabInfoImpl, TupleDescriptor tupleDescriptor, List<? super T> list, Class<T> clazz, boolean bl2, int n3, TransactionController transactionController) throws StandardException {
        ExecIndexRow execIndexRow2;
        CatalogRowFactory catalogRowFactory = tabInfoImpl.getCatalogRowFactory();
        TupleDescriptor tupleDescriptor2 = null;
        ExecRow execRow = catalogRowFactory.makeEmptyRow();
        ConglomerateController conglomerateController = transactionController.openConglomerate(tabInfoImpl.getHeapConglomerate(), false, 0, 6, n3);
        ScanController scanController = transactionController.openScan(tabInfoImpl.getIndexConglomerate(n2), false, bl2 ? 4 : 0, 6, n3, null, execIndexRow.getRowArray(), 1, scanQualifierArray, execIndexRow.getRowArray(), -1);
        while (scanController.fetchNext((execIndexRow2 = DataDictionaryImpl.getIndexRowFromHeapRow(tabInfoImpl.getIndexRowGenerator(n2), conglomerateController.newRowLocationTemplate(), execRow)).getRowArray())) {
            RowLocation rowLocation = (RowLocation)execIndexRow2.getColumn(execIndexRow2.nColumns());
            boolean bl3 = false;
            try {
                bl3 = conglomerateController.fetch(rowLocation, execRow.getRowArray(), null);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (StandardException standardException) {
                throw standardException;
            }
            tupleDescriptor2 = !bl3 && n3 == 1 ? null : (TupleDescriptor)clazz.cast(catalogRowFactory.buildDescriptor(execRow, tupleDescriptor, this));
            if (list == null) break;
            if (tupleDescriptor2 == null) continue;
            list.add(tupleDescriptor2);
        }
        scanController.close();
        conglomerateController.close();
        return (T)tupleDescriptor2;
    }

    private void debugGenerateInfo(StringBuffer stringBuffer, TransactionController transactionController, ConglomerateController conglomerateController, TabInfoImpl tabInfoImpl, int n2) {
    }

    protected <T extends TupleDescriptor> T getDescriptorViaHeap(FormatableBitSet formatableBitSet, ScanQualifier[][] scanQualifierArray, TabInfoImpl tabInfoImpl, TupleDescriptor tupleDescriptor, List<? super T> list, Class<T> clazz) throws StandardException {
        CatalogRowFactory catalogRowFactory = tabInfoImpl.getCatalogRowFactory();
        TupleDescriptor tupleDescriptor2 = null;
        TransactionController transactionController = this.getTransactionCompile();
        ExecRow execRow = catalogRowFactory.makeEmptyRow();
        ScanController scanController = transactionController.openScan(tabInfoImpl.getHeapConglomerate(), false, 0, 7, 4, formatableBitSet, null, 0, scanQualifierArray, null, 0);
        while (scanController.fetchNext(execRow.getRowArray())) {
            tupleDescriptor2 = (TupleDescriptor)clazz.cast(catalogRowFactory.buildDescriptor(execRow, tupleDescriptor, this));
            if (list == null) break;
            list.add(tupleDescriptor2);
        }
        scanController.close();
        return (T)tupleDescriptor2;
    }

    private TabInfoImpl getNonCoreTI(int n2) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTIByNumber(n2);
        this.faultInTabInfo(tabInfoImpl);
        return tabInfoImpl;
    }

    protected TabInfoImpl getNonCoreTIByNumber(int n2) throws StandardException {
        int n3 = n2 - 4;
        TabInfoImpl tabInfoImpl = this.noncoreInfo[n3];
        if (tabInfoImpl == null) {
            UUIDFactory uUIDFactory = this.uuidFactory;
            switch (n2) {
                case 4: {
                    tabInfoImpl = new TabInfoImpl(new SYSCONSTRAINTSRowFactory(uUIDFactory, this.exFactory, this.dvf));
                    break;
                }
                case 5: {
                    tabInfoImpl = new TabInfoImpl(new SYSKEYSRowFactory(uUIDFactory, this.exFactory, this.dvf));
                    break;
                }
                case 6: {
                    tabInfoImpl = new TabInfoImpl(new SYSDEPENDSRowFactory(uUIDFactory, this.exFactory, this.dvf));
                    break;
                }
                case 8: {
                    tabInfoImpl = new TabInfoImpl(new SYSVIEWSRowFactory(uUIDFactory, this.exFactory, this.dvf));
                    break;
                }
                case 9: {
                    tabInfoImpl = new TabInfoImpl(new SYSCHECKSRowFactory(uUIDFactory, this.exFactory, this.dvf));
                    break;
                }
                case 10: {
                    tabInfoImpl = new TabInfoImpl(new SYSFOREIGNKEYSRowFactory(uUIDFactory, this.exFactory, this.dvf));
                    break;
                }
                case 11: {
                    tabInfoImpl = new TabInfoImpl(new SYSSTATEMENTSRowFactory(uUIDFactory, this.exFactory, this.dvf));
                    break;
                }
                case 12: {
                    tabInfoImpl = new TabInfoImpl(new SYSFILESRowFactory(uUIDFactory, this.exFactory, this.dvf));
                    break;
                }
                case 7: {
                    tabInfoImpl = new TabInfoImpl(new SYSALIASESRowFactory(uUIDFactory, this.exFactory, this.dvf));
                    break;
                }
                case 13: {
                    tabInfoImpl = new TabInfoImpl(new SYSTRIGGERSRowFactory(this, uUIDFactory, this.exFactory, this.dvf));
                    break;
                }
                case 14: {
                    tabInfoImpl = new TabInfoImpl(new SYSSTATISTICSRowFactory(uUIDFactory, this.exFactory, this.dvf));
                    break;
                }
                case 15: {
                    tabInfoImpl = new TabInfoImpl(new SYSDUMMY1RowFactory(uUIDFactory, this.exFactory, this.dvf));
                    break;
                }
                case 16: {
                    tabInfoImpl = new TabInfoImpl(new SYSTABLEPERMSRowFactory(uUIDFactory, this.exFactory, this.dvf));
                    break;
                }
                case 17: {
                    tabInfoImpl = new TabInfoImpl(new SYSCOLPERMSRowFactory(uUIDFactory, this.exFactory, this.dvf));
                    break;
                }
                case 18: {
                    tabInfoImpl = new TabInfoImpl(new SYSROUTINEPERMSRowFactory(uUIDFactory, this.exFactory, this.dvf));
                    break;
                }
                case 19: {
                    tabInfoImpl = new TabInfoImpl(new SYSROLESRowFactory(uUIDFactory, this.exFactory, this.dvf));
                    break;
                }
                case 20: {
                    tabInfoImpl = new TabInfoImpl(new SYSSEQUENCESRowFactory(uUIDFactory, this.exFactory, this.dvf));
                    break;
                }
                case 21: {
                    tabInfoImpl = new TabInfoImpl(new SYSPERMSRowFactory(uUIDFactory, this.exFactory, this.dvf));
                    break;
                }
                case 22: {
                    tabInfoImpl = new TabInfoImpl(new SYSUSERSRowFactory(uUIDFactory, this.exFactory, this.dvf));
                }
            }
            this.initSystemIndexVariables(tabInfoImpl);
            this.noncoreInfo[n3] = tabInfoImpl;
        }
        return tabInfoImpl;
    }

    protected void initSystemIndexVariables(TabInfoImpl tabInfoImpl) throws StandardException {
        int n2 = tabInfoImpl.getNumberOfIndexes();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.initSystemIndexVariables(tabInfoImpl, i2);
        }
    }

    private void clearNoncoreTable(int n2) {
        this.noncoreInfo[n2] = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void faultInTabInfo(TabInfoImpl tabInfoImpl) throws StandardException {
        if (tabInfoImpl.isComplete()) {
            return;
        }
        TabInfoImpl tabInfoImpl2 = tabInfoImpl;
        synchronized (tabInfoImpl2) {
            int n2;
            if (tabInfoImpl.isComplete()) {
                return;
            }
            TableDescriptor tableDescriptor = this.getTableDescriptor(tabInfoImpl.getTableName(), this.getSystemSchemaDescriptor(), null);
            if (tableDescriptor == null) {
                return;
            }
            ConglomerateDescriptor conglomerateDescriptor = null;
            ConglomerateDescriptor[] conglomerateDescriptorArray = tableDescriptor.getConglomerateDescriptors();
            for (int i2 = 0; i2 < conglomerateDescriptorArray.length; ++i2) {
                conglomerateDescriptor = conglomerateDescriptorArray[i2];
                if (conglomerateDescriptor.isIndex()) continue;
                tabInfoImpl.setHeapConglomerate(conglomerateDescriptor.getConglomerateNumber());
                break;
            }
            if ((n2 = tabInfoImpl.getCatalogRowFactory().getNumIndexes()) == 0) {
                return;
            }
            ConglomerateDescriptor conglomerateDescriptor2 = null;
            int n3 = 0;
            for (int i3 = 0; i3 < conglomerateDescriptorArray.length; ++i3) {
                conglomerateDescriptor2 = conglomerateDescriptorArray[i3];
                if (!conglomerateDescriptor2.isIndex()) continue;
                tabInfoImpl.setIndexConglomerate(conglomerateDescriptor2);
                ++n3;
            }
        }
    }

    public static ExecIndexRow getIndexRowFromHeapRow(IndexRowGenerator indexRowGenerator, RowLocation rowLocation, ExecRow execRow) throws StandardException {
        ExecIndexRow execIndexRow = indexRowGenerator.getIndexRowTemplate();
        indexRowGenerator.getIndexRow(execRow, rowLocation, execIndexRow, null);
        return execIndexRow;
    }

    @Override
    public int getEngineType() {
        return this.engineType;
    }

    public long getSYSCOLUMNSHeapConglomerateNumber() {
        return this.coreInfo[2].getHeapConglomerate();
    }

    void addSYSCOLUMNSIndex2Property(TransactionController transactionController, long l2) {
        this.startupParameters.put(CFG_SYSCOLUMNS_INDEX2_ID, Long.toString(l2));
    }

    private long getBootParameter(Properties properties, String string, boolean bl2) throws StandardException {
        String string2 = properties.getProperty(string);
        if (string2 == null) {
            if (!bl2) {
                return -1L;
            }
            throw StandardException.newException("XCY03.S", string);
        }
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw StandardException.newException("XCY00.S", string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSystemSQLName() {
        StringBuffer stringBuffer = new StringBuffer("SQL");
        DataDictionaryImpl dataDictionaryImpl = this;
        synchronized (dataDictionaryImpl) {
            long l2 = System.currentTimeMillis() / 10L * 10L;
            if (l2 > this.timeForLastSystemSQLName) {
                this.systemSQLNameNumber = 0;
                this.calendarForLastSystemSQLName.setTimeInMillis(l2);
                this.timeForLastSystemSQLName = l2;
            } else {
                ++this.systemSQLNameNumber;
                if (this.systemSQLNameNumber == 10) {
                    this.systemSQLNameNumber = 0;
                    this.timeForLastSystemSQLName += 10L;
                    this.calendarForLastSystemSQLName.setTimeInMillis(this.timeForLastSystemSQLName);
                }
            }
            stringBuffer.append(DataDictionaryImpl.twoDigits(this.calendarForLastSystemSQLName.get(1)));
            stringBuffer.append(DataDictionaryImpl.twoDigits(this.calendarForLastSystemSQLName.get(2) + 1));
            stringBuffer.append(DataDictionaryImpl.twoDigits(this.calendarForLastSystemSQLName.get(5)));
            stringBuffer.append(DataDictionaryImpl.twoDigits(this.calendarForLastSystemSQLName.get(11)));
            stringBuffer.append(DataDictionaryImpl.twoDigits(this.calendarForLastSystemSQLName.get(12)));
            stringBuffer.append(DataDictionaryImpl.twoDigits(this.calendarForLastSystemSQLName.get(13)));
            stringBuffer.append(DataDictionaryImpl.twoDigits(this.calendarForLastSystemSQLName.get(14) / 10));
            stringBuffer.append(this.systemSQLNameNumber);
        }
        return stringBuffer.toString();
    }

    private static String twoDigits(int n2) {
        String string;
        if (n2 < 10) {
            string = "0" + n2;
        } else {
            int n3 = Integer.toString(n2).length();
            string = Integer.toString(n2).substring(n3 - 2);
        }
        return string;
    }

    @Override
    public void setAutoincrementValue(TransactionController transactionController, UUID uUID, String string, long l2, boolean bl2) throws StandardException {
        TabInfoImpl tabInfoImpl = this.coreInfo[2];
        ExecIndexRow execIndexRow = null;
        execIndexRow = this.exFactory.getIndexableRow(2);
        execIndexRow.setColumn(1, DataDictionaryImpl.getIDValueAsCHAR(uUID));
        execIndexRow.setColumn(2, new SQLChar(string));
        SYSCOLUMNSRowFactory sYSCOLUMNSRowFactory = (SYSCOLUMNSRowFactory)tabInfoImpl.getCatalogRowFactory();
        ExecRow execRow = sYSCOLUMNSRowFactory.makeEmptyRow();
        boolean[] blArray = new boolean[2];
        for (int i2 = 0; i2 < 2; ++i2) {
            blArray[i2] = false;
        }
        int[] nArray = new int[]{7};
        if (bl2) {
            ExecRow execRow2 = tabInfoImpl.getRow(transactionController, execIndexRow, 0);
            NumberDataValue numberDataValue = (NumberDataValue)execRow2.getColumn(9);
            l2 += numberDataValue.getLong();
        }
        execRow.setColumn(7, new SQLLongint(l2));
        tabInfoImpl.updateRow(execIndexRow, execRow, 0, blArray, nArray, transactionController);
    }

    private RowLocation computeRowLocation(TransactionController transactionController, TableDescriptor tableDescriptor, String string) throws StandardException {
        TabInfoImpl tabInfoImpl = this.coreInfo[2];
        ExecIndexRow execIndexRow = null;
        UUID uUID = tableDescriptor.getUUID();
        execIndexRow = this.exFactory.getIndexableRow(2);
        execIndexRow.setColumn(1, DataDictionaryImpl.getIDValueAsCHAR(uUID));
        execIndexRow.setColumn(2, new SQLChar(string));
        return tabInfoImpl.getRowLocation(transactionController, execIndexRow, 0);
    }

    @Override
    public void computeSequenceRowLocation(TransactionController transactionController, String string, RowLocation[] rowLocationArray, SequenceDescriptor[] sequenceDescriptorArray) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(20);
        ExecIndexRow execIndexRow = null;
        execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, new SQLChar(string));
        rowLocationArray[0] = tabInfoImpl.getRowLocation(transactionController, execIndexRow, 0);
        sequenceDescriptorArray[0] = this.getDescriptorViaIndex(0, execIndexRow, null, tabInfoImpl, null, null, SequenceDescriptor.class, false, 4, transactionController);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateCurrentSequenceValue(TransactionController transactionController, RowLocation rowLocation, boolean bl2, Long l2, Long l3) throws StandardException {
        int n2 = 5;
        FormatableBitSet formatableBitSet = new FormatableBitSet(10);
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(20);
        ConglomerateController conglomerateController = null;
        SYSSEQUENCESRowFactory sYSSEQUENCESRowFactory = (SYSSEQUENCESRowFactory)tabInfoImpl.getCatalogRowFactory();
        ExecRow execRow = sYSSEQUENCESRowFactory.makeEmptyRow();
        formatableBitSet.set(n2 - 1);
        try {
            conglomerateController = transactionController.openConglomerate(tabInfoImpl.getHeapConglomerate(), false, 4 | (bl2 ? 0 : 128), 6, 4);
            boolean bl3 = conglomerateController.fetch(rowLocation, execRow.getRowArray(), formatableBitSet, bl2);
            if (!bl3) {
                boolean bl4 = false;
                return bl4;
            }
            NumberDataValue numberDataValue = (NumberDataValue)execRow.getColumn(n2);
            SQLLongint sQLLongint = l2 == null ? new SQLLongint() : new SQLLongint((long)l2);
            if (l2 == null || sQLLongint.compare(numberDataValue) == 0) {
                SQLLongint sQLLongint2 = l3 == null ? new SQLLongint() : new SQLLongint((long)l3);
                execRow.setColumn(n2, sQLLongint2);
                conglomerateController.replace(rowLocation, execRow.getRowArray(), formatableBitSet);
                boolean bl5 = true;
                return bl5;
            }
            boolean bl6 = false;
            return bl6;
        }
        finally {
            if (conglomerateController != null) {
                conglomerateController.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getCurrentValueAndAdvance(String string, NumberDataValue numberDataValue) throws StandardException {
        SequenceUpdater sequenceUpdater = null;
        try {
            sequenceUpdater = (SequenceUpdater)this.sequenceGeneratorCache.find(string);
            sequenceUpdater.getCurrentValueAndAdvance(numberDataValue);
        }
        finally {
            if (sequenceUpdater != null) {
                this.sequenceGeneratorCache.release(sequenceUpdater);
            }
        }
    }

    @Override
    public Long peekAtIdentity(String string, String string2) throws StandardException {
        LanguageConnectionContext languageConnectionContext = DataDictionaryImpl.getLCC();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        SchemaDescriptor schemaDescriptor = this.getSchemaDescriptor(string, transactionController, true);
        TableDescriptor tableDescriptor = this.getTableDescriptor(string2, schemaDescriptor, transactionController);
        if (tableDescriptor == null) {
            throw StandardException.newException("X0X81.S", "TABLE", string + "." + string2);
        }
        return this.peekAtSequence("SYS", TableDescriptor.makeSequenceName(tableDescriptor.getUUID()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long peekAtSequence(String string, String string2) throws StandardException {
        String string3 = this.getSequenceID(string, string2);
        if (string3 == null) {
            throw StandardException.newException("X0X81.S", "SEQUENCE", string + "." + string2);
        }
        SequenceUpdater sequenceUpdater = null;
        try {
            sequenceUpdater = (SequenceUpdater)this.sequenceGeneratorCache.find(string3);
            Long l2 = sequenceUpdater.peekAtCurrentValue();
            return l2;
        }
        finally {
            if (sequenceUpdater != null) {
                this.sequenceGeneratorCache.release(sequenceUpdater);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BulkInsertCounter getBulkInsertCounter(String string, boolean bl2) throws StandardException {
        SequenceUpdater sequenceUpdater = null;
        try {
            sequenceUpdater = (SequenceUpdater)this.sequenceGeneratorCache.find(string);
            SequenceUpdater.BulkInsertUpdater bulkInsertUpdater = sequenceUpdater.getBulkInsertUpdater(bl2);
            return bulkInsertUpdater;
        }
        finally {
            if (sequenceUpdater != null) {
                this.sequenceGeneratorCache.release(sequenceUpdater);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushBulkInsertCounter(String string, BulkInsertCounter bulkInsertCounter) throws StandardException {
        SequenceUpdater sequenceUpdater = null;
        try {
            sequenceUpdater = (SequenceUpdater)this.sequenceGeneratorCache.find(string);
            sequenceUpdater.reset(bulkInsertCounter.peekAtCurrentValue());
        }
        finally {
            if (sequenceUpdater != null) {
                this.sequenceGeneratorCache.release(sequenceUpdater);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowLocation getRowLocationTemplate(LanguageConnectionContext languageConnectionContext, TableDescriptor tableDescriptor) throws StandardException {
        RowLocation rowLocation;
        ConglomerateController conglomerateController = null;
        TransactionController transactionController = languageConnectionContext.getTransactionCompile();
        long l2 = tableDescriptor.getHeapConglomerateId();
        conglomerateController = transactionController.openConglomerate(l2, false, 0, 6, 2);
        try {
            rowLocation = conglomerateController.newRowLocationTemplate();
        }
        finally {
            conglomerateController.close();
        }
        return rowLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTableDescriptorToOtherCache(TableDescriptor tableDescriptor, Cacheable cacheable) throws StandardException {
        CacheManager cacheManager = cacheable instanceof OIDTDCacheable ? this.nameTdCache : this.OIDTdCache;
        TDCacheable tDCacheable = null;
        Object object = cacheManager == this.nameTdCache ? new TableKey(tableDescriptor.getSchemaDescriptor().getUUID(), tableDescriptor.getName()) : tableDescriptor.getUUID();
        try {
            tDCacheable = (TDCacheable)cacheManager.create(object, tableDescriptor);
        }
        catch (StandardException standardException) {
            if (!standardException.getMessageId().equals("XBCA0.S")) {
                throw standardException;
            }
        }
        finally {
            if (tDCacheable != null) {
                cacheManager.release(tDCacheable);
            }
        }
    }

    @Override
    public void dropStatisticsDescriptors(UUID uUID, UUID uUID2, TransactionController transactionController) throws StandardException {
        ExecIndexRow execIndexRow;
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(14);
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(uUID);
        if (uUID2 != null) {
            execIndexRow = this.exFactory.getIndexableRow(2);
            SQLChar sQLChar2 = DataDictionaryImpl.getIDValueAsCHAR(uUID2);
            execIndexRow.setColumn(2, sQLChar2);
        } else {
            execIndexRow = this.exFactory.getIndexableRow(1);
        }
        execIndexRow.setColumn(1, sQLChar);
        tabInfoImpl.deleteRow(transactionController, execIndexRow, 0);
    }

    private static LanguageConnectionContext getLCC() {
        return (LanguageConnectionContext)DataDictionaryImpl.getContextOrNull("LanguageConnectionContext");
    }

    private SchemaDescriptor newSystemSchemaDesc(String string, String string2) {
        return new SchemaDescriptor(this, string, this.authorizationDatabaseOwner, this.uuidFactory.recreateUUID(string2), true);
    }

    private SchemaDescriptor newDeclaredGlobalTemporaryTablesSchemaDesc(String string) {
        return new SchemaDescriptor(this, string, this.authorizationDatabaseOwner, null, false);
    }

    @Override
    public boolean checkVersion(int n2, String string) throws StandardException {
        if (n2 == -1) {
            n2 = this.softwareVersion.majorVersionNumber;
        }
        return this.dictionaryVersion.checkVersion(n2, string);
    }

    @Override
    public boolean isReadOnlyUpgrade() {
        return this.readOnlyUpgrade;
    }

    void setReadOnlyUpgrade() {
        this.readOnlyUpgrade = true;
    }

    void createSystemSps(TransactionController transactionController) throws StandardException {
        this.createSPSSet(transactionController, false, this.getSystemSchemaDescriptor().getUUID());
        this.createSPSSet(transactionController, true, this.getSysIBMSchemaDescriptor().getUUID());
    }

    protected void createSPSSet(TransactionController transactionController, boolean bl2, UUID uUID) throws StandardException {
        Properties properties = this.getQueryDescriptions(bl2);
        Enumeration<Object> enumeration = properties.keys();
        boolean bl3 = true;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            SPSDescriptor sPSDescriptor = new SPSDescriptor(this, string, this.getUUIDFactory().createUUID(), uUID, uUID, 'S', !bl3, string2, !bl3);
            this.addSPSDescriptor(sPSDescriptor, transactionController);
        }
    }

    private final UUID createSystemProcedureOrFunction(String string, UUID uUID, String[] stringArray, TypeDescriptor[] typeDescriptorArray, int n2, int n3, short s2, boolean bl2, boolean bl3, TypeDescriptor typeDescriptor, HashSet<String> hashSet, TransactionController transactionController, String string2) throws StandardException {
        int n4 = 0;
        if (stringArray != null) {
            n4 = stringArray.length;
        }
        int[] nArray = null;
        if (n4 != 0) {
            int n5;
            nArray = new int[n4];
            int n6 = n4 - n2;
            for (n5 = 0; n5 < n6; ++n5) {
                nArray[n5] = 1;
            }
            for (n5 = 0; n5 < n2; ++n5) {
                nArray[n6 + n5] = 4;
            }
        }
        RoutineAliasInfo routineAliasInfo = new RoutineAliasInfo(string, n4, stringArray, typeDescriptorArray, nArray, n3, 0, s2, bl2, bl3, false, true, typeDescriptor);
        UUID uUID2 = this.getUUIDFactory().createUUID();
        AliasDescriptor aliasDescriptor = new AliasDescriptor(this, uUID2, string, uUID, string2, typeDescriptor == null ? (char)'P' : 'F', typeDescriptor == null ? (char)'P' : 'F', false, routineAliasInfo, null);
        this.addDescriptor(aliasDescriptor, null, 7, false, transactionController);
        hashSet.add(string);
        return uUID2;
    }

    private final UUID createSystemProcedureOrFunction(String string, UUID uUID, String[] stringArray, TypeDescriptor[] typeDescriptorArray, int n2, int n3, short s2, boolean bl2, boolean bl3, TypeDescriptor typeDescriptor, HashSet<String> hashSet, TransactionController transactionController) throws StandardException {
        UUID uUID2 = this.createSystemProcedureOrFunction(string, uUID, stringArray, typeDescriptorArray, n2, n3, s2, bl2, bl3, typeDescriptor, hashSet, transactionController, "org.apache.derby.catalog.SystemProcedures");
        return uUID2;
    }

    private final void create_SYSCS_procedures(TransactionController transactionController, HashSet<String> hashSet) throws StandardException {
        TypeDescriptor typeDescriptor = DataTypeDescriptor.getCatalogType(12, 32672);
        UUID uUID = this.getSystemUtilSchemaDescriptor().getUUID();
        Object object = new String[]{"KEY", "VALUE"};
        Object[] objectArray = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, DataTypeDescriptor.getCatalogType(12, 32672)};
        this.createSystemProcedureOrFunction("SYSCS_SET_DATABASE_PROPERTY", uUID, (String[])object, (TypeDescriptor[])objectArray, 0, 0, (short)0, false, false, null, hashSet, transactionController);
        object = new String[]{"SCHEMANAME", "TABLENAME", "SEQUENTIAL"};
        objectArray = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, TypeDescriptor.SMALLINT};
        this.createSystemProcedureOrFunction("SYSCS_COMPRESS_TABLE", uUID, (String[])object, (TypeDescriptor[])objectArray, 0, 0, (short)0, false, false, null, hashSet, transactionController);
        this.createSystemProcedureOrFunction("SYSCS_CHECKPOINT_DATABASE", uUID, null, null, 0, 0, (short)2, false, false, null, hashSet, transactionController);
        this.createSystemProcedureOrFunction("SYSCS_FREEZE_DATABASE", uUID, null, null, 0, 0, (short)2, false, false, null, hashSet, transactionController);
        this.createSystemProcedureOrFunction("SYSCS_UNFREEZE_DATABASE", uUID, null, null, 0, 0, (short)2, false, false, null, hashSet, transactionController);
        object = new String[]{"BACKUPDIR"};
        objectArray = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(12, 32672)};
        this.createSystemProcedureOrFunction("SYSCS_BACKUP_DATABASE", uUID, (String[])object, (TypeDescriptor[])objectArray, 0, 0, (short)0, false, false, null, hashSet, transactionController);
        object = new String[]{"BACKUPDIR", "DELETE_ARCHIVED_LOG_FILES"};
        objectArray = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(12, 32672), TypeDescriptor.SMALLINT};
        this.createSystemProcedureOrFunction("SYSCS_BACKUP_DATABASE_AND_ENABLE_LOG_ARCHIVE_MODE", uUID, (String[])object, (TypeDescriptor[])objectArray, 0, 0, (short)0, false, false, null, hashSet, transactionController);
        object = new String[]{"DELETE_ARCHIVED_LOG_FILES"};
        objectArray = new TypeDescriptor[]{TypeDescriptor.SMALLINT};
        this.createSystemProcedureOrFunction("SYSCS_DISABLE_LOG_ARCHIVE_MODE", uUID, (String[])object, (TypeDescriptor[])objectArray, 0, 0, (short)0, false, false, null, hashSet, transactionController);
        object = new String[]{"ENABLE"};
        objectArray = new TypeDescriptor[]{TypeDescriptor.SMALLINT};
        this.createSystemProcedureOrFunction("SYSCS_SET_RUNTIMESTATISTICS", uUID, (String[])object, (TypeDescriptor[])objectArray, 0, 0, (short)2, false, false, null, hashSet, transactionController);
        object = new String[]{"ENABLE"};
        objectArray = new TypeDescriptor[]{TypeDescriptor.SMALLINT};
        this.createSystemProcedureOrFunction("SYSCS_SET_STATISTICS_TIMING", uUID, (String[])object, (TypeDescriptor[])objectArray, 0, 0, (short)2, false, false, null, hashSet, transactionController);
        object = new String[]{"KEY"};
        objectArray = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER};
        this.createSystemProcedureOrFunction("SYSCS_GET_DATABASE_PROPERTY", uUID, (String[])object, (TypeDescriptor[])objectArray, 0, 0, (short)1, false, false, DataTypeDescriptor.getCatalogType(12, 32672), hashSet, transactionController);
        object = new String[]{"SCHEMANAME", "TABLENAME"};
        objectArray = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER};
        this.createSystemProcedureOrFunction("SYSCS_CHECK_TABLE", uUID, (String[])object, (TypeDescriptor[])objectArray, 0, 0, (short)1, false, false, TypeDescriptor.INTEGER, hashSet, transactionController);
        this.createSystemProcedureOrFunction("SYSCS_GET_RUNTIMESTATISTICS", uUID, null, null, 0, 0, (short)2, false, false, DataTypeDescriptor.getCatalogType(12, 32672), hashSet, transactionController);
        object = this.getSchemaDescriptor("SQLJ", transactionController, true).getUUID();
        objectArray = new String[]{"URL", "JAR", "DEPLOY"};
        TypeDescriptor[] typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(12, 256), CATALOG_TYPE_SYSTEM_IDENTIFIER, TypeDescriptor.INTEGER};
        this.createSystemProcedureOrFunction("INSTALL_JAR", (UUID)object, (String[])objectArray, typeDescriptorArray, 0, 0, (short)0, false, false, null, hashSet, transactionController);
        objectArray = new String[]{"URL", "JAR"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(12, 256), CATALOG_TYPE_SYSTEM_IDENTIFIER};
        this.createSystemProcedureOrFunction("REPLACE_JAR", (UUID)object, (String[])objectArray, typeDescriptorArray, 0, 0, (short)0, false, false, null, hashSet, transactionController);
        objectArray = new String[]{"JAR", "UNDEPLOY"};
        typeDescriptorArray = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, TypeDescriptor.INTEGER};
        this.createSystemProcedureOrFunction("REMOVE_JAR", (UUID)object, (String[])objectArray, typeDescriptorArray, 0, 0, (short)0, false, false, null, hashSet, transactionController);
        objectArray = new String[]{"schemaName", "tableName", "fileName", " columnDelimiter", "characterDelimiter", "codeset"};
        typeDescriptorArray = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, typeDescriptor, DataTypeDescriptor.getCatalogType(1, 1), DataTypeDescriptor.getCatalogType(1, 1), CATALOG_TYPE_SYSTEM_IDENTIFIER};
        this.createSystemProcedureOrFunction("SYSCS_EXPORT_TABLE", uUID, (String[])objectArray, typeDescriptorArray, 0, 0, (short)1, false, false, null, hashSet, transactionController);
        objectArray = new String[]{"selectStatement", "fileName", " columnDelimiter", "characterDelimiter", "codeset"};
        typeDescriptorArray = new TypeDescriptor[]{typeDescriptor, typeDescriptor, DataTypeDescriptor.getCatalogType(1, 1), DataTypeDescriptor.getCatalogType(1, 1), CATALOG_TYPE_SYSTEM_IDENTIFIER};
        this.createSystemProcedureOrFunction("SYSCS_EXPORT_QUERY", uUID, (String[])objectArray, typeDescriptorArray, 0, 0, (short)1, false, false, null, hashSet, transactionController);
        objectArray = new String[]{"schemaName", "tableName", "fileName", " columnDelimiter", "characterDelimiter", "codeset", "replace"};
        typeDescriptorArray = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, typeDescriptor, DataTypeDescriptor.getCatalogType(1, 1), DataTypeDescriptor.getCatalogType(1, 1), CATALOG_TYPE_SYSTEM_IDENTIFIER, TypeDescriptor.SMALLINT};
        this.createSystemProcedureOrFunction("SYSCS_IMPORT_TABLE", uUID, (String[])objectArray, typeDescriptorArray, 0, 0, (short)0, false, false, null, hashSet, transactionController);
        objectArray = new String[]{"schemaName", "tableName", "insertColumnList", "columnIndexes", "fileName", " columnDelimiter", "characterDelimiter", "codeset", "replace"};
        typeDescriptorArray = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, typeDescriptor, typeDescriptor, typeDescriptor, DataTypeDescriptor.getCatalogType(1, 1), DataTypeDescriptor.getCatalogType(1, 1), CATALOG_TYPE_SYSTEM_IDENTIFIER, TypeDescriptor.SMALLINT};
        this.createSystemProcedureOrFunction("SYSCS_IMPORT_DATA", uUID, (String[])objectArray, typeDescriptorArray, 0, 0, (short)0, false, false, null, hashSet, transactionController);
        objectArray = new String[]{"schemaName", "tableName", "vtiName", "vtiArg"};
        typeDescriptorArray = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, typeDescriptor, typeDescriptor};
        this.createSystemProcedureOrFunction("SYSCS_BULK_INSERT", uUID, (String[])objectArray, typeDescriptorArray, 0, 0, (short)0, false, false, null, hashSet, transactionController);
        this.create_10_1_system_procedures(transactionController, hashSet, uUID);
        this.create_10_2_system_procedures(transactionController, hashSet, uUID);
        this.create_10_3_system_procedures(transactionController, hashSet);
        this.create_10_5_system_procedures(transactionController, hashSet);
        this.create_10_6_system_procedures(transactionController, hashSet);
        this.create_10_9_system_procedures(transactionController, hashSet);
        this.create_10_10_system_procedures(transactionController, hashSet);
        this.create_10_11_system_procedures(transactionController, hashSet);
        this.create_10_12_system_procedures(transactionController, hashSet);
        this.create_10_13_system_procedures(transactionController, hashSet);
    }

    protected final void create_SYSIBM_procedures(TransactionController transactionController, HashSet<String> hashSet) throws StandardException {
        UUID uUID = this.getSysIBMSchemaDescriptor().getUUID();
        String[] stringArray = new String[]{"SQLCODE", "SQLERRML", "SQLERRMC", "SQLERRP", "SQLERRD0", "SQLERRD1", "SQLERRD2", "SQLERRD3", "SQLERRD4", "SQLERRD5", "SQLWARN", "SQLSTATE", "FILE", "LOCALE", "MESSAGE", "RETURNCODE"};
        TypeDescriptor[] typeDescriptorArray = new TypeDescriptor[]{TypeDescriptor.INTEGER, TypeDescriptor.SMALLINT, DataTypeDescriptor.getCatalogType(12, 2400), DataTypeDescriptor.getCatalogType(1, 8), TypeDescriptor.INTEGER, TypeDescriptor.INTEGER, TypeDescriptor.INTEGER, TypeDescriptor.INTEGER, TypeDescriptor.INTEGER, TypeDescriptor.INTEGER, DataTypeDescriptor.getCatalogType(1, 11), DataTypeDescriptor.getCatalogType(1, 5), DataTypeDescriptor.getCatalogType(12, 50), DataTypeDescriptor.getCatalogType(1, 5), DataTypeDescriptor.getCatalogType(12, 2400), TypeDescriptor.INTEGER};
        this.createSystemProcedureOrFunction("SQLCAMESSAGE", uUID, stringArray, typeDescriptorArray, 2, 0, (short)1, false, false, null, hashSet, transactionController);
        stringArray = new String[]{"CATALOGNAME", "SCHEMANAME", "PROCNAME", "OPTIONS"};
        typeDescriptorArray = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, DataTypeDescriptor.getCatalogType(12, 4000)};
        this.createSystemProcedureOrFunction("SQLPROCEDURES", uUID, stringArray, typeDescriptorArray, 0, 1, (short)1, false, false, null, hashSet, transactionController);
        stringArray = new String[]{"CATALOGNAME", "SCHEMANAME", "TABLENAME", "OPTIONS"};
        typeDescriptorArray = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, DataTypeDescriptor.getCatalogType(12, 4000)};
        this.createSystemProcedureOrFunction("SQLTABLEPRIVILEGES", uUID, stringArray, typeDescriptorArray, 0, 1, (short)1, false, false, null, hashSet, transactionController);
        stringArray = new String[]{"CATALOGNAME", "SCHEMANAME", "TABLENAME", "OPTIONS"};
        typeDescriptorArray = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, DataTypeDescriptor.getCatalogType(12, 4000)};
        this.createSystemProcedureOrFunction("SQLPRIMARYKEYS", uUID, stringArray, typeDescriptorArray, 0, 1, (short)1, false, false, null, hashSet, transactionController);
        stringArray = new String[]{"CATALOGNAME", "SCHEMANAME", "TABLENAME", "TABLETYPE", "OPTIONS"};
        typeDescriptorArray = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, DataTypeDescriptor.getCatalogType(12, 4000), DataTypeDescriptor.getCatalogType(12, 4000)};
        this.createSystemProcedureOrFunction("SQLTABLES", uUID, stringArray, typeDescriptorArray, 0, 1, (short)1, false, false, null, hashSet, transactionController);
        stringArray = new String[]{"CATALOGNAME", "SCHEMANAME", "PROCNAME", "PARAMNAME", "OPTIONS"};
        typeDescriptorArray = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, DataTypeDescriptor.getCatalogType(12, 4000)};
        this.createSystemProcedureOrFunction("SQLPROCEDURECOLS", uUID, stringArray, typeDescriptorArray, 0, 1, (short)1, false, false, null, hashSet, transactionController);
        stringArray = new String[]{"CATALOGNAME", "SCHEMANAME", "TABLENAME", "COLUMNNAME", "OPTIONS"};
        typeDescriptorArray = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, DataTypeDescriptor.getCatalogType(12, 4000)};
        this.createSystemProcedureOrFunction("SQLCOLUMNS", uUID, stringArray, typeDescriptorArray, 0, 1, (short)1, false, false, null, hashSet, transactionController);
        stringArray = new String[]{"CATALOGNAME", "SCHEMANAME", "TABLENAME", "COLUMNNAME", "OPTIONS"};
        typeDescriptorArray = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, DataTypeDescriptor.getCatalogType(12, 4000)};
        this.createSystemProcedureOrFunction("SQLCOLPRIVILEGES", uUID, stringArray, typeDescriptorArray, 0, 1, (short)1, false, false, null, hashSet, transactionController);
        stringArray = new String[]{"CATALOGNAME", "SCHEMAPATTERN", "TYPENAMEPATTERN", "UDTTYPES", "OPTIONS"};
        typeDescriptorArray = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, DataTypeDescriptor.getCatalogType(12, 4000)};
        this.createSystemProcedureOrFunction("SQLUDTS", uUID, stringArray, typeDescriptorArray, 0, 1, (short)1, false, false, null, hashSet, transactionController);
        stringArray = new String[]{"PKCATALOGNAME", "PKSCHEMANAME", "PKTABLENAME", "FKCATALOGNAME", "FKSCHEMANAME", "FKTABLENAME", "OPTIONS"};
        typeDescriptorArray = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, DataTypeDescriptor.getCatalogType(12, 4000)};
        this.createSystemProcedureOrFunction("SQLFOREIGNKEYS", uUID, stringArray, typeDescriptorArray, 0, 1, (short)1, false, false, null, hashSet, transactionController);
        stringArray = new String[]{"COLTYPE", "CATALOGNAME", "SCHEMANAME", "TABLENAME", "SCOPE", "NULLABLE", "OPTIONS"};
        typeDescriptorArray = new TypeDescriptor[]{TypeDescriptor.SMALLINT, CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, TypeDescriptor.SMALLINT, TypeDescriptor.SMALLINT, DataTypeDescriptor.getCatalogType(12, 4000)};
        this.createSystemProcedureOrFunction("SQLSPECIALCOLUMNS", uUID, stringArray, typeDescriptorArray, 0, 1, (short)1, false, false, null, hashSet, transactionController);
        stringArray = new String[]{"DATATYPE", "OPTIONS"};
        typeDescriptorArray = new TypeDescriptor[]{TypeDescriptor.SMALLINT, DataTypeDescriptor.getCatalogType(12, 4000)};
        this.createSystemProcedureOrFunction("SQLGETTYPEINFO", uUID, stringArray, typeDescriptorArray, 0, 1, (short)1, false, false, null, hashSet, transactionController);
        stringArray = new String[]{"CATALOGNAME", "SCHEMANAME", "TABLENAME", "UNIQUE", "RESERVED", "OPTIONS"};
        typeDescriptorArray = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, TypeDescriptor.SMALLINT, TypeDescriptor.SMALLINT, DataTypeDescriptor.getCatalogType(12, 4000)};
        this.createSystemProcedureOrFunction("SQLSTATISTICS", uUID, stringArray, typeDescriptorArray, 0, 1, (short)1, false, false, null, hashSet, transactionController);
        this.createSystemProcedureOrFunction("METADATA", uUID, null, null, 0, 1, (short)1, false, false, null, hashSet, transactionController);
    }

    public void grantPublicAccessToSystemRoutines(HashSet hashSet, TransactionController transactionController, String string) throws StandardException {
        String string2;
        int n2;
        String string3 = this.getSystemUtilSchemaDescriptor().getUUID().toString();
        for (n2 = 0; n2 < sysUtilProceduresWithPublicAccess.length; ++n2) {
            string2 = sysUtilProceduresWithPublicAccess[n2];
            if (!hashSet.contains(string2)) continue;
            this.grantPublicAccessToSystemRoutine(string3, string2, 'P', transactionController, string);
        }
        for (n2 = 0; n2 < sysUtilFunctionsWithPublicAccess.length; ++n2) {
            string2 = sysUtilFunctionsWithPublicAccess[n2];
            if (!hashSet.contains(string2)) continue;
            this.grantPublicAccessToSystemRoutine(string3, string2, 'F', transactionController, string);
        }
    }

    private void grantPublicAccessToSystemRoutine(String string, String string2, char c2, TransactionController transactionController, String string3) throws StandardException {
        AliasDescriptor aliasDescriptor = this.getAliasDescriptor(string, string2, c2);
        if (aliasDescriptor == null) {
            return;
        }
        UUID uUID = aliasDescriptor.getUUID();
        this.createRoutinePermPublicDescriptor(uUID, transactionController, string3);
    }

    void createRoutinePermPublicDescriptor(UUID uUID, TransactionController transactionController, String string) throws StandardException {
        RoutinePermsDescriptor routinePermsDescriptor = new RoutinePermsDescriptor(this, "PUBLIC", string, uUID);
        this.addDescriptor(routinePermsDescriptor, null, 18, false, transactionController);
    }

    void create_10_1_system_procedures(TransactionController transactionController, HashSet<String> hashSet, UUID uUID) throws StandardException {
        String[] stringArray = new String[]{"SCHEMANAME", "TABLENAME", "PURGE_ROWS", "DEFRAGMENT_ROWS", "TRUNCATE_END"};
        TypeDescriptor[] typeDescriptorArray = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, TypeDescriptor.SMALLINT, TypeDescriptor.SMALLINT, TypeDescriptor.SMALLINT};
        this.createSystemProcedureOrFunction("SYSCS_INPLACE_COMPRESS_TABLE", uUID, stringArray, typeDescriptorArray, 0, 0, (short)0, false, false, null, hashSet, transactionController);
    }

    void create_10_2_system_procedures(TransactionController transactionController, HashSet<String> hashSet, UUID uUID) throws StandardException {
        String[] stringArray = new String[]{"BACKUPDIR"};
        TypeDescriptor[] typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(12, 32672)};
        this.createSystemProcedureOrFunction("SYSCS_BACKUP_DATABASE_NOWAIT", uUID, stringArray, typeDescriptorArray, 0, 0, (short)0, false, false, null, hashSet, transactionController);
        stringArray = new String[]{"BACKUPDIR", "DELETE_ARCHIVED_LOG_FILES"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(12, 32672), TypeDescriptor.SMALLINT};
        this.createSystemProcedureOrFunction("SYSCS_BACKUP_DATABASE_AND_ENABLE_LOG_ARCHIVE_MODE_NOWAIT", uUID, stringArray, typeDescriptorArray, 0, 0, (short)0, false, false, null, hashSet, transactionController);
        stringArray = new String[]{"CATALOGNAME", "SCHEMANAME", "FUNCNAME", "OPTIONS"};
        typeDescriptorArray = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, DataTypeDescriptor.getCatalogType(12, 4000)};
        this.createSystemProcedureOrFunction("SQLFUNCTIONS", this.getSysIBMSchemaDescriptor().getUUID(), stringArray, typeDescriptorArray, 0, 1, (short)1, false, false, null, hashSet, transactionController);
        stringArray = new String[]{"CATALOGNAME", "SCHEMANAME", "FUNCNAME", "PARAMNAME", "OPTIONS"};
        typeDescriptorArray = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, DataTypeDescriptor.getCatalogType(12, 4000)};
        this.createSystemProcedureOrFunction("SQLFUNCTIONPARAMS", this.getSysIBMSchemaDescriptor().getUUID(), stringArray, typeDescriptorArray, 0, 1, (short)1, false, false, null, hashSet, transactionController);
    }

    private void create_10_3_system_procedures_SYSIBM(TransactionController transactionController, HashSet<String> hashSet) throws StandardException {
        UUID uUID = this.getSysIBMSchemaDescriptor().getUUID();
        String[] stringArray = null;
        TypeDescriptor[] typeDescriptorArray = null;
        this.createSystemProcedureOrFunction("CLOBCREATELOCATOR", uUID, stringArray, typeDescriptorArray, 0, 0, (short)2, false, false, TypeDescriptor.INTEGER, hashSet, transactionController, "org.apache.derby.impl.jdbc.LOBStoredProcedure");
        stringArray = new String[]{"LOCATOR"};
        typeDescriptorArray = new TypeDescriptor[]{TypeDescriptor.INTEGER};
        this.createSystemProcedureOrFunction("CLOBRELEASELOCATOR", uUID, stringArray, typeDescriptorArray, 0, 0, (short)2, false, false, null, hashSet, transactionController, "org.apache.derby.impl.jdbc.LOBStoredProcedure");
        stringArray = new String[]{"LOCATOR", "SEARCHSTR", "POS"};
        typeDescriptorArray = new TypeDescriptor[]{TypeDescriptor.INTEGER, DataTypeDescriptor.getCatalogType(12), DataTypeDescriptor.getCatalogType(-5)};
        this.createSystemProcedureOrFunction("CLOBGETPOSITIONFROMSTRING", uUID, stringArray, typeDescriptorArray, 0, 0, (short)2, false, false, DataTypeDescriptor.getCatalogType(-5), hashSet, transactionController, "org.apache.derby.impl.jdbc.LOBStoredProcedure");
        stringArray = new String[]{"LOCATOR", "SEARCHLOCATOR", "POS"};
        typeDescriptorArray = new TypeDescriptor[]{TypeDescriptor.INTEGER, TypeDescriptor.INTEGER, DataTypeDescriptor.getCatalogType(-5)};
        this.createSystemProcedureOrFunction("CLOBGETPOSITIONFROMLOCATOR", uUID, stringArray, typeDescriptorArray, 0, 0, (short)2, false, false, DataTypeDescriptor.getCatalogType(-5), hashSet, transactionController, "org.apache.derby.impl.jdbc.LOBStoredProcedure");
        stringArray = new String[]{"LOCATOR"};
        typeDescriptorArray = new TypeDescriptor[]{TypeDescriptor.INTEGER};
        this.createSystemProcedureOrFunction("CLOBGETLENGTH", uUID, stringArray, typeDescriptorArray, 0, 0, (short)2, false, false, DataTypeDescriptor.getCatalogType(-5), hashSet, transactionController, "org.apache.derby.impl.jdbc.LOBStoredProcedure");
        stringArray = new String[]{"LOCATOR", "POS", "LEN"};
        typeDescriptorArray = new TypeDescriptor[]{TypeDescriptor.INTEGER, DataTypeDescriptor.getCatalogType(-5), TypeDescriptor.INTEGER};
        this.createSystemProcedureOrFunction("CLOBGETSUBSTRING", uUID, stringArray, typeDescriptorArray, 0, 0, (short)2, false, false, DataTypeDescriptor.getCatalogType(12, 10890), hashSet, transactionController, "org.apache.derby.impl.jdbc.LOBStoredProcedure");
        stringArray = new String[]{"LOCATOR", "POS", "LEN", "REPLACESTR"};
        typeDescriptorArray = new TypeDescriptor[]{TypeDescriptor.INTEGER, DataTypeDescriptor.getCatalogType(-5), TypeDescriptor.INTEGER, DataTypeDescriptor.getCatalogType(12)};
        this.createSystemProcedureOrFunction("CLOBSETSTRING", uUID, stringArray, typeDescriptorArray, 0, 0, (short)2, false, false, null, hashSet, transactionController, "org.apache.derby.impl.jdbc.LOBStoredProcedure");
        stringArray = new String[]{"LOCATOR", "LEN"};
        typeDescriptorArray = new TypeDescriptor[]{TypeDescriptor.INTEGER, DataTypeDescriptor.getCatalogType(-5)};
        this.createSystemProcedureOrFunction("CLOBTRUNCATE", uUID, stringArray, typeDescriptorArray, 0, 0, (short)2, false, false, null, hashSet, transactionController, "org.apache.derby.impl.jdbc.LOBStoredProcedure");
        stringArray = null;
        typeDescriptorArray = null;
        this.createSystemProcedureOrFunction("BLOBCREATELOCATOR", uUID, stringArray, typeDescriptorArray, 0, 0, (short)2, false, false, TypeDescriptor.INTEGER, hashSet, transactionController, "org.apache.derby.impl.jdbc.LOBStoredProcedure");
        stringArray = new String[]{"LOCATOR"};
        typeDescriptorArray = new TypeDescriptor[]{TypeDescriptor.INTEGER};
        this.createSystemProcedureOrFunction("BLOBRELEASELOCATOR", uUID, stringArray, typeDescriptorArray, 0, 0, (short)2, false, false, null, hashSet, transactionController, "org.apache.derby.impl.jdbc.LOBStoredProcedure");
        stringArray = new String[]{"LOCATOR", "SEARCHBYTES", "POS"};
        typeDescriptorArray = new TypeDescriptor[]{TypeDescriptor.INTEGER, DataTypeDescriptor.getCatalogType(-3), DataTypeDescriptor.getCatalogType(-5)};
        this.createSystemProcedureOrFunction("BLOBGETPOSITIONFROMBYTES", uUID, stringArray, typeDescriptorArray, 0, 0, (short)2, false, false, DataTypeDescriptor.getCatalogType(-5), hashSet, transactionController, "org.apache.derby.impl.jdbc.LOBStoredProcedure");
        stringArray = new String[]{"LOCATOR", "SEARCHLOCATOR", "POS"};
        typeDescriptorArray = new TypeDescriptor[]{TypeDescriptor.INTEGER, TypeDescriptor.INTEGER, DataTypeDescriptor.getCatalogType(-5)};
        this.createSystemProcedureOrFunction("BLOBGETPOSITIONFROMLOCATOR", uUID, stringArray, typeDescriptorArray, 0, 0, (short)2, false, false, DataTypeDescriptor.getCatalogType(-5), hashSet, transactionController, "org.apache.derby.impl.jdbc.LOBStoredProcedure");
        stringArray = new String[]{"LOCATOR"};
        typeDescriptorArray = new TypeDescriptor[]{TypeDescriptor.INTEGER};
        this.createSystemProcedureOrFunction("BLOBGETLENGTH", uUID, stringArray, typeDescriptorArray, 0, 0, (short)2, false, false, DataTypeDescriptor.getCatalogType(-5), hashSet, transactionController, "org.apache.derby.impl.jdbc.LOBStoredProcedure");
        stringArray = new String[]{"LOCATOR", "POS", "LEN"};
        typeDescriptorArray = new TypeDescriptor[]{TypeDescriptor.INTEGER, DataTypeDescriptor.getCatalogType(-5), TypeDescriptor.INTEGER};
        this.createSystemProcedureOrFunction("BLOBGETBYTES", uUID, stringArray, typeDescriptorArray, 0, 0, (short)2, false, false, DataTypeDescriptor.getCatalogType(-3, 32672), hashSet, transactionController, "org.apache.derby.impl.jdbc.LOBStoredProcedure");
        stringArray = new String[]{"LOCATOR", "POS", "LEN", "REPLACEBYTES"};
        typeDescriptorArray = new TypeDescriptor[]{TypeDescriptor.INTEGER, DataTypeDescriptor.getCatalogType(-5), TypeDescriptor.INTEGER, DataTypeDescriptor.getCatalogType(-3)};
        this.createSystemProcedureOrFunction("BLOBSETBYTES", uUID, stringArray, typeDescriptorArray, 0, 0, (short)2, false, false, null, hashSet, transactionController, "org.apache.derby.impl.jdbc.LOBStoredProcedure");
        stringArray = new String[]{"LOCATOR", "LEN"};
        typeDescriptorArray = new TypeDescriptor[]{TypeDescriptor.INTEGER, DataTypeDescriptor.getCatalogType(-5)};
        this.createSystemProcedureOrFunction("BLOBTRUNCATE", uUID, stringArray, typeDescriptorArray, 0, 0, (short)2, false, false, null, hashSet, transactionController, "org.apache.derby.impl.jdbc.LOBStoredProcedure");
    }

    void create_10_5_system_procedures(TransactionController transactionController, HashSet<String> hashSet) throws StandardException {
        UUID uUID = this.getSystemUtilSchemaDescriptor().getUUID();
        String[] stringArray = new String[]{"SCHEMANAME", "TABLENAME", "INDEXNAME"};
        TypeDescriptor[] typeDescriptorArray = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER};
        this.createSystemProcedureOrFunction("SYSCS_UPDATE_STATISTICS", uUID, stringArray, typeDescriptorArray, 0, 0, (short)0, false, false, null, hashSet, transactionController);
    }

    void create_10_6_system_procedures(TransactionController transactionController, HashSet<String> hashSet) throws StandardException {
        UUID uUID = this.getSystemUtilSchemaDescriptor().getUUID();
        String[] stringArray = new String[]{"ENABLE"};
        TypeDescriptor[] typeDescriptorArray = new TypeDescriptor[]{TypeDescriptor.INTEGER};
        this.createSystemProcedureOrFunction("SYSCS_SET_XPLAIN_MODE", uUID, stringArray, typeDescriptorArray, 0, 0, (short)2, false, false, null, hashSet, transactionController);
        this.createSystemProcedureOrFunction("SYSCS_GET_XPLAIN_MODE", uUID, null, null, 0, 0, (short)1, false, false, TypeDescriptor.INTEGER, hashSet, transactionController);
        stringArray = new String[]{"SCHEMANAME"};
        typeDescriptorArray = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER};
        this.createSystemProcedureOrFunction("SYSCS_SET_XPLAIN_SCHEMA", uUID, stringArray, typeDescriptorArray, 0, 0, (short)0, false, false, null, hashSet, transactionController);
        this.createSystemProcedureOrFunction("SYSCS_GET_XPLAIN_SCHEMA", uUID, null, null, 0, 0, (short)1, false, false, CATALOG_TYPE_SYSTEM_IDENTIFIER, hashSet, transactionController);
    }

    void create_10_3_system_procedures(TransactionController transactionController, HashSet<String> hashSet) throws StandardException {
        this.create_10_3_system_procedures_SYSCS_UTIL(transactionController, hashSet);
        this.create_10_3_system_procedures_SYSIBM(transactionController, hashSet);
    }

    void create_10_3_system_procedures_SYSCS_UTIL(TransactionController transactionController, HashSet<String> hashSet) throws StandardException {
        UUID uUID = this.getSystemUtilSchemaDescriptor().getUUID();
        Object[] objectArray = new String[]{"schemaName", "tableName", "fileName", " columnDelimiter", "characterDelimiter", "codeset", "lobsFileName"};
        TypeDescriptor[] typeDescriptorArray = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, DataTypeDescriptor.getCatalogType(12, 32672), DataTypeDescriptor.getCatalogType(1, 1), DataTypeDescriptor.getCatalogType(1, 1), CATALOG_TYPE_SYSTEM_IDENTIFIER, DataTypeDescriptor.getCatalogType(12, 32672)};
        this.createSystemProcedureOrFunction("SYSCS_EXPORT_TABLE_LOBS_TO_EXTFILE", uUID, (String[])objectArray, typeDescriptorArray, 0, 0, (short)1, false, false, null, hashSet, transactionController);
        objectArray = new String[]{"selectStatement", "fileName", " columnDelimiter", "characterDelimiter", "codeset", "lobsFileName"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(12, 32672), DataTypeDescriptor.getCatalogType(12, 32672), DataTypeDescriptor.getCatalogType(1, 1), DataTypeDescriptor.getCatalogType(1, 1), CATALOG_TYPE_SYSTEM_IDENTIFIER, DataTypeDescriptor.getCatalogType(12, 32672)};
        this.createSystemProcedureOrFunction("SYSCS_EXPORT_QUERY_LOBS_TO_EXTFILE", uUID, (String[])objectArray, typeDescriptorArray, 0, 0, (short)1, false, false, null, hashSet, transactionController);
        objectArray = new String[]{"schemaName", "tableName", "fileName", " columnDelimiter", "characterDelimiter", "codeset", "replace"};
        typeDescriptorArray = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, DataTypeDescriptor.getCatalogType(12, 32672), DataTypeDescriptor.getCatalogType(1, 1), DataTypeDescriptor.getCatalogType(1, 1), CATALOG_TYPE_SYSTEM_IDENTIFIER, TypeDescriptor.SMALLINT};
        this.createSystemProcedureOrFunction("SYSCS_IMPORT_TABLE_LOBS_FROM_EXTFILE", uUID, (String[])objectArray, typeDescriptorArray, 0, 0, (short)0, false, false, null, hashSet, transactionController);
        objectArray = new String[]{"schemaName", "tableName", "insertColumnList", "columnIndexes", "fileName", " columnDelimiter", "characterDelimiter", "codeset", "replace"};
        typeDescriptorArray = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, DataTypeDescriptor.getCatalogType(12, 32672), DataTypeDescriptor.getCatalogType(12, 32672), DataTypeDescriptor.getCatalogType(12, 32672), DataTypeDescriptor.getCatalogType(1, 1), DataTypeDescriptor.getCatalogType(1, 1), CATALOG_TYPE_SYSTEM_IDENTIFIER, TypeDescriptor.SMALLINT};
        this.createSystemProcedureOrFunction("SYSCS_IMPORT_DATA_LOBS_FROM_EXTFILE", uUID, (String[])objectArray, typeDescriptorArray, 0, 0, (short)0, false, false, null, hashSet, transactionController);
        this.createSystemProcedureOrFunction("SYSCS_RELOAD_SECURITY_POLICY", uUID, null, null, 0, 0, (short)3, false, false, null, hashSet, transactionController);
        objectArray = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER};
        this.createSystemProcedureOrFunction("SYSCS_SET_USER_ACCESS", uUID, new String[]{"USERNAME", "CONNECTIONPERMISSION"}, (TypeDescriptor[])objectArray, 0, 0, (short)0, false, false, null, hashSet, transactionController);
        objectArray = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER};
        this.createSystemProcedureOrFunction("SYSCS_GET_USER_ACCESS", uUID, new String[]{"USERNAME"}, (TypeDescriptor[])objectArray, 0, 0, (short)1, false, false, CATALOG_TYPE_SYSTEM_IDENTIFIER, hashSet, transactionController);
        this.createSystemProcedureOrFunction("SYSCS_EMPTY_STATEMENT_CACHE", uUID, null, null, 0, 0, (short)3, false, false, null, hashSet, transactionController);
    }

    void create_10_9_system_procedures(TransactionController transactionController, HashSet<String> hashSet) throws StandardException {
        UUID uUID = this.getSystemUtilSchemaDescriptor().getUUID();
        String[] stringArray = new String[]{"userName", "password"};
        TypeDescriptor[] typeDescriptorArray = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, DataTypeDescriptor.getCatalogType(12, 32672)};
        this.createSystemProcedureOrFunction("SYSCS_CREATE_USER", uUID, stringArray, typeDescriptorArray, 0, 0, (short)0, false, false, null, hashSet, transactionController);
        stringArray = new String[]{"userName", "password"};
        typeDescriptorArray = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, DataTypeDescriptor.getCatalogType(12, 32672)};
        this.createSystemProcedureOrFunction("SYSCS_RESET_PASSWORD", uUID, stringArray, typeDescriptorArray, 0, 0, (short)0, false, false, null, hashSet, transactionController);
        stringArray = new String[]{"password"};
        typeDescriptorArray = new TypeDescriptor[]{DataTypeDescriptor.getCatalogType(12, 32672)};
        this.createSystemProcedureOrFunction("SYSCS_MODIFY_PASSWORD", uUID, stringArray, typeDescriptorArray, 0, 0, (short)0, false, false, null, hashSet, transactionController);
        stringArray = new String[]{"userName"};
        typeDescriptorArray = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER};
        this.createSystemProcedureOrFunction("SYSCS_DROP_USER", uUID, stringArray, typeDescriptorArray, 0, 0, (short)0, false, false, null, hashSet, transactionController);
        stringArray = new String[]{"schemaName", "sequenceName"};
        typeDescriptorArray = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER};
        this.createSystemProcedureOrFunction("SYSCS_PEEK_AT_SEQUENCE", uUID, stringArray, typeDescriptorArray, 0, 0, (short)1, false, false, DataTypeDescriptor.getCatalogType(-5), hashSet, transactionController);
        stringArray = new String[]{"SCHEMANAME", "TABLENAME", "INDEXNAME"};
        typeDescriptorArray = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER};
        this.createSystemProcedureOrFunction("SYSCS_DROP_STATISTICS", uUID, stringArray, typeDescriptorArray, 0, 0, (short)0, false, false, null, hashSet, transactionController);
    }

    void create_10_10_system_procedures(TransactionController transactionController, HashSet<String> hashSet) throws StandardException {
        UUID uUID = this.getSystemUtilSchemaDescriptor().getUUID();
        TypeDescriptor typeDescriptor = DataTypeDescriptor.getCatalogType(12, 32672);
        this.createSystemProcedureOrFunction("SYSCS_INVALIDATE_STORED_STATEMENTS", uUID, null, null, 0, 0, (short)3, false, false, null, hashSet, transactionController);
        String[] stringArray = new String[]{"toolName", "register", "optionalArgs"};
        TypeDescriptor[] typeDescriptorArray = new TypeDescriptor[]{typeDescriptor, DataTypeDescriptor.getCatalogType(16), typeDescriptor};
        this.createSystemProcedureOrFunction("SYSCS_REGISTER_TOOL", uUID, stringArray, typeDescriptorArray, 0, 0, (short)0, false, true, null, hashSet, transactionController, "org.apache.derby.catalog.Java5SystemProcedures");
    }

    void create_10_11_system_procedures(TransactionController transactionController, HashSet<String> hashSet) throws StandardException {
        UUID uUID = this.getSystemUtilSchemaDescriptor().getUUID();
        String[] stringArray = new String[]{"schemaName", "tableName"};
        TypeDescriptor[] typeDescriptorArray = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER};
        this.createSystemProcedureOrFunction("SYSCS_PEEK_AT_IDENTITY", uUID, stringArray, typeDescriptorArray, 0, 0, (short)1, false, false, DataTypeDescriptor.getCatalogType(-5), hashSet, transactionController);
    }

    void create_10_12_system_procedures(TransactionController transactionController, HashSet<String> hashSet) throws StandardException {
        UUID uUID = this.getSystemUtilSchemaDescriptor().getUUID();
        this.createSystemProcedureOrFunction("SYSCS_GET_DATABASE_NAME", uUID, null, null, 0, 0, (short)1, false, false, DataTypeDescriptor.getCatalogType(12), hashSet, transactionController);
    }

    void create_10_13_system_procedures(TransactionController transactionController, HashSet<String> hashSet) throws StandardException {
        UUID uUID = this.getSystemUtilSchemaDescriptor().getUUID();
        TypeDescriptor typeDescriptor = DataTypeDescriptor.getCatalogType(12, 32672);
        String[] stringArray = new String[]{"schemaName", "tableName", "fileName", " columnDelimiter", "characterDelimiter", "codeset", "replace", "skip"};
        TypeDescriptor[] typeDescriptorArray = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, typeDescriptor, DataTypeDescriptor.getCatalogType(1, 1), DataTypeDescriptor.getCatalogType(1, 1), CATALOG_TYPE_SYSTEM_IDENTIFIER, TypeDescriptor.SMALLINT, TypeDescriptor.SMALLINT};
        this.createSystemProcedureOrFunction("SYSCS_IMPORT_TABLE_BULK", uUID, stringArray, typeDescriptorArray, 0, 0, (short)0, false, false, null, hashSet, transactionController);
        stringArray = new String[]{"schemaName", "tableName", "insertColumnList", "columnIndexes", "fileName", " columnDelimiter", "characterDelimiter", "codeset", "replace", "skip"};
        typeDescriptorArray = new TypeDescriptor[]{CATALOG_TYPE_SYSTEM_IDENTIFIER, CATALOG_TYPE_SYSTEM_IDENTIFIER, typeDescriptor, typeDescriptor, typeDescriptor, DataTypeDescriptor.getCatalogType(1, 1), DataTypeDescriptor.getCatalogType(1, 1), CATALOG_TYPE_SYSTEM_IDENTIFIER, TypeDescriptor.SMALLINT, TypeDescriptor.SMALLINT};
        this.createSystemProcedureOrFunction("SYSCS_IMPORT_DATA_BULK", uUID, stringArray, typeDescriptorArray, 0, 0, (short)0, false, false, null, hashSet, transactionController);
    }

    private final synchronized Properties getQueryDescriptions(boolean bl2) {
        this.spsSet = bl2 ? "metadata_net.properties" : "/org/apache/derby/impl/jdbc/metadata.properties";
        return AccessController.doPrivileged(this);
    }

    @Override
    public final Properties run() {
        Properties properties = new Properties();
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(this.spsSet);
            properties.load(inputStream);
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return properties;
    }

    private static <T> List<T> newSList() {
        return Collections.synchronizedList(new LinkedList());
    }

    @Override
    public TablePermsDescriptor getTablePermissions(UUID uUID, String string) throws StandardException {
        TablePermsDescriptor tablePermsDescriptor = new TablePermsDescriptor(this, string, null, uUID);
        return (TablePermsDescriptor)this.getPermissions(tablePermsDescriptor);
    }

    @Override
    public TablePermsDescriptor getTablePermissions(UUID uUID) throws StandardException {
        TablePermsDescriptor tablePermsDescriptor = new TablePermsDescriptor(this, uUID);
        return this.getUncachedTablePermsDescriptor(tablePermsDescriptor);
    }

    private Object getPermissions(PermissionsDescriptor permissionsDescriptor) throws StandardException {
        Cacheable cacheable = this.getPermissionsCache().find(permissionsDescriptor);
        if (cacheable == null) {
            return null;
        }
        Object object = cacheable.getIdentity();
        this.getPermissionsCache().release(cacheable);
        return object;
    }

    @Override
    public ColPermsDescriptor getColumnPermissions(UUID uUID) throws StandardException {
        ColPermsDescriptor colPermsDescriptor = new ColPermsDescriptor(this, uUID);
        return this.getUncachedColPermsDescriptor(colPermsDescriptor);
    }

    @Override
    public ColPermsDescriptor getColumnPermissions(UUID uUID, int n2, boolean bl2, String string) throws StandardException {
        String string2 = bl2 ? colPrivTypeMapForGrant[n2] : colPrivTypeMap[n2];
        ColPermsDescriptor colPermsDescriptor = new ColPermsDescriptor(this, string, null, uUID, string2);
        return (ColPermsDescriptor)this.getPermissions(colPermsDescriptor);
    }

    @Override
    public ColPermsDescriptor getColumnPermissions(UUID uUID, String string, boolean bl2, String string2) throws StandardException {
        ColPermsDescriptor colPermsDescriptor = new ColPermsDescriptor(this, string2, null, uUID, string);
        return (ColPermsDescriptor)this.getPermissions(colPermsDescriptor);
    }

    @Override
    public RoutinePermsDescriptor getRoutinePermissions(UUID uUID, String string) throws StandardException {
        RoutinePermsDescriptor routinePermsDescriptor = new RoutinePermsDescriptor(this, string, null, uUID);
        return (RoutinePermsDescriptor)this.getPermissions(routinePermsDescriptor);
    }

    @Override
    public RoutinePermsDescriptor getRoutinePermissions(UUID uUID) throws StandardException {
        RoutinePermsDescriptor routinePermsDescriptor = new RoutinePermsDescriptor(this, uUID);
        return this.getUncachedRoutinePermsDescriptor(routinePermsDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addRemovePermissionsDescriptor(boolean bl2, PermissionsDescriptor permissionsDescriptor, String string, TransactionController transactionController) throws StandardException {
        int n2 = permissionsDescriptor.getCatalogNumber();
        permissionsDescriptor.setUUID(null);
        permissionsDescriptor.setGrantee(string);
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(n2);
        PermissionsCatalogRowFactory permissionsCatalogRowFactory = (PermissionsCatalogRowFactory)tabInfoImpl.getCatalogRowFactory();
        int n3 = permissionsCatalogRowFactory.getPrimaryKeyIndexNumber();
        ConglomerateController conglomerateController = transactionController.openConglomerate(tabInfoImpl.getHeapConglomerate(), false, 0, 6, 4);
        RowLocation rowLocation = null;
        try {
            rowLocation = conglomerateController.newRowLocationTemplate();
        }
        finally {
            conglomerateController.close();
            conglomerateController = null;
        }
        ExecIndexRow execIndexRow = permissionsCatalogRowFactory.buildIndexKeyRow(n3, permissionsDescriptor);
        ExecRow execRow = tabInfoImpl.getRow(transactionController, execIndexRow, n3);
        if (execRow == null) {
            if (!bl2) {
                return false;
            }
            ExecRow execRow2 = tabInfoImpl.getCatalogRowFactory().makeRow(permissionsDescriptor, null);
            int n4 = tabInfoImpl.insertRow(execRow2, transactionController);
        } else {
            boolean[] blArray = new boolean[execRow.nColumns()];
            boolean[] blArray2 = new boolean[permissionsCatalogRowFactory.getNumIndexes()];
            int n5 = 0;
            n5 = bl2 ? permissionsCatalogRowFactory.orPermissions(execRow, permissionsDescriptor, blArray) : permissionsCatalogRowFactory.removePermissions(execRow, permissionsDescriptor, blArray);
            if (n5 == 0) {
                return false;
            }
            if (!bl2) {
                permissionsCatalogRowFactory.setUUIDOfThePassedDescriptor(execRow, permissionsDescriptor);
            }
            if (n5 < 0) {
                tabInfoImpl.deleteRow(transactionController, execIndexRow, n3);
            } else if (n5 > 0) {
                int[] nArray = new int[n5];
                n5 = 0;
                for (int i2 = 0; i2 < blArray.length; ++i2) {
                    if (!blArray[i2]) continue;
                    nArray[n5++] = i2 + 1;
                }
                tabInfoImpl.updateRow(execIndexRow, execRow, n3, blArray2, nArray, transactionController);
            }
        }
        this.removePermEntryInCache(permissionsDescriptor);
        return !bl2;
    }

    TablePermsDescriptor getUncachedTablePermsDescriptor(TablePermsDescriptor tablePermsDescriptor) throws StandardException {
        if (tablePermsDescriptor.getObjectID() == null) {
            return this.getUncachedPermissionsDescriptor(16, 0, tablePermsDescriptor, TablePermsDescriptor.class);
        }
        return this.getUncachedPermissionsDescriptor(16, 1, tablePermsDescriptor, TablePermsDescriptor.class);
    }

    ColPermsDescriptor getUncachedColPermsDescriptor(ColPermsDescriptor colPermsDescriptor) throws StandardException {
        if (colPermsDescriptor.getObjectID() == null) {
            return this.getUncachedPermissionsDescriptor(17, 0, colPermsDescriptor, ColPermsDescriptor.class);
        }
        return this.getUncachedPermissionsDescriptor(17, 1, colPermsDescriptor, ColPermsDescriptor.class);
    }

    private <T extends PermissionsDescriptor> T getUncachedPermissionsDescriptor(int n2, int n3, T t2, Class<T> clazz) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(n2);
        PermissionsCatalogRowFactory permissionsCatalogRowFactory = (PermissionsCatalogRowFactory)tabInfoImpl.getCatalogRowFactory();
        ExecIndexRow execIndexRow = permissionsCatalogRowFactory.buildIndexKeyRow(n3, t2);
        return (T)((PermissionsDescriptor)this.getDescriptorViaIndex(n3, execIndexRow, null, tabInfoImpl, null, null, clazz, false));
    }

    RoutinePermsDescriptor getUncachedRoutinePermsDescriptor(RoutinePermsDescriptor routinePermsDescriptor) throws StandardException {
        if (routinePermsDescriptor.getObjectID() == null) {
            return this.getUncachedPermissionsDescriptor(18, 0, routinePermsDescriptor, RoutinePermsDescriptor.class);
        }
        return this.getUncachedPermissionsDescriptor(18, 1, routinePermsDescriptor, RoutinePermsDescriptor.class);
    }

    @Override
    public String getVTIClass(TableDescriptor tableDescriptor, boolean bl2) throws StandardException {
        if ("SYSCS_DIAG".equals(tableDescriptor.getSchemaName())) {
            return this.getBuiltinVTIClass(tableDescriptor, bl2);
        }
        String string = tableDescriptor.getSchemaName();
        String string2 = tableDescriptor.getDescriptorName();
        SchemaDescriptor schemaDescriptor = this.getSchemaDescriptor(tableDescriptor.getSchemaName(), null, true);
        if (schemaDescriptor != null) {
            AliasDescriptor aliasDescriptor = this.getAliasDescriptor(schemaDescriptor.getUUID().toString(), string2, 'F');
            if (aliasDescriptor != null && aliasDescriptor.isTableFunction()) {
                return aliasDescriptor.getJavaClassName();
            }
            throw StandardException.newException("42ZB4", string, string2);
        }
        return null;
    }

    @Override
    public String getBuiltinVTIClass(TableDescriptor tableDescriptor, boolean bl2) throws StandardException {
        if ("SYSCS_DIAG".equals(tableDescriptor.getSchemaName())) {
            String[][] stringArray = bl2 ? this.DIAG_VTI_TABLE_FUNCTION_CLASSES : this.DIAG_VTI_TABLE_CLASSES;
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String[] stringArray2 = stringArray[i2];
                if (!stringArray2[0].equals(tableDescriptor.getDescriptorName())) continue;
                return stringArray2[1];
            }
        }
        return null;
    }

    @Override
    public RoleGrantDescriptor getRoleGrantDescriptor(UUID uUID) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(19);
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(uUID);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        return this.getDescriptorViaIndex(2, execIndexRow, null, tabInfoImpl, null, null, RoleGrantDescriptor.class, false);
    }

    @Override
    public RoleGrantDescriptor getRoleDefinitionDescriptor(String string) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(19);
        SQLVarchar sQLVarchar = new SQLVarchar(string);
        SQLVarchar sQLVarchar2 = new SQLVarchar("Y");
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(2);
        execIndexRow.setColumn(1, sQLVarchar);
        execIndexRow.setColumn(2, sQLVarchar2);
        return this.getDescriptorViaIndex(1, execIndexRow, null, tabInfoImpl, null, null, RoleGrantDescriptor.class, false);
    }

    @Override
    public RoleGrantDescriptor getRoleGrantDescriptor(String string, String string2, String string3) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(19);
        SQLVarchar sQLVarchar = new SQLVarchar(string);
        SQLVarchar sQLVarchar2 = new SQLVarchar(string2);
        SQLVarchar sQLVarchar3 = new SQLVarchar(string3);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(3);
        execIndexRow.setColumn(1, sQLVarchar);
        execIndexRow.setColumn(2, sQLVarchar2);
        execIndexRow.setColumn(3, sQLVarchar3);
        return this.getDescriptorViaIndex(0, execIndexRow, null, tabInfoImpl, null, null, RoleGrantDescriptor.class, false);
    }

    @Override
    public boolean existsGrantToAuthid(String string, TransactionController transactionController) throws StandardException {
        return this.existsPermByGrantee(string, transactionController, 16, 0, 1) || this.existsPermByGrantee(string, transactionController, 17, 0, 1) || this.existsPermByGrantee(string, transactionController, 18, 0, 1) || this.existsRoleGrantByGrantee(string, transactionController);
    }

    private void dropJDBCMetadataSPSes(TransactionController transactionController) throws StandardException {
        for (SPSDescriptor sPSDescriptor : this.getAllSPSDescriptors()) {
            SchemaDescriptor schemaDescriptor = sPSDescriptor.getSchemaDescriptor();
            if (!schemaDescriptor.isSystemSchema()) continue;
            this.dropSPSDescriptor(sPSDescriptor, transactionController);
            this.dropDependentsStoredDependencies(sPSDescriptor.getUUID(), transactionController);
        }
    }

    @Override
    public void updateMetadataSPSes(TransactionController transactionController) throws StandardException {
        this.dropJDBCMetadataSPSes(transactionController);
        this.createSystemSps(transactionController);
    }

    @Override
    public void dropSequenceDescriptor(SequenceDescriptor sequenceDescriptor, TransactionController transactionController) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(20);
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(sequenceDescriptor.getUUID());
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        tabInfoImpl.deleteRow(transactionController, execIndexRow, 0);
        this.dropSequenceID(sequenceDescriptor);
    }

    @Override
    public SequenceDescriptor getSequenceDescriptor(UUID uUID) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(20);
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(uUID);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        SequenceDescriptor sequenceDescriptor = this.getDescriptorViaIndex(0, execIndexRow, null, tabInfoImpl, null, null, SequenceDescriptor.class, false);
        this.putSequenceID(sequenceDescriptor);
        return sequenceDescriptor;
    }

    @Override
    public SequenceDescriptor getSequenceDescriptor(SchemaDescriptor schemaDescriptor, String string) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(20);
        SQLVarchar sQLVarchar = new SQLVarchar(string);
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(schemaDescriptor.getUUID());
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(2);
        execIndexRow.setColumn(1, sQLChar);
        execIndexRow.setColumn(2, sQLVarchar);
        SequenceDescriptor sequenceDescriptor = this.getDescriptorViaIndex(1, execIndexRow, null, tabInfoImpl, null, null, SequenceDescriptor.class, false);
        this.putSequenceID(sequenceDescriptor);
        return sequenceDescriptor;
    }

    private void putSequenceID(SequenceDescriptor sequenceDescriptor) throws StandardException {
        if (sequenceDescriptor == null) {
            return;
        }
        SchemaDescriptor schemaDescriptor = sequenceDescriptor.getSchemaDescriptor();
        String string = schemaDescriptor.getSchemaName();
        String string2 = sequenceDescriptor.getSequenceName();
        String string3 = sequenceDescriptor.getUUID().toString();
        HashMap<String, String> hashMap = this.sequenceIDs.get(string);
        if (hashMap == null) {
            hashMap = new HashMap();
            this.sequenceIDs.put(string, hashMap);
        }
        if (hashMap.get(string2) == null) {
            hashMap.put(string2, string3);
        }
    }

    private void dropSequenceID(SequenceDescriptor sequenceDescriptor) throws StandardException {
        if (sequenceDescriptor == null) {
            return;
        }
        SchemaDescriptor schemaDescriptor = sequenceDescriptor.getSchemaDescriptor();
        String string = schemaDescriptor.getSchemaName();
        String string2 = sequenceDescriptor.getSequenceName();
        HashMap<String, String> hashMap = this.sequenceIDs.get(string);
        if (hashMap == null) {
            return;
        }
        if (hashMap.get(string2) == null) {
            return;
        }
        hashMap.remove(string2);
    }

    private String getSequenceID(String string, String string2) throws StandardException {
        Object object;
        HashMap<String, String> hashMap = this.sequenceIDs.get(string);
        if (hashMap != null && (object = hashMap.get(string2)) != null) {
            return object;
        }
        object = this.getSequenceDescriptor(this.getSchemaDescriptor(string, this.getTransactionCompile(), true), string2);
        if (object == null) {
            return null;
        }
        return ((SequenceDescriptor)object).getUUID().toString();
    }

    PermDescriptor getUncachedGenericPermDescriptor(PermDescriptor permDescriptor) throws StandardException {
        if (permDescriptor.getObjectID() == null) {
            return this.getUncachedPermissionsDescriptor(21, 2, permDescriptor, PermDescriptor.class);
        }
        return this.getUncachedPermissionsDescriptor(21, 0, permDescriptor, PermDescriptor.class);
    }

    @Override
    public PermDescriptor getGenericPermissions(UUID uUID, String string, String string2, String string3) throws StandardException {
        PermDescriptor permDescriptor = new PermDescriptor(this, null, string, uUID, string2, null, string3, false);
        return (PermDescriptor)this.getPermissions(permDescriptor);
    }

    @Override
    public PermDescriptor getGenericPermissions(UUID uUID) throws StandardException {
        PermDescriptor permDescriptor = new PermDescriptor(this, uUID);
        return this.getUncachedGenericPermDescriptor(permDescriptor);
    }

    @Override
    public void dropAllPermDescriptors(UUID uUID, TransactionController transactionController) throws StandardException {
        TabInfoImpl tabInfoImpl = this.getNonCoreTI(21);
        SYSPERMSRowFactory sYSPERMSRowFactory = (SYSPERMSRowFactory)tabInfoImpl.getCatalogRowFactory();
        if (!this.usesSqlAuthorization) {
            return;
        }
        SQLChar sQLChar = DataDictionaryImpl.getIDValueAsCHAR(uUID);
        ExecIndexRow execIndexRow = this.exFactory.getIndexableRow(1);
        execIndexRow.setColumn(1, sQLChar);
        while (true) {
            ExecRow execRow = tabInfoImpl.getRow(transactionController, execIndexRow, 1);
            if (execRow == null) break;
            PermissionsDescriptor permissionsDescriptor = (PermissionsDescriptor)sYSPERMSRowFactory.buildDescriptor(execRow, null, this);
            this.removePermEntryInCache(permissionsDescriptor);
            ExecIndexRow execIndexRow2 = sYSPERMSRowFactory.buildIndexKeyRow(0, permissionsDescriptor);
            tabInfoImpl.deleteRow(transactionController, execIndexRow2, 0);
        }
    }

    @Override
    public IndexStatisticsDaemon getIndexStatsRefresher(boolean bl2) {
        if (this.indexStatsUpdateDisabled && bl2) {
            return null;
        }
        return this.indexRefresher;
    }

    @Override
    public void disableIndexStatsRefresher() {
        if (!this.indexStatsUpdateDisabled) {
            this.indexStatsUpdateDisabled = true;
            this.indexRefresher.stop();
        }
    }

    @Override
    public boolean doCreateIndexStatsRefresher() {
        return this.indexRefresher == null;
    }

    @Override
    public void createIndexStatsRefresher(Database database, String string) {
        if (this.af.isReadOnly()) {
            this.indexStatsUpdateDisabled = true;
            return;
        }
        this.indexRefresher = new IndexStatisticsDaemonImpl(Monitor.getStream(), this.indexStatsUpdateLogging, this.indexStatsUpdateTracing, database, this.authorizationDatabaseOwner, string);
    }

    @Override
    public DependableFinder getDependableFinder(int n2) {
        return new DDdependableFinder(n2);
    }

    @Override
    public DependableFinder getColumnDependableFinder(int n2, byte[] byArray) {
        return new DDColumnDependableFinder(n2, byArray);
    }

    void createIdentitySequences(TransactionController transactionController) throws StandardException {
        Hashtable<UUID, TableDescriptor> hashtable = this.hashAllTableDescriptorsByTableId(transactionController);
        for (UUID uUID : hashtable.keySet()) {
            TableDescriptor tableDescriptor = this.getTableDescriptor(uUID);
            ColumnDescriptorList columnDescriptorList = tableDescriptor.getColumnDescriptorList();
            for (ColumnDescriptor columnDescriptor : columnDescriptorList) {
                if (!columnDescriptor.isAutoincrement()) continue;
                this.createIdentitySequence(tableDescriptor, columnDescriptor, transactionController);
            }
        }
    }

    private void createIdentitySequence(TableDescriptor tableDescriptor, ColumnDescriptor columnDescriptor, TransactionController transactionController) throws StandardException {
        DataTypeDescriptor dataTypeDescriptor = columnDescriptor.getType();
        long[] lArray = dataTypeDescriptor.getNumericBounds();
        long l2 = columnDescriptor.getAutoincValue();
        long l3 = columnDescriptor.getAutoincStart();
        long l4 = lArray[0];
        long l5 = lArray[1];
        long l6 = columnDescriptor.getAutoincInc();
        SchemaDescriptor schemaDescriptor = this.getSystemSchemaDescriptor();
        SequenceDescriptor sequenceDescriptor = this.getDataDescriptorGenerator().newSequenceDescriptor(schemaDescriptor, this.getUUIDFactory().createUUID(), TableDescriptor.makeSequenceName(tableDescriptor.getUUID()), dataTypeDescriptor, l2, l3, l4, l5, l6, false);
        this.addDescriptor(sequenceDescriptor, null, 20, false, transactionController);
    }

    private static ContextService getContextService() {
        if (System.getSecurityManager() == null) {
            return ContextService.getFactory();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ContextService>(){

            @Override
            public ContextService run() {
                return ContextService.getFactory();
            }
        });
    }

    private static Context getContextOrNull(final String string) {
        if (System.getSecurityManager() == null) {
            return ContextService.getContextOrNull(string);
        }
        return AccessController.doPrivileged(new PrivilegedAction<Context>(){

            @Override
            public Context run() {
                return ContextService.getContextOrNull(string);
            }
        });
    }

    private static Context getContext(final String string) {
        return AccessController.doPrivileged(new PrivilegedAction<Context>(){

            @Override
            public Context run() {
                return ContextService.getContext(string);
            }
        });
    }

    static ModuleFactory getMonitor() {
        return AccessController.doPrivileged(new PrivilegedAction<ModuleFactory>(){

            @Override
            public ModuleFactory run() {
                return Monitor.getMonitor();
            }
        });
    }

    private static Object startSystemModule(final String string) throws StandardException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws StandardException {
                    return Monitor.startSystemModule(string);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw StandardException.plainWrapException(privilegedActionException);
        }
    }

    private static Object bootServiceModule(final boolean bl2, final Object object, final String string, final Properties properties) throws StandardException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws StandardException {
                    return Monitor.bootServiceModule(bl2, object, string, properties);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw StandardException.plainWrapException(privilegedActionException);
        }
    }

    private static Object findServiceModule(final Object object, final String string) throws StandardException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws StandardException {
                    return Monitor.findServiceModule(object, string);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw StandardException.plainWrapException(privilegedActionException);
        }
    }

    static {
        DataDictionaryImpl.colPrivTypeMap[8] = "s";
        DataDictionaryImpl.colPrivTypeMapForGrant[8] = "S";
        DataDictionaryImpl.colPrivTypeMap[0] = "s";
        DataDictionaryImpl.colPrivTypeMapForGrant[0] = "S";
        DataDictionaryImpl.colPrivTypeMap[1] = "u";
        DataDictionaryImpl.colPrivTypeMapForGrant[1] = "U";
        DataDictionaryImpl.colPrivTypeMap[2] = "r";
        DataDictionaryImpl.colPrivTypeMapForGrant[2] = "R";
    }
}

