/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.types.RoutineAliasInfo;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.io.FormatableHashtable;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;

public final class GenericColumnDescriptor
implements Formatable,
ResultColumnDescriptor {
    private String name;
    private String schemaName;
    private String tableName;
    private int columnPos;
    private DataTypeDescriptor type;
    private boolean isAutoincrement;
    private boolean updatableByCursor;
    private boolean hasGenerationClause;

    public GenericColumnDescriptor() {
    }

    public GenericColumnDescriptor(String string, DataTypeDescriptor dataTypeDescriptor) {
        this.name = string;
        this.type = dataTypeDescriptor;
    }

    public GenericColumnDescriptor(ResultColumnDescriptor resultColumnDescriptor) {
        this.name = resultColumnDescriptor.getName();
        this.tableName = resultColumnDescriptor.getSourceTableName();
        this.schemaName = resultColumnDescriptor.getSourceSchemaName();
        this.columnPos = resultColumnDescriptor.getColumnPosition();
        this.type = resultColumnDescriptor.getType();
        this.isAutoincrement = resultColumnDescriptor.isAutoincrement();
        this.updatableByCursor = resultColumnDescriptor.updatableByCursor();
        this.hasGenerationClause = resultColumnDescriptor.hasGenerationClause();
    }

    @Override
    public DataTypeDescriptor getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getSourceSchemaName() {
        return this.schemaName;
    }

    @Override
    public String getSourceTableName() {
        return this.tableName;
    }

    @Override
    public int getColumnPosition() {
        return this.columnPos;
    }

    @Override
    public boolean isAutoincrement() {
        return this.isAutoincrement;
    }

    @Override
    public boolean updatableByCursor() {
        return this.updatableByCursor;
    }

    @Override
    public boolean hasGenerationClause() {
        return this.hasGenerationClause;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        FormatableHashtable formatableHashtable = new FormatableHashtable();
        formatableHashtable.put("name", this.name);
        formatableHashtable.put("tableName", this.tableName);
        formatableHashtable.put("schemaName", this.schemaName);
        formatableHashtable.putInt("columnPos", this.columnPos);
        formatableHashtable.put("type", this.type);
        formatableHashtable.putBoolean("isAutoincrement", this.isAutoincrement);
        formatableHashtable.putBoolean("updatableByCursor", this.updatableByCursor);
        objectOutput.writeObject(formatableHashtable);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        FormatableHashtable formatableHashtable = (FormatableHashtable)objectInput.readObject();
        this.name = (String)formatableHashtable.get("name");
        this.tableName = (String)formatableHashtable.get("tableName");
        this.schemaName = (String)formatableHashtable.get("schemaName");
        this.columnPos = formatableHashtable.getInt("columnPos");
        this.type = this.getStoredDataTypeDescriptor(formatableHashtable.get("type"));
        this.isAutoincrement = formatableHashtable.getBoolean("isAutoincrement");
        this.updatableByCursor = formatableHashtable.getBoolean("updatableByCursor");
    }

    @Override
    public int getTypeFormatId() {
        return 383;
    }

    public String toString() {
        return "";
    }

    private DataTypeDescriptor getStoredDataTypeDescriptor(Object object) {
        if (object instanceof DataTypeDescriptor) {
            return (DataTypeDescriptor)object;
        }
        return DataTypeDescriptor.getType(RoutineAliasInfo.getStoredType(object));
    }
}

