/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.reflect;

import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.Context;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.loader.ClassFactoryContext;
import org.apache.derby.iapi.services.loader.JarReader;
import org.apache.derby.iapi.services.locks.CompatibilitySpace;
import org.apache.derby.iapi.services.locks.LockFactory;
import org.apache.derby.iapi.services.locks.LockOwner;
import org.apache.derby.iapi.services.locks.ShExLockable;
import org.apache.derby.iapi.services.locks.ShExQual;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PersistentSet;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.services.stream.HeaderPrintWriter;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.impl.services.reflect.ClassLoaderLock;
import org.apache.derby.impl.services.reflect.DatabaseClasses;
import org.apache.derby.impl.services.reflect.JarLoader;

final class UpdateLoader
implements LockOwner {
    private static final String[] RESTRICTED_PACKAGES = new String[]{"javax.", "org.apache.derby."};
    private JarLoader[] jarList;
    private HeaderPrintWriter vs;
    private final ClassLoader myLoader;
    private boolean initDone;
    private String thisClasspath;
    private final LockFactory lf;
    private final ShExLockable classLoaderLock;
    private int version;
    private boolean normalizeToUpper;
    private DatabaseClasses parent;
    private final CompatibilitySpace compat;
    private boolean needReload;
    private JarReader jarReader;

    UpdateLoader(String string, DatabaseClasses databaseClasses, boolean bl2, boolean bl3) throws StandardException {
        this.normalizeToUpper = bl3;
        this.parent = databaseClasses;
        this.lf = (LockFactory)UpdateLoader.getServiceModule(databaseClasses, "org.apache.derby.iapi.services.locks.LockFactory");
        CompatibilitySpace compatibilitySpace = this.compat = this.lf != null ? this.lf.createCompatibilitySpace(this) : null;
        if (bl2) {
            this.vs = Monitor.getStream();
        }
        this.myLoader = this.getClass().getClassLoader();
        this.classLoaderLock = new ClassLoaderLock(this);
        this.initializeFromClassPath(string);
    }

    private void initializeFromClassPath(String string) throws StandardException {
        final String[][] stringArray = IdUtil.parseDbClassPath(string);
        final int n2 = stringArray.length;
        this.jarList = new JarLoader[n2];
        if (n2 != 0) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    for (int i2 = 0; i2 < n2; ++i2) {
                        ((UpdateLoader)UpdateLoader.this).jarList[i2] = new JarLoader(UpdateLoader.this, stringArray[i2], UpdateLoader.this.vs);
                    }
                    return null;
                }
            });
        }
        if (this.vs != null) {
            this.vs.println(MessageService.getTextMessage("C005", string));
        }
        this.thisClasspath = string;
        this.initDone = false;
    }

    /*
     * Exception decompiling
     */
    Class loadClass(String var1_1, boolean var2_2) throws ClassNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    InputStream getResourceAsStream(String string) {
        InputStream inputStream;
        InputStream inputStream2 = inputStream = this.myLoader == null ? ClassLoader.getSystemResourceAsStream(string) : this.myLoader.getResourceAsStream(string);
        if (inputStream != null) {
            return inputStream;
        }
        if (string.endsWith(".class")) {
            return null;
        }
        boolean bl2 = false;
        try {
            bl2 = this.lockClassLoader(ShExQual.SH);
            UpdateLoader updateLoader = this;
            synchronized (updateLoader) {
                if (this.needReload) {
                    this.reload();
                }
                if (!this.initDone) {
                    this.initLoaders();
                }
                for (int i2 = 0; i2 < this.jarList.length; ++i2) {
                    JarLoader jarLoader = this.jarList[i2];
                    inputStream = jarLoader.getStream(string);
                    if (inputStream == null) continue;
                    InputStream inputStream3 = inputStream;
                    return inputStream3;
                }
            }
            updateLoader = null;
            return updateLoader;
        }
        catch (StandardException standardException) {
            InputStream inputStream4 = null;
            return inputStream4;
        }
        finally {
            if (bl2) {
                this.lf.unlock(this.compat, this, this.classLoaderLock, ShExQual.SH);
            }
        }
    }

    synchronized void modifyClasspath(String string) throws StandardException {
        this.lockClassLoader(ShExQual.EX);
        ++this.version;
        this.modifyJar(false);
        this.initializeFromClassPath(string);
    }

    synchronized void modifyJar(boolean bl2) throws StandardException {
        this.lockClassLoader(ShExQual.EX);
        ++this.version;
        if (!this.initDone) {
            return;
        }
        this.close();
        if (bl2) {
            this.initializeFromClassPath(this.thisClasspath);
        }
    }

    private boolean lockClassLoader(ShExQual shExQual) throws StandardException {
        if (this.lf == null) {
            return false;
        }
        ClassFactoryContext classFactoryContext = (ClassFactoryContext)UpdateLoader.getContextOrNull("ClassFactoryContext");
        CompatibilitySpace compatibilitySpace = null;
        if (classFactoryContext != null) {
            compatibilitySpace = classFactoryContext.getLockSpace();
        }
        if (compatibilitySpace == null) {
            compatibilitySpace = this.compat;
        }
        LockOwner lockOwner = compatibilitySpace.getOwner();
        this.lf.lockObject(compatibilitySpace, lockOwner, this.classLoaderLock, shExQual, -2);
        return lockOwner == this;
    }

    Class checkLoaded(String string, boolean bl2) {
        for (int i2 = 0; i2 < this.jarList.length; ++i2) {
            Class clazz = this.jarList[i2].checkLoaded(string, bl2);
            if (clazz == null) continue;
            return clazz;
        }
        return null;
    }

    void close() {
        for (int i2 = 0; i2 < this.jarList.length; ++i2) {
            this.jarList[i2].setInvalid();
        }
    }

    private void initLoaders() {
        if (this.initDone) {
            return;
        }
        for (int i2 = 0; i2 < this.jarList.length; ++i2) {
            this.jarList[i2].initialize();
        }
        this.initDone = true;
    }

    int getClassLoaderVersion() {
        return this.version;
    }

    synchronized void needReload() {
        ++this.version;
        this.needReload = true;
    }

    private void reload() throws StandardException {
        this.thisClasspath = this.getClasspath();
        this.close();
        this.initializeFromClassPath(this.thisClasspath);
        this.needReload = false;
    }

    private String getClasspath() throws StandardException {
        ClassFactoryContext classFactoryContext = (ClassFactoryContext)UpdateLoader.getContextOrNull("ClassFactoryContext");
        PersistentSet persistentSet = classFactoryContext.getPersistentSet();
        String string = PropertyUtil.getServiceProperty(persistentSet, "derby.database.classpath");
        if (string == null) {
            string = "";
        }
        return string;
    }

    JarReader getJarReader() {
        if (this.jarReader == null) {
            ClassFactoryContext classFactoryContext = (ClassFactoryContext)UpdateLoader.getContextOrNull("ClassFactoryContext");
            this.jarReader = classFactoryContext.getJarReader();
        }
        return this.jarReader;
    }

    @Override
    public boolean noWait() {
        return false;
    }

    @Override
    public boolean isNestedOwner() {
        return false;
    }

    @Override
    public boolean nestsUnder(LockOwner lockOwner) {
        return false;
    }

    private static Context getContextOrNull(final String string) {
        return AccessController.doPrivileged(new PrivilegedAction<Context>(){

            @Override
            public Context run() {
                return ContextService.getContextOrNull(string);
            }
        });
    }

    private static Object getServiceModule(final Object object, final String string) {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return Monitor.getServiceModule(object, string);
            }
        });
    }
}

