/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.reflect;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.services.reflect.DatabaseClasses;
import org.apache.derby.impl.services.reflect.LoadedGeneratedClass;
import org.apache.derby.impl.services.reflect.ReflectGeneratedClass;
import org.apache.derby.impl.services.reflect.ReflectLoaderJava2;

public class ReflectClassesJava2
extends DatabaseClasses
implements PrivilegedAction<Object> {
    private HashMap<String, ReflectGeneratedClass> preCompiled;
    private int action = -1;

    @Override
    synchronized LoadedGeneratedClass loadGeneratedClassFromData(String string, ByteArray byteArray) {
        if (byteArray == null || byteArray.getArray() == null) {
            Object object;
            if (this.preCompiled == null) {
                this.preCompiled = new HashMap();
            } else {
                object = this.preCompiled.get(string);
                if (object != null) {
                    return object;
                }
            }
            try {
                object = Class.forName(string);
                ReflectGeneratedClass reflectGeneratedClass = new ReflectGeneratedClass(this, (Class)object);
                this.preCompiled.put(string, reflectGeneratedClass);
                return reflectGeneratedClass;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.toString());
            }
        }
        int n2 = string.lastIndexOf(".");
        String string2 = n2 < 0 ? "" : string.substring(0, n2 + 1);
        if (!"org.apache.derby.exe.".equals(string2)) {
            throw new IllegalArgumentException(string);
        }
        this.action = 1;
        return ((ReflectLoaderJava2)AccessController.doPrivileged(this)).loadGeneratedClass(string, byteArray);
    }

    @Override
    public final Object run() {
        try {
            switch (this.action) {
                case 1: {
                    ReflectLoaderJava2 reflectLoaderJava2 = new ReflectLoaderJava2(this.getClass().getClassLoader(), this);
                    return reflectLoaderJava2;
                }
                case 2: {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    return classLoader;
                }
            }
            Object var1_3 = null;
            return var1_3;
        }
        finally {
            this.action = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Class loadClassNotInDatabaseJar(String string) throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            ClassLoader classLoader;
            ReflectClassesJava2 reflectClassesJava2 = this;
            synchronized (reflectClassesJava2) {
                this.action = 2;
                classLoader = (ClassLoader)AccessController.doPrivileged(this);
            }
            clazz = classLoader != null ? classLoader.loadClass(string) : Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = Class.forName(string);
        }
        return clazz;
    }
}

