/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.monitor;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.FileUtil;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.monitor.PersistentService;
import org.apache.derby.io.StorageFactory;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.WritableStorageFactory;

final class StorageFactoryService
implements PersistentService {
    private static final String SERVICE_PROPERTIES_EOF_TOKEN = "#--- last line, don't put anything after this line ---";
    private String home;
    private String canonicalHome;
    private final String subSubProtocol;
    private final Class<?> storageFactoryClass;
    private StorageFactory rootStorageFactory;
    private char separatorChar;

    StorageFactoryService(String string, Class clazz) throws StandardException {
        this.subSubProtocol = string;
        this.storageFactoryClass = clazz;
        Object object = StorageFactoryService.getMonitor().getEnvironment();
        if (object instanceof File) {
            final File file = (File)object;
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws IOException, StandardException {
                        StorageFile storageFile;
                        boolean bl2;
                        StorageFactoryService.this.home = file.getPath();
                        StorageFactoryService.this.canonicalHome = file.getCanonicalPath();
                        StorageFactoryService.this.rootStorageFactory = StorageFactoryService.this.getStorageFactoryInstance(true, null, null, null);
                        if (StorageFactoryService.this.home != null && (bl2 = (storageFile = StorageFactoryService.this.rootStorageFactory.newStorageFile(null)).mkdirs())) {
                            storageFile.limitAccessToOwner();
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                this.home = null;
                this.canonicalHome = null;
            }
        }
        if (this.rootStorageFactory == null) {
            try {
                this.rootStorageFactory = this.getStorageFactoryInstance(true, null, null, null);
            }
            catch (IOException iOException) {
                throw Monitor.exceptionStartingModule(iOException);
            }
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                StorageFactoryService.this.separatorChar = StorageFactoryService.this.rootStorageFactory.getSeparator();
                return null;
            }
        });
    }

    @Override
    public boolean hasStorageFactory() {
        return true;
    }

    @Override
    public StorageFactory getStorageFactoryInstance(final boolean bl2, final String string, final String string2, final String string3) throws StandardException, IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<StorageFactory>(){

                @Override
                public StorageFactory run() throws InstantiationException, IllegalAccessException, IOException, NoSuchMethodException, InvocationTargetException {
                    return StorageFactoryService.this.privGetStorageFactoryInstance(bl2, string, string2, string3);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            throw StandardException.newException("XBM0W.S", exception, this.subSubProtocol, this.storageFactoryClass);
        }
    }

    private StorageFactory privGetStorageFactoryInstance(boolean bl2, String string, String string2, String string3) throws InstantiationException, IllegalAccessException, IOException, NoSuchMethodException, InvocationTargetException {
        StorageFactory storageFactory = (StorageFactory)this.storageFactoryClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        String string4 = string != null && this.subSubProtocol != null && string.startsWith(this.subSubProtocol + ":") ? string.substring(this.subSubProtocol.length() + 1) : string;
        storageFactory.init(bl2 ? this.home : null, string4, string2, string3);
        return storageFactory;
    }

    @Override
    public String getType() {
        return this.subSubProtocol;
    }

    @Override
    public Enumeration getBootTimeServices() {
        if (this.home == null) {
            return null;
        }
        return new DirectoryList();
    }

    @Override
    public Properties getServiceProperties(final String string, Properties properties) throws StandardException {
        final String string2 = this.recreateServiceRoot(string, properties);
        final Properties properties2 = new Properties(properties);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object run() throws IOException, StandardException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
                    if (string2 != null) {
                        File file = new File(string2, "service.properties");
                        try (FileInputStream fileInputStream = new FileInputStream(file);){
                            properties2.load(new BufferedInputStream(fileInputStream));
                        }
                    }
                    StorageFactory storageFactory = StorageFactoryService.this.privGetStorageFactoryInstance(true, string, null, null);
                    StorageFile storageFile = storageFactory.newStorageFile("service.properties");
                    StorageFactoryService.this.resolveServicePropertiesFiles(storageFactory, storageFile);
                    try (InputStream inputStream = storageFile.getInputStream();){
                        properties2.load(new BufferedInputStream(inputStream));
                    }
                    finally {
                        storageFactory.shutdown();
                    }
                    return null;
                }
            });
            return properties2;
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (privilegedActionException.getException() instanceof FileNotFoundException) {
                return null;
            }
            throw Monitor.exceptionStartingModule(privilegedActionException.getException());
        }
        catch (SecurityException securityException) {
            throw Monitor.exceptionStartingModule(securityException);
        }
    }

    @Override
    public void saveServiceProperties(final String string, StorageFactory storageFactory, final Properties properties, final boolean bl2) throws StandardException {
        if (!(storageFactory instanceof WritableStorageFactory)) {
            throw StandardException.newException("XBM0P.D", new Object[0]);
        }
        final WritableStorageFactory writableStorageFactory = (WritableStorageFactory)storageFactory;
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws StandardException {
                    StorageFile storageFile = bl2 ? writableStorageFactory.newStorageFile("service.properties".concat("old")) : null;
                    StorageFile storageFile2 = writableStorageFactory.newStorageFile("service.properties");
                    FileOperationHelper fileOperationHelper = new FileOperationHelper();
                    if (bl2) {
                        fileOperationHelper.renameTo(storageFile2, storageFile, true);
                    }
                    OutputStream outputStream = null;
                    try {
                        outputStream = storageFile2.getOutputStream();
                        properties.store(outputStream, string + MessageService.getTextMessage("M001", new Object[0]));
                        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "ISO-8859-1"));
                        bufferedWriter.write(StorageFactoryService.SERVICE_PROPERTIES_EOF_TOKEN);
                        bufferedWriter.newLine();
                        writableStorageFactory.sync(outputStream, false);
                        bufferedWriter.close();
                        outputStream.close();
                        outputStream = null;
                    }
                    catch (IOException iOException) {
                        if (storageFile != null) {
                            fileOperationHelper.renameTo(storageFile, storageFile2, false);
                        }
                        if (bl2) {
                            throw StandardException.newException("XBM0B.D", iOException, new Object[0]);
                        }
                        throw Monitor.exceptionStartingModule(iOException);
                    }
                    finally {
                        if (outputStream != null) {
                            try {
                                outputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    if (storageFile != null && !fileOperationHelper.delete(storageFile, false)) {
                        Monitor.getStream().printlnWithHeader(MessageService.getTextMessage("M004", StorageFactoryService.getMostAccuratePath(storageFile)));
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (StandardException)privilegedActionException.getException();
        }
    }

    @Override
    public void createDataWarningFile(StorageFactory storageFactory) throws StandardException {
        if (!(storageFactory instanceof WritableStorageFactory)) {
            throw StandardException.newException("XBM0P.D", new Object[0]);
        }
        final WritableStorageFactory writableStorageFactory = (WritableStorageFactory)storageFactory;
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws StandardException {
                    OutputStreamWriter outputStreamWriter = null;
                    try {
                        StorageFile storageFile = writableStorageFactory.newStorageFile("README_DO_NOT_TOUCH_FILES.txt");
                        outputStreamWriter = new OutputStreamWriter(storageFile.getOutputStream(), "UTF8");
                        outputStreamWriter.write(MessageService.getTextMessage("M005", new Object[0]));
                    }
                    catch (IOException iOException) {
                    }
                    finally {
                        if (outputStreamWriter != null) {
                            try {
                                outputStreamWriter.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (StandardException)privilegedActionException.getException();
        }
    }

    @Override
    public void saveServiceProperties(final String string, final Properties properties) throws StandardException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws StandardException {
                    File file = new File(string, "service.properties");
                    FileOutputStream fileOutputStream = null;
                    try {
                        fileOutputStream = new FileOutputStream(file);
                        FileUtil.limitAccessToOwner(file);
                        properties.store(fileOutputStream, string + MessageService.getTextMessage("M001", new Object[0]));
                        fileOutputStream.getFD().sync();
                        fileOutputStream.close();
                        fileOutputStream = null;
                    }
                    catch (IOException iOException) {
                        if (fileOutputStream != null) {
                            try {
                                fileOutputStream.close();
                            }
                            catch (IOException iOException2) {
                                // empty catch block
                            }
                            fileOutputStream = null;
                        }
                        throw Monitor.exceptionStartingModule(iOException);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (StandardException)privilegedActionException.getException();
        }
    }

    private void resolveServicePropertiesFiles(StorageFactory storageFactory, StorageFile storageFile) throws StandardException {
        StorageFile storageFile2 = storageFactory.newStorageFile("service.properties".concat("old"));
        FileOperationHelper fileOperationHelper = new FileOperationHelper();
        boolean bl2 = fileOperationHelper.exists(storageFile, true);
        boolean bl3 = fileOperationHelper.exists(storageFile2, true);
        if (bl2 && !bl3) {
            return;
        }
        if (bl3 && !bl2) {
            fileOperationHelper.renameTo(storageFile2, storageFile, true);
            Monitor.getStream().printlnWithHeader(MessageService.getTextMessage("M002", new Object[0]));
        } else if (bl3 && bl2) {
            String string;
            BufferedReader bufferedReader = null;
            String string2 = null;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(storageFile.getPath()), "ISO-8859-1"));
                while ((string = bufferedReader.readLine()) != null) {
                    if (string.trim().length() == 0) continue;
                    string2 = string;
                }
            }
            catch (IOException iOException) {
                throw StandardException.newException("XJ113.S", iOException, storageFile.getPath(), iOException.getMessage());
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {}
            }
            if (string2 != null && string2.startsWith(SERVICE_PROPERTIES_EOF_TOKEN)) {
                string = fileOperationHelper.delete(storageFile2, false) ? MessageService.getTextMessage("M003", new Object[0]) : MessageService.getTextMessage("M004", StorageFactoryService.getMostAccuratePath(storageFile2));
                Monitor.getStream().printlnWithHeader(string);
            } else {
                fileOperationHelper.delete(storageFile, false);
                fileOperationHelper.renameTo(storageFile2, storageFile, true);
                Monitor.getStream().printlnWithHeader(MessageService.getTextMessage("M002", new Object[0]));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String recreateServiceRoot(final String string, Properties properties) throws StandardException {
        if (properties == null) {
            return null;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        String string2 = properties.getProperty("createFrom");
        if (string2 != null) {
            bl2 = true;
            bl3 = false;
        } else {
            string2 = properties.getProperty("restoreFrom");
            if (string2 != null) {
                bl2 = true;
                bl3 = true;
            } else {
                string2 = properties.getProperty("rollForwardRecoveryFrom");
                if (string2 != null) {
                    try {
                        if (AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public Object run() throws IOException, StandardException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
                                StorageFactory storageFactory = StorageFactoryService.this.privGetStorageFactoryInstance(true, string, null, null);
                                try {
                                    StorageFile storageFile = storageFactory.newStorageFile(null);
                                    8 var3_3 = storageFile.exists() ? this : null;
                                    return var3_3;
                                }
                                finally {
                                    storageFactory.shutdown();
                                }
                            }
                        }) == null) {
                            bl2 = true;
                            bl3 = false;
                        }
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw Monitor.exceptionStartingModule((IOException)privilegedActionException.getException());
                    }
                }
            }
        }
        if (string2 == null) return string2;
        File file = new File(string2);
        if (!this.fileExists(file)) throw StandardException.newException("XBM0Y.D", file);
        File file2 = new File(string2, "service.properties");
        if (!this.fileExists(file2)) throw StandardException.newException("XBM0Q.D", file2);
        if (bl2) {
            this.createServiceRoot(string, bl3);
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object run() throws IOException, StandardException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
                    WritableStorageFactory writableStorageFactory = (WritableStorageFactory)StorageFactoryService.this.privGetStorageFactoryInstance(true, string, null, null);
                    try {
                        StorageFile storageFile = writableStorageFactory.newStorageFile("service.properties");
                        if (storageFile.exists() && !storageFile.delete()) {
                            throw StandardException.newException("XBM0R.D", storageFile);
                        }
                        Object var3_3 = null;
                        return var3_3;
                    }
                    finally {
                        writableStorageFactory.shutdown();
                    }
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw Monitor.exceptionStartingModule((IOException)privilegedActionException.getException());
        }
        properties.put("derby.__rt.inRestore", "True");
        if (!bl2) return string2;
        properties.put("derby.__rt.deleteRootOnError", "True");
        return string2;
    }

    @Override
    public String createServiceRoot(final String string, final boolean bl2) throws StandardException {
        Exception exception;
        block4: {
            if (!(this.rootStorageFactory instanceof WritableStorageFactory)) {
                throw StandardException.newException("XBM0P.D", new Object[0]);
            }
            exception = null;
            try {
                return this.getProtocolLeadIn() + (String)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws StandardException, IOException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
                        StorageFactory storageFactory = StorageFactoryService.this.privGetStorageFactoryInstance(true, string, null, null);
                        try {
                            StorageFile storageFile = storageFactory.newStorageFile(null);
                            if (storageFile.exists()) {
                                if (bl2) {
                                    if (!storageFile.deleteAll()) {
                                        throw StandardException.newException("XBM0I.D", StorageFactoryService.this.getDirectoryPath(string));
                                    }
                                } else {
                                    StorageFactoryService.this.vetService(storageFactory, string);
                                    throw StandardException.newException("XBM0J.D", StorageFactoryService.this.getDirectoryPath(string));
                                }
                            }
                            if (storageFile.mkdirs()) {
                                storageFile.limitAccessToOwner();
                                String string3 = storageFile.getCanonicalPath();
                                storageFactory.setCanonicalName(string3);
                                try {
                                    String string2 = storageFactory.getCanonicalName();
                                    return string2;
                                }
                                catch (IOException iOException) {
                                    storageFile.deleteAll();
                                    throw iOException;
                                }
                            }
                            throw StandardException.newException("XBM0H.D", storageFile);
                        }
                        finally {
                            storageFactory.shutdown();
                        }
                    }
                });
            }
            catch (SecurityException securityException) {
                exception = securityException;
            }
            catch (PrivilegedActionException privilegedActionException) {
                exception = privilegedActionException.getException();
                if (!(exception instanceof StandardException)) break block4;
                throw (StandardException)exception;
            }
        }
        throw StandardException.newException("XBM0H.D", exception, string);
    }

    private void vetService(StorageFactory storageFactory, String string) throws StandardException {
        StorageFile storageFile;
        StorageFile storageFile2 = storageFactory.newStorageFile("service.properties");
        if (!storageFile2.exists() && (storageFile = storageFactory.newStorageFile("seg0")).exists()) {
            throw StandardException.newException("XBM0A.D", string, "service.properties");
        }
    }

    private String getDirectoryPath(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.home != null) {
            stringBuffer.append(this.home);
            stringBuffer.append(this.separatorChar);
        }
        if (this.separatorChar != '/') {
            stringBuffer.append(string.replace('/', this.separatorChar));
        } else {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    @Override
    public boolean removeServiceRoot(final String string) {
        if (!(this.rootStorageFactory instanceof WritableStorageFactory)) {
            return false;
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object run() throws StandardException, IOException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
                    StorageFactory storageFactory = StorageFactoryService.this.privGetStorageFactoryInstance(true, string, null, null);
                    try {
                        StorageFile storageFile = storageFactory.newStorageFile(null);
                        11 var3_3 = storageFile.deleteAll() ? this : null;
                        return var3_3;
                    }
                    finally {
                        storageFactory.shutdown();
                    }
                }
            }) != null;
        }
        catch (PrivilegedActionException privilegedActionException) {
            return false;
        }
    }

    @Override
    public String getCanonicalServiceName(String string) throws StandardException {
        int n2 = string.indexOf(58);
        if (n2 < 2 && !this.getType().equals("directory")) {
            return null;
        }
        if (n2 > 1) {
            if (!string.startsWith(this.getType() + ":")) {
                return null;
            }
            string = string.substring(n2 + 1);
        }
        final String string2 = string;
        try {
            return this.getProtocolLeadIn() + AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws StandardException, IOException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
                    StorageFactory storageFactory = StorageFactoryService.this.privGetStorageFactoryInstance(true, string2, null, null);
                    try {
                        String string = storageFactory.getCanonicalName();
                        return string;
                    }
                    finally {
                        storageFactory.shutdown();
                    }
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw Monitor.exceptionStartingModule(privilegedActionException.getException());
        }
    }

    @Override
    public String getUserServiceName(String string) {
        if (this.home != null && string.length() > this.canonicalHome.length() + 1 && string.startsWith(this.canonicalHome) && (string = string.substring(this.canonicalHome.length())).charAt(0) == this.separatorChar) {
            string = string.substring(1);
        }
        return string.replace(this.separatorChar, '/');
    }

    @Override
    public boolean isSameService(String string, String string2) {
        return string.equals(string2);
    }

    private final boolean fileExists(final File file) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return file.exists();
            }
        });
    }

    public Class getStorageFactoryClass() {
        return this.storageFactoryClass;
    }

    private String getProtocolLeadIn() {
        if (this.getType().equals("directory")) {
            return "";
        }
        return this.getType() + ":";
    }

    private static ModuleFactory getMonitor() {
        return AccessController.doPrivileged(new PrivilegedAction<ModuleFactory>(){

            @Override
            public ModuleFactory run() {
                return Monitor.getMonitor();
            }
        });
    }

    private static String getMostAccuratePath(StorageFile storageFile) {
        String string = storageFile.getPath();
        try {
            string = storageFile.getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    private static class FileOperationHelper {
        private String operation;

        private FileOperationHelper() {
        }

        boolean exists(StorageFile storageFile, boolean bl2) throws StandardException {
            this.operation = "exists";
            boolean bl3 = false;
            try {
                bl3 = storageFile.exists();
            }
            catch (SecurityException securityException) {
                this.handleSecPrivException(storageFile, bl2, securityException);
            }
            return bl3;
        }

        boolean delete(StorageFile storageFile, boolean bl2) throws StandardException {
            this.operation = "delete";
            boolean bl3 = false;
            try {
                bl3 = storageFile.delete();
            }
            catch (SecurityException securityException) {
                this.handleSecPrivException(storageFile, bl2, securityException);
            }
            if (bl2 && !bl3) {
                throw StandardException.newException("XBM0R.D", storageFile.getPath());
            }
            return bl3;
        }

        boolean renameTo(StorageFile storageFile, StorageFile storageFile2, boolean bl2) throws StandardException {
            this.operation = "renameTo";
            this.delete(storageFile2, false);
            boolean bl3 = false;
            try {
                bl3 = storageFile.renameTo(storageFile2);
            }
            catch (SecurityException securityException) {
                StorageFile storageFile3 = storageFile2;
                try {
                    System.getSecurityManager().checkWrite(storageFile.getPath());
                }
                catch (SecurityException securityException2) {
                    storageFile3 = storageFile;
                }
                this.handleSecPrivException(storageFile3, bl2, securityException);
            }
            if (bl2 && !bl3) {
                throw StandardException.newException("XBM0S.D", storageFile.getPath(), storageFile2.getPath());
            }
            return bl3;
        }

        private void handleSecPrivException(StorageFile storageFile, boolean bl2, SecurityException securityException) throws StandardException {
            if (bl2) {
                throw StandardException.newException("XBM0C.D", securityException, this.operation, storageFile.getName(), securityException.getMessage());
            }
            Monitor.getStream().printlnWithHeader(MessageService.getTextMessage("XBM0C.D", this.operation, StorageFactoryService.getMostAccuratePath(storageFile), securityException.getMessage()));
        }
    }

    final class DirectoryList
    implements PrivilegedAction<DirectoryList>,
    Enumeration {
        private String[] contents;
        private StorageFile systemDirectory;
        private int index;
        private boolean validIndex;
        private int actionCode = 0;
        private static final int INIT_ACTION = 0;
        private static final int HAS_MORE_ELEMENTS_ACTION = 1;

        DirectoryList() {
            AccessController.doPrivileged(this);
        }

        @Override
        public boolean hasMoreElements() {
            if (this.contents == null) {
                return false;
            }
            if (this.validIndex) {
                return true;
            }
            this.actionCode = 1;
            return AccessController.doPrivileged(this) != null;
        }

        public Object nextElement() throws NoSuchElementException {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            this.validIndex = false;
            return this.contents[this.index++];
        }

        @Override
        public final DirectoryList run() {
            switch (this.actionCode) {
                case 0: {
                    this.systemDirectory = StorageFactoryService.this.rootStorageFactory.newStorageFile(null);
                    this.contents = this.systemDirectory.list();
                    return null;
                }
                case 1: {
                    while (this.index < this.contents.length) {
                        try {
                            StorageFile storageFile;
                            String string = this.contents[this.index];
                            StorageFile storageFile2 = StorageFactoryService.this.rootStorageFactory.newStorageFile(string);
                            if (storageFile2.isDirectory() && (storageFile = StorageFactoryService.this.rootStorageFactory.newStorageFile(storageFile2, "service.properties")).exists()) {
                                this.contents[this.index] = storageFile2.getCanonicalPath();
                                this.validIndex = true;
                                return this;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.contents[this.index++] = null;
                    }
                    return null;
                }
            }
            return null;
        }
    }
}

