/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.locks;

import java.util.Hashtable;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;

public class TableNameInfo {
    private DataDictionary dd;
    private Hashtable<Long, ConglomerateDescriptor> ddCache;
    private Hashtable<UUID, TableDescriptor> tdCache;
    private Hashtable<Long, TableDescriptor> tableCache = new Hashtable(31);
    private Hashtable<Long, String> indexCache;

    public TableNameInfo(LanguageConnectionContext languageConnectionContext, boolean bl2) throws StandardException {
        if (bl2) {
            this.indexCache = new Hashtable(13);
        }
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        this.dd = languageConnectionContext.getDataDictionary();
        this.ddCache = this.dd.hashAllConglomerateDescriptorsByNumber(transactionController);
        this.tdCache = this.dd.hashAllTableDescriptorsByTableId(transactionController);
    }

    public String getTableName(Long l2) {
        if (l2 == null) {
            return "?";
        }
        TableDescriptor tableDescriptor = this.tableCache.get(l2);
        if (tableDescriptor == null) {
            ConglomerateDescriptor conglomerateDescriptor = this.ddCache.get(l2);
            if (conglomerateDescriptor != null) {
                tableDescriptor = this.tdCache.get(conglomerateDescriptor.getTableID());
            }
            if (conglomerateDescriptor == null || tableDescriptor == null) {
                String string;
                if (l2 > 20L) {
                    string = "*** TRANSIENT_" + l2;
                } else {
                    switch (l2.intValue()) {
                        case 0: {
                            string = "*** INVALID CONGLOMERATE ***";
                            break;
                        }
                        case 1: {
                            string = "ConglomerateDirectory";
                            break;
                        }
                        case 2: {
                            string = "PropertyConglomerate";
                            break;
                        }
                        default: {
                            string = "*** INTERNAL TABLE " + l2;
                        }
                    }
                }
                return string;
            }
            this.tableCache.put(l2, tableDescriptor);
            if (this.indexCache != null && conglomerateDescriptor.isIndex()) {
                this.indexCache.put(l2, conglomerateDescriptor.getConglomerateName());
            }
        }
        return tableDescriptor.getName();
    }

    public String getTableType(Long l2) {
        String string;
        if (l2 == null) {
            return "?";
        }
        TableDescriptor tableDescriptor = this.tableCache.get(l2);
        if (tableDescriptor != null) {
            switch (tableDescriptor.getTableType()) {
                case 0: {
                    string = "T";
                    break;
                }
                case 1: {
                    string = "S";
                    break;
                }
                default: {
                    string = "?";
                    break;
                }
            }
        } else {
            string = l2 > 20L ? "T" : "S";
        }
        return string;
    }

    public String getIndexName(Long l2) {
        if (l2 == null) {
            return "?";
        }
        return this.indexCache.get(l2);
    }
}

