/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.locks;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.derby.iapi.services.locks.CompatibilitySpace;
import org.apache.derby.iapi.services.locks.Latch;
import org.apache.derby.iapi.services.locks.LockOwner;
import org.apache.derby.iapi.services.locks.Lockable;
import org.apache.derby.impl.services.locks.ActiveLock;
import org.apache.derby.impl.services.locks.Control;
import org.apache.derby.impl.services.locks.Lock;
import org.apache.derby.impl.services.locks.LockTable;

final class LockControl
implements Control {
    private final Lockable ref;
    private Lock firstGrant;
    private List<Lock> granted;
    private List<Lock> waiting;
    private Lock lastPossibleSkip;

    protected LockControl(Lock lock, Lockable lockable) {
        this.ref = lockable;
        this.firstGrant = lock;
    }

    private LockControl(LockControl lockControl) {
        this.ref = lockControl.ref;
        this.firstGrant = lockControl.firstGrant;
        if (lockControl.granted != null) {
            this.granted = new LinkedList<Lock>(lockControl.granted);
        }
        if (lockControl.waiting != null) {
            this.waiting = new LinkedList<Lock>(lockControl.waiting);
        }
        this.lastPossibleSkip = lockControl.lastPossibleSkip;
    }

    @Override
    public LockControl getLockControl() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        if (!this.isUnlocked()) {
            return false;
        }
        return this.waiting == null || this.waiting.isEmpty();
    }

    void grant(Lock lock) {
        lock.grant();
        List<Lock> list = this.granted;
        if (list == null) {
            if (this.firstGrant == null) {
                this.firstGrant = lock;
            } else {
                list = this.granted = new LinkedList<Lock>();
                list.add(this.firstGrant);
                list.add(lock);
                this.firstGrant = null;
            }
        } else {
            list.add(lock);
        }
    }

    @Override
    public boolean unlock(Latch latch, int n2) {
        if (n2 == 0) {
            n2 = latch.getCount();
        }
        List<Lock> list = this.granted;
        int n3 = 0;
        while (n2 > 0) {
            Lock lock;
            if (this.firstGrant != null) {
                lock = this.firstGrant;
            } else {
                n3 = list.indexOf(latch);
                lock = list.get(n3);
            }
            n2 -= lock.unlock(n2);
            if (lock.getCount() != 0) continue;
            if (this.firstGrant == lock) {
                this.firstGrant = null;
                continue;
            }
            list.remove(n3);
        }
        return true;
    }

    @Override
    public boolean isGrantable(boolean bl2, CompatibilitySpace compatibilitySpace, Object object) {
        if (this.isUnlocked()) {
            return true;
        }
        boolean bl3 = false;
        Lockable lockable = this.ref;
        List<Lock> list = this.granted;
        boolean bl4 = lockable.lockerAlwaysCompatible();
        int n2 = 0;
        int n3 = this.firstGrant == null ? list.size() : 0;
        do {
            boolean bl5;
            Lock lock = this.firstGrant == null ? list.get(n2) : this.firstGrant;
            boolean bl6 = bl5 = lock.getCompatabilitySpace() == compatibilitySpace;
            if (bl5 && bl4) {
                bl3 = true;
                continue;
            }
            if (!lockable.requestCompatible(object, lock.getQualifier())) {
                bl3 = false;
                break;
            }
            if (!bl5 && !bl2) continue;
            bl3 = true;
        } while (++n2 < n3);
        return bl3;
    }

    public Lock addLock(LockTable lockTable, CompatibilitySpace compatibilitySpace, Object object) {
        boolean bl2 = false;
        boolean bl3 = this.firstWaiter() != null;
        Lock lock = null;
        Lockable lockable = this.ref;
        boolean bl4 = false;
        boolean bl5 = false;
        if (!this.isUnlocked()) {
            boolean bl6 = lockable.lockerAlwaysCompatible();
            int n2 = 0;
            int n3 = this.firstGrant == null ? this.granted.size() : 0;
            do {
                boolean bl7;
                Lock lock2 = this.firstGrant == null ? this.granted.get(n2) : this.firstGrant;
                boolean bl8 = bl7 = lock2.getCompatabilitySpace() == compatibilitySpace;
                if (bl7 && bl6) {
                    bl4 = true;
                    if (bl5) break;
                    if (object == lock2.getQualifier()) {
                        lock = lock2;
                    }
                    bl2 = true;
                    continue;
                }
                if (!lockable.requestCompatible(object, lock2.getQualifier())) {
                    bl2 = false;
                    lock = null;
                    if (bl4) break;
                    bl5 = true;
                }
                if (bl5 || !bl7 && bl3) continue;
                bl2 = true;
            } while (++n2 < n3);
        }
        if (lock != null) {
            ++lock.count;
            return lock;
        }
        if (bl2) {
            lock = new Lock(compatibilitySpace, lockable, object);
            this.grant(lock);
            return lock;
        }
        ActiveLock activeLock = new ActiveLock(compatibilitySpace, lockable, object);
        if (bl4) {
            activeLock.canSkip = true;
        }
        if (this.waiting == null) {
            this.waiting = new LinkedList<Lock>();
        }
        this.addWaiter(activeLock, lockTable);
        if (activeLock.canSkip) {
            this.lastPossibleSkip = activeLock;
        }
        return activeLock;
    }

    protected boolean isUnlocked() {
        if (this.firstGrant != null) {
            return false;
        }
        List<Lock> list = this.granted;
        return list == null || list.isEmpty();
    }

    @Override
    public ActiveLock firstWaiter() {
        if (this.waiting == null || this.waiting.isEmpty()) {
            return null;
        }
        return (ActiveLock)this.waiting.get(0);
    }

    ActiveLock getNextWaiter(ActiveLock activeLock, boolean bl2, LockTable lockTable) {
        ActiveLock activeLock2 = null;
        if (bl2 && this.waiting.get(0) == activeLock) {
            this.popFrontWaiter(lockTable);
            activeLock2 = this.firstWaiter();
        } else if (this.lastPossibleSkip != null && this.lastPossibleSkip != activeLock) {
            int n2;
            int n3 = this.waiting.indexOf(activeLock);
            int n4 = n2 = bl2 ? n3 : -1;
            if (n3 != this.waiting.size() - 1) {
                ListIterator<Lock> listIterator = this.waiting.listIterator(n3 + 1);
                while (listIterator.hasNext()) {
                    ActiveLock activeLock3 = (ActiveLock)listIterator.next();
                    if (!activeLock3.canSkip) continue;
                    activeLock2 = activeLock3;
                    break;
                }
            }
            if (bl2) {
                this.removeWaiter(n2, lockTable);
            }
        } else if (bl2) {
            int n5 = this.removeWaiter(activeLock, lockTable);
        }
        if (bl2 && activeLock == this.lastPossibleSkip) {
            this.lastPossibleSkip = null;
        }
        if (activeLock2 != null && !activeLock2.setPotentiallyGranted()) {
            activeLock2 = null;
        }
        return activeLock2;
    }

    @Override
    public Lockable getLockable() {
        return this.ref;
    }

    @Override
    public Lock getFirstGrant() {
        return this.firstGrant;
    }

    @Override
    public List<Lock> getGranted() {
        return this.granted;
    }

    @Override
    public List<Lock> getWaiting() {
        return this.waiting;
    }

    protected void giveUpWait(Object object, LockTable lockTable) {
        int n2 = this.removeWaiter(object, lockTable);
        if (object == this.lastPossibleSkip) {
            this.lastPossibleSkip = null;
        }
    }

    @Override
    public void addWaiters(Map<Object, Object> map) {
        if (this.waiting == null || this.waiting.isEmpty()) {
            return;
        }
        Control control = this;
        ListIterator<Lock> listIterator = this.waiting.listIterator();
        while (listIterator.hasNext()) {
            ActiveLock activeLock = (ActiveLock)listIterator.next();
            CompatibilitySpace compatibilitySpace = activeLock.getCompatabilitySpace();
            map.put(compatibilitySpace, activeLock);
            map.put(activeLock, control);
            control = activeLock;
        }
    }

    List<Lock> getGrants() {
        LinkedList<Lock> linkedList;
        if (this.firstGrant != null) {
            linkedList = new LinkedList<Lock>();
            linkedList.add(this.firstGrant);
        } else {
            linkedList = new LinkedList<Lock>(this.granted);
        }
        return linkedList;
    }

    @Override
    public final Lock getLock(CompatibilitySpace compatibilitySpace, Object object) {
        if (this.isUnlocked()) {
            return null;
        }
        List<Lock> list = this.granted;
        int n2 = 0;
        int n3 = this.firstGrant == null ? list.size() : 0;
        do {
            Lock lock;
            Lock lock2 = lock = this.firstGrant == null ? list.get(n2) : this.firstGrant;
            if (lock.getCompatabilitySpace() != compatibilitySpace || lock.getQualifier() != object) continue;
            return lock;
        } while (++n2 < n3);
        return null;
    }

    public boolean blockedByParent(Lock lock) {
        if (this.granted == null) {
            return false;
        }
        LockOwner lockOwner = lock.getCompatabilitySpace().getOwner();
        Object object = lock.getQualifier();
        for (Lock lock2 : this.granted) {
            LockOwner lockOwner2 = lock2.getCompatabilitySpace().getOwner();
            if (!lockOwner.nestsUnder(lockOwner2)) continue;
            Object object2 = lock2.getQualifier();
            if (lock2.getLockable().requestCompatible(object, object2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Control shallowClone() {
        return new LockControl(this);
    }

    private void addWaiter(Lock lock, LockTable lockTable) {
        this.waiting.add(lock);
        lockTable.oneMoreWaiter();
    }

    private Object popFrontWaiter(LockTable lockTable) {
        return this.removeWaiter(0, lockTable);
    }

    private Object removeWaiter(int n2, LockTable lockTable) {
        lockTable.oneLessWaiter();
        return this.waiting.remove(n2);
    }

    private int removeWaiter(Object object, LockTable lockTable) {
        lockTable.oneLessWaiter();
        return this.waiting.remove(object) ? 1 : 0;
    }
}

