/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.jce;

import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Enumeration;
import java.util.Properties;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.security.SecurityUtil;
import org.apache.derby.iapi.services.crypto.CipherFactory;
import org.apache.derby.iapi.services.crypto.CipherProvider;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.services.jce.JCECipherProvider;
import org.apache.derby.io.StorageFactory;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.StorageRandomAccessFile;

final class JCECipherFactory
implements CipherFactory {
    private static final String MESSAGE_DIGEST = "MD5";
    private static final String DEFAULT_ALGORITHM = "DES/CBC/NoPadding";
    private static final String DES = "DES";
    private static final String DESede = "DESede";
    private static final String TripleDES = "TripleDES";
    private static final String AES = "AES";
    private static final int BLOCK_LENGTH = 8;
    private static final int AES_IV_LENGTH = 16;
    private int keyLengthBits;
    private int encodedKeyLength;
    private String cryptoAlgorithm;
    private String cryptoAlgorithmShort;
    private String cryptoProvider;
    private String cryptoProviderShort;
    private MessageDigest messageDigest;
    private SecretKey mainSecretKey;
    private byte[] mainIV;
    private Properties persistentProperties;
    private static final int VERIFYKEY_DATALEN = 4096;

    JCECipherFactory(boolean bl2, Properties properties, boolean bl3) throws StandardException {
        SecurityUtil.checkDerbyInternalsPrivilege();
        this.init(bl2, properties, bl3);
    }

    static String providerErrorName(String string) {
        return string == null ? "default" : string;
    }

    private byte[] generateUniqueBytes() throws StandardException {
        try {
            KeyGenerator keyGenerator;
            String string = this.cryptoProviderShort;
            if (string == null) {
                keyGenerator = KeyGenerator.getInstance(this.cryptoAlgorithmShort);
            } else {
                if (string.equals("BouncyCastleProvider")) {
                    string = "BC";
                }
                keyGenerator = KeyGenerator.getInstance(this.cryptoAlgorithmShort, string);
            }
            keyGenerator.init(this.keyLengthBits);
            SecretKey secretKey = keyGenerator.generateKey();
            return secretKey.getEncoded();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw StandardException.newException("XBCXC.S", this.cryptoAlgorithm, JCECipherFactory.providerErrorName(this.cryptoProviderShort));
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw StandardException.newException("XBCXG.S", JCECipherFactory.providerErrorName(this.cryptoProviderShort));
        }
    }

    private EncryptedKeyResult encryptKey(byte[] byArray, byte[] byArray2) throws StandardException {
        int n2 = byArray.length;
        if (this.cryptoAlgorithmShort.equals(AES)) {
            n2 = 16;
        }
        byte[] byArray3 = this.getMuckFromBootPassword(byArray2, n2);
        SecretKey secretKey = this.generateKey(byArray3);
        byte[] byArray4 = this.generateIV(byArray3);
        CipherProvider cipherProvider = this.createNewCipher(1, secretKey, byArray4);
        this.encodedKeyLength = byArray.length;
        byArray = this.padKey(byArray, cipherProvider.getEncryptionBlockSize());
        byte[] byArray5 = new byte[byArray.length];
        cipherProvider.encrypt(byArray, 0, byArray.length, byArray5, 0);
        String string = StringUtil.toHexString(byArray5, 0, byArray5.length);
        return new EncryptedKeyResult(string, byArray);
    }

    private byte[] padKey(byte[] byArray, int n2) {
        byte[] byArray2 = byArray;
        if (byArray.length % n2 != 0) {
            int n3 = byArray.length + n2 - byArray.length % n2;
            byArray2 = new byte[n3];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        }
        return byArray2;
    }

    private byte[] decryptKey(String string, int n2, byte[] byArray) throws StandardException {
        byte[] byArray2 = StringUtil.fromHexString(string, 0, n2);
        int n3 = this.cryptoAlgorithmShort.equals(AES) ? 16 : byArray2.length;
        byte[] byArray3 = this.getMuckFromBootPassword(byArray, n3);
        SecretKey secretKey = this.generateKey(byArray3);
        byte[] byArray4 = this.generateIV(byArray3);
        this.createNewCipher(2, secretKey, byArray4).decrypt(byArray2, 0, byArray2.length, byArray2, 0);
        return byArray2;
    }

    private byte[] getMuckFromBootPassword(byte[] byArray, int n2) {
        int n3;
        int n4 = byArray.length;
        byte[] byArray2 = new byte[n2];
        int n5 = 0;
        for (n3 = 0; n3 < byArray.length; ++n3) {
            n5 += byArray[n3];
        }
        for (n3 = 0; n3 < n2; ++n3) {
            byArray2[n3] = (byte)(byArray[(n3 + n5) % n4] ^ byArray[n3 % n4] << 4);
        }
        return byArray2;
    }

    private SecretKey generateKey(byte[] byArray) throws StandardException {
        int n2 = byArray.length;
        if (n2 < 8) {
            throw StandardException.newException("XBCX2.S", 8);
        }
        try {
            if (this.cryptoAlgorithmShort.equals(DES) && DESKeySpec.isWeak(byArray, 0)) {
                byte[] byArray2 = StringUtil.getAsciiBytes("louDScap");
                for (int i2 = 0; i2 < 7; ++i2) {
                    byArray[i2] = (byte)(byArray2[i2] << 3 ^ byArray[i2]);
                }
            }
            return new SecretKeySpec(byArray, this.cryptoAlgorithmShort);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw StandardException.newException("XBCX0.S", invalidKeyException, new Object[0]);
        }
    }

    private byte[] generateIV(byte[] byArray) {
        int n2 = 8;
        byte[] byArray2 = null;
        if (this.cryptoAlgorithmShort.equals(AES)) {
            int n3;
            n2 = 16;
            byArray2 = new byte[n2];
            byArray2[0] = (byte)((byArray[byArray.length - 1] << 2 | 0xF) ^ byArray[0]);
            for (n3 = 1; n3 < 8; ++n3) {
                byArray2[n3] = (byte)((byArray[n3 - 1] << n3 % 5 | 0xF) ^ byArray[n3]);
            }
            for (n3 = 8; n3 < 16; ++n3) {
                byArray2[n3] = byArray2[n3 - 8];
            }
        } else {
            byArray2 = new byte[8];
            byArray2[0] = (byte)((byArray[byArray.length - 1] << 2 | 0xF) ^ byArray[0]);
            for (int i2 = 1; i2 < 8; ++i2) {
                byArray2[i2] = (byte)((byArray[i2 - 1] << i2 % 5 | 0xF) ^ byArray[i2]);
            }
        }
        return byArray2;
    }

    private int digest(byte[] byArray) {
        int n2;
        this.messageDigest.reset();
        byte[] byArray2 = this.messageDigest.digest(byArray);
        byte[] byArray3 = new byte[2];
        for (n2 = 0; n2 < byArray2.length; ++n2) {
            int n3 = n2 % 2;
            byArray3[n3] = (byte)(byArray3[n3] ^ byArray2[n2]);
        }
        n2 = byArray3[0] & 0xFF | byArray3[1] << 8 & 0xFF00;
        return n2;
    }

    @Override
    public SecureRandom getSecureRandom() {
        return new SecureRandom(this.mainIV);
    }

    @Override
    public CipherProvider createNewCipher(int n2) throws StandardException {
        return this.createNewCipher(n2, this.mainSecretKey, this.mainIV);
    }

    private CipherProvider createNewCipher(int n2, SecretKey secretKey, byte[] byArray) throws StandardException {
        return new JCECipherProvider(n2, secretKey, byArray, this.cryptoAlgorithm, this.cryptoProviderShort);
    }

    private void init(boolean bl2, Properties properties, boolean bl3) throws StandardException {
        Throwable throwable;
        Object object;
        int n2;
        boolean bl4 = false;
        boolean bl5 = bl2;
        this.persistentProperties = new Properties();
        String string = properties.getProperty(bl3 ? "newEncryptionKey" : "encryptionKey");
        if (string != null) {
            bl5 = false;
        }
        this.cryptoProvider = properties.getProperty("encryptionProvider");
        if (this.cryptoProvider != null) {
            bl4 = true;
            n2 = this.cryptoProvider.lastIndexOf(46);
            this.cryptoProviderShort = n2 == -1 ? this.cryptoProvider : this.cryptoProvider.substring(n2 + 1);
        }
        this.cryptoAlgorithm = properties.getProperty("encryptionAlgorithm");
        if (this.cryptoAlgorithm == null) {
            this.cryptoAlgorithm = DEFAULT_ALGORITHM;
        } else {
            bl4 = true;
        }
        if (bl5) {
            this.persistentProperties.put("encryptionAlgorithm", this.cryptoAlgorithm);
        }
        n2 = this.cryptoAlgorithm.indexOf(47);
        int n3 = this.cryptoAlgorithm.lastIndexOf(47);
        if (n2 < 0 || n3 < 0 || n2 == n3) {
            throw StandardException.newException("XBCXH.S", this.cryptoAlgorithm);
        }
        this.cryptoAlgorithmShort = this.cryptoAlgorithm.substring(0, n2);
        if (bl4) {
            try {
                object = Class.forName("javax.crypto.ExemptionMechanism");
            }
            catch (Throwable throwable2) {
                throw StandardException.newException("XBCXJ.S", new Object[0]);
            }
        }
        if (!bl2 && properties.getProperty("encryptionKeyLength") != null) {
            object = properties.getProperty("encryptionKeyLength");
            int n4 = ((String)object).lastIndexOf(45);
            this.encodedKeyLength = Integer.parseInt(((String)object).substring(n4 + 1));
            if (n4 != -1) {
                this.keyLengthBits = Integer.parseInt(((String)object).substring(0, n4));
            }
        }
        if (string == null && bl2) {
            this.keyLengthBits = properties.getProperty("encryptionKeyLength") != null ? Integer.parseInt(properties.getProperty("encryptionKeyLength")) : (this.cryptoAlgorithmShort.equals(DES) ? 56 : (this.cryptoAlgorithmShort.equals(DESede) || this.cryptoAlgorithmShort.equals(TripleDES) ? 168 : 128));
        }
        if (!(((String)(object = this.cryptoAlgorithm.substring(n2 + 1, n3))).equals("CBC") || ((String)object).equals("CFB") || ((String)object).equals("ECB") || ((String)object).equals("OFB"))) {
            throw StandardException.newException("XBCXI.S", object);
        }
        String string2 = this.cryptoAlgorithm.substring(n3 + 1, this.cryptoAlgorithm.length());
        if (!string2.equals("NoPadding")) {
            throw StandardException.newException("XBCXB.S", string2);
        }
        try {
            Class<?> clazz;
            if (this.cryptoProvider != null && Security.getProvider(this.cryptoProviderShort) == null) {
                clazz = Class.forName(this.cryptoProvider);
                if (!Provider.class.isAssignableFrom(clazz)) {
                    throw StandardException.newException("XBCXF.S.1", this.cryptoProvider);
                }
                Constructor constructor = clazz.getConstructor(new Class[0]);
                final Provider provider = (Provider)constructor.newInstance(new Object[0]);
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        Security.addProvider(provider);
                        return null;
                    }
                });
            }
            this.messageDigest = MessageDigest.getInstance(MESSAGE_DIGEST);
            if (string != null) {
                if (properties.getProperty(bl3 ? "newBootPassword" : "bootPassword") != null) {
                    throw StandardException.newException("XBM06.D", new Object[0]);
                }
                clazz = (Class<?>)StringUtil.fromHexString(string, 0, string.length());
                if (clazz == null) {
                    throw StandardException.newException(string.length() % 2 == 0 ? "XBCXN.S" : "XBCXM.S", new Object[0]);
                }
            } else {
                clazz = (Class<?>)this.handleBootPassword(bl2, properties, bl3);
                if (bl2 || bl3) {
                    this.persistentProperties.put("encryptionKeyLength", this.keyLengthBits + "-" + ((Object)clazz).length);
                }
            }
            this.mainSecretKey = this.generateKey((byte[])clazz);
            this.mainIV = this.generateIV((byte[])clazz);
            if (bl2) {
                this.persistentProperties.put("dataEncryption", "true");
                this.persistentProperties.put("data_encrypt_algorithm_version", String.valueOf(1));
                this.persistentProperties.put("log_encrypt_algorithm_version", String.valueOf(1));
            }
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throwable = StandardException.newException("XBCXF.S", classNotFoundException, this.cryptoProvider);
        }
        catch (InstantiationException instantiationException) {
            throwable = instantiationException;
        }
        catch (IllegalAccessException illegalAccessException) {
            throwable = illegalAccessException;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throwable = noSuchMethodException;
        }
        catch (InvocationTargetException invocationTargetException) {
            throwable = invocationTargetException;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throwable = noSuchAlgorithmException;
        }
        catch (SecurityException securityException) {
            throwable = securityException;
        }
        catch (LinkageError linkageError) {
            throwable = linkageError;
        }
        catch (ClassCastException classCastException) {
            throwable = classCastException;
        }
        throw StandardException.newException("XBM0G.D", throwable, new Object[0]);
    }

    private byte[] handleBootPassword(boolean bl2, Properties properties, boolean bl3) throws StandardException {
        byte[] byArray;
        String string = properties.getProperty(bl3 ? "newBootPassword" : "bootPassword");
        if (string == null) {
            throw StandardException.newException("XBM06.D", new Object[0]);
        }
        byte[] byArray2 = StringUtil.getAsciiBytes(string);
        if (byArray2.length < 8) {
            String string2 = bl2 ? "XBM07.D" : "XBM06.D";
            throw StandardException.newException(string2, new Object[0]);
        }
        if (bl2 || bl3) {
            byArray = this.generateUniqueBytes();
            this.persistentProperties.put("encryptedBootPassword", this.saveSecretKey(byArray, byArray2));
        } else {
            byArray = this.getDatabaseSecretKey(properties, byArray2, "XBM06.D");
        }
        return byArray;
    }

    @Override
    public void saveProperties(Properties properties) {
        Enumeration<Object> enumeration = this.persistentProperties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            properties.put(string, this.persistentProperties.get(string));
        }
        this.persistentProperties = null;
    }

    private byte[] getDatabaseSecretKey(Properties properties, byte[] byArray, String string) throws StandardException {
        String string2 = properties.getProperty("encryptedBootPassword");
        if (string2 == null) {
            throw StandardException.newException(string, new Object[0]);
        }
        int n2 = string2.indexOf(45);
        if (n2 == -1) {
            throw StandardException.newException(string, new Object[0]);
        }
        int n3 = Integer.parseInt(string2.substring(n2 + 1));
        byte[] byArray2 = this.decryptKey(string2, n2, byArray);
        int n4 = this.digest(byArray2);
        if (n4 != n3) {
            throw StandardException.newException(string, new Object[0]);
        }
        if (this.encodedKeyLength != 0) {
            byte[] byArray3 = new byte[this.encodedKeyLength];
            System.arraycopy(byArray2, 0, byArray3, 0, this.encodedKeyLength);
            return byArray3;
        }
        return byArray2;
    }

    private String saveSecretKey(byte[] byArray, byte[] byArray2) throws StandardException {
        EncryptedKeyResult encryptedKeyResult = this.encryptKey(byArray, byArray2);
        String string = encryptedKeyResult.hexOutput;
        int n2 = this.digest(encryptedKeyResult.paddedInputKey);
        return string.concat("-" + n2);
    }

    @Override
    public String changeBootPassword(String string, Properties properties, CipherProvider cipherProvider) throws StandardException {
        int n2 = string.indexOf(44);
        if (n2 == -1) {
            throw StandardException.newException("XBCX7.S", new Object[0]);
        }
        String string2 = string.substring(0, n2).trim();
        byte[] byArray = StringUtil.getAsciiBytes(string2);
        if (byArray == null || byArray.length < 8) {
            throw StandardException.newException("XBCXA.S", new Object[0]);
        }
        String string3 = string.substring(n2 + 1).trim();
        byte[] byArray2 = StringUtil.getAsciiBytes(string3);
        if (byArray2 == null || byArray2.length < 8) {
            throw StandardException.newException("XBCX2.S", 8);
        }
        byte[] byArray3 = this.getDatabaseSecretKey(properties, byArray, "XBCXA.S");
        byte[] byArray4 = this.generateIV(byArray3);
        if (!((JCECipherProvider)cipherProvider).verifyIV(byArray4)) {
            throw StandardException.newException("XBCXA.S", new Object[0]);
        }
        CipherProvider cipherProvider2 = this.createNewCipher(2, this.generateKey(byArray3), byArray4);
        this.vetCipherProviders(cipherProvider2, cipherProvider, "XBCXA.S");
        String string4 = this.saveSecretKey(byArray3, byArray2);
        properties.put("encryptionKeyLength", this.keyLengthBits + "-" + this.encodedKeyLength);
        return this.saveSecretKey(byArray3, byArray2);
    }

    private void vetCipherProviders(CipherProvider cipherProvider, CipherProvider cipherProvider2, String string) throws StandardException {
        int n2;
        int n3 = 1024;
        int n4 = 256;
        byte[] byArray = new byte[n3];
        byte[] byArray2 = new byte[n3];
        byte[] byArray3 = new byte[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            byArray[n2] = (byte)(n2 % n4);
        }
        n2 = cipherProvider2.encrypt(byArray, 0, n3, byArray2, 0);
        int n5 = cipherProvider.decrypt(byArray2, 0, n2, byArray3, 0);
        if (n2 != n3 || n5 != n3) {
            throw StandardException.newException(string, new Object[0]);
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            if (byArray[i2] == byArray3[i2]) continue;
            throw StandardException.newException(string, new Object[0]);
        }
    }

    @Override
    public void verifyKey(boolean bl2, StorageFactory storageFactory, Properties properties) throws StandardException {
        if (properties.getProperty("encryptionKey") == null) {
            return;
        }
        InputStream inputStream = null;
        StorageRandomAccessFile storageRandomAccessFile = null;
        byte[] byArray = new byte[4096];
        try {
            Object object;
            if (bl2) {
                this.getSecureRandom().nextBytes(byArray);
                object = this.getMD5Checksum(byArray);
                CipherProvider cipherProvider = this.createNewCipher(1, this.mainSecretKey, this.mainIV);
                cipherProvider.encrypt(byArray, 0, byArray.length, byArray, 0);
                storageRandomAccessFile = this.privAccessFile(storageFactory, "verifyKey.dat", "rw");
                storageRandomAccessFile.writeInt(((Object)object).length);
                storageRandomAccessFile.write((byte[])object);
                storageRandomAccessFile.write(byArray);
                storageRandomAccessFile.sync();
            } else {
                inputStream = this.privAccessGetInputStream(storageFactory, "verifyKey.dat");
                object = new DataInputStream(inputStream);
                int n2 = ((DataInputStream)object).readInt();
                byte[] byArray2 = new byte[n2];
                ((DataInputStream)object).readFully(byArray2);
                ((DataInputStream)object).readFully(byArray);
                CipherProvider cipherProvider = this.createNewCipher(2, this.mainSecretKey, this.mainIV);
                cipherProvider.decrypt(byArray, 0, byArray.length, byArray, 0);
                byte[] byArray3 = this.getMD5Checksum(byArray);
                if (!MessageDigest.isEqual(byArray2, byArray3)) {
                    throw StandardException.newException("XBCXK.S", new Object[0]);
                }
            }
        }
        catch (IOException iOException) {
            throw StandardException.newException("XBCXL.S", iOException, new Object[0]);
        }
        finally {
            try {
                if (storageRandomAccessFile != null) {
                    storageRandomAccessFile.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                throw StandardException.newException("XBCXL.S", iOException, new Object[0]);
            }
        }
    }

    private byte[] getMD5Checksum(byte[] byArray) throws StandardException {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(MESSAGE_DIGEST);
            return messageDigest.digest(byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw StandardException.newException("XBCXH.S", MESSAGE_DIGEST);
        }
    }

    private StorageRandomAccessFile privAccessFile(StorageFactory storageFactory, String string, final String string2) throws IOException {
        final StorageFile storageFile = storageFactory.newStorageFile("", string);
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<StorageRandomAccessFile>(){

                @Override
                public StorageRandomAccessFile run() throws IOException {
                    return storageFile.getRandomAccessFile(string2);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    private InputStream privAccessGetInputStream(StorageFactory storageFactory, String string) throws StandardException {
        final StorageFile storageFile = storageFactory.newStorageFile("", string);
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                @Override
                public InputStream run() throws FileNotFoundException {
                    return storageFile.getInputStream();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw StandardException.newException("XBCXL.S", privilegedActionException.getCause(), this.cryptoProvider);
        }
    }

    private static final class EncryptedKeyResult {
        public String hexOutput;
        public byte[] paddedInputKey;

        public EncryptedKeyResult(String string, byte[] byArray) {
            this.hexOutput = string;
            this.paddedInputKey = byArray;
        }
    }
}

