/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.daemon;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.daemon.DaemonService;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.util.InterruptStatus;
import org.apache.derby.impl.services.daemon.ServiceRecord;

public class BasicDaemon
implements Runnable,
DaemonService {
    private int numClients;
    private static final int OPTIMAL_QUEUE_SIZE = 100;
    private final Vector<ServiceRecord> subscription;
    protected final ContextService contextService;
    protected final ContextManager contextMgr;
    private final List<ServiceRecord> highPQ;
    private final List<ServiceRecord> normPQ;
    private int nextService;
    private boolean awakened;
    private boolean waiting;
    private boolean inPause;
    private boolean running;
    private boolean stopRequested;
    private boolean stopped;
    private long lastServiceTime;
    private int earlyWakeupCount;

    public BasicDaemon(ContextService contextService) {
        this.contextService = contextService;
        this.contextMgr = contextService.newContextManager();
        this.subscription = new Vector(1, 1);
        this.highPQ = new LinkedList<ServiceRecord>();
        this.normPQ = new LinkedList<ServiceRecord>();
        this.lastServiceTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int subscribe(Serviceable serviceable, boolean bl2) {
        int n2;
        BasicDaemon basicDaemon = this;
        synchronized (basicDaemon) {
            n2 = this.numClients++;
            ServiceRecord serviceRecord = new ServiceRecord(serviceable, bl2, true);
            this.subscription.add(n2, serviceRecord);
        }
        return n2;
    }

    @Override
    public void unsubscribe(int n2) {
        if (n2 < 0 || n2 > this.subscription.size()) {
            return;
        }
        this.subscription.set(n2, null);
    }

    @Override
    public void serviceNow(int n2) {
        if (n2 < 0 || n2 > this.subscription.size()) {
            return;
        }
        ServiceRecord serviceRecord = this.subscription.get(n2);
        if (serviceRecord == null) {
            return;
        }
        serviceRecord.called();
        this.wakeUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean enqueue(Serviceable serviceable, boolean bl2) {
        int n2;
        ServiceRecord serviceRecord = new ServiceRecord(serviceable, false, false);
        List<ServiceRecord> list = bl2 ? this.highPQ : this.normPQ;
        BasicDaemon basicDaemon = this;
        synchronized (basicDaemon) {
            list.add(serviceRecord);
            n2 = this.highPQ.size();
        }
        if (bl2 && !this.awakened) {
            this.wakeUp();
        }
        if (bl2) {
            return n2 > 100;
        }
        return false;
    }

    @Override
    public synchronized void clear() {
        this.normPQ.clear();
        this.highPQ.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServiceRecord nextAssignment(boolean bl2) {
        ServiceRecord serviceRecord;
        while (this.nextService < this.subscription.size()) {
            if ((serviceRecord = this.subscription.get(this.nextService++)) == null || !serviceRecord.needImmediateService() && (bl2 || !serviceRecord.needService())) continue;
            return serviceRecord;
        }
        serviceRecord = null;
        BasicDaemon basicDaemon = this;
        synchronized (basicDaemon) {
            if (!this.highPQ.isEmpty()) {
                serviceRecord = this.highPQ.remove(0);
            }
        }
        if (bl2 || serviceRecord != null) {
            return serviceRecord;
        }
        serviceRecord = null;
        basicDaemon = this;
        synchronized (basicDaemon) {
            if (!this.normPQ.isEmpty()) {
                serviceRecord = this.normPQ.remove(0);
            }
        }
        return serviceRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serviceClient(ServiceRecord serviceRecord) {
        serviceRecord.serviced();
        Serviceable serviceable = serviceRecord.client;
        if (serviceable == null) {
            return;
        }
        ContextManager contextManager = this.contextMgr;
        try {
            int n2 = serviceable.performWork(contextManager);
            if (serviceRecord.subscriber) {
                return;
            }
            if (n2 == 2) {
                List<ServiceRecord> list = serviceable.serviceASAP() ? this.highPQ : this.normPQ;
                BasicDaemon basicDaemon = this;
                synchronized (basicDaemon) {
                    list.add(serviceRecord);
                }
            }
            return;
        }
        catch (Throwable throwable) {
            contextManager.cleanupOnError(throwable, false);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.contextService.setCurrentContextManager(this.contextMgr);
        while (!this.stopRequested()) {
            boolean bl2 = this.rest();
            if (this.stopRequested()) break;
            if (this.inPause()) continue;
            this.work(bl2);
        }
        BasicDaemon basicDaemon = this;
        synchronized (basicDaemon) {
            this.running = false;
            this.stopped = true;
        }
        this.contextMgr.cleanupOnError(StandardException.normalClose(), false);
        this.contextService.resetCurrentContextManager(this.contextMgr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() {
        BasicDaemon basicDaemon = this;
        synchronized (basicDaemon) {
            this.inPause = true;
            while (this.running) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    InterruptStatus.setInterrupted();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        BasicDaemon basicDaemon = this;
        synchronized (basicDaemon) {
            this.inPause = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (this.stopped) {
            return;
        }
        BasicDaemon basicDaemon = this;
        synchronized (basicDaemon) {
            this.stopRequested = true;
            this.notifyAll();
        }
        this.pause();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitUntilQueueIsEmpty() {
        while (true) {
            BasicDaemon basicDaemon = this;
            synchronized (basicDaemon) {
                boolean bl2 = true;
                for (int i2 = 0; i2 < this.subscription.size(); ++i2) {
                    ServiceRecord serviceRecord = this.subscription.get(i2);
                    if (serviceRecord == null || !serviceRecord.needService()) continue;
                    bl2 = false;
                    break;
                }
                if (this.highPQ.isEmpty() && bl2 && !this.running) {
                    return;
                }
                this.notifyAll();
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    InterruptStatus.setInterrupted();
                }
            }
        }
    }

    private synchronized boolean stopRequested() {
        return this.stopRequested;
    }

    private synchronized boolean inPause() {
        return this.inPause;
    }

    protected synchronized void wakeUp() {
        if (!this.awakened) {
            this.awakened = true;
            if (this.waiting) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean rest() {
        long l2;
        boolean bl2;
        boolean bl3 = false;
        BasicDaemon basicDaemon = this;
        synchronized (basicDaemon) {
            try {
                if (!this.awakened) {
                    this.waiting = true;
                    this.wait(10000L);
                    this.waiting = false;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.nextService = 0;
            bl2 = this.awakened;
            if (bl2 && this.earlyWakeupCount++ > 20) {
                this.earlyWakeupCount = 0;
                bl3 = true;
            }
            this.awakened = false;
        }
        if (bl3 && (l2 = System.currentTimeMillis()) - this.lastServiceTime > 10000L) {
            this.lastServiceTime = l2;
            bl2 = false;
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void work(boolean bl2) {
        int n2 = 0;
        int n3 = 10;
        if (bl2 && this.highPQ.size() > 100) {
            n3 = 2;
        }
        int n4 = 100 / n3;
        ServiceRecord serviceRecord = this.nextAssignment(bl2);
        while (serviceRecord != null) {
            BasicDaemon basicDaemon = this;
            synchronized (basicDaemon) {
                if (this.inPause || this.stopRequested) {
                    break;
                }
                this.running = true;
            }
            try {
                this.serviceClient(serviceRecord);
            }
            finally {
                basicDaemon = this;
                synchronized (basicDaemon) {
                    this.running = false;
                    this.notifyAll();
                    if (this.inPause || this.stopRequested) {
                        break;
                    }
                }
            }
            if (++n2 % 50 == 0) {
                this.nextService = 0;
            }
            if (n2 % n4 == 0) {
                this.yield();
            }
            serviceRecord = this.nextAssignment(bl2);
        }
    }

    private void yield() {
        Thread thread = Thread.currentThread();
        int n2 = thread.getPriority();
        if (n2 <= 1) {
            Thread.yield();
        } else {
            ModuleFactory moduleFactory = BasicDaemon.getMonitor();
            BasicDaemon.setThreadPriority(moduleFactory, 1);
            Thread.yield();
            BasicDaemon.setThreadPriority(moduleFactory, n2);
        }
    }

    private static void setThreadPriority(ModuleFactory moduleFactory, final int n2) {
        final Thread thread = Thread.currentThread();
        if (moduleFactory != null && moduleFactory.isDaemonThread(thread)) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    thread.setPriority(n2);
                    return null;
                }
            });
        }
    }

    static ModuleFactory getMonitor() {
        return AccessController.doPrivileged(new PrivilegedAction<ModuleFactory>(){

            @Override
            public ModuleFactory run() {
                return Monitor.getMonitor();
            }
        });
    }
}

