/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.cache;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.impl.services.cache.BackgroundCleaner;
import org.apache.derby.impl.services.cache.CacheEntry;
import org.apache.derby.impl.services.cache.ConcurrentCache;
import org.apache.derby.impl.services.cache.ReplacementPolicy;

final class ClockPolicy
implements ReplacementPolicy {
    private static final int MIN_ITEMS_TO_CHECK = 20;
    private static final float MAX_ROTATION = 0.2f;
    private static final float PART_OF_CLOCK_FOR_SHRINK = 0.1f;
    private final ConcurrentCache cacheManager;
    private final int maxSize;
    private final ArrayList<Holder> clock;
    private int hand;
    private final AtomicInteger freeEntries = new AtomicInteger();
    private final AtomicBoolean isShrinking = new AtomicBoolean();

    ClockPolicy(ConcurrentCache concurrentCache, int n2, int n3) {
        this.cacheManager = concurrentCache;
        this.maxSize = n3;
        this.clock = new ArrayList(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        ArrayList<Holder> arrayList = this.clock;
        synchronized (arrayList) {
            return this.clock.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertEntry(CacheEntry cacheEntry) throws StandardException {
        int n2;
        Object object = this.clock;
        synchronized (object) {
            n2 = this.clock.size();
            if (n2 < this.maxSize && this.freeEntries.get() == 0) {
                this.clock.add(new Holder(cacheEntry));
                return;
            }
        }
        if (n2 > this.maxSize) {
            object = this.cacheManager.getBackgroundCleaner();
            if (object != null) {
                ((BackgroundCleaner)object).scheduleShrink();
            } else {
                this.doShrink();
            }
        }
        if ((object = this.rotateClock(cacheEntry, n2 >= this.maxSize)) == null) {
            ArrayList<Holder> arrayList = this.clock;
            synchronized (arrayList) {
                this.clock.add(new Holder(cacheEntry));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Holder moveHand() {
        ArrayList<Holder> arrayList = this.clock;
        synchronized (arrayList) {
            if (this.clock.isEmpty()) {
                return null;
            }
            if (this.hand >= this.clock.size()) {
                this.hand = 0;
            }
            return this.clock.get(this.hand++);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Holder rotateClock(CacheEntry cacheEntry, boolean bl2) throws StandardException {
        Object object;
        int n2 = 0;
        if (bl2) {
            object = this.clock;
            synchronized (object) {
                n2 = Math.max(20, (int)((float)this.clock.size() * 0.2f));
            }
        }
        while (n2-- > 0 || this.freeEntries.get() > 0) {
            Cacheable cacheable;
            object = this.moveHand();
            if (object == null) {
                return null;
            }
            CacheEntry cacheEntry2 = ((Holder)object).getEntry();
            if (cacheEntry2 == null) {
                if (!((Holder)object).takeIfFree(cacheEntry)) continue;
                return object;
            }
            if (!bl2) continue;
            cacheEntry2.lock();
            try {
                Object object2;
                if (!this.isEvictable(cacheEntry2, (Holder)object, true)) continue;
                Cacheable cacheable2 = cacheEntry2.getCacheable();
                if (!cacheable2.isDirty()) {
                    ((Holder)object).switchEntry(cacheEntry);
                    this.cacheManager.evictEntry(cacheable2.getIdentity());
                    object2 = object;
                    return object2;
                }
                object2 = this.cacheManager.getBackgroundCleaner();
                if (object2 != null && ((BackgroundCleaner)object2).scheduleClean(cacheEntry2)) continue;
                cacheEntry2.keep(false);
                cacheable = cacheable2;
            }
            finally {
                cacheEntry2.unlock();
                continue;
            }
            this.cacheManager.cleanAndUnkeepEntry(cacheEntry2, cacheable);
        }
        return null;
    }

    private boolean isEvictable(CacheEntry cacheEntry, Holder holder, boolean bl2) {
        if (holder.getEntry() != cacheEntry) {
            return false;
        }
        if (cacheEntry.isKept()) {
            return false;
        }
        if (holder.recentlyUsed) {
            if (bl2) {
                holder.recentlyUsed = false;
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeHolder(int n2, Holder holder) {
        ArrayList<Holder> arrayList = this.clock;
        synchronized (arrayList) {
            Holder holder2 = this.clock.remove(n2);
        }
    }

    @Override
    public void doShrink() {
        if (this.isShrinking.compareAndSet(false, true)) {
            try {
                this.shrinkMe();
            }
            finally {
                this.isShrinking.set(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shrinkMe() {
        int n2;
        int n3 = Math.max(1, (int)((float)this.maxSize * 0.1f));
        Object object = this.clock;
        synchronized (object) {
            n2 = this.hand;
        }
        while (n3-- > 0) {
            int n4;
            ArrayList<Holder> arrayList = this.clock;
            synchronized (arrayList) {
                n4 = this.clock.size();
                if (n2 >= n4) {
                    n2 = 0;
                }
                object = this.clock.get(n2);
            }
            int n5 = n2++;
            if (n4 <= this.maxSize) break;
            CacheEntry cacheEntry = ((Holder)object).getEntry();
            if (cacheEntry == null) {
                if (!((Holder)object).evictIfFree()) continue;
                this.removeHolder(n5, (Holder)object);
                n2 = n5;
                continue;
            }
            cacheEntry.lock();
            try {
                Cacheable cacheable;
                if (!this.isEvictable(cacheEntry, (Holder)object, false) || (cacheable = cacheEntry.getCacheable()).isDirty()) continue;
                ((Holder)object).setEvicted();
                this.cacheManager.evictEntry(cacheable.getIdentity());
                this.removeHolder(n5, (Holder)object);
                n2 = n5;
            }
            finally {
                cacheEntry.unlock();
            }
        }
    }

    private class Holder
    implements ReplacementPolicy.Callback {
        boolean recentlyUsed;
        private CacheEntry entry;
        private Cacheable freedCacheable;
        private boolean evicted;

        Holder(CacheEntry cacheEntry) {
            this.entry = cacheEntry;
            cacheEntry.setCallback(this);
        }

        @Override
        public void access() {
            this.recentlyUsed = true;
        }

        @Override
        public synchronized void free() {
            this.freedCacheable = this.entry.getCacheable();
            this.entry = null;
            this.recentlyUsed = false;
            int n2 = ClockPolicy.this.freeEntries.incrementAndGet();
        }

        synchronized boolean takeIfFree(CacheEntry cacheEntry) {
            if (this.entry == null && !this.evicted) {
                int n2 = ClockPolicy.this.freeEntries.decrementAndGet();
                cacheEntry.setCacheable(this.freedCacheable);
                cacheEntry.setCallback(this);
                this.entry = cacheEntry;
                this.freedCacheable = null;
                return true;
            }
            return false;
        }

        synchronized CacheEntry getEntry() {
            return this.entry;
        }

        synchronized void switchEntry(CacheEntry cacheEntry) {
            cacheEntry.setCallback(this);
            cacheEntry.setCacheable(this.entry.getCacheable());
            this.entry = cacheEntry;
        }

        synchronized boolean evictIfFree() {
            if (this.entry == null && !this.evicted) {
                int n2 = ClockPolicy.this.freeEntries.decrementAndGet();
                this.evicted = true;
                return true;
            }
            return false;
        }

        synchronized void setEvicted() {
            this.evicted = true;
            this.entry = null;
        }

        synchronized boolean isEvicted() {
            return this.evicted;
        }
    }
}

