/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.load;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.impl.load.ColumnInfo;
import org.apache.derby.impl.load.LoadError;

class ExportResultSetForObject {
    private Connection con;
    private String selectQuery;
    private ResultSet rs;
    private int columnCount;
    private String[] columnNames;
    private String[] columnTypes;
    private int[] columnLengths;
    private Statement expStmt = null;
    private String schemaName;
    private String tableName;

    public ExportResultSetForObject(Connection connection, String string, String string2, String string3) {
        this.con = connection;
        if (string3 == null) {
            this.schemaName = string;
            this.tableName = string2;
            this.selectQuery = "select * from " + IdUtil.mkQualifiedName(string, string2);
        } else {
            this.selectQuery = string3;
        }
    }

    public ResultSet getResultSet() throws SQLException {
        this.rs = null;
        this.expStmt = this.con.createStatement();
        this.rs = this.expStmt.executeQuery(this.selectQuery);
        this.getMetaDataInfo();
        return this.rs;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public String[] getColumnDefinition() {
        return this.columnNames;
    }

    public String[] getColumnTypes() {
        return this.columnTypes;
    }

    public int[] getColumnLengths() {
        return this.columnLengths;
    }

    private void getMetaDataInfo() throws SQLException {
        ResultSetMetaData resultSetMetaData = this.rs.getMetaData();
        int n2 = this.columnCount = resultSetMetaData.getColumnCount();
        this.columnNames = new String[n2];
        this.columnTypes = new String[n2];
        this.columnLengths = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = resultSetMetaData.getColumnType(i2 + 1);
            this.columnNames[i2] = resultSetMetaData.getColumnName(i2 + 1);
            this.columnTypes[i2] = resultSetMetaData.getColumnTypeName(i2 + 1);
            if (!ColumnInfo.importExportSupportedType(n3)) {
                throw LoadError.nonSupportedTypeColumn(this.columnNames[i2], this.columnTypes[i2]);
            }
            this.columnLengths[i2] = resultSetMetaData.getColumnDisplaySize(i2 + 1);
        }
    }

    public void close() throws Exception {
        if (this.expStmt != null) {
            this.expStmt.close();
        }
    }
}

