/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.load;

import java.io.Closeable;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import org.apache.derby.iapi.services.io.DynamicByteArrayOutputStream;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.load.ControlInfo;
import org.apache.derby.impl.load.ExportResultSetForObject;
import org.apache.derby.impl.load.ExportWriteDataAbstract;

abstract class ExportAbstract {
    protected ControlInfo controlFileReader;
    protected ExportResultSetForObject exportResultSetForObject;
    protected ExportWriteDataAbstract exportWriteData;
    protected Connection con;
    protected String entityName;
    protected String schemaName;
    protected String selectStatement;
    protected boolean lobsInExtFile = false;

    ExportAbstract() {
    }

    protected ResultSet resultSetForEntity() throws Exception {
        this.exportResultSetForObject = new ExportResultSetForObject(this.con, this.schemaName, this.entityName, this.selectStatement);
        ResultSet resultSet = this.exportResultSetForObject.getResultSet();
        return resultSet;
    }

    private String[] getOneRowAtATime(ResultSet resultSet, boolean[] blArray, boolean[] blArray2) throws Exception {
        if (resultSet.next()) {
            int n2 = this.exportResultSetForObject.getColumnCount();
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            String[] stringArray = new String[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                String string;
                if (this.lobsInExtFile && (blArray2[i2] || blArray[i2])) {
                    Closeable closeable;
                    if (blArray[i2]) {
                        closeable = resultSet.getBinaryStream(i2 + 1);
                        string = this.exportWriteData.writeBinaryColumnToExternalFile((InputStream)closeable);
                    } else {
                        closeable = resultSet.getCharacterStream(i2 + 1);
                        string = this.exportWriteData.writeCharColumnToExternalFile((Reader)closeable);
                    }
                    stringArray[i2] = string;
                    continue;
                }
                int n3 = i2 + 1;
                string = resultSetMetaData.getColumnType(n3) == 2000 ? ExportAbstract.stringifyObject(resultSet.getObject(n3)) : resultSet.getString(n3);
                stringArray[i2] = string;
            }
            return stringArray;
        }
        resultSet.close();
        this.exportResultSetForObject.close();
        return null;
    }

    public static String stringifyObject(Object object) throws Exception {
        DynamicByteArrayOutputStream dynamicByteArrayOutputStream = new DynamicByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(dynamicByteArrayOutputStream);
        objectOutputStream.writeObject(object);
        byte[] byArray = dynamicByteArrayOutputStream.getByteArray();
        int n2 = dynamicByteArrayOutputStream.getUsed();
        return StringUtil.toHexString(byArray, 0, n2);
    }

    protected ControlInfo getControlFileReader() {
        return this.controlFileReader;
    }

    protected abstract ExportWriteDataAbstract getExportWriteData() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAllTheWork() throws Exception {
        ResultSet resultSet = null;
        try {
            resultSet = this.resultSetForEntity();
            if (resultSet != null) {
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int n2 = resultSetMetaData.getColumnCount();
                boolean[] blArray = new boolean[n2];
                boolean[] blArray2 = new boolean[n2];
                boolean[] blArray3 = new boolean[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    int n3 = resultSetMetaData.getColumnType(i2 + 1);
                    blArray[i2] = n3 == -5 || n3 == 3 || n3 == 8 || n3 == 6 || n3 == 4 || n3 == 2 || n3 == 7 || n3 == 5 || n3 == -6;
                    blArray2[i2] = n3 == 2005;
                    blArray3[i2] = n3 == 2004;
                }
                this.exportWriteData = this.getExportWriteData();
                this.exportWriteData.writeColumnDefinitionOptionally(this.exportResultSetForObject.getColumnDefinition(), this.exportResultSetForObject.getColumnTypes());
                this.exportWriteData.setColumnLengths(this.controlFileReader.getColumnWidths());
                String[] stringArray = this.getOneRowAtATime(resultSet, blArray3, blArray2);
                while (stringArray != null) {
                    this.exportWriteData.writeData(stringArray, blArray);
                    stringArray = this.getOneRowAtATime(resultSet, blArray3, blArray2);
                }
            }
        }
        finally {
            if (this.exportWriteData != null) {
                this.exportWriteData.noMoreRows();
            }
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }
}

