/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.load;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.derby.iapi.error.PublicAPI;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.EngineConnection;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.impl.load.ExportAbstract;
import org.apache.derby.impl.load.ImportAbstract;
import org.apache.derby.impl.load.LoadError;

class ColumnInfo {
    private ArrayList<String> vtiColumnNames = new ArrayList(1);
    private ArrayList<String> insertColumnNames = new ArrayList(1);
    private ArrayList<String> columnTypes = new ArrayList(1);
    private ArrayList<Integer> jdbcColumnTypes = new ArrayList(1);
    private int noOfColumns = 0;
    private ArrayList columnPositions;
    private boolean createolumnNames = true;
    private int expectedNumberOfCols;
    private Connection conn;
    private String tableName;
    private String schemaName;
    private String[] headerColumnNames;
    private HashMap<String, String> udtClassNames = new HashMap();

    public ColumnInfo(Connection connection, String string, String string2, String string3, String string4, String string5, String[] stringArray) throws SQLException {
        StringTokenizer stringTokenizer;
        this.conn = connection;
        this.headerColumnNames = stringArray;
        if (string == null) {
            string = ((EngineConnection)connection).getCurrentSchemaName();
        }
        this.schemaName = string;
        this.tableName = string2;
        if (string3 != null) {
            stringTokenizer = new StringTokenizer(string3, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string6 = stringTokenizer.nextToken().trim();
                if (this.initializeColumnInfo(string6)) continue;
                if (this.tableExists()) {
                    throw LoadError.invalidColumnName(string6);
                }
                String string7 = this.schemaName != null ? this.schemaName + "." + this.tableName : this.tableName;
                throw LoadError.tableNotFound(string7);
            }
        } else if (!this.initializeColumnInfo(null)) {
            String string8 = this.schemaName != null ? this.schemaName + "." + this.tableName : this.tableName;
            throw LoadError.tableNotFound(string8);
        }
        if (string4 != null) {
            stringTokenizer = new StringTokenizer(string4, ",");
            while (stringTokenizer.hasMoreTokens()) {
                int n2;
                String string9 = stringTokenizer.nextToken().trim();
                if ("\"".equals(string9.substring(0, 1))) {
                    n2 = this.readHeaders(string9.replace('\"', ' ').trim());
                    this.vtiColumnNames.add(string5 + n2);
                } else {
                    this.vtiColumnNames.add(string5 + string9);
                    n2 = Integer.parseInt(string9);
                }
                if (n2 <= this.expectedNumberOfCols) continue;
                this.expectedNumberOfCols = n2;
            }
        }
        if (this.vtiColumnNames.size() < 1) {
            for (int i2 = 1; i2 <= this.noOfColumns; ++i2) {
                this.vtiColumnNames.add(string5 + i2);
            }
            this.expectedNumberOfCols = this.noOfColumns;
        }
    }

    private int readHeaders(String string) throws SQLException {
        if (this.headerColumnNames != null) {
            for (int i2 = 0; i2 < this.headerColumnNames.length; ++i2) {
                if (!this.headerColumnNames[i2].equals(string)) continue;
                return i2 + 1;
            }
            throw PublicAPI.wrapStandardException(StandardException.newException("42XAU", string));
        }
        throw PublicAPI.wrapStandardException(StandardException.newException("42XAV", new Object[0]));
    }

    private boolean initializeColumnInfo(String string) throws SQLException {
        DatabaseMetaData databaseMetaData = this.conn.getMetaData();
        ResultSet resultSet = databaseMetaData.getColumns(null, this.schemaName, this.tableName, string);
        boolean bl2 = false;
        while (resultSet.next()) {
            String string2 = resultSet.getString(4);
            short s2 = resultSet.getShort(5);
            String string3 = resultSet.getString(6);
            int n2 = resultSet.getInt(7);
            int n3 = resultSet.getInt(9);
            int n4 = resultSet.getInt(10);
            bl2 = true;
            if (ColumnInfo.importExportSupportedType(s2)) {
                this.insertColumnNames.add(string2);
                String string4 = string3 + this.getTypeOption(string3, n2, n2, n3);
                this.columnTypes.add(string4);
                this.jdbcColumnTypes.add(Integer.valueOf(s2));
                ++this.noOfColumns;
                if (s2 != 2000) continue;
                this.udtClassNames.put("COLUMN" + this.noOfColumns, this.getUDTClassName(databaseMetaData, string3));
                continue;
            }
            resultSet.close();
            throw LoadError.nonSupportedTypeColumn(string2, string3);
        }
        resultSet.close();
        return bl2;
    }

    private String getUDTClassName(DatabaseMetaData databaseMetaData, String string) throws SQLException {
        String string2 = null;
        try {
            if (string.charAt(0) != '\"') {
                return string;
            }
            String[] stringArray = IdUtil.parseMultiPartSQLIdentifier(string);
            String string3 = stringArray[0];
            String string4 = stringArray[1];
            ResultSet resultSet = databaseMetaData.getUDTs(null, string3, string4, new int[]{2000});
            if (resultSet.next()) {
                string2 = resultSet.getString(4);
            }
            resultSet.close();
        }
        catch (Exception exception) {
            throw LoadError.unexpectedError(exception);
        }
        if (string2 == null) {
            string2 = "???";
        }
        return string2;
    }

    public static final boolean importExportSupportedType(int n2) {
        return n2 != -7 && n2 != 1111 && n2 != 2009;
    }

    private String getTypeOption(String string, int n2, int n3, int n4) {
        if ((string.equals("CHAR") || string.equals("BLOB") || string.equals("CLOB") || string.equals("VARCHAR")) && n2 != 0) {
            return "(" + n2 + ")";
        }
        if (string.equals("FLOAT") && n3 != 0) {
            return "(" + n3 + ")";
        }
        if (string.equals("DECIMAL") || string.equals("NUMERIC")) {
            if (n3 != 0 && n4 == 0) {
                return "(" + n3 + ")";
            }
            if (n3 != 0 && n4 != 0) {
                return "(" + n3 + "," + n4 + ")";
            }
            if (n3 == 0 && n4 != 0) {
                return "(" + n4 + ")";
            }
        }
        if ((string.equals("DECIMAL") || string.equals("NUMERIC")) && n4 != 0) {
            return "(" + n4 + ")";
        }
        return "";
    }

    public String getColumnTypeNames() throws Exception {
        return ExportAbstract.stringifyObject(this.columnTypes);
    }

    public String getUDTClassNames() throws Exception {
        return ExportAbstract.stringifyObject(this.udtClassNames);
    }

    public String getColumnNamesWithCasts() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = true;
        int n2 = this.vtiColumnNames.size();
        for (int i2 = 0; i2 < this.noOfColumns && i2 < n2; ++i2) {
            if (!bl2) {
                stringBuffer.append(", ");
            } else {
                bl2 = false;
            }
            String string = this.columnTypes.get(i2);
            String string2 = this.vtiColumnNames.get(i2);
            if (string.startsWith("SMALLINT") || string.startsWith("INTEGER") || string.startsWith("DECIMAL") || string.startsWith("BIGINT") || string.startsWith("NUMERIC")) {
                stringBuffer.append(" cast(" + string2 + " AS " + string + ") ");
                continue;
            }
            if (string.startsWith("DOUBLE")) {
                stringBuffer.append(" DOUBLE(" + string2 + ") ");
                continue;
            }
            if (string.startsWith("REAL")) {
                stringBuffer.append("cast( DOUBLE(" + string2 + ") " + " AS " + "REAL" + ") ");
                continue;
            }
            stringBuffer.append(" " + string2 + " ");
        }
        if (bl2) {
            return " * ";
        }
        return stringBuffer.toString();
    }

    public String getInsertColumnNames() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = true;
        for (int i2 = 0; i2 < this.noOfColumns; ++i2) {
            if (!bl2) {
                stringBuffer.append(", ");
            } else {
                bl2 = false;
            }
            String string = this.insertColumnNames.get(i2);
            stringBuffer.append(IdUtil.normalToDelimited(string));
        }
        if (bl2) {
            return null;
        }
        return stringBuffer.toString();
    }

    public int getExpectedNumberOfColumnsInFile() {
        return this.expectedNumberOfCols;
    }

    private boolean tableExists() throws SQLException {
        DatabaseMetaData databaseMetaData = this.conn.getMetaData();
        ResultSet resultSet = databaseMetaData.getTables(null, this.schemaName, this.tableName, null);
        boolean bl2 = false;
        if (resultSet.next()) {
            bl2 = true;
        }
        resultSet.close();
        return bl2;
    }

    public String getExpectedVtiColumnTypesAsString() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = true;
        for (int i2 = 0; i2 < this.noOfColumns && i2 < this.vtiColumnNames.size(); ++i2) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.vtiColumnNames.get(i2) + ":" + this.jdbcColumnTypes.get(i2));
        }
        if (bl2) {
            return null;
        }
        return stringBuffer.toString();
    }

    public static int[] getExpectedVtiColumnTypes(String string, int n2) {
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = 12;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            int n3 = string2.indexOf(":");
            int n4 = Integer.parseInt(string2.substring(6, n3));
            int n5 = Integer.parseInt(string2.substring(n3 + 1));
            if (n4 > n2) continue;
            nArray[n4 - 1] = n5;
        }
        return nArray;
    }

    public static String[] getExpectedColumnTypeNames(String string, int n2) throws Exception {
        ArrayList arrayList = (ArrayList)ImportAbstract.destringifyObject(string);
        String[] stringArray = new String[arrayList.size()];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = (String)arrayList.get(i2);
        }
        return stringArray;
    }

    public static HashMap getExpectedUDTClasses(String string) throws Exception {
        HashMap hashMap = ColumnInfo.deserializeHashMap(string);
        if (hashMap == null) {
            return null;
        }
        HashMap hashMap2 = new HashMap();
        for (Map.Entry entry : hashMap.entrySet()) {
            String string2 = (String)entry.getKey();
            String string3 = (String)entry.getValue();
            Class<?> clazz = Class.forName(string3);
            hashMap2.put(string2, clazz);
        }
        return hashMap2;
    }

    public static HashMap deserializeHashMap(String string) throws Exception {
        if (string == null) {
            return null;
        }
        HashMap hashMap = (HashMap)ImportAbstract.destringifyObject(string);
        return hashMap;
    }
}

