/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc.authentication;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.derby.authentication.UserAuthenticator;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.sql.dictionary.PasswordHasher;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.impl.jdbc.authentication.AuthenticationServiceBase;

public final class BasicAuthenticationServiceImpl
extends AuthenticationServiceBase
implements UserAuthenticator {
    @Override
    public boolean canSupport(Properties properties) {
        if (!this.requireAuthentication(properties)) {
            return false;
        }
        String string = PropertyUtil.getPropertyFromSet(properties, "derby.authentication.provider");
        return string == null || string.length() == 0 || StringUtil.SQLEqualsIgnoreCase(string, "BUILTIN");
    }

    @Override
    public void boot(boolean bl2, Properties properties) throws StandardException {
        super.boot(bl2, properties);
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            messageDigest.reset();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw Monitor.exceptionStartingModule(noSuchAlgorithmException);
        }
        this.setAuthenticationService(this);
    }

    @Override
    public boolean authenticateUser(String string, String string2, String string3, Properties properties) throws SQLException {
        boolean bl2;
        String string4;
        String string5 = null;
        int n2 = 0;
        if (string == null) {
            return false;
        }
        String string6 = null;
        String string7 = null;
        string5 = properties.getProperty("drdaSecMec");
        if (string5 != null) {
            n2 = Integer.parseInt(string5);
        }
        if ((string6 = this.getDatabaseProperty(string4 = "derby.user.".concat(string))) != null) {
            if (n2 != 8) {
                try {
                    string7 = this.hashPasswordUsingStoredAlgorithm(string, string2, string6);
                }
                catch (StandardException standardException) {
                    throw Util.generateCsSQLException(standardException);
                }
            } else {
                string6 = this.substitutePassword(string, string6, properties, true);
                string7 = string2;
            }
        } else {
            try {
                Properties properties2 = this.getDatabaseProperties();
                if (properties2 != null) {
                    this.hashUsingDefaultAlgorithm(string, string2, properties2);
                }
            }
            catch (StandardException standardException) {
                throw Util.generateCsSQLException(standardException);
            }
            string6 = this.getSystemProperty(string4);
            string7 = string2;
            if (string6 != null && n2 == 8) {
                string6 = this.substitutePassword(string, string6, properties, false);
            }
        }
        boolean bl3 = bl2 = string6 != null && string6.equals(string7);
        if (!bl2 && n2 == 8) {
            throw Util.generateCsSQLException("08004.C.12", new Object[0]);
        }
        return bl2;
    }

    private String hashPasswordUsingStoredAlgorithm(String string, String string2, String string3) throws StandardException {
        if (string3.startsWith("3b60")) {
            return this.hashPasswordSHA1Scheme(string2);
        }
        PasswordHasher passwordHasher = new PasswordHasher(string3);
        return passwordHasher.hashAndEncode(string, string2);
    }
}

