/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import org.apache.derby.iapi.jdbc.EngineLOB;
import org.apache.derby.impl.jdbc.EmbedBlob;
import org.apache.derby.impl.jdbc.EmbedClob;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.jdbc.InternalDriver;

public class LOBStoredProcedure {
    public static int CLOBCREATELOCATOR() throws SQLException {
        EngineLOB engineLOB = (EngineLOB)((Object)LOBStoredProcedure.getEmbedConnection().createClob());
        return engineLOB.getLocator();
    }

    public static void CLOBRELEASELOCATOR(int n2) throws SQLException {
        Clob clob = (Clob)LOBStoredProcedure.getEmbedConnection().getLOBMapping(n2);
        if (clob == null) {
            return;
        }
        EmbedClob embedClob = (EmbedClob)clob;
        embedClob.free();
        LOBStoredProcedure.getEmbedConnection().removeLOBMapping(n2);
    }

    public static long CLOBGETPOSITIONFROMSTRING(int n2, String string, long l2) throws SQLException {
        return LOBStoredProcedure.getClobObjectCorrespondingtoLOCATOR(n2).position(string, l2);
    }

    public static long CLOBGETPOSITIONFROMLOCATOR(int n2, int n3, long l2) throws SQLException {
        return LOBStoredProcedure.getClobObjectCorrespondingtoLOCATOR(n2).position(LOBStoredProcedure.getClobObjectCorrespondingtoLOCATOR(n3), l2);
    }

    public static long CLOBGETLENGTH(int n2) throws SQLException {
        return LOBStoredProcedure.getClobObjectCorrespondingtoLOCATOR(n2).length();
    }

    public static String CLOBGETSUBSTRING(int n2, long l2, int n3) throws SQLException {
        n3 = Math.min(n3, 10890);
        return LOBStoredProcedure.getClobObjectCorrespondingtoLOCATOR(n2).getSubString(l2, n3);
    }

    public static void CLOBSETSTRING(int n2, long l2, int n3, String string) throws SQLException {
        LOBStoredProcedure.getClobObjectCorrespondingtoLOCATOR(n2).setString(l2, string, 0, n3);
    }

    public static void CLOBTRUNCATE(int n2, long l2) throws SQLException {
        LOBStoredProcedure.getClobObjectCorrespondingtoLOCATOR(n2).truncate(l2);
    }

    private static Clob getClobObjectCorrespondingtoLOCATOR(int n2) throws SQLException {
        Clob clob = (Clob)LOBStoredProcedure.getEmbedConnection().getLOBMapping(n2);
        if (clob == null) {
            throw LOBStoredProcedure.newSQLException("XJ217.S");
        }
        return clob;
    }

    public static int BLOBCREATELOCATOR() throws SQLException {
        EngineLOB engineLOB = (EngineLOB)((Object)LOBStoredProcedure.getEmbedConnection().createBlob());
        return engineLOB.getLocator();
    }

    public static void BLOBRELEASELOCATOR(int n2) throws SQLException {
        Blob blob = (Blob)LOBStoredProcedure.getEmbedConnection().getLOBMapping(n2);
        if (blob == null) {
            return;
        }
        EmbedBlob embedBlob = (EmbedBlob)blob;
        embedBlob.free();
        LOBStoredProcedure.getEmbedConnection().removeLOBMapping(n2);
    }

    public static long BLOBGETPOSITIONFROMLOCATOR(int n2, int n3, long l2) throws SQLException {
        return LOBStoredProcedure.getBlobObjectCorrespondingtoLOCATOR(n2).position(LOBStoredProcedure.getBlobObjectCorrespondingtoLOCATOR(n3), l2);
    }

    public static long BLOBGETPOSITIONFROMBYTES(int n2, byte[] byArray, long l2) throws SQLException {
        return LOBStoredProcedure.getBlobObjectCorrespondingtoLOCATOR(n2).position(byArray, l2);
    }

    public static long BLOBGETLENGTH(int n2) throws SQLException {
        return LOBStoredProcedure.getBlobObjectCorrespondingtoLOCATOR(n2).length();
    }

    public static byte[] BLOBGETBYTES(int n2, long l2, int n3) throws SQLException {
        n3 = Math.min(n3, 32672);
        return LOBStoredProcedure.getBlobObjectCorrespondingtoLOCATOR(n2).getBytes(l2, n3);
    }

    public static void BLOBSETBYTES(int n2, long l2, int n3, byte[] byArray) throws SQLException {
        LOBStoredProcedure.getBlobObjectCorrespondingtoLOCATOR(n2).setBytes(l2, byArray, 0, n3);
    }

    public static void BLOBTRUNCATE(int n2, long l2) throws SQLException {
        LOBStoredProcedure.getBlobObjectCorrespondingtoLOCATOR(n2).truncate(l2);
    }

    private static Blob getBlobObjectCorrespondingtoLOCATOR(int n2) throws SQLException {
        Blob blob = (Blob)LOBStoredProcedure.getEmbedConnection().getLOBMapping(n2);
        if (blob == null) {
            throw LOBStoredProcedure.newSQLException("XJ217.S");
        }
        return blob;
    }

    private static EmbedConnection getEmbedConnection() throws SQLException {
        EmbedConnection embedConnection;
        InternalDriver internalDriver = InternalDriver.activeDriver();
        if (internalDriver != null && (embedConnection = (EmbedConnection)internalDriver.connect("jdbc:default:connection", null, 0)) != null) {
            return embedConnection;
        }
        throw Util.noCurrentConnection();
    }

    private static SQLException newSQLException(String string) {
        return Util.generateCsSQLException(string, new Object[0]);
    }
}

