/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.derby.iapi.error.ExceptionUtil;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.types.PositionedStream;
import org.apache.derby.impl.jdbc.LOBStreamControl;
import org.apache.derby.impl.jdbc.Util;

public class LOBInputStream
extends InputStream
implements PositionedStream {
    private boolean closed = false;
    private final LOBStreamControl control;
    private long pos;
    private long updateCount;

    LOBInputStream(LOBStreamControl lOBStreamControl, long l2) {
        this.control = lOBStreamControl;
        this.pos = l2;
        this.updateCount = lOBStreamControl.getUpdateCount();
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (this.closed) {
            throw new IOException(MessageService.getTextMessage("J104", new Object[0]));
        }
        try {
            int n4 = this.control.read(byArray, n2, n3, this.pos);
            if (n4 != -1) {
                this.pos += (long)n4;
                return n4;
            }
            return -1;
        }
        catch (StandardException standardException) {
            String string = standardException.getSQLState();
            if (string.equals(ExceptionUtil.getSQLStateFromIdentifier("XJ076.S"))) {
                return -1;
            }
            if (string.equals(ExceptionUtil.getSQLStateFromIdentifier("XJ078.S"))) {
                throw new ArrayIndexOutOfBoundsException(standardException.getMessage());
            }
            throw Util.newIOException(standardException);
        }
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            throw new IOException(MessageService.getTextMessage("J104", new Object[0]));
        }
        try {
            int n2 = this.control.read(this.pos);
            if (n2 != -1) {
                ++this.pos;
            }
            return n2;
        }
        catch (StandardException standardException) {
            throw Util.newIOException(standardException);
        }
    }

    boolean isObsolete() {
        return this.updateCount != this.control.getUpdateCount();
    }

    void reInitialize() {
        this.updateCount = this.control.getUpdateCount();
        this.pos = 0L;
    }

    long length() throws IOException {
        return this.control.getLength();
    }

    @Override
    public InputStream asInputStream() {
        return this;
    }

    @Override
    public long getPosition() {
        return this.pos;
    }

    @Override
    public void reposition(long l2) throws IOException {
        if (l2 > this.length()) {
            this.pos = 0L;
            throw new EOFException();
        }
        this.pos = l2;
    }
}

