/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.store.raw.data.DataFactory;
import org.apache.derby.impl.jdbc.LOBFile;
import org.apache.derby.io.StorageFile;

class EncryptedLOBFile
extends LOBFile {
    private final int blockSize;
    private final byte[] tail;
    private int tailSize;
    private long currentPos;
    private final DataFactory df;

    EncryptedLOBFile(StorageFile storageFile, DataFactory dataFactory) throws FileNotFoundException {
        super(storageFile);
        this.df = dataFactory;
        this.blockSize = dataFactory.getEncryptionBlockSize();
        this.tail = new byte[this.blockSize];
        this.tailSize = 0;
    }

    private byte[] getBlocks(long l2, int n2) throws IOException, StandardException {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException(MessageService.getTextMessage("XJ071.S", n2));
        }
        long l3 = l2 - l2 % (long)this.blockSize;
        long l4 = (l2 + (long)n2 + (long)this.blockSize - 1L) / (long)this.blockSize * (long)this.blockSize;
        byte[] byArray = new byte[(int)(l4 - l3)];
        super.seek(l3);
        super.read(byArray, 0, byArray.length);
        return byArray;
    }

    @Override
    long length() throws IOException {
        return super.length() + (long)this.tailSize;
    }

    @Override
    long getFilePointer() {
        return this.currentPos;
    }

    @Override
    void seek(long l2) throws IOException {
        long l3 = super.length();
        if (l2 > l3 + (long)this.tailSize) {
            throw new IllegalArgumentException("Internal Error");
        }
        if (l2 < l3) {
            super.seek(l2);
        }
        this.currentPos = l2;
    }

    @Override
    void write(int n2) throws IOException, StandardException {
        long l2 = super.length();
        if (this.currentPos >= l2) {
            int n3 = (int)(this.currentPos - l2);
            this.tail[n3] = (byte)n2;
            if (n3 >= this.tailSize) {
                this.tailSize = n3 + 1;
            }
            if (this.tailSize == this.blockSize) {
                byte[] byArray = new byte[this.blockSize];
                this.df.encrypt(this.tail, 0, this.tailSize, byArray, 0, false);
                super.seek(l2);
                super.write(byArray);
                this.tailSize = 0;
            }
        } else {
            byte[] byArray = this.getBlocks(this.currentPos, 1);
            byte[] byArray2 = new byte[this.blockSize];
            this.df.decrypt(byArray, 0, this.blockSize, byArray2, 0);
            byArray2[(int)(this.currentPos % (long)this.blockSize)] = (byte)n2;
            this.df.encrypt(byArray2, 0, this.blockSize, byArray, 0, false);
            super.seek(this.currentPos - this.currentPos % (long)this.blockSize);
            super.write(byArray);
        }
        ++this.currentPos;
    }

    @Override
    void write(byte[] byArray, int n2, int n3) throws IOException, StandardException {
        int n4;
        byte[] byArray2;
        int n5;
        long l2 = super.length();
        if (this.currentPos < l2) {
            int n6;
            n5 = (int)Math.max(0L, this.currentPos + (long)n3 - l2);
            long l3 = this.currentPos;
            byte[] byArray3 = this.getBlocks(this.currentPos, n3 - n5);
            byArray2 = new byte[byArray3.length];
            for (n6 = 0; n6 < byArray3.length / this.blockSize; ++n6) {
                this.df.decrypt(byArray3, n6 * this.blockSize, this.blockSize, byArray2, n6 * this.blockSize);
            }
            System.arraycopy(byArray, n2, byArray2, (int)(this.currentPos % (long)this.blockSize), n3 - n5);
            for (n6 = 0; n6 < byArray3.length / this.blockSize; ++n6) {
                this.df.encrypt(byArray2, n6 * this.blockSize, this.blockSize, byArray3, n6 * this.blockSize, false);
            }
            super.seek(l3 - l3 % (long)this.blockSize);
            super.write(byArray3);
            this.currentPos = l3 + (long)byArray3.length;
            if (n5 == 0) {
                return;
            }
            n2 = n2 + n3 - n5;
            n3 = n5;
            this.currentPos = l2;
        }
        if ((n4 = (n5 = (int)(this.currentPos - l2)) + n3) < this.blockSize) {
            System.arraycopy(byArray, n2, this.tail, n5, n3);
            this.tailSize = Math.max(this.tailSize, n5 + n3);
            this.currentPos += (long)n3;
            return;
        }
        int n7 = n4 - n4 % this.blockSize;
        int n8 = n4 % this.blockSize;
        byArray2 = new byte[n7];
        System.arraycopy(this.tail, 0, byArray2, 0, n5);
        System.arraycopy(byArray, n2, byArray2, n5, n7 - n5);
        byte[] byArray4 = new byte[byArray2.length];
        for (int i2 = 0; i2 < byArray4.length; i2 += this.blockSize) {
            this.df.encrypt(byArray2, i2, this.blockSize, byArray4, i2, false);
        }
        super.seek(l2);
        super.write(byArray4);
        System.arraycopy(byArray, n2 + n3 - n8, this.tail, 0, n8);
        this.tailSize = n8;
        this.currentPos = (long)this.tailSize + l2 + (long)byArray4.length;
    }

    @Override
    void write(byte[] byArray) throws IOException, StandardException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    int readByte() throws IOException, StandardException {
        long l2 = super.length();
        if (this.currentPos >= l2 + (long)this.tailSize) {
            throw new EOFException();
        }
        if (this.currentPos >= l2) {
            return this.tail[(int)(this.currentPos++ - l2)] & 0xFF;
        }
        byte[] byArray = this.getBlocks(this.currentPos, 1);
        byte[] byArray2 = new byte[byArray.length];
        this.df.decrypt(byArray, 0, byArray.length, byArray2, 0);
        return byArray2[(int)(this.currentPos++ % (long)this.blockSize)] & 0xFF;
    }

    @Override
    int read(byte[] byArray, int n2, int n3) throws IOException, StandardException {
        long l2 = super.length();
        if (this.currentPos < l2) {
            int n4;
            int n5 = (int)Math.max(0L, this.currentPos + (long)n3 - l2);
            byte[] byArray2 = this.getBlocks(this.currentPos, n3 - n5);
            byte[] byArray3 = new byte[byArray2.length];
            for (n4 = 0; n4 < byArray2.length; n4 += this.blockSize) {
                this.df.decrypt(byArray2, n4, this.blockSize, byArray3, n4);
            }
            System.arraycopy(byArray3, (int)(this.currentPos % (long)this.blockSize), byArray, n2, n3 - n5);
            if (n5 == 0) {
                this.currentPos += (long)n3;
                return n3;
            }
            n4 = Math.min(n5, this.tailSize);
            System.arraycopy(this.tail, 0, byArray, n2 + n3 - n5, n4);
            this.currentPos += (long)(n3 - n5 + n4);
            return n3 - n5 + n4;
        }
        int n6 = (int)Math.min((long)this.tailSize - this.currentPos + l2, (long)n3);
        if (n6 == 0 && n3 != 0) {
            return -1;
        }
        System.arraycopy(this.tail, (int)(this.currentPos - l2), byArray, n2, n6);
        this.currentPos += (long)n6;
        return n6;
    }

    @Override
    void setLength(long l2) throws IOException, StandardException {
        long l3 = super.length();
        if (l2 > l3 + (long)this.tailSize) {
            throw new IllegalArgumentException("Internal Error");
        }
        if (l2 < l3) {
            byte[] byArray = this.getBlocks(l2, 1);
            super.setLength(l2 - l2 % (long)this.blockSize);
            this.df.decrypt(byArray, 0, this.blockSize, this.tail, 0);
            this.tailSize = (int)(l2 % (long)this.blockSize);
        } else {
            this.tailSize = (int)(l2 - l3);
        }
    }
}

