/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.derby.iapi.services.io.ArrayUtil;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataTypeUtilities;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.impl.sql.GenericColumnDescriptor;

public class EmbedResultSetMetaData
implements ResultSetMetaData {
    private final ResultColumnDescriptor[] columnInfo;

    public EmbedResultSetMetaData(ResultColumnDescriptor[] resultColumnDescriptorArray) {
        this.columnInfo = ArrayUtil.copy(resultColumnDescriptorArray);
    }

    @Override
    public final int getColumnCount() {
        return this.columnInfo.length;
    }

    @Override
    public final boolean isAutoIncrement(int n2) throws SQLException {
        this.validColumnNumber(n2);
        ResultColumnDescriptor resultColumnDescriptor = this.columnInfo[n2 - 1];
        return resultColumnDescriptor.isAutoincrement();
    }

    @Override
    public final boolean isCaseSensitive(int n2) throws SQLException {
        return DataTypeUtilities.isCaseSensitive(this.getColumnTypeDescriptor(n2));
    }

    @Override
    public final boolean isSearchable(int n2) throws SQLException {
        this.validColumnNumber(n2);
        return true;
    }

    @Override
    public final boolean isCurrency(int n2) throws SQLException {
        return false;
    }

    @Override
    public final int isNullable(int n2) throws SQLException {
        return DataTypeUtilities.isNullable(this.getColumnTypeDescriptor(n2));
    }

    @Override
    public final boolean isSigned(int n2) throws SQLException {
        return DataTypeUtilities.isSigned(this.getColumnTypeDescriptor(n2));
    }

    @Override
    public final int getColumnDisplaySize(int n2) throws SQLException {
        return DataTypeUtilities.getColumnDisplaySize(this.getColumnTypeDescriptor(n2));
    }

    @Override
    public final String getColumnLabel(int n2) throws SQLException {
        ResultColumnDescriptor resultColumnDescriptor = this.columnInfo[n2 - 1];
        String string = resultColumnDescriptor.getName();
        return string == null ? "Column" + Integer.toString(n2) : string;
    }

    @Override
    public final String getColumnName(int n2) throws SQLException {
        ResultColumnDescriptor resultColumnDescriptor = this.columnInfo[n2 - 1];
        String string = resultColumnDescriptor.getName();
        return string == null ? "" : string;
    }

    @Override
    public final String getSchemaName(int n2) throws SQLException {
        ResultColumnDescriptor resultColumnDescriptor = this.columnInfo[n2 - 1];
        String string = resultColumnDescriptor.getSourceSchemaName();
        return string == null ? "" : string;
    }

    @Override
    public final int getPrecision(int n2) throws SQLException {
        return DataTypeUtilities.getDigitPrecision(this.getColumnTypeDescriptor(n2));
    }

    @Override
    public final int getScale(int n2) throws SQLException {
        DataTypeDescriptor dataTypeDescriptor = this.getColumnTypeDescriptor(n2);
        return dataTypeDescriptor.getScale();
    }

    @Override
    public final String getTableName(int n2) throws SQLException {
        ResultColumnDescriptor resultColumnDescriptor = this.columnInfo[n2 - 1];
        String string = resultColumnDescriptor.getSourceTableName();
        return string == null ? "" : string;
    }

    @Override
    public final String getCatalogName(int n2) throws SQLException {
        this.validColumnNumber(n2);
        return "";
    }

    @Override
    public final int getColumnType(int n2) throws SQLException {
        DataTypeDescriptor dataTypeDescriptor = this.getColumnTypeDescriptor(n2);
        return dataTypeDescriptor.getTypeId().getJDBCTypeId();
    }

    @Override
    public final String getColumnTypeName(int n2) throws SQLException {
        DataTypeDescriptor dataTypeDescriptor = this.getColumnTypeDescriptor(n2);
        return dataTypeDescriptor.getTypeId().getSQLTypeName();
    }

    @Override
    public final boolean isReadOnly(int n2) throws SQLException {
        this.validColumnNumber(n2);
        return false;
    }

    @Override
    public final boolean isWritable(int n2) throws SQLException {
        this.validColumnNumber(n2);
        return this.columnInfo[n2 - 1].updatableByCursor();
    }

    @Override
    public final boolean isDefinitelyWritable(int n2) throws SQLException {
        this.validColumnNumber(n2);
        return false;
    }

    private void validColumnNumber(int n2) throws SQLException {
        if (n2 < 1 || n2 > this.getColumnCount()) {
            throw Util.generateCsSQLException("S0022", n2);
        }
    }

    private DataTypeDescriptor getColumnTypeDescriptor(int n2) throws SQLException {
        this.validColumnNumber(n2);
        ResultColumnDescriptor resultColumnDescriptor = this.columnInfo[n2 - 1];
        return resultColumnDescriptor.getType();
    }

    @Override
    public final String getColumnClassName(int n2) throws SQLException {
        return this.getColumnTypeDescriptor(n2).getTypeId().getResultSetMetaDataTypeName();
    }

    public static ResultColumnDescriptor getResultColumnDescriptor(String string, int n2, boolean bl2) {
        return new GenericColumnDescriptor(string, DataTypeDescriptor.getBuiltInDataTypeDescriptor(n2, bl2));
    }

    public static ResultColumnDescriptor getResultColumnDescriptor(String string, int n2, boolean bl2, int n3) {
        return new GenericColumnDescriptor(string, DataTypeDescriptor.getBuiltInDataTypeDescriptor(n2, bl2, n3));
    }

    public static ResultColumnDescriptor getResultColumnDescriptor(String string, DataTypeDescriptor dataTypeDescriptor) {
        return new GenericColumnDescriptor(string, dataTypeDescriptor);
    }

    @Override
    public final boolean isWrapperFor(Class<?> clazz) {
        return clazz.isInstance(this);
    }

    @Override
    public final <T> T unwrap(Class<T> clazz) throws SQLException {
        try {
            return clazz.cast(this);
        }
        catch (ClassCastException classCastException) {
            throw Util.generateCsSQLException("XJ128.S", clazz);
        }
    }
}

