/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Map;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.CharacterStreamDescriptor;
import org.apache.derby.iapi.jdbc.EngineResultSet;
import org.apache.derby.iapi.services.io.CloseFilterInputStream;
import org.apache.derby.iapi.services.io.LimitInputStream;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ParameterValueSet;
import org.apache.derby.iapi.sql.PreparedStatement;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.sql.execute.CursorActivation;
import org.apache.derby.iapi.sql.execute.ExecCursorTableReference;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RawToBinaryFormatStream;
import org.apache.derby.iapi.types.ReaderToUTF8Stream;
import org.apache.derby.iapi.types.SQLDecimal;
import org.apache.derby.iapi.types.StringDataValue;
import org.apache.derby.iapi.types.UserDataValue;
import org.apache.derby.iapi.types.VariableSizeDataValue;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.iapi.util.InterruptStatus;
import org.apache.derby.impl.jdbc.BinaryToRawStream;
import org.apache.derby.impl.jdbc.ConnectionChild;
import org.apache.derby.impl.jdbc.EmbedBlob;
import org.apache.derby.impl.jdbc.EmbedClob;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.EmbedStatement;
import org.apache.derby.impl.jdbc.ReaderToAscii;
import org.apache.derby.impl.jdbc.TransactionResourceImpl;
import org.apache.derby.impl.jdbc.UTF8Reader;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.impl.sql.execute.ScrollInsensitiveResultSet;

public class EmbedResultSet
extends ConnectionChild
implements Comparable,
EngineResultSet {
    private static long fetchedRowBase = 0L;
    protected static final int FIRST = 1;
    protected static final int NEXT = 2;
    protected static final int LAST = 3;
    protected static final int PREVIOUS = 4;
    protected static final int BEFOREFIRST = 5;
    protected static final int AFTERLAST = 6;
    protected static final int ABSOLUTE = 7;
    protected static final int RELATIVE = 8;
    private ExecRow currentRow;
    protected boolean wasNull;
    boolean isClosed;
    private boolean isOnInsertRow;
    private Object currentStream;
    private ResultSet theResults;
    private boolean forMetaData;
    private SQLWarning topWarning;
    Activation singleUseActivation;
    final int order;
    private final ResultDescription resultDescription;
    private long maxRows;
    private final int maxFieldSize;
    private long NumberofFetchedRows = fetchedRowBase;
    private final EmbedStatement stmt;
    private EmbedStatement owningStmt;
    private Statement applicationStmt;
    private final long timeoutMillis;
    private final boolean isAtomic;
    private final int concurrencyOfThisResultSet;
    private final ExecRow updateRow;
    private boolean[] columnGotUpdated;
    private boolean currentRowHasBeenUpdated;
    private int fetchDirection;
    private int fetchSize;
    private boolean[] columnUsedFlags;

    public EmbedResultSet(EmbedConnection embedConnection, ResultSet resultSet, boolean bl2, EmbedStatement embedStatement, boolean bl3) throws SQLException {
        super(embedConnection);
        this.theResults = resultSet;
        this.forMetaData = bl2;
        if (this.forMetaData) {
            this.singleUseActivation = resultSet.getActivation();
        }
        this.stmt = this.owningStmt = embedStatement;
        this.applicationStmt = this.owningStmt;
        this.timeoutMillis = embedStatement == null ? 0L : embedStatement.timeoutMillis;
        this.isAtomic = bl3;
        if (embedStatement == null) {
            this.concurrencyOfThisResultSet = 1007;
        } else if (embedStatement.resultSetConcurrency == 1007) {
            this.concurrencyOfThisResultSet = 1007;
        } else if (!this.isForUpdate()) {
            this.concurrencyOfThisResultSet = 1007;
            SQLWarning sQLWarning = StandardException.newWarning("01J06", new Object[0]);
            this.addWarning(sQLWarning);
        } else {
            this.concurrencyOfThisResultSet = 1008;
        }
        this.resultDescription = this.theResults.getResultDescription();
        if (this.concurrencyOfThisResultSet == 1008) {
            int n2 = this.resultDescription.getColumnCount();
            ExecutionFactory executionFactory = this.getLanguageConnectionContext(embedConnection).getLanguageConnectionFactory().getExecutionFactory();
            try {
                this.columnGotUpdated = new boolean[n2];
                this.updateRow = executionFactory.getValueRow(n2);
                for (int i2 = 1; i2 <= n2; ++i2) {
                    this.updateRow.setColumn(i2, this.resultDescription.getColumnDescriptor(i2).getType().getNull());
                }
                this.initializeUpdateRowModifiers();
            }
            catch (StandardException standardException) {
                throw EmbedResultSet.noStateChangeException(standardException);
            }
        } else {
            this.updateRow = null;
        }
        if (embedStatement != null) {
            if (embedStatement.resultSetType == 1003) {
                this.maxRows = embedStatement.maxRows;
            }
            this.maxFieldSize = embedStatement.MaxFieldSize;
        } else {
            this.maxFieldSize = 0;
        }
        this.order = embedConnection.getResultSetOrderId();
    }

    public static void setFetchedRowBase(long l2) {
    }

    private void checkNotOnInsertRow() throws SQLException {
        if (this.isOnInsertRow) {
            throw EmbedResultSet.newSQLException("24000", new Object[0]);
        }
    }

    protected final void checkOnRow() throws SQLException {
        if (this.currentRow == null) {
            throw EmbedResultSet.newSQLException("24000", new Object[0]);
        }
    }

    private void initializeUpdateRowModifiers() {
        this.currentRowHasBeenUpdated = false;
        Arrays.fill(this.columnGotUpdated, false);
    }

    final int getColumnType(int n2) throws SQLException {
        if (!this.isOnInsertRow) {
            this.checkOnRow();
        }
        if (n2 < 1 || n2 > this.resultDescription.getColumnCount()) {
            throw EmbedResultSet.newSQLException("S0022", n2);
        }
        return this.resultDescription.getColumnDescriptor(n2).getType().getJDBCTypeId();
    }

    @Override
    public boolean next() throws SQLException {
        if (this.maxRows != 0L) {
            ++this.NumberofFetchedRows;
            if (this.NumberofFetchedRows > this.maxRows) {
                this.closeCurrentStream();
                return false;
            }
        }
        return this.movePosition(2, 0, "next");
    }

    protected boolean movePosition(int n2, String string) throws SQLException {
        return this.movePosition(n2, 0, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean movePosition(int n2, int n3, String string) throws SQLException {
        this.closeCurrentStream();
        this.checkExecIfClosed(string);
        if (this.isOnInsertRow) {
            this.moveToCurrentRow();
        }
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            boolean bl2;
            this.setupContextStack();
            try {
                boolean bl3;
                ExecRow execRow;
                Object object2;
                LanguageConnectionContext languageConnectionContext = this.getLanguageConnectionContext(this.getEmbedConnection());
                try {
                    object2 = languageConnectionContext.pushStatementContext(this.isAtomic, this.concurrencyOfThisResultSet == 1007, this.getSQLText(), this.getParameterValueSet(), false, this.timeoutMillis);
                    switch (n2) {
                        case 5: {
                            execRow = this.theResults.setBeforeFirstRow();
                            break;
                        }
                        case 1: {
                            execRow = this.theResults.getFirstRow();
                            break;
                        }
                        case 2: {
                            execRow = this.theResults.getNextRow();
                            break;
                        }
                        case 3: {
                            execRow = this.theResults.getLastRow();
                            break;
                        }
                        case 6: {
                            execRow = this.theResults.setAfterLastRow();
                            break;
                        }
                        case 4: {
                            execRow = this.theResults.getPreviousRow();
                            break;
                        }
                        case 7: {
                            execRow = this.theResults.getAbsoluteRow(n3);
                            break;
                        }
                        case 8: {
                            execRow = this.theResults.getRelativeRow(n3);
                            break;
                        }
                        default: {
                            execRow = null;
                        }
                    }
                    languageConnectionContext.popStatementContext((StatementContext)object2, null);
                    InterruptStatus.restoreIntrFlagIfSeen(languageConnectionContext);
                }
                catch (Throwable throwable) {
                    throw this.closeOnTransactionError(throwable);
                }
                object2 = this.theResults.getWarnings();
                if (object2 != null) {
                    this.addWarning((SQLWarning)object2);
                }
                boolean bl4 = bl3 = (this.currentRow = execRow) != null;
                if (!(bl3 || n2 != 2 || this.forMetaData && languageConnectionContext.getActivationCount() > 1 || this.owningStmt == null || this.owningStmt.getResultSetType() != 1003)) {
                    this.owningStmt.resultSetClosing(this);
                }
                if (this.columnUsedFlags != null) {
                    Arrays.fill(this.columnUsedFlags, false);
                }
                if (this.columnGotUpdated != null && this.currentRowHasBeenUpdated) {
                    this.initializeUpdateRowModifiers();
                }
                bl2 = bl3;
            }
            catch (Throwable throwable) {
                this.restoreContextStack();
                throw throwable;
            }
            this.restoreContextStack();
            return bl2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.closeCurrentStream();
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            try {
                this.setupContextStack();
            }
            catch (SQLException sQLException) {
                return;
            }
            try {
                LanguageConnectionContext languageConnectionContext = this.getLanguageConnectionContext(this.getEmbedConnection());
                try {
                    this.theResults.close();
                    if (this.singleUseActivation != null) {
                        this.singleUseActivation.close();
                        this.singleUseActivation = null;
                    }
                    InterruptStatus.restoreIntrFlagIfSeen(languageConnectionContext);
                }
                catch (Throwable throwable) {
                    throw this.handleException(throwable);
                }
                if (this.forMetaData) {
                    if (languageConnectionContext.getActivationCount() > 1) {
                    } else if (this.owningStmt != null) {
                        this.owningStmt.resultSetClosing(this);
                    }
                } else if (this.owningStmt != null) {
                    this.owningStmt.resultSetClosing(this);
                }
            }
            finally {
                this.markClosed();
                this.restoreContextStack();
            }
            this.currentRow = null;
        }
    }

    private void markClosed() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        if (this.stmt != null) {
            this.stmt.closeMeOnCompletion();
        }
        if (this.owningStmt != null && this.owningStmt != this.stmt) {
            this.owningStmt.closeMeOnCompletion();
        }
    }

    @Override
    public final boolean wasNull() throws SQLException {
        this.checkIfClosed("wasNull");
        return this.wasNull;
    }

    @Override
    public final String getString(int n2) throws SQLException {
        this.checkIfClosed("getString");
        int n3 = this.getColumnType(n2);
        if (n3 == 2004 || n3 == 2005) {
            this.checkLOBMultiCall(n2);
        }
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n2);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return null;
            }
            String string = dataValueDescriptor.getString();
            if (this.maxFieldSize > 0 && EmbedResultSet.isMaxFieldSizeType(n3) && string.length() > this.maxFieldSize) {
                string = string.substring(0, this.maxFieldSize);
            }
            return string;
        }
        catch (Throwable throwable) {
            throw EmbedResultSet.noStateChangeException(throwable);
        }
    }

    @Override
    public final boolean getBoolean(int n2) throws SQLException {
        this.checkIfClosed("getBoolean");
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n2);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return false;
            }
            return dataValueDescriptor.getBoolean();
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    @Override
    public final byte getByte(int n2) throws SQLException {
        this.checkIfClosed("getByte");
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n2);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return 0;
            }
            return dataValueDescriptor.getByte();
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    @Override
    public final short getShort(int n2) throws SQLException {
        this.checkIfClosed("getShort");
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n2);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return 0;
            }
            return dataValueDescriptor.getShort();
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    @Override
    public final int getInt(int n2) throws SQLException {
        this.checkIfClosed("getInt");
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n2);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return 0;
            }
            return dataValueDescriptor.getInt();
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    @Override
    public final long getLong(int n2) throws SQLException {
        this.checkIfClosed("getLong");
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n2);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return 0L;
            }
            return dataValueDescriptor.getLong();
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    @Override
    public final float getFloat(int n2) throws SQLException {
        this.checkIfClosed("getFloat");
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n2);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return 0.0f;
            }
            return dataValueDescriptor.getFloat();
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    @Override
    public final double getDouble(int n2) throws SQLException {
        this.checkIfClosed("getDouble");
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n2);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return 0.0;
            }
            return dataValueDescriptor.getDouble();
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    @Override
    public final byte[] getBytes(int n2) throws SQLException {
        this.checkIfClosed("getBytes");
        int n3 = this.getColumnType(n2);
        if (n3 == 2004) {
            this.checkLOBMultiCall(n2);
        }
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n2);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return null;
            }
            byte[] byArray = dataValueDescriptor.getBytes();
            if (this.maxFieldSize > 0 && EmbedResultSet.isMaxFieldSizeType(n3) && byArray.length > this.maxFieldSize) {
                byte[] byArray2 = new byte[this.maxFieldSize];
                System.arraycopy(byArray, 0, byArray2, 0, this.maxFieldSize);
                byArray = byArray2;
            }
            return byArray;
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    @Override
    public final Date getDate(int n2) throws SQLException {
        return this.getDate(n2, (Calendar)null);
    }

    @Override
    public final Time getTime(int n2) throws SQLException {
        return this.getTime(n2, (Calendar)null);
    }

    @Override
    public final Timestamp getTimestamp(int n2) throws SQLException {
        return this.getTimestamp(n2, (Calendar)null);
    }

    @Override
    public Date getDate(int n2, Calendar calendar) throws SQLException {
        this.checkIfClosed("getDate");
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n2);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return null;
            }
            if (calendar == null) {
                calendar = this.getCal();
            }
            return dataValueDescriptor.getDate(calendar);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        this.checkIfClosed("getDate");
        return this.getDate(this.findColumnName(string), calendar);
    }

    @Override
    public Time getTime(int n2, Calendar calendar) throws SQLException {
        this.checkIfClosed("getTime");
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n2);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return null;
            }
            if (calendar == null) {
                calendar = this.getCal();
            }
            return dataValueDescriptor.getTime(calendar);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        this.checkIfClosed("getTime");
        return this.getTime(this.findColumnName(string), calendar);
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        this.checkIfClosed("getTimestamp");
        return this.getTimestamp(this.findColumnName(string), calendar);
    }

    @Override
    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        this.checkIfClosed("getTimestamp");
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n2);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return null;
            }
            if (calendar == null) {
                calendar = this.getCal();
            }
            return dataValueDescriptor.getTimestamp(calendar);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final Reader getCharacterStream(int n2) throws SQLException {
        Object object;
        int n3;
        this.checkIfClosed("getCharacterStream");
        int n4 = this.getColumnType(n2);
        switch (n4) {
            case -1: 
            case 1: 
            case 12: {
                n3 = this.maxFieldSize;
                break;
            }
            case 2005: {
                n3 = 0;
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                try {
                    InputStream inputStream = this.getBinaryStream(n2);
                    if (inputStream == null) {
                        return null;
                    }
                    InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-16BE");
                    this.currentStream = inputStreamReader;
                    return inputStreamReader;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new SQLException(unsupportedEncodingException.getMessage());
                }
            }
            default: {
                throw this.dataTypeConversion("java.io.Reader", n2);
            }
        }
        Object object2 = object = this.getConnectionSynchronization();
        synchronized (object2) {
            boolean bl2 = false;
            try {
                Reader reader;
                Object object3;
                this.useStreamOrLOB(n2);
                StringDataValue stringDataValue = (StringDataValue)this.getColumn(n2);
                this.wasNull = stringDataValue.isNull();
                if (this.wasNull) {
                    Reader reader2 = null;
                    return reader2;
                }
                bl2 = true;
                this.setupContextStack();
                if (stringDataValue.hasStream()) {
                    object3 = stringDataValue.getStreamWithDescriptor();
                    if (n3 > 0) {
                        object3 = new CharacterStreamDescriptor.Builder().copyState((CharacterStreamDescriptor)object3).maxCharLength(n3).build();
                    }
                    reader = new UTF8Reader((CharacterStreamDescriptor)object3, this, object);
                } else {
                    object3 = stringDataValue.getString();
                    if (n3 > 0 && ((String)object3).length() > n3) {
                        object3 = ((String)object3).substring(0, n3);
                    }
                    reader = new StringReader((String)object3);
                }
                this.currentStream = reader;
                object3 = reader;
                return object3;
            }
            catch (Throwable throwable) {
                throw EmbedResultSet.noStateChangeException(throwable);
            }
            finally {
                if (bl2) {
                    this.restoreContextStack();
                }
            }
        }
    }

    @Override
    public final InputStream getAsciiStream(int n2) throws SQLException {
        this.checkIfClosed("getAsciiStream");
        int n3 = this.getColumnType(n2);
        switch (n3) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return this.getBinaryStream(n2);
            }
            default: {
                throw this.dataTypeConversion("java.io.InputStream(ASCII)", n2);
            }
        }
        Reader reader = this.getCharacterStream(n2);
        if (reader == null) {
            return null;
        }
        return new ReaderToAscii(reader);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final InputStream getBinaryStream(int n2) throws SQLException {
        Object object;
        int n3;
        this.checkIfClosed("getBinaryStream");
        int n4 = this.getColumnType(n2);
        switch (n4) {
            case -4: 
            case -3: 
            case -2: {
                n3 = this.maxFieldSize;
                break;
            }
            case 2004: {
                n3 = 0;
                break;
            }
            default: {
                throw this.dataTypeConversion("java.io.InputStream", n2);
            }
        }
        Object object2 = object = this.getConnectionSynchronization();
        synchronized (object2) {
            boolean bl2 = false;
            try {
                InputStream inputStream;
                this.useStreamOrLOB(n2);
                DataValueDescriptor dataValueDescriptor = this.getColumn(n2);
                this.wasNull = dataValueDescriptor.isNull();
                if (this.wasNull) {
                    InputStream inputStream2 = null;
                    return inputStream2;
                }
                bl2 = true;
                this.setupContextStack();
                InputStream inputStream3 = dataValueDescriptor.hasStream() ? new BinaryToRawStream(dataValueDescriptor.getStream(), dataValueDescriptor) : new ByteArrayInputStream(dataValueDescriptor.getBytes());
                if (n3 > 0) {
                    inputStream = new LimitInputStream(inputStream3);
                    inputStream.setLimit(n3);
                    inputStream3 = inputStream;
                }
                inputStream3 = new CloseFilterInputStream(inputStream3);
                this.currentStream = inputStream3;
                inputStream = inputStream3;
                return inputStream;
            }
            catch (Throwable throwable) {
                throw EmbedResultSet.noStateChangeException(throwable);
            }
            finally {
                if (bl2) {
                    this.restoreContextStack();
                }
            }
        }
    }

    @Override
    public final String getString(String string) throws SQLException {
        this.checkIfClosed("getString");
        return this.getString(this.findColumnName(string));
    }

    @Override
    public final boolean getBoolean(String string) throws SQLException {
        this.checkIfClosed("getBoolean");
        return this.getBoolean(this.findColumnName(string));
    }

    @Override
    public final byte getByte(String string) throws SQLException {
        this.checkIfClosed("getByte");
        return this.getByte(this.findColumnName(string));
    }

    @Override
    public final short getShort(String string) throws SQLException {
        this.checkIfClosed("getShort");
        return this.getShort(this.findColumnName(string));
    }

    @Override
    public final int getInt(String string) throws SQLException {
        this.checkIfClosed("getInt");
        return this.getInt(this.findColumnName(string));
    }

    @Override
    public final long getLong(String string) throws SQLException {
        this.checkIfClosed("getLong");
        return this.getLong(this.findColumnName(string));
    }

    @Override
    public final float getFloat(String string) throws SQLException {
        this.checkIfClosed("getFloat");
        return this.getFloat(this.findColumnName(string));
    }

    @Override
    public final double getDouble(String string) throws SQLException {
        this.checkIfClosed("getDouble");
        return this.getDouble(this.findColumnName(string));
    }

    @Override
    @Deprecated
    public final BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        BigDecimal bigDecimal = this.getBigDecimal(n2);
        if (bigDecimal != null) {
            return bigDecimal.setScale(n3, 5);
        }
        return null;
    }

    @Override
    public final BigDecimal getBigDecimal(int n2) throws SQLException {
        this.checkIfClosed("getBigDecimal");
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n2);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return null;
            }
            return SQLDecimal.getBigDecimal(dataValueDescriptor);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    @Override
    @Deprecated
    public final BigDecimal getBigDecimal(String string, int n2) throws SQLException {
        this.checkIfClosed("getBigDecimal");
        return this.getBigDecimal(this.findColumnName(string), n2);
    }

    @Override
    public final BigDecimal getBigDecimal(String string) throws SQLException {
        this.checkIfClosed("getBigDecimal");
        return this.getBigDecimal(this.findColumnName(string));
    }

    @Override
    public final byte[] getBytes(String string) throws SQLException {
        this.checkIfClosed("getBytes");
        return this.getBytes(this.findColumnName(string));
    }

    @Override
    public final Date getDate(String string) throws SQLException {
        this.checkIfClosed("getDate");
        return this.getDate(this.findColumnName(string));
    }

    @Override
    public final Time getTime(String string) throws SQLException {
        this.checkIfClosed("getTime");
        return this.getTime(this.findColumnName(string));
    }

    @Override
    public final Timestamp getTimestamp(String string) throws SQLException {
        this.checkIfClosed("getTimestamp");
        return this.getTimestamp(this.findColumnName(string));
    }

    @Override
    public final Reader getCharacterStream(String string) throws SQLException {
        this.checkIfClosed("getCharacterStream");
        return this.getCharacterStream(this.findColumnName(string));
    }

    @Override
    public final InputStream getAsciiStream(String string) throws SQLException {
        this.checkIfClosed("getAsciiStream");
        return this.getAsciiStream(this.findColumnName(string));
    }

    @Override
    public final InputStream getBinaryStream(String string) throws SQLException {
        this.checkIfClosed("getBinaryStream");
        return this.getBinaryStream(this.findColumnName(string));
    }

    @Override
    @Deprecated
    public final InputStream getUnicodeStream(int n2) throws SQLException {
        throw Util.notImplemented("getUnicodeStream");
    }

    @Override
    @Deprecated
    public final InputStream getUnicodeStream(String string) throws SQLException {
        throw Util.notImplemented("getUnicodeStream");
    }

    @Override
    public URL getURL(int n2) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public URL getURL(String string) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final SQLWarning getWarnings() throws SQLException {
        this.checkIfClosed("getWarnings");
        return this.topWarning;
    }

    @Override
    public final void clearWarnings() throws SQLException {
        this.checkIfClosed("clearWarnings");
        this.topWarning = null;
    }

    @Override
    public final String getCursorName() throws SQLException {
        this.checkIfClosed("getCursorName");
        return this.theResults.getCursorName();
    }

    @Override
    public final ResultSetMetaData getMetaData() throws SQLException {
        this.checkIfClosed("getMetaData");
        ResultSetMetaData resultSetMetaData = this.resultDescription.getMetaData();
        if (resultSetMetaData == null) {
            resultSetMetaData = this.factory.newEmbedResultSetMetaData(this.resultDescription.getColumnInfo());
            this.resultDescription.setMetaData(resultSetMetaData);
        }
        return resultSetMetaData;
    }

    @Override
    public final int getHoldability() throws SQLException {
        this.checkIfClosed("getHoldability");
        if (this.theResults.getActivation().getResultSetHoldability()) {
            return 1;
        }
        return 2;
    }

    @Override
    public final Object getObject(int n2) throws SQLException {
        this.checkIfClosed("getObject");
        int n3 = this.getColumnType(n2);
        switch (n3) {
            case -1: 
            case 1: 
            case 12: {
                return this.getString(n2);
            }
            case 2005: {
                return this.getClob(n2);
            }
            case -4: 
            case -3: 
            case -2: {
                return this.getBytes(n2);
            }
            case 2004: {
                return this.getBlob(n2);
            }
        }
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n2);
            this.wasNull = dataValueDescriptor.isNull();
            if (this.wasNull) {
                return null;
            }
            return dataValueDescriptor.getObject();
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    @Override
    public final Object getObject(String string) throws SQLException {
        this.checkIfClosed("getObject");
        return this.getObject(this.findColumnName(string));
    }

    @Override
    public Object getObject(int n2, Map<String, Class<?>> map) throws SQLException {
        this.checkIfClosed("getObject");
        if (map == null) {
            throw Util.generateCsSQLException("XJ081.S", map, "map", "java.sql.ResultSet.getObject");
        }
        if (!map.isEmpty()) {
            throw Util.notImplemented();
        }
        return this.getObject(n2);
    }

    @Override
    public Object getObject(String string, Map<String, Class<?>> map) throws SQLException {
        this.checkIfClosed("getObject");
        return this.getObject(this.findColumn(string), map);
    }

    @Override
    public final int findColumn(String string) throws SQLException {
        this.checkIfClosed("findColumn");
        return this.findColumnName(string);
    }

    @Override
    public final Statement getStatement() throws SQLException {
        this.checkIfClosed("getStatement");
        return this.applicationStmt;
    }

    public final void setApplicationStatement(Statement statement) {
        this.applicationStmt = statement;
    }

    @Override
    public final Ref getRef(int n2) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final Array getArray(int n2) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final Ref getRef(String string) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final Array getArray(String string) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.checkRowPosition(101, "isBeforeFirst");
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.checkRowPosition(104, "isAfterLast");
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.checkRowPosition(102, "isFirst");
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.checkRowPosition(103, "isLast");
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.checkScrollCursor("beforeFirst()");
        this.movePosition(5, "beforeFirst");
    }

    @Override
    public void afterLast() throws SQLException {
        this.checkScrollCursor("afterLast()");
        this.movePosition(6, "afterLast");
    }

    @Override
    public boolean first() throws SQLException {
        this.checkScrollCursor("first()");
        return this.movePosition(1, "first");
    }

    @Override
    public boolean last() throws SQLException {
        this.checkScrollCursor("last()");
        return this.movePosition(3, "last");
    }

    @Override
    public int getRow() throws SQLException {
        this.checkScrollCursor("getRow()");
        return this.theResults.getRowNumber();
    }

    @Override
    public boolean absolute(int n2) throws SQLException {
        this.checkScrollCursor("absolute()");
        return this.movePosition(7, n2, "absolute");
    }

    @Override
    public boolean relative(int n2) throws SQLException {
        this.checkScrollCursor("relative()");
        return this.movePosition(8, n2, "relative");
    }

    @Override
    public boolean previous() throws SQLException {
        this.checkScrollCursor("previous()");
        return this.movePosition(4, "previous");
    }

    @Override
    public void setFetchDirection(int n2) throws SQLException {
        this.checkScrollCursor("setFetchDirection()");
        this.fetchDirection = n2;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkIfClosed("getFetchDirection");
        if (this.fetchDirection == 0) {
            return this.stmt.getFetchDirection();
        }
        return this.fetchDirection;
    }

    @Override
    public void setFetchSize(int n2) throws SQLException {
        this.checkIfClosed("setFetchSize");
        if (n2 < 0) {
            throw Util.generateCsSQLException("XJ062.S", n2);
        }
        if (n2 > 0) {
            this.fetchSize = n2;
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkIfClosed("getFetchSize");
        if (this.fetchSize == 0) {
            return this.stmt.getFetchSize();
        }
        return this.fetchSize;
    }

    @Override
    public int getType() throws SQLException {
        this.checkIfClosed("getType");
        return this.stmt.getResultSetType();
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.checkIfClosed("getConcurrency");
        return this.concurrencyOfThisResultSet;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        this.checkIfClosed("rowUpdated");
        this.checkNotOnInsertRow();
        this.checkOnRow();
        boolean bl2 = false;
        try {
            if (this.isForUpdate() && this.getType() == 1004) {
                bl2 = ((ScrollInsensitiveResultSet)this.theResults).isUpdated();
            }
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
        return bl2;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        this.checkIfClosed("rowInserted");
        this.checkNotOnInsertRow();
        this.checkOnRow();
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        this.checkIfClosed("rowDeleted");
        this.checkNotOnInsertRow();
        this.checkOnRow();
        boolean bl2 = false;
        try {
            if (this.isForUpdate() && this.getType() == 1004) {
                bl2 = ((ScrollInsensitiveResultSet)this.theResults).isDeleted();
            }
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
        return bl2;
    }

    protected void checksBeforeUpdateXXX(String string, int n2) throws SQLException {
        this.checksBeforeUpdateOrDelete(string, n2);
        ResultDescription resultDescription = this.theResults.getResultDescription();
        if (n2 < 1 || n2 > resultDescription.getColumnCount()) {
            throw Util.generateCsSQLException("XCL14.S", n2, String.valueOf(resultDescription.getColumnCount()));
        }
        if (resultDescription.getColumnDescriptor(n2).getSourceTableName() == null) {
            throw Util.generateCsSQLException("XJ084.U", string);
        }
        if (!this.getMetaData().isWritable(n2)) {
            throw Util.generateCsSQLException("42X31", this.theResults.getResultDescription().getColumnDescriptor(n2).getName(), this.getCursorName());
        }
    }

    protected void checksBeforeUpdateOrDelete(String string, int n2) throws SQLException {
        this.checkIfClosed(string);
        this.checkUpdatableCursor(string);
        if (!this.isOnInsertRow) {
            this.checkOnRow();
        }
    }

    protected DataValueDescriptor getDVDforColumnToBeUpdated(int n2, String string) throws StandardException, SQLException {
        this.checksBeforeUpdateXXX(string, n2);
        this.columnGotUpdated[n2 - 1] = true;
        this.currentRowHasBeenUpdated = true;
        return this.updateRow.getColumn(n2);
    }

    protected void checksBeforeInsert() throws SQLException {
        this.checkIfClosed("insertRow");
        this.checkUpdatableCursor("insertRow");
        if (!this.isOnInsertRow) {
            throw EmbedResultSet.newSQLException("XJ086.S", new Object[0]);
        }
    }

    private void checksBeforeUpdateAsciiStream(int n2) throws SQLException {
        this.checksBeforeUpdateXXX("updateAsciiStream", n2);
        int n3 = this.getColumnType(n2);
        if (!DataTypeDescriptor.isAsciiStreamAssignable(n3)) {
            throw this.dataTypeConversion(n2, "java.io.InputStream");
        }
    }

    private void checksBeforeUpdateBinaryStream(int n2) throws SQLException {
        this.checksBeforeUpdateXXX("updateBinaryStream", n2);
        int n3 = this.getColumnType(n2);
        if (!DataTypeDescriptor.isBinaryStreamAssignable(n3)) {
            throw this.dataTypeConversion(n2, "java.io.InputStream");
        }
    }

    private void checksBeforeUpdateCharacterStream(int n2) throws SQLException {
        this.checksBeforeUpdateXXX("updateCharacterStream", n2);
        int n3 = this.getColumnType(n2);
        if (!DataTypeDescriptor.isCharacterStreamAssignable(n3)) {
            throw this.dataTypeConversion(n2, "java.io.Reader");
        }
    }

    @Override
    public void updateNull(int n2) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(n2, "updateNull").setToNull();
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    @Override
    public void updateBoolean(int n2, boolean bl2) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(n2, "updateBoolean").setValue(bl2);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    @Override
    public void updateByte(int n2, byte by) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(n2, "updateByte").setValue(by);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    @Override
    public void updateShort(int n2, short s2) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(n2, "updateShort").setValue(s2);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    @Override
    public void updateInt(int n2, int n3) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(n2, "updateInt").setValue(n3);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    @Override
    public void updateLong(int n2, long l2) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(n2, "updateLong").setValue(l2);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    @Override
    public void updateFloat(int n2, float f2) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(n2, "updateFloat").setValue(f2);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    @Override
    public void updateDouble(int n2, double d2) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(n2, "updateDouble").setValue(d2);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    @Override
    public void updateBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(n2, "updateBigDecimal").setBigDecimal(bigDecimal);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.checkIfClosed("updateBigDecimal");
        this.updateBigDecimal(this.findColumnName(string), bigDecimal);
    }

    @Override
    public void updateString(int n2, String string) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(n2, "updateString").setValue(string);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    @Override
    public void updateBytes(int n2, byte[] byArray) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(n2, "updateBytes").setValue(byArray);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    @Override
    public void updateDate(int n2, Date date) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(n2, "updateDate").setValue(date);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    @Override
    public void updateTime(int n2, Time time) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(n2, "updateTime").setValue(time);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    @Override
    public void updateTimestamp(int n2, Timestamp timestamp) throws SQLException {
        try {
            this.getDVDforColumnToBeUpdated(n2, "updateTimestamp").setValue(timestamp);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    @Override
    public void updateAsciiStream(int n2, InputStream inputStream, long l2) throws SQLException {
        this.checksBeforeUpdateAsciiStream(n2);
        InputStreamReader inputStreamReader = null;
        if (inputStream != null) {
            try {
                inputStreamReader = new InputStreamReader(inputStream, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SQLException(unsupportedEncodingException.getMessage());
            }
        }
        this.updateCharacterStreamInternal(n2, inputStreamReader, false, l2, "updateAsciiStream");
    }

    @Override
    public void updateAsciiStream(int n2, InputStream inputStream) throws SQLException {
        this.checksBeforeUpdateAsciiStream(n2);
        InputStreamReader inputStreamReader = null;
        if (inputStream != null) {
            try {
                inputStreamReader = new InputStreamReader(inputStream, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SQLException(unsupportedEncodingException.getMessage());
            }
        }
        this.updateCharacterStreamInternal(n2, inputStreamReader, true, -1L, "updateAsciiStream");
    }

    @Override
    public void updateBinaryStream(int n2, InputStream inputStream, long l2) throws SQLException {
        this.checksBeforeUpdateBinaryStream(n2);
        if (inputStream == null) {
            this.updateNull(n2);
            return;
        }
        this.updateBinaryStreamInternal(n2, inputStream, false, l2, "updateBinaryStream");
    }

    @Override
    public void updateBinaryStream(int n2, InputStream inputStream) throws SQLException {
        this.checksBeforeUpdateBinaryStream(n2);
        this.updateBinaryStreamInternal(n2, inputStream, true, -1L, "updateBinaryStream");
    }

    private void updateBinaryStreamInternal(int n2, InputStream inputStream, boolean bl2, long l2, String string) throws SQLException {
        RawToBinaryFormatStream rawToBinaryFormatStream;
        if (!bl2) {
            if (l2 < 0L) {
                throw EmbedResultSet.newSQLException("XJ025.S", new Object[0]);
            }
            if (l2 > Integer.MAX_VALUE) {
                throw EmbedResultSet.newSQLException("22003", this.getColumnSQLType(n2));
            }
            rawToBinaryFormatStream = new RawToBinaryFormatStream(inputStream, (int)l2);
        } else {
            l2 = -1L;
            rawToBinaryFormatStream = new RawToBinaryFormatStream(inputStream, this.getMaxColumnWidth(n2), this.getColumnSQLType(n2));
        }
        try {
            this.getDVDforColumnToBeUpdated(n2, string).setValue(rawToBinaryFormatStream, (int)l2);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    @Override
    public void updateCharacterStream(int n2, Reader reader, long l2) throws SQLException {
        this.checksBeforeUpdateCharacterStream(n2);
        this.updateCharacterStreamInternal(n2, reader, false, l2, "updateCharacterStream");
    }

    @Override
    public void updateCharacterStream(int n2, Reader reader) throws SQLException {
        this.checksBeforeUpdateCharacterStream(n2);
        this.updateCharacterStreamInternal(n2, reader, true, -1L, "updateCharacterStream");
    }

    private void updateCharacterStreamInternal(int n2, Reader reader, boolean bl2, long l2, String string) throws SQLException {
        try {
            ReaderToUTF8Stream readerToUTF8Stream;
            if (reader == null) {
                this.updateNull(n2);
                return;
            }
            StringDataValue stringDataValue = (StringDataValue)this.getDVDforColumnToBeUpdated(n2, string);
            stringDataValue.setStreamHeaderFormat(!this.getEmbedConnection().getDatabase().getDataDictionary().checkVersion(170, null));
            int n3 = -1;
            if (!bl2) {
                int n4;
                if (l2 < 0L) {
                    throw EmbedResultSet.newSQLException("XJ025.S", new Object[0]);
                }
                if (l2 > Integer.MAX_VALUE) {
                    throw EmbedResultSet.newSQLException("22003", this.getColumnSQLType(n2));
                }
                n3 = (int)l2;
                int n5 = 0;
                if (this.getColumnType(n2) == 2005 && n3 > (n4 = this.getMaxColumnWidth(n2))) {
                    n5 = n3 - n4;
                    n3 = n4;
                }
                readerToUTF8Stream = new ReaderToUTF8Stream(reader, n3, n5, this.getColumnSQLType(n2), stringDataValue.getStreamHeaderGenerator());
            } else {
                int n6 = this.getMaxColumnWidth(n2);
                readerToUTF8Stream = new ReaderToUTF8Stream(reader, n6, this.getColumnSQLType(n2), stringDataValue.getStreamHeaderGenerator());
            }
            stringDataValue.setValue(readerToUTF8Stream, n3);
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    @Override
    public void updateObject(int n2, Object object, int n3) throws SQLException {
        this.updateObject(n2, object);
        this.adjustScale(n2, n3);
    }

    protected void adjustScale(int n2, int n3) throws SQLException {
        int n4 = this.getColumnType(n2);
        if (n4 == 3 || n4 == 2) {
            if (n3 < 0) {
                throw EmbedResultSet.newSQLException("XJ044.S", n3);
            }
            try {
                DataValueDescriptor dataValueDescriptor = this.updateRow.getColumn(n2);
                int n5 = dataValueDescriptor.getLength();
                ((VariableSizeDataValue)((Object)dataValueDescriptor)).setWidth(-1, n3, false);
            }
            catch (StandardException standardException) {
                throw EmbedResultSet.noStateChangeException(standardException);
            }
        }
    }

    @Override
    public void updateObject(int n2, Object object) throws SQLException {
        this.checksBeforeUpdateXXX("updateObject", n2);
        int n3 = this.getColumnType(n2);
        if (n3 == 2000) {
            try {
                ((UserDataValue)this.getDVDforColumnToBeUpdated(n2, "updateObject")).setValue(object);
                return;
            }
            catch (StandardException standardException) {
                throw EmbedResultSet.noStateChangeException(standardException);
            }
        }
        if (object == null) {
            this.updateNull(n2);
            return;
        }
        if (object instanceof String) {
            this.updateString(n2, (String)object);
            return;
        }
        if (object instanceof Boolean) {
            this.updateBoolean(n2, (boolean)((Boolean)object));
            return;
        }
        if (object instanceof Short) {
            this.updateShort(n2, (short)((Short)object));
            return;
        }
        if (object instanceof Integer) {
            this.updateInt(n2, (int)((Integer)object));
            return;
        }
        if (object instanceof Long) {
            this.updateLong(n2, (long)((Long)object));
            return;
        }
        if (object instanceof Float) {
            this.updateFloat(n2, ((Float)object).floatValue());
            return;
        }
        if (object instanceof Double) {
            this.updateDouble(n2, (double)((Double)object));
            return;
        }
        if (object instanceof BigDecimal) {
            this.updateBigDecimal(n2, (BigDecimal)object);
            return;
        }
        if (object instanceof byte[]) {
            this.updateBytes(n2, (byte[])object);
            return;
        }
        if (object instanceof Date) {
            this.updateDate(n2, (Date)object);
            return;
        }
        if (object instanceof Time) {
            this.updateTime(n2, (Time)object);
            return;
        }
        if (object instanceof Timestamp) {
            this.updateTimestamp(n2, (Timestamp)object);
            return;
        }
        if (object instanceof Blob) {
            this.updateBlob(n2, (Blob)object);
            return;
        }
        if (object instanceof Clob) {
            this.updateClob(n2, (Clob)object);
            return;
        }
        throw this.dataTypeConversion(n2, object.getClass().getName());
    }

    @Override
    public void updateNull(String string) throws SQLException {
        this.checkIfClosed("updateNull");
        this.updateNull(this.findColumnName(string));
    }

    @Override
    public void updateBoolean(String string, boolean bl2) throws SQLException {
        this.checkIfClosed("updateBoolean");
        this.updateBoolean(this.findColumnName(string), bl2);
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
        this.checkIfClosed("updateByte");
        this.updateByte(this.findColumnName(string), by);
    }

    @Override
    public void updateShort(String string, short s2) throws SQLException {
        this.checkIfClosed("updateShort");
        this.updateShort(this.findColumnName(string), s2);
    }

    @Override
    public void updateInt(String string, int n2) throws SQLException {
        this.checkIfClosed("updateInt");
        this.updateInt(this.findColumnName(string), n2);
    }

    @Override
    public void updateLong(String string, long l2) throws SQLException {
        this.checkIfClosed("updateLong");
        this.updateLong(this.findColumnName(string), l2);
    }

    @Override
    public void updateFloat(String string, float f2) throws SQLException {
        this.checkIfClosed("updateFloat");
        this.updateFloat(this.findColumnName(string), f2);
    }

    @Override
    public void updateDouble(String string, double d2) throws SQLException {
        this.checkIfClosed("updateDouble");
        this.updateDouble(this.findColumnName(string), d2);
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        this.checkIfClosed("updateString");
        this.updateString(this.findColumnName(string), string2);
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.checkIfClosed("updateBytes");
        this.updateBytes(this.findColumnName(string), byArray);
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
        this.checkIfClosed("updateDate");
        this.updateDate(this.findColumnName(string), date);
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        this.checkIfClosed("updateTime");
        this.updateTime(this.findColumnName(string), time);
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.checkIfClosed("updateTimestamp");
        this.updateTimestamp(this.findColumnName(string), timestamp);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n2) throws SQLException {
        this.checkIfClosed("updateAsciiStream");
        this.updateAsciiStream(this.findColumnName(string), inputStream, n2);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n2) throws SQLException {
        this.checkIfClosed("updateBinaryStream");
        this.updateBinaryStream(this.findColumnName(string), inputStream, n2);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n2) throws SQLException {
        this.checkIfClosed("updateCharacterStream");
        this.updateCharacterStream(this.findColumnName(string), reader, n2);
    }

    @Override
    public void updateObject(String string, Object object, int n2) throws SQLException {
        this.checkIfClosed("updateObject");
        this.updateObject(this.findColumnName(string), object, n2);
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        this.checkIfClosed("updateObject");
        this.updateObject(this.findColumnName(string), object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertRow() throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.checksBeforeInsert();
            this.setupContextStack();
            LanguageConnectionContext languageConnectionContext = this.getLanguageConnectionContext(this.getEmbedConnection());
            StatementContext statementContext = null;
            try {
                boolean bl2 = false;
                StringBuffer stringBuffer = new StringBuffer("INSERT INTO ");
                StringBuffer stringBuffer2 = new StringBuffer("VALUES (");
                CursorActivation cursorActivation = languageConnectionContext.lookupCursorActivation(this.getCursorName());
                ExecCursorTableReference execCursorTableReference = cursorActivation.getPreparedStatement().getTargetTable();
                stringBuffer.append(this.getFullBaseTableName(execCursorTableReference));
                ResultDescription resultDescription = this.theResults.getResultDescription();
                stringBuffer.append(" (");
                for (int i2 = 1; i2 <= resultDescription.getColumnCount(); ++i2) {
                    if (bl2) {
                        stringBuffer.append(",");
                        stringBuffer2.append(",");
                    }
                    stringBuffer.append(IdUtil.normalToDelimited(resultDescription.getColumnDescriptor(i2).getName()));
                    if (this.columnGotUpdated[i2 - 1]) {
                        stringBuffer2.append("?");
                    } else {
                        stringBuffer2.append("DEFAULT");
                    }
                    bl2 = true;
                }
                stringBuffer.append(") ");
                stringBuffer2.append(") ");
                stringBuffer.append(stringBuffer2);
                StatementContext statementContext2 = languageConnectionContext.getStatementContext();
                Activation activation = null;
                if (statementContext2 != null) {
                    activation = statementContext2.getActivation();
                }
                statementContext = languageConnectionContext.pushStatementContext(this.isAtomic, false, stringBuffer.toString(), null, false, 0L);
                statementContext.setActivation(activation);
                PreparedStatement preparedStatement = languageConnectionContext.prepareInternalStatement(stringBuffer.toString());
                Activation activation2 = preparedStatement.getActivation(languageConnectionContext, false);
                statementContext.setActivation(activation2);
                int n2 = 0;
                for (int i3 = 1; i3 <= resultDescription.getColumnCount(); ++i3) {
                    if (!this.columnGotUpdated[i3 - 1]) continue;
                    activation2.getParameterValueSet().getParameterForSet(n2++).setValue(this.updateRow.getColumn(i3));
                }
                ResultSet resultSet = preparedStatement.executeSubStatement(cursorActivation, activation2, true, 0L);
                activation2.close();
                languageConnectionContext.popStatementContext(statementContext, null);
                InterruptStatus.restoreIntrFlagIfSeen(languageConnectionContext);
                if (statementContext != null) {
                    languageConnectionContext.popStatementContext(statementContext, null);
                }
            }
            catch (Throwable throwable) {
                try {
                    throw this.closeOnTransactionError(throwable);
                }
                catch (Throwable throwable2) {
                    if (statementContext != null) {
                        languageConnectionContext.popStatementContext(statementContext, null);
                    }
                    this.restoreContextStack();
                    throw throwable2;
                }
            }
            this.restoreContextStack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRow() throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            StatementContext statementContext;
            LanguageConnectionContext languageConnectionContext;
            block17: {
                block18: {
                    this.checksBeforeUpdateOrDelete("updateRow", -1);
                    this.checkNotOnInsertRow();
                    this.setupContextStack();
                    languageConnectionContext = this.getLanguageConnectionContext(this.getEmbedConnection());
                    statementContext = null;
                    if (this.currentRowHasBeenUpdated) break block17;
                    if (statementContext == null) break block18;
                    languageConnectionContext.popStatementContext(statementContext, null);
                }
                this.restoreContextStack();
                this.initializeUpdateRowModifiers();
                return;
            }
            try {
                boolean bl2 = false;
                StringBuffer stringBuffer = new StringBuffer("UPDATE ");
                CursorActivation cursorActivation = languageConnectionContext.lookupCursorActivation(this.getCursorName());
                ExecCursorTableReference execCursorTableReference = cursorActivation.getPreparedStatement().getTargetTable();
                stringBuffer.append(this.getFullBaseTableName(execCursorTableReference));
                stringBuffer.append(" SET ");
                ResultDescription resultDescription = this.theResults.getResultDescription();
                for (int i2 = 1; i2 <= resultDescription.getColumnCount(); ++i2) {
                    if (!this.columnGotUpdated[i2 - 1]) continue;
                    if (bl2) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(IdUtil.normalToDelimited(resultDescription.getColumnDescriptor(i2).getName()) + "=?");
                    bl2 = true;
                }
                stringBuffer.append(" WHERE CURRENT OF " + IdUtil.normalToDelimited(this.getCursorName()));
                StatementContext statementContext2 = languageConnectionContext.getStatementContext();
                Activation activation = null;
                if (statementContext2 != null) {
                    activation = statementContext2.getActivation();
                }
                statementContext = languageConnectionContext.pushStatementContext(this.isAtomic, false, stringBuffer.toString(), null, false, 0L);
                statementContext.setActivation(activation);
                PreparedStatement preparedStatement = languageConnectionContext.prepareInternalStatement(stringBuffer.toString());
                Activation activation2 = preparedStatement.getActivation(languageConnectionContext, false);
                statementContext.setActivation(activation2);
                int n2 = 0;
                for (int i3 = 1; i3 <= resultDescription.getColumnCount(); ++i3) {
                    if (!this.columnGotUpdated[i3 - 1]) continue;
                    activation2.getParameterValueSet().getParameterForSet(n2++).setValue(this.updateRow.getColumn(i3));
                }
                ResultSet resultSet = preparedStatement.executeSubStatement(cursorActivation, activation2, true, 0L);
                SQLWarning sQLWarning = activation2.getWarnings();
                if (sQLWarning != null) {
                    this.addWarning(sQLWarning);
                }
                activation2.close();
                if (this.getType() == 1003) {
                    this.currentRow = null;
                } else {
                    this.movePosition(8, 0, "relative");
                }
                languageConnectionContext.popStatementContext(statementContext, null);
                InterruptStatus.restoreIntrFlagIfSeen(languageConnectionContext);
                if (statementContext != null) {
                    languageConnectionContext.popStatementContext(statementContext, null);
                }
            }
            catch (Throwable throwable) {
                try {
                    throw this.closeOnTransactionError(throwable);
                }
                catch (Throwable throwable2) {
                    if (statementContext != null) {
                        languageConnectionContext.popStatementContext(statementContext, null);
                    }
                    this.restoreContextStack();
                    this.initializeUpdateRowModifiers();
                    throw throwable2;
                }
            }
            this.restoreContextStack();
            this.initializeUpdateRowModifiers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteRow() throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.checksBeforeUpdateOrDelete("deleteRow", -1);
            this.checkNotOnInsertRow();
            this.setupContextStack();
            LanguageConnectionContext languageConnectionContext = this.getLanguageConnectionContext(this.getEmbedConnection());
            StatementContext statementContext = null;
            try {
                StringBuffer stringBuffer = new StringBuffer("DELETE FROM ");
                CursorActivation cursorActivation = languageConnectionContext.lookupCursorActivation(this.getCursorName());
                stringBuffer.append(this.getFullBaseTableName(cursorActivation.getPreparedStatement().getTargetTable()));
                stringBuffer.append(" WHERE CURRENT OF " + IdUtil.normalToDelimited(this.getCursorName()));
                StatementContext statementContext2 = languageConnectionContext.getStatementContext();
                Activation activation = null;
                if (statementContext2 != null) {
                    activation = statementContext2.getActivation();
                }
                statementContext = languageConnectionContext.pushStatementContext(this.isAtomic, false, stringBuffer.toString(), null, false, 0L);
                statementContext.setActivation(activation);
                PreparedStatement preparedStatement = languageConnectionContext.prepareInternalStatement(stringBuffer.toString());
                Activation activation2 = preparedStatement.getActivation(languageConnectionContext, false);
                statementContext.setActivation(activation2);
                ResultSet resultSet = preparedStatement.executeSubStatement(cursorActivation, activation2, true, 0L);
                SQLWarning sQLWarning = activation2.getWarnings();
                if (sQLWarning != null) {
                    this.addWarning(sQLWarning);
                }
                activation2.close();
                this.currentRow = null;
                languageConnectionContext.popStatementContext(statementContext, null);
                InterruptStatus.restoreIntrFlagIfSeen(languageConnectionContext);
                if (statementContext != null) {
                    languageConnectionContext.popStatementContext(statementContext, null);
                }
            }
            catch (Throwable throwable) {
                try {
                    throw this.closeOnTransactionError(throwable);
                }
                catch (Throwable throwable2) {
                    if (statementContext != null) {
                        languageConnectionContext.popStatementContext(statementContext, null);
                    }
                    this.restoreContextStack();
                    this.initializeUpdateRowModifiers();
                    throw throwable2;
                }
            }
            this.restoreContextStack();
            this.initializeUpdateRowModifiers();
        }
    }

    private String getFullBaseTableName(ExecCursorTableReference execCursorTableReference) {
        return IdUtil.mkQualifiedName(execCursorTableReference.getSchemaName(), execCursorTableReference.getBaseName());
    }

    @Override
    public void refreshRow() throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.checksBeforeUpdateOrDelete("cancelRowUpdates", -1);
        this.checkNotOnInsertRow();
        this.initializeUpdateRowModifiers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveToInsertRow() throws SQLException {
        this.checkExecIfClosed("moveToInsertRow");
        this.checkUpdatableCursor("moveToInsertRow");
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            try {
                this.setupContextStack();
                this.initializeUpdateRowModifiers();
                this.isOnInsertRow = true;
                for (int i2 = 1; i2 <= this.columnGotUpdated.length; ++i2) {
                    this.updateRow.setColumn(i2, this.resultDescription.getColumnDescriptor(i2).getType().getNull());
                }
                InterruptStatus.restoreIntrFlagIfSeen(this.getLanguageConnectionContext(this.getEmbedConnection()));
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveToCurrentRow() throws SQLException {
        this.checkExecIfClosed("moveToCurrentRow");
        this.checkUpdatableCursor("moveToCurrentRow");
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            try {
                if (this.isOnInsertRow) {
                    this.initializeUpdateRowModifiers();
                    this.isOnInsertRow = false;
                }
                InterruptStatus.restoreIntrFlagIfSeen();
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Blob getBlob(int n2) throws SQLException {
        this.closeCurrentStream();
        this.checkIfClosed("getBlob");
        this.useStreamOrLOB(n2);
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            int n3 = this.getColumnType(n2);
            if (n3 != 2004) {
                throw this.dataTypeConversion("java.sql.Blob", n2);
            }
            boolean bl2 = false;
            try {
                DataValueDescriptor dataValueDescriptor = this.getColumn(n2);
                EmbedConnection embedConnection = this.getEmbedConnection();
                this.wasNull = dataValueDescriptor.isNull();
                if (this.wasNull) {
                    InterruptStatus.restoreIntrFlagIfSeen();
                    Blob blob = null;
                    return blob;
                }
                if (dataValueDescriptor.hasStream()) {
                    bl2 = true;
                }
                if (bl2) {
                    this.setupContextStack();
                }
                EmbedBlob embedBlob = new EmbedBlob(dataValueDescriptor, embedConnection);
                EmbedResultSet.restoreIntrFlagIfSeen(bl2, embedConnection);
                EmbedBlob embedBlob2 = embedBlob;
                return embedBlob2;
            }
            catch (Throwable throwable) {
                throw this.handleException(throwable);
            }
            finally {
                if (bl2) {
                    this.restoreContextStack();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final Clob getClob(int n2) throws SQLException {
        this.closeCurrentStream();
        this.checkIfClosed("getClob");
        this.useStreamOrLOB(n2);
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            int n3 = this.getColumnType(n2);
            if (n3 != 2005) {
                throw this.dataTypeConversion("java.sql.Clob", n2);
            }
            boolean bl2 = false;
            EmbedConnection embedConnection = this.getEmbedConnection();
            try {
                StringDataValue stringDataValue = (StringDataValue)this.getColumn(n2);
                LanguageConnectionContext languageConnectionContext = this.getLanguageConnectionContext(embedConnection);
                this.wasNull = stringDataValue.isNull();
                if (this.wasNull) {
                    InterruptStatus.restoreIntrFlagIfSeen();
                    Clob clob = null;
                    return clob;
                }
                if (stringDataValue.hasStream()) {
                    bl2 = true;
                    this.setupContextStack();
                }
                EmbedClob embedClob = new EmbedClob(embedConnection, stringDataValue);
                EmbedResultSet.restoreIntrFlagIfSeen(bl2, embedConnection);
                EmbedClob embedClob2 = embedClob;
                return embedClob2;
            }
            catch (Throwable throwable) {
                throw this.handleException(throwable);
            }
            finally {
                if (bl2) {
                    this.restoreContextStack();
                }
            }
        }
    }

    @Override
    public final Blob getBlob(String string) throws SQLException {
        this.checkIfClosed("getBlob");
        return this.getBlob(this.findColumnName(string));
    }

    @Override
    public final Clob getClob(String string) throws SQLException {
        this.checkIfClosed("getClob");
        return this.getClob(this.findColumnName(string));
    }

    @Override
    public void updateBlob(int n2, Blob blob) throws SQLException {
        this.checksBeforeUpdateXXX("updateBlob", n2);
        int n3 = this.getColumnType(n2);
        if (n3 != 2004) {
            throw this.dataTypeConversion(n2, "java.sql.Blob");
        }
        if (blob == null) {
            this.updateNull(n2);
        } else {
            long l2 = blob.length();
            this.updateBinaryStreamInternal(n2, blob.getBinaryStream(), false, l2, "updateBlob");
        }
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        this.checkIfClosed("updateBlob");
        this.updateBlob(this.findColumnName(string), blob);
    }

    @Override
    public void updateClob(int n2, Clob clob) throws SQLException {
        this.checksBeforeUpdateXXX("updateClob", n2);
        int n3 = this.getColumnType(n2);
        if (n3 != 2005) {
            throw this.dataTypeConversion(n2, "java.sql.Clob");
        }
        if (clob == null) {
            this.updateNull(n2);
        } else {
            long l2 = clob.length();
            this.updateCharacterStreamInternal(n2, clob.getCharacterStream(), false, l2, "updateClob");
        }
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        this.checkIfClosed("updateClob");
        this.updateClob(this.findColumnName(string), clob);
    }

    protected int findColumnName(String string) throws SQLException {
        if (string == null) {
            throw EmbedResultSet.newSQLException("XJ018.S", new Object[0]);
        }
        int n2 = this.resultDescription.findColumnInsenstive(string);
        if (n2 == -1) {
            throw EmbedResultSet.newSQLException("S0022", string);
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void closeCurrentStream() {
        if (this.currentStream != null) {
            try {
                EmbedResultSet embedResultSet = this;
                synchronized (embedResultSet) {
                    if (this.currentStream != null) {
                        if (this.currentStream instanceof Reader) {
                            ((Reader)this.currentStream).close();
                        } else {
                            ((InputStream)this.currentStream).close();
                        }
                    }
                }
            }
            catch (IOException iOException) {
            }
            finally {
                this.currentStream = null;
            }
        }
    }

    final void checkIfClosed(String string) throws SQLException {
        if (this.isClosed || this.theResults.isClosed()) {
            if (!this.isClosed) {
                this.closeCurrentStream();
                this.markClosed();
            }
            throw EmbedResultSet.newSQLException("XCL16.S", string);
        }
    }

    final void checkExecIfClosed(String string) throws SQLException {
        this.checkIfClosed(string);
        Connection connection = this.getEmbedConnection().getApplicationConnection();
        if (connection == null) {
            throw Util.noCurrentConnection();
        }
        if (connection.isClosed()) {
            this.closeCurrentStream();
            this.markClosed();
            throw Util.noCurrentConnection();
        }
    }

    protected String getSQLText() {
        if (this.stmt == null) {
            return null;
        }
        return this.stmt.getSQLText();
    }

    protected ParameterValueSet getParameterValueSet() {
        if (this.stmt == null) {
            return null;
        }
        return this.stmt.getParameterValueSet();
    }

    private static boolean isMaxFieldSizeType(int n2) {
        return n2 == -2 || n2 == -3 || n2 == -4 || n2 == 1 || n2 == 12 || n2 == -1;
    }

    final SQLException closeOnTransactionError(Throwable throwable) throws SQLException {
        StandardException standardException;
        int n2;
        SQLException sQLException = this.handleException(throwable);
        if (throwable instanceof StandardException && (n2 = (standardException = (StandardException)throwable).getSeverity()) == 30000) {
            try {
                this.close();
            }
            catch (Throwable throwable2) {
                sQLException.setNextException(this.handleException(throwable2));
            }
        }
        return sQLException;
    }

    protected final DataValueDescriptor getColumn(int n2) throws SQLException, StandardException {
        this.closeCurrentStream();
        if (n2 < 1 || n2 > this.resultDescription.getColumnCount()) {
            throw EmbedResultSet.newSQLException("S0022", n2);
        }
        if (this.isOnInsertRow || this.currentRowHasBeenUpdated && this.columnGotUpdated[n2 - 1]) {
            return this.updateRow.getColumn(n2);
        }
        this.checkOnRow();
        return this.currentRow.getColumn(n2);
    }

    static final SQLException noStateChangeException(Throwable throwable) {
        return TransactionResourceImpl.wrapInSQLException(throwable);
    }

    void setDynamicResultSet(EmbedStatement embedStatement) {
        if (embedStatement != null) {
            this.owningStmt = embedStatement;
            this.applicationStmt = embedStatement.applicationStatement;
            this.localConn = embedStatement.getEmbedConnection();
        } else {
            this.localConn = this.localConn.rootConnection;
        }
        this.singleUseActivation = this.theResults.getActivation();
    }

    public final int compareTo(Object object) {
        EmbedResultSet embedResultSet = (EmbedResultSet)object;
        return this.order - embedResultSet.order;
    }

    private void checkScrollCursor(String string) throws SQLException {
        this.checkIfClosed(string);
        if (this.stmt.getResultSetType() == 1003) {
            throw Util.generateCsSQLException("XJ061.S", string);
        }
    }

    private void checkUpdatableCursor(String string) throws SQLException {
        if (this.getConcurrency() != 1008) {
            throw Util.generateCsSQLException("XJ083.U", string);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkRowPosition(int n2, String string) throws SQLException {
        this.checkScrollCursor(string);
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack();
            LanguageConnectionContext languageConnectionContext = this.getLanguageConnectionContext(this.getEmbedConnection());
            try {
                StatementContext statementContext = languageConnectionContext.pushStatementContext(this.isAtomic, this.concurrencyOfThisResultSet == 1007, this.getSQLText(), this.getParameterValueSet(), false, 0L);
                boolean bl2 = this.theResults.checkRowPosition(n2);
                languageConnectionContext.popStatementContext(statementContext, null);
                InterruptStatus.restoreIntrFlagIfSeen(languageConnectionContext);
                boolean bl3 = bl2;
                return bl3;
            }
            catch (Throwable throwable) {
                throw this.closeOnTransactionError(throwable);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    @Override
    public final boolean isForUpdate() {
        if (this.theResults instanceof NoPutResultSet) {
            return ((NoPutResultSet)this.theResults).isForUpdate();
        }
        return false;
    }

    final String getColumnSQLType(int n2) {
        return this.resultDescription.getColumnDescriptor(n2).getType().getTypeId().getSQLTypeName();
    }

    private final int getMaxColumnWidth(int n2) {
        return this.resultDescription.getColumnDescriptor(n2).getType().getMaximumWidth();
    }

    private final SQLException dataTypeConversion(String string, int n2) {
        return EmbedResultSet.newSQLException("22005", string, this.getColumnSQLType(n2));
    }

    private final SQLException dataTypeConversion(int n2, String string) {
        return EmbedResultSet.newSQLException("22005", this.getColumnSQLType(n2), string);
    }

    final void useStreamOrLOB(int n2) throws SQLException {
        this.checkLOBMultiCall(n2);
        this.columnUsedFlags[n2 - 1] = true;
    }

    private void checkLOBMultiCall(int n2) throws SQLException {
        if (this.columnUsedFlags == null) {
            this.columnUsedFlags = new boolean[this.getMetaData().getColumnCount()];
        } else if (this.columnUsedFlags[n2 - 1]) {
            throw EmbedResultSet.newSQLException("XCL18.S", new Object[0]);
        }
    }

    @Override
    public final boolean isClosed() throws SQLException {
        if (this.isClosed) {
            return true;
        }
        try {
            this.checkExecIfClosed("");
            return false;
        }
        catch (SQLException sQLException) {
            return this.isClosed;
        }
    }

    private void addWarning(SQLWarning sQLWarning) {
        if (this.topWarning == null) {
            this.topWarning = sQLWarning;
        } else {
            this.topWarning.setNextWarning(sQLWarning);
        }
    }

    @Override
    public void updateAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.checkIfClosed("updateAsciiStream");
        this.updateAsciiStream(n2, inputStream, (long)n3);
    }

    @Override
    public void updateBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.checkIfClosed("updateBinaryStream");
        this.updateBinaryStream(n2, inputStream, (long)n3);
    }

    @Override
    public void updateCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        this.checkIfClosed("updateCharacterStream");
        this.updateCharacterStream(n2, reader, (long)n3);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l2) throws SQLException {
        this.checkIfClosed("updateAsciiStream");
        this.updateAsciiStream(this.findColumnName(string), inputStream, l2);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        this.checkIfClosed("updateAsciiStream");
        this.updateAsciiStream(this.findColumnName(string), inputStream);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l2) throws SQLException {
        this.checkIfClosed("updateBinaryStream");
        this.updateBinaryStream(this.findColumnName(string), inputStream, l2);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        this.checkIfClosed("updateBinaryStream");
        this.updateBinaryStream(this.findColumnName(string), inputStream);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l2) throws SQLException {
        this.checkIfClosed("updateCharacterStream");
        this.updateCharacterStream(this.findColumnName(string), reader, l2);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        this.checkIfClosed("updateCharacterStream");
        this.updateCharacterStream(this.findColumnName(string), reader);
    }

    @Override
    public void updateBlob(int n2, InputStream inputStream, long l2) throws SQLException {
        this.checksBeforeUpdateXXX("updateBlob", n2);
        int n3 = this.getColumnType(n2);
        if (n3 != 2004) {
            throw this.dataTypeConversion(n2, "java.sql.Blob");
        }
        if (inputStream == null) {
            this.updateNull(n2);
        } else {
            this.updateBinaryStreamInternal(n2, inputStream, false, l2, "updateBlob");
        }
    }

    @Override
    public void updateBlob(int n2, InputStream inputStream) throws SQLException {
        this.checksBeforeUpdateXXX("updateBlob", n2);
        int n3 = this.getColumnType(n2);
        if (n3 != 2004) {
            throw this.dataTypeConversion(n2, "java.sql.Blob");
        }
        this.updateBinaryStreamInternal(n2, inputStream, true, -1L, "updateBlob");
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l2) throws SQLException {
        this.checkIfClosed("updateBlob");
        this.updateBlob(this.findColumnName(string), inputStream, l2);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        this.checkIfClosed("updateBlob");
        this.updateBlob(this.findColumnName(string), inputStream);
    }

    @Override
    public void updateClob(int n2, Reader reader, long l2) throws SQLException {
        this.checksBeforeUpdateXXX("updateClob", n2);
        int n3 = this.getColumnType(n2);
        if (n3 != 2005) {
            throw this.dataTypeConversion(n2, "java.sql.Clob");
        }
        if (reader == null) {
            this.updateNull(n2);
        } else {
            this.updateCharacterStreamInternal(n2, reader, false, l2, "updateClob");
        }
    }

    @Override
    public void updateClob(int n2, Reader reader) throws SQLException {
        this.checksBeforeUpdateXXX("updateClob", n2);
        int n3 = this.getColumnType(n2);
        if (n3 != 2005) {
            throw this.dataTypeConversion(n2, "java.sql.Clob");
        }
        this.updateCharacterStreamInternal(n2, reader, true, -1L, "updateClob");
    }

    @Override
    public void updateClob(String string, Reader reader, long l2) throws SQLException {
        this.checkIfClosed("updateClob");
        this.updateClob(this.findColumnName(string), reader, l2);
    }

    @Override
    public void updateClob(String string, Reader reader) throws SQLException {
        this.checkIfClosed("updateClob");
        this.updateClob(this.findColumnName(string), reader);
    }

    @Override
    public void updateRef(int n2, Ref ref) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void updateArray(int n2, Array array) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void updateArray(String string, Array array) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public RowId getRowId(int n2) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void updateNCharacterStream(int n2, Reader reader) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void updateNCharacterStream(int n2, Reader reader, long l2) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l2) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void updateNString(int n2, String string) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void updateNString(String string, String string2) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void updateNClob(int n2, NClob nClob) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void updateNClob(int n2, Reader reader) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void updateNClob(String string, NClob nClob) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void updateNClob(String string, Reader reader) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public Reader getNCharacterStream(int n2) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public NClob getNClob(int n2) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public String getNString(int n2) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public String getNString(String string) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void updateRowId(int n2, RowId rowId) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void updateRowId(String string, RowId rowId) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public SQLXML getSQLXML(int n2) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void updateSQLXML(int n2, SQLXML sQLXML) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        this.checkIfClosed("isWrapperFor");
        return clazz.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        this.checkIfClosed("unwrap");
        try {
            return clazz.cast(this);
        }
        catch (ClassCastException classCastException) {
            throw EmbedResultSet.newSQLException("XJ128.S", clazz);
        }
    }

    @Override
    public void updateNClob(int n2, Reader reader, long l2) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void updateNClob(String string, Reader reader, long l2) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public <T> T getObject(int n2, Class<T> clazz) throws SQLException {
        this.checkIfClosed("getObject");
        if (clazz == null) {
            throw this.mismatchException("NULL", n2);
        }
        Object object = String.class.equals(clazz) ? this.getString(n2) : (BigDecimal.class.equals(clazz) ? this.getBigDecimal(n2) : (Boolean.class.equals(clazz) ? Boolean.valueOf(this.getBoolean(n2)) : (Byte.class.equals(clazz) ? Byte.valueOf(this.getByte(n2)) : (Short.class.equals(clazz) ? Short.valueOf(this.getShort(n2)) : (Integer.class.equals(clazz) ? Integer.valueOf(this.getInt(n2)) : (Long.class.equals(clazz) ? Long.valueOf(this.getLong(n2)) : (Float.class.equals(clazz) ? Float.valueOf(this.getFloat(n2)) : (Double.class.equals(clazz) ? Double.valueOf(this.getDouble(n2)) : (Date.class.equals(clazz) ? this.getDate(n2) : (Time.class.equals(clazz) ? this.getTime(n2) : (Timestamp.class.equals(clazz) ? this.getTimestamp(n2) : (Blob.class.equals(clazz) ? this.getBlob(n2) : (Clob.class.equals(clazz) ? this.getClob(n2) : (clazz.isArray() && clazz.getComponentType().equals(Byte.TYPE) ? (Object)this.getBytes(n2) : this.getObject(n2)))))))))))))));
        if (this.wasNull()) {
            object = null;
        }
        if (object == null || clazz.isInstance(object)) {
            return clazz.cast(object);
        }
        throw this.mismatchException(clazz.getName(), n2);
    }

    private SQLException mismatchException(String string, int n2) throws SQLException {
        String string2 = this.getMetaData().getColumnTypeName(n2);
        return EmbedResultSet.newSQLException("22005", string, string2);
    }

    @Override
    public <T> T getObject(String string, Class<T> clazz) throws SQLException {
        this.checkIfClosed("getObject");
        return this.getObject(this.findColumn(string), clazz);
    }

    @Override
    public boolean isNull(int n2) throws SQLException {
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n2);
            return dataValueDescriptor.isNull();
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }

    @Override
    public int getLength(int n2) throws SQLException {
        try {
            DataValueDescriptor dataValueDescriptor = this.getColumn(n2);
            return dataValueDescriptor.getLength();
        }
        catch (StandardException standardException) {
            throw EmbedResultSet.noStateChangeException(standardException);
        }
    }
}

