/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.lang.ref.SoftReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.ConnectionContext;
import org.apache.derby.iapi.services.context.ContextImpl;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.EmbedResultSet;
import org.apache.derby.impl.jdbc.EmbedStatement;
import org.apache.derby.impl.jdbc.Util;

class EmbedConnectionContext
extends ContextImpl
implements ConnectionContext {
    private SoftReference<EmbedConnection> connRef;

    EmbedConnectionContext(ContextManager contextManager, EmbedConnection embedConnection) {
        super(contextManager, "JDBC_ConnectionContext");
        this.connRef = new SoftReference<EmbedConnection>(embedConnection);
    }

    @Override
    public void cleanupOnError(Throwable throwable) {
        StandardException standardException;
        if (this.connRef == null) {
            return;
        }
        EmbedConnection embedConnection = this.connRef.get();
        if (throwable instanceof StandardException && (standardException = (StandardException)throwable).getSeverity() < 40000) {
            if (embedConnection != null) {
                embedConnection.needCommit = false;
            }
            return;
        }
        if (embedConnection != null) {
            embedConnection.setInactive();
        }
        this.connRef = null;
        this.popMe();
    }

    @Override
    public Connection getNestedConnection(boolean bl2) throws SQLException {
        StatementContext statementContext;
        EmbedConnection embedConnection = this.connRef.get();
        if (embedConnection == null || embedConnection.isClosed()) {
            throw Util.noCurrentConnection();
        }
        if (!(bl2 || (statementContext = this.privilegedGetLCC(embedConnection).getStatementContext()) != null && statementContext.getSQLAllowed() >= 0)) {
            throw Util.noCurrentConnection();
        }
        return embedConnection.getLocalDriver().getNewNestedConnection(embedConnection);
    }

    @Override
    public ResultSet getResultSet(org.apache.derby.iapi.sql.ResultSet resultSet) throws SQLException {
        EmbedConnection embedConnection = this.connRef.get();
        EmbedResultSet embedResultSet = embedConnection.getLocalDriver().newEmbedResultSet(embedConnection, resultSet, false, null, true);
        return embedResultSet;
    }

    @Override
    public boolean processInaccessibleDynamicResult(ResultSet resultSet) {
        EmbedConnection embedConnection = this.connRef.get();
        if (embedConnection == null) {
            return false;
        }
        return EmbedStatement.processDynamicResult(embedConnection, resultSet, null) != null;
    }

    private LanguageConnectionContext privilegedGetLCC(final EmbedConnection embedConnection) {
        return AccessController.doPrivileged(new PrivilegedAction<LanguageConnectionContext>(){

            @Override
            public LanguageConnectionContext run() {
                return embedConnection.getLanguageConnection();
            }
        });
    }
}

