/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.impl.jdbc.TemporaryClob;
import org.apache.derby.impl.jdbc.Util;

final class ClobUtf8Writer
extends Writer {
    private TemporaryClob control;
    private long pos;
    private boolean closed;

    ClobUtf8Writer(TemporaryClob temporaryClob, long l2) {
        this.control = temporaryClob;
        this.pos = l2;
        this.closed = false;
    }

    @Override
    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException(MessageService.getTextMessage("J104", new Object[0]));
        }
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public void write(char[] cArray, int n2, int n3) throws IOException {
        if (this.closed) {
            throw new IOException(MessageService.getTextMessage("J104", new Object[0]));
        }
        try {
            long l2 = this.control.insertString(String.copyValueOf(cArray, n2, n3), this.pos);
            if (l2 > 0L) {
                this.pos += l2;
            }
        }
        catch (SQLException sQLException) {
            throw Util.newIOException(sQLException);
        }
    }
}

