/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.io.vfmem;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.impl.io.vfmem.DataStore;
import org.apache.derby.impl.io.vfmem.DataStoreEntry;
import org.apache.derby.impl.io.vfmem.PathUtil;
import org.apache.derby.impl.io.vfmem.VirtualRandomAccessFile;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.StorageRandomAccessFile;

public class VirtualFile
implements StorageFile {
    private final String path;
    private final DataStore dStore;

    public VirtualFile(String string, DataStore dataStore) {
        this.path = string;
        this.dStore = dataStore;
    }

    @Override
    public String[] list() {
        DataStoreEntry dataStoreEntry = this.getEntry();
        if (dataStoreEntry == null || !dataStoreEntry.isDirectory()) {
            return null;
        }
        return this.dStore.listChildren(this.path);
    }

    @Override
    public boolean canWrite() {
        return this.getEntry() != null && !this.getEntry().isReadOnly();
    }

    @Override
    public boolean exists() {
        return this.getEntry() != null;
    }

    @Override
    public boolean isDirectory() {
        DataStoreEntry dataStoreEntry = this.getEntry();
        return dataStoreEntry != null && dataStoreEntry.isDirectory();
    }

    @Override
    public boolean delete() {
        return this.dStore.deleteEntry(this.path);
    }

    @Override
    public boolean deleteAll() {
        DataStoreEntry dataStoreEntry = this.getEntry();
        if (dataStoreEntry == null) {
            return false;
        }
        if (dataStoreEntry.isDirectory()) {
            return this.dStore.deleteAll(this.path);
        }
        return this.delete();
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getCanonicalPath() {
        return this.getPath();
    }

    @Override
    public String getName() {
        return PathUtil.getBaseName(this.path);
    }

    @Override
    public boolean createNewFile() {
        return this.dStore.createEntry(this.path, false) != null;
    }

    @Override
    public boolean renameTo(StorageFile storageFile) {
        return this.dStore.move(this, storageFile);
    }

    @Override
    public boolean mkdir() {
        DataStoreEntry dataStoreEntry = this.getEntry();
        if (dataStoreEntry == null) {
            return this.dStore.createEntry(this.path, true) != null;
        }
        return false;
    }

    @Override
    public boolean mkdirs() {
        DataStoreEntry dataStoreEntry = this.getEntry();
        if (dataStoreEntry == null) {
            return this.dStore.createAllParents(this.path) && this.dStore.createEntry(this.path, true) != null;
        }
        return false;
    }

    public long length() {
        DataStoreEntry dataStoreEntry = this.getEntry();
        if (dataStoreEntry != null && !dataStoreEntry.isDirectory()) {
            return dataStoreEntry.length();
        }
        return 0L;
    }

    @Override
    public StorageFile getParentDir() {
        String string = PathUtil.getParent(this.path);
        if (string == null) {
            return null;
        }
        return new VirtualFile(string, this.dStore);
    }

    @Override
    public boolean setReadOnly() {
        DataStoreEntry dataStoreEntry = this.getEntry();
        if (dataStoreEntry == null) {
            return false;
        }
        dataStoreEntry.setReadOnly();
        return true;
    }

    @Override
    public OutputStream getOutputStream() throws FileNotFoundException {
        return this.getOutputStream(false);
    }

    @Override
    public OutputStream getOutputStream(boolean bl2) throws FileNotFoundException {
        DataStoreEntry dataStoreEntry = this.getEntry();
        if (dataStoreEntry == null && (dataStoreEntry = this.dStore.createEntry(this.path, false)) == null) {
            throw new FileNotFoundException("Unable to create file: " + this.path);
        }
        return dataStoreEntry.getOutputStream(bl2);
    }

    @Override
    public InputStream getInputStream() throws FileNotFoundException {
        DataStoreEntry dataStoreEntry = this.getEntry();
        if (dataStoreEntry == null) {
            throw new FileNotFoundException(this.path);
        }
        return dataStoreEntry.getInputStream();
    }

    @Override
    public int getExclusiveFileLock() throws StandardException {
        return 1;
    }

    @Override
    public void releaseExclusiveFileLock() {
    }

    @Override
    public StorageRandomAccessFile getRandomAccessFile(String string) throws FileNotFoundException {
        if (!(string.equals("r") || string.equals("rw") || string.equals("rws") || string.equals("rwd"))) {
            throw new IllegalArgumentException("Invalid mode: " + string);
        }
        DataStoreEntry dataStoreEntry = this.getEntry();
        if (dataStoreEntry == null) {
            if (string.equals("r")) {
                throw new FileNotFoundException("Cannot read from non-existing file: " + this.path + " (mode=" + string + ")");
            }
            dataStoreEntry = this.dStore.createEntry(this.path, false);
            if (dataStoreEntry == null) {
                throw new FileNotFoundException("Unable to create file: " + this.path + " (mode=" + string + ")");
            }
        }
        return new VirtualRandomAccessFile(dataStoreEntry, string.equals("r"));
    }

    public String toString() {
        return "(db=" + this.dStore.getDatabaseName() + ")" + this.path + "#exists=" + this.exists() + ", isDirectory=" + this.isDirectory() + ", length=" + this.length() + ", canWrite=" + this.canWrite();
    }

    private DataStoreEntry getEntry() {
        return this.dStore.getEntry(this.path);
    }

    @Override
    public void limitAccessToOwner() {
    }
}

