/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.io.vfmem;

import java.io.OutputStream;
import org.apache.derby.impl.io.vfmem.BlockedByteArray;

public class BlockedByteArrayOutputStream
extends OutputStream {
    private BlockedByteArray src;
    private long pos;

    public BlockedByteArrayOutputStream(BlockedByteArray blockedByteArray, long l2) {
        if (blockedByteArray == null) {
            throw new IllegalArgumentException("BlockedByteArray cannot be null");
        }
        this.src = blockedByteArray;
        this.pos = l2;
    }

    void setPosition(long l2) {
        this.pos = l2;
    }

    long getPosition() {
        return this.pos;
    }

    @Override
    public void write(int n2) {
        this.pos += (long)this.src.writeByte(this.pos, (byte)n2);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        this.pos += (long)this.src.writeBytes(this.pos, byArray, n2, n3);
    }

    @Override
    public void close() {
        this.src = null;
    }
}

