/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.db;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Dictionary;
import java.util.Locale;
import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.db.Database;
import org.apache.derby.iapi.error.PublicAPI;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.AuthenticationService;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.iapi.services.io.FileUtil;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.loader.JarReader;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.ModuleSupportable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyFactory;
import org.apache.derby.iapi.services.property.PropertySetCallback;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.LanguageFactory;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.LanguageConnectionFactory;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.FileInfoDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.iapi.store.access.FileResource;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.store.raw.data.DataFactory;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.util.DoubleProperties;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.db.DatabaseContextImpl;
import org.apache.derby.impl.db.StoreClassFactoryContext;
import org.apache.derby.impl.sql.execute.JarUtil;
import org.apache.derby.io.StorageFactory;
import org.apache.derby.io.StorageFile;

public class BasicDatabase
implements Database,
JarReader,
ModuleControl,
ModuleSupportable,
PropertySetCallback {
    protected boolean active;
    private AuthenticationService authenticationService;
    protected AccessFactory af;
    protected PropertyFactory pf;
    protected ClassFactory cfDB;
    private DataDictionary dd;
    protected LanguageConnectionFactory lcf;
    protected LanguageFactory lf;
    protected Object resourceAdapter;
    private Locale databaseLocale;
    private DateFormat dateFormat;
    private DateFormat timeFormat;
    private DateFormat timestampFormat;
    private UUID myUUID;
    protected boolean lastToBoot = true;

    @Override
    public boolean canSupport(Properties properties) {
        String string;
        boolean bl2 = Monitor.isDesiredCreateType(properties, this.getEngineType());
        if (bl2 && (string = properties.getProperty("replication.slave.mode")) != null && !string.equals("slavepremode")) {
            bl2 = false;
        }
        return bl2;
    }

    @Override
    public void boot(boolean bl2, Properties properties) throws StandardException {
        Object object;
        ModuleFactory moduleFactory = BasicDatabase.getMonitor();
        if (bl2) {
            if (properties.getProperty("derby.__rt.storage.createWithNoLog") == null) {
                properties.put("derby.__rt.storage.createWithNoLog", "true");
            }
            if ((object = properties.getProperty("territory")) == null) {
                object = Locale.getDefault().toString();
            }
            this.databaseLocale = moduleFactory.setLocale(properties, (String)object);
        } else {
            this.databaseLocale = moduleFactory.getLocale(this);
        }
        this.setLocale(this.databaseLocale);
        this.bootValidation(bl2, properties);
        object = (DataValueFactory)BasicDatabase.bootServiceModule(bl2, this, "org.apache.derby.iapi.types.DataValueFactory", properties);
        this.bootStore(bl2, properties);
        this.myUUID = this.makeDatabaseID(bl2, properties);
        DoubleProperties doubleProperties = new DoubleProperties(this.getAllDatabaseProperties(), properties);
        if (this.pf != null) {
            this.pf.addPropertySetNotification(this);
        }
        this.bootClassFactory(bl2, doubleProperties);
        this.dd = (DataDictionary)BasicDatabase.bootServiceModule(bl2, this, "org.apache.derby.iapi.sql.dictionary.DataDictionary", doubleProperties);
        this.lcf = (LanguageConnectionFactory)BasicDatabase.bootServiceModule(bl2, this, "org.apache.derby.iapi.sql.conn.LanguageConnectionFactory", doubleProperties);
        this.lf = (LanguageFactory)BasicDatabase.bootServiceModule(bl2, this, "org.apache.derby.iapi.sql.LanguageFactory", doubleProperties);
        this.bootResourceAdapter(bl2, doubleProperties);
        this.authenticationService = this.bootAuthenticationService(bl2, doubleProperties);
        if (bl2 && this.lastToBoot && properties.getProperty("derby.__rt.storage.createWithNoLog") != null) {
            this.createFinished();
        }
        this.active = true;
        if (this.dd.doCreateIndexStatsRefresher()) {
            this.dd.createIndexStatsRefresher(this, ((Properties)doubleProperties).getProperty("derby.__rt.serviceDirectory"));
        }
    }

    @Override
    public void stop() {
        if (this.dd != null) {
            try {
                this.dd.clearSequenceCaches();
            }
            catch (StandardException standardException) {
                standardException.printStackTrace(Monitor.getStream().getPrintWriter());
            }
        }
        this.active = false;
    }

    @Override
    public int getEngineType() {
        return 2;
    }

    @Override
    public boolean isReadOnly() {
        return this.af.isReadOnly();
    }

    @Override
    public LanguageConnectionContext setupConnection(ContextManager contextManager, String string, String string2, String string3) throws StandardException {
        TransactionController transactionController = this.getConnectionTransaction(contextManager);
        contextManager.setLocaleFinder(this);
        this.pushDbContext(contextManager);
        LanguageConnectionContext languageConnectionContext = this.lcf.newLanguageConnectionContext(contextManager, transactionController, this.lf, this, string, string2, string3);
        this.pushClassFactoryContext(contextManager, this.lcf.getClassFactory());
        ExecutionFactory executionFactory = this.lcf.getExecutionFactory();
        executionFactory.newExecutionContext(contextManager);
        languageConnectionContext.initialize();
        languageConnectionContext.internalCommitNoSync(5);
        return languageConnectionContext;
    }

    @Override
    public final DataDictionary getDataDictionary() {
        return this.dd;
    }

    @Override
    public void pushDbContext(ContextManager contextManager) {
        DatabaseContextImpl databaseContextImpl = new DatabaseContextImpl(contextManager, this);
    }

    @Override
    public AuthenticationService getAuthenticationService() throws StandardException {
        return this.authenticationService;
    }

    @Override
    public void startReplicationMaster(String string, String string2, int n2, String string3) throws SQLException {
        try {
            this.af.startReplicationMaster(string, string2, n2, string3);
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    @Override
    public void stopReplicationMaster() throws SQLException {
        try {
            this.af.stopReplicationMaster();
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    @Override
    public void stopReplicationSlave() throws SQLException {
        StandardException standardException = StandardException.newException("XRE40", new Object[0]);
        throw PublicAPI.wrapStandardException(standardException);
    }

    @Override
    public boolean isInSlaveMode() {
        return false;
    }

    @Override
    public void failover(String string) throws StandardException {
        this.af.failover(string);
    }

    @Override
    public void freeze() throws SQLException {
        try {
            this.af.freeze();
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    @Override
    public void unfreeze() throws SQLException {
        try {
            this.af.unfreeze();
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    @Override
    public void backup(String string, boolean bl2) throws SQLException {
        try {
            this.af.backup(string, bl2);
            if (this.luceneLoaded()) {
                this.backupLucene(string);
            }
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    @Override
    public void backupAndEnableLogArchiveMode(String string, boolean bl2, boolean bl3) throws SQLException {
        try {
            this.af.backupAndEnableLogArchiveMode(string, bl2, bl3);
            if (this.luceneLoaded()) {
                this.backupLucene(string);
            }
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    @Override
    public void disableLogArchiveMode(boolean bl2) throws SQLException {
        try {
            this.af.disableLogArchiveMode(bl2);
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    @Override
    public void checkpoint() throws SQLException {
        try {
            this.af.checkpoint();
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
    }

    @Override
    public Locale getLocale() {
        return this.databaseLocale;
    }

    @Override
    public final UUID getId() {
        return this.myUUID;
    }

    @Override
    public Locale getCurrentLocale() throws StandardException {
        if (this.databaseLocale != null) {
            return this.databaseLocale;
        }
        throw BasicDatabase.noLocale();
    }

    @Override
    public DateFormat getDateFormat() throws StandardException {
        if (this.databaseLocale != null) {
            if (this.dateFormat == null) {
                this.dateFormat = DateFormat.getDateInstance(1, this.databaseLocale);
            }
            return this.dateFormat;
        }
        throw BasicDatabase.noLocale();
    }

    @Override
    public DateFormat getTimeFormat() throws StandardException {
        if (this.databaseLocale != null) {
            if (this.timeFormat == null) {
                this.timeFormat = DateFormat.getTimeInstance(1, this.databaseLocale);
            }
            return this.timeFormat;
        }
        throw BasicDatabase.noLocale();
    }

    @Override
    public DateFormat getTimestampFormat() throws StandardException {
        if (this.databaseLocale != null) {
            if (this.timestampFormat == null) {
                this.timestampFormat = DateFormat.getDateTimeInstance(1, 1, this.databaseLocale);
            }
            return this.timestampFormat;
        }
        throw BasicDatabase.noLocale();
    }

    private static StandardException noLocale() {
        return StandardException.newException("XCXE0.S", new Object[0]);
    }

    @Override
    public void setLocale(Locale locale) {
        this.databaseLocale = locale;
        this.dateFormat = null;
        this.timeFormat = null;
        this.timestampFormat = null;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    protected UUID makeDatabaseID(boolean bl2, Properties properties) throws StandardException {
        TransactionController transactionController = this.af.getTransaction(BasicDatabase.getContextService().getCurrentContextManager());
        String string = null;
        UUID uUID = (UUID)transactionController.getProperty("derby.databaseID");
        if (uUID == null) {
            UUIDFactory uUIDFactory = BasicDatabase.getMonitor().getUUIDFactory();
            string = properties.getProperty("derby.databaseID");
            uUID = string == null ? uUIDFactory.createUUID() : uUIDFactory.recreateUUID(string);
            transactionController.setProperty("derby.databaseID", uUID, true);
        }
        if (string != null) {
            properties.remove("derby.databaseID");
        }
        transactionController.commit();
        transactionController.destroy();
        return uUID;
    }

    @Override
    public Object getResourceAdapter() {
        return this.resourceAdapter;
    }

    @Override
    public void init(boolean bl2, Dictionary dictionary) {
    }

    @Override
    public boolean validate(String string, Serializable serializable, Dictionary dictionary) throws StandardException {
        if (string.equals("derby.engineType")) {
            throw StandardException.newException("XCY02.S", string, serializable);
        }
        if (!string.equals("derby.database.classpath")) {
            return false;
        }
        String string2 = (String)((Object)serializable);
        String[][] stringArray = null;
        if (string2 != null) {
            stringArray = IdUtil.parseDbClassPath(string2);
        }
        if (stringArray != null) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                SchemaDescriptor schemaDescriptor = this.dd.getSchemaDescriptor(stringArray[i2][0], null, false);
                FileInfoDescriptor fileInfoDescriptor = null;
                if (schemaDescriptor != null) {
                    fileInfoDescriptor = this.dd.getFileInfoDescriptor(schemaDescriptor, stringArray[i2][1]);
                }
                if (fileInfoDescriptor != null) continue;
                throw StandardException.newException("42X96", IdUtil.mkQualifiedName(stringArray[i2]));
            }
        }
        return true;
    }

    @Override
    public Serviceable apply(String string, Serializable serializable, Dictionary dictionary) throws StandardException {
        if (!string.equals("derby.database.classpath")) {
            return null;
        }
        if (this.cfDB != null) {
            this.getDataDictionary().invalidateAllSPSPlans();
            String string2 = (String)((Object)serializable);
            if (string2 == null) {
                string2 = "";
            }
            this.cfDB.notifyModifyClasspath(string2);
        }
        return null;
    }

    @Override
    public Serializable map(String string, Serializable serializable, Dictionary dictionary) {
        return null;
    }

    protected void createFinished() throws StandardException {
        this.af.createFinished();
    }

    protected String getClasspath(Properties properties) {
        String string = PropertyUtil.getPropertyFromSet(properties, "derby.database.classpath");
        if (string == null) {
            string = PropertyUtil.getSystemProperty("derby.database.classpath", "");
        }
        return string;
    }

    protected void bootClassFactory(boolean bl2, Properties properties) throws StandardException {
        String string = this.getClasspath(properties);
        IdUtil.parseDbClassPath(string);
        properties.put("derby.__rt.database.classpath", string);
        this.cfDB = (ClassFactory)BasicDatabase.bootServiceModule(bl2, this, "org.apache.derby.iapi.services.loader.ClassFactory", properties);
    }

    protected TransactionController getConnectionTransaction(ContextManager contextManager) throws StandardException {
        return this.af.getTransaction(contextManager);
    }

    protected AuthenticationService bootAuthenticationService(boolean bl2, Properties properties) throws StandardException {
        return (AuthenticationService)BasicDatabase.bootServiceModule(bl2, this, "org.apache.derby.iapi.jdbc.AuthenticationService", properties);
    }

    protected void bootValidation(boolean bl2, Properties properties) throws StandardException {
        this.pf = (PropertyFactory)BasicDatabase.bootServiceModule(bl2, this, "org.apache.derby.iapi.services.property.PropertyFactory", properties);
    }

    protected void bootStore(boolean bl2, Properties properties) throws StandardException {
        this.af = (AccessFactory)BasicDatabase.bootServiceModule(bl2, this, "org.apache.derby.iapi.store.access.AccessFactory", properties);
    }

    protected Properties getAllDatabaseProperties() throws StandardException {
        TransactionController transactionController = this.af.getTransaction(BasicDatabase.getContextService().getCurrentContextManager());
        Properties properties = transactionController.getProperties();
        transactionController.commit();
        transactionController.destroy();
        return properties;
    }

    protected void bootResourceAdapter(boolean bl2, Properties properties) {
        try {
            this.resourceAdapter = BasicDatabase.bootServiceModule(bl2, this, "org.apache.derby.iapi.jdbc.ResourceAdapter", properties);
        }
        catch (StandardException standardException) {
            // empty catch block
        }
    }

    protected void pushClassFactoryContext(ContextManager contextManager, ClassFactory classFactory) {
        new StoreClassFactoryContext(contextManager, classFactory, this.af, this);
    }

    @Override
    public StorageFile getJarFile(String string, String string2) throws StandardException {
        SchemaDescriptor schemaDescriptor = this.dd.getSchemaDescriptor(string, null, true);
        FileInfoDescriptor fileInfoDescriptor = this.dd.getFileInfoDescriptor(schemaDescriptor, string2);
        if (fileInfoDescriptor == null) {
            throw StandardException.newException("X0X13.S", string2, string);
        }
        long l2 = fileInfoDescriptor.getGenerationId();
        ContextManager contextManager = BasicDatabase.getContextService().getCurrentContextManager();
        FileResource fileResource = this.af.getTransaction(contextManager).getFileHandler();
        String string3 = JarUtil.mkExternalName(fileInfoDescriptor.getUUID(), string, string2, fileResource.getSeparatorChar());
        return fileResource.getAsFile(string3, l2);
    }

    private boolean luceneLoaded() throws StandardException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws StandardException {
                    return BasicDatabase.this.getLuceneDir().exists();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw StandardException.plainWrapException(privilegedActionException);
        }
    }

    private StorageFile getLuceneDir() throws StandardException {
        StorageFactory storageFactory = this.getStorageFactory();
        return storageFactory.newStorageFile("LUCENE");
    }

    private StorageFactory getStorageFactory() throws StandardException {
        DataFactory dataFactory = (DataFactory)BasicDatabase.findServiceModule(this, "org.apache.derby.iapi.store.raw.data.DataFactory");
        return dataFactory.getStorageFactory();
    }

    private void backupLucene(String string) throws StandardException {
        try {
            File file = new File(string);
            StorageFactory storageFactory = this.getStorageFactory();
            String string2 = storageFactory.getCanonicalName();
            String string3 = StringUtil.shortDBName(string2, storageFactory.getSeparator());
            File file2 = new File(file, string3);
            final File file3 = new File(file2, "LUCENE");
            final StorageFile storageFile = this.getLuceneDir();
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Boolean run() throws StandardException {
                    if (!FileUtil.copyDirectory(BasicDatabase.this.getStorageFactory(), storageFile, file3, null, null, true)) {
                        throw StandardException.newException("XBM0Z.D", storageFile.getPath(), file3.getAbsolutePath());
                    }
                    return null;
                }
            });
        }
        catch (IOException iOException) {
            throw StandardException.plainWrapException(iOException);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw StandardException.plainWrapException(privilegedActionException);
        }
    }

    private static ContextService getContextService() {
        return AccessController.doPrivileged(new PrivilegedAction<ContextService>(){

            @Override
            public ContextService run() {
                return ContextService.getFactory();
            }
        });
    }

    private static ModuleFactory getMonitor() {
        return AccessController.doPrivileged(new PrivilegedAction<ModuleFactory>(){

            @Override
            public ModuleFactory run() {
                return Monitor.getMonitor();
            }
        });
    }

    private static Object bootServiceModule(final boolean bl2, final Object object, final String string, final Properties properties) throws StandardException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws StandardException {
                    return Monitor.bootServiceModule(bl2, object, string, properties);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw StandardException.plainWrapException(privilegedActionException);
        }
    }

    private static Object findServiceModule(final Object object, final String string) throws StandardException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws StandardException {
                    return Monitor.findServiceModule(object, string);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw StandardException.plainWrapException(privilegedActionException);
        }
    }
}

