/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;

public class PropertyUtil {
    public static String sortProperties(Properties properties) {
        return PropertyUtil.sortProperties(properties, null);
    }

    public static String sortProperties(Properties properties, String string) {
        Set<Object> set = properties == null ? Collections.emptySet() : properties.stringPropertyNames();
        Object[] objectArray = set.toArray(new String[set.size()]);
        Arrays.sort(objectArray);
        StringBuilder stringBuilder = new StringBuilder();
        if (string == null) {
            stringBuilder.append("{ ");
        }
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (i2 > 0 && string == null) {
                stringBuilder.append(", ");
            }
            Object object = objectArray[i2];
            if (string != null) {
                stringBuilder.append(string);
            }
            stringBuilder.append((String)object);
            stringBuilder.append("=");
            String string2 = properties.getProperty((String)object, "MISSING_VALUE");
            stringBuilder.append(string2);
            if (string == null) continue;
            stringBuilder.append("\n");
        }
        if (string == null) {
            stringBuilder.append(" }");
        }
        return stringBuilder.toString();
    }

    public static void copyProperties(Properties properties, Properties properties2) {
        for (String string : properties.stringPropertyNames()) {
            properties2.put(string, properties.get(string));
        }
    }

    public static void loadWithTrimmedValues(InputStream inputStream, Properties properties) throws IOException {
        if (inputStream == null || properties == null) {
            return;
        }
        Properties properties2 = new Properties();
        properties2.load(inputStream);
        for (String string : properties2.stringPropertyNames()) {
            String string2 = properties2.getProperty(string);
            string2 = string2.trim();
            properties.put(string, string2);
        }
    }
}

