/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.util;

import java.util.BitSet;

public final class JBitSet {
    private final BitSet bitSet;
    private int size;

    public JBitSet(int n2) {
        this.bitSet = new BitSet(n2);
        this.size = n2;
    }

    private JBitSet(BitSet bitSet, int n2) {
        this.bitSet = bitSet;
        this.size = n2;
    }

    public void setTo(JBitSet jBitSet) {
        this.and(jBitSet);
        this.or(jBitSet);
    }

    public boolean contains(JBitSet jBitSet) {
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (!jBitSet.bitSet.get(i2) || this.bitSet.get(i2)) continue;
            return false;
        }
        return true;
    }

    public boolean hasSingleBitSet() {
        boolean bl2 = false;
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (!this.bitSet.get(i2)) continue;
            if (bl2) {
                return false;
            }
            bl2 = true;
        }
        return bl2;
    }

    public int getFirstSetBit() {
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (!this.bitSet.get(i2)) continue;
            return i2;
        }
        return -1;
    }

    public void grow(int n2) {
        this.size = n2;
    }

    public void clearAll() {
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (!this.bitSet.get(i2)) continue;
            this.bitSet.clear(i2);
        }
    }

    public String toString() {
        return this.bitSet.toString();
    }

    public boolean equals(Object object) {
        return this.bitSet.equals(((JBitSet)object).bitSet);
    }

    public int hashCode() {
        return this.bitSet.hashCode();
    }

    public Object clone() {
        return new JBitSet((BitSet)this.bitSet.clone(), this.size);
    }

    public boolean get(int n2) {
        return this.bitSet.get(n2);
    }

    public void set(int n2) {
        this.bitSet.set(n2);
    }

    public void clear(int n2) {
        this.bitSet.clear(n2);
    }

    public void and(JBitSet jBitSet) {
        this.bitSet.and(jBitSet.bitSet);
    }

    public void or(JBitSet jBitSet) {
        this.bitSet.or(jBitSet.bitSet);
    }

    public void xor(JBitSet jBitSet) {
        this.bitSet.xor(jBitSet.bitSet);
    }

    public int size() {
        return this.size;
    }
}

