/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class ByteArray {
    private byte[] array;
    private int offset;
    private int length;

    public ByteArray(byte[] byArray, int n2, int n3) {
        this.array = byArray;
        this.offset = n2;
        this.length = n3;
    }

    public ByteArray(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public ByteArray() {
    }

    public void setBytes(byte[] byArray) {
        this.array = byArray;
        this.offset = 0;
        this.length = byArray.length;
    }

    public void setBytes(byte[] byArray, int n2) {
        this.array = byArray;
        this.offset = 0;
        this.length = n2;
    }

    public void setBytes(byte[] byArray, int n2, int n3) {
        this.array = byArray;
        this.offset = n2;
        this.length = n3;
    }

    public boolean equals(Object object) {
        if (object instanceof ByteArray) {
            ByteArray byteArray = (ByteArray)object;
            return ByteArray.equals(this.array, this.offset, this.length, byteArray.array, byteArray.offset, byteArray.length);
        }
        return false;
    }

    public int hashCode() {
        byte[] byArray = this.array;
        int n2 = this.length;
        for (int i2 = 0; i2 < this.length; ++i2) {
            n2 += byArray[i2 + this.offset];
        }
        return n2;
    }

    public final byte[] getArray() {
        return this.array;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final int getLength() {
        return this.length;
    }

    public final void setLength(int n2) {
        this.length = n2;
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        int n2 = this.length = objectInput.readInt();
        this.offset = 0;
        this.array = new byte[n2];
        objectInput.readFully(this.array, 0, n2);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.length);
        objectOutput.write(this.array, this.offset, this.length);
    }

    private static boolean equals(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5) {
        if (n3 != n5) {
            return false;
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            if (byArray[i2 + n2] == byArray2[i2 + n4]) continue;
            return false;
        }
        return true;
    }
}

