/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.RuleBasedCollator;
import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.services.io.StreamStorable;
import org.apache.derby.iapi.sql.conn.ConnectionUtil;
import org.apache.derby.iapi.types.BooleanDataValue;
import org.apache.derby.iapi.types.DataType;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLBoolean;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.iapi.types.SQLClob;
import org.apache.derby.iapi.types.SQLLongvarchar;
import org.apache.derby.iapi.types.SQLVarchar;
import org.apache.derby.iapi.types.SqlXmlUtil;
import org.apache.derby.iapi.types.StringDataValue;
import org.apache.derby.iapi.types.XMLDataValue;

public class XML
extends DataType
implements StreamStorable,
XMLDataValue {
    protected static final short UTF8_IMPL_ID = 0;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(XML.class);
    public static final short XQ_PASS_BY_REF = 1;
    public static final short XQ_PASS_BY_VALUE = 2;
    public static final short XQ_RETURN_SEQUENCE = 3;
    public static final short XQ_RETURN_CONTENT = 4;
    public static final short XQ_EMPTY_ON_EMPTY = 5;
    public static final short XQ_NULL_ON_EMPTY = 6;
    public static final int XML_DOC_ANY = 0;
    public static final int XML_SEQUENCE = 1;
    private int xType;
    private SQLChar xmlStringValue;
    private static String xmlReqCheck = null;
    private boolean containsTopLevelAttr;
    private SqlXmlUtil tmpUtil;

    public XML() {
        this.xmlStringValue = null;
        this.xType = -1;
        this.containsTopLevelAttr = false;
    }

    private XML(SQLChar sQLChar, int n2, boolean bl2, boolean bl3) {
        this.xmlStringValue = sQLChar == null ? null : (SQLChar)sQLChar.cloneValue(bl3);
        this.setXType(n2);
        if (bl2) {
            this.markAsHavingTopLevelAttr();
        }
    }

    @Override
    public DataValueDescriptor cloneValue(boolean bl2) {
        return new XML(this.xmlStringValue, this.getXType(), this.hasTopLevelAttr(), bl2);
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return new XML();
    }

    @Override
    public String getTypeName() {
        return "XML";
    }

    @Override
    public int typePrecedence() {
        return 180;
    }

    @Override
    public String getString() throws StandardException {
        return this.xmlStringValue == null ? null : this.xmlStringValue.getString();
    }

    @Override
    public int getLength() throws StandardException {
        return this.xmlStringValue == null ? 0 : this.xmlStringValue.getLength();
    }

    @Override
    public int estimateMemoryUsage() {
        int n2 = BASE_MEMORY_USAGE;
        if (this.xmlStringValue != null) {
            n2 += this.xmlStringValue.estimateMemoryUsage();
        }
        return n2;
    }

    @Override
    public void readExternalFromArray(ArrayInputStream arrayInputStream) throws IOException {
        if (this.xmlStringValue == null) {
            this.xmlStringValue = new SQLChar();
        }
        arrayInputStream.readShort();
        this.xmlStringValue.readExternalFromArray(arrayInputStream);
        this.setXType(0);
    }

    @Override
    protected void setFrom(DataValueDescriptor dataValueDescriptor) throws StandardException {
        String string = dataValueDescriptor.getString();
        if (string == null) {
            this.xmlStringValue = null;
            this.setXType(0);
            return;
        }
        if (this.xmlStringValue == null) {
            this.xmlStringValue = new SQLChar();
        }
        this.xmlStringValue.setValue(string);
        if (dataValueDescriptor instanceof XMLDataValue) {
            this.setXType(((XMLDataValue)dataValueDescriptor).getXType());
            if (((XMLDataValue)dataValueDescriptor).hasTopLevelAttr()) {
                this.markAsHavingTopLevelAttr();
            }
        }
    }

    @Override
    public final void setValueFromResultSet(ResultSet resultSet, int n2, boolean bl2) throws SQLException {
        if (this.xmlStringValue == null) {
            this.xmlStringValue = new SQLChar();
        }
        String string = resultSet.getString(n2);
        if (this.tmpUtil == null) {
            try {
                this.tmpUtil = new SqlXmlUtil();
            }
            catch (StandardException standardException) {
                this.xmlStringValue.setValue(string);
                this.setXType(-1);
                return;
            }
        }
        try {
            string = this.tmpUtil.serializeToString(string);
            this.xmlStringValue.setValue(string);
            this.setXType(0);
        }
        catch (Throwable throwable) {
            this.xmlStringValue.setValue(string);
            this.setXType(-1);
        }
    }

    @Override
    public int compare(DataValueDescriptor dataValueDescriptor) throws StandardException {
        if (this.isNull()) {
            if (dataValueDescriptor.isNull()) {
                return 0;
            }
            return -1;
        }
        if (dataValueDescriptor.isNull()) {
            return 1;
        }
        return 0;
    }

    @Override
    public void normalize(DataTypeDescriptor dataTypeDescriptor, DataValueDescriptor dataValueDescriptor) throws StandardException {
        if (((XMLDataValue)dataValueDescriptor).getXType() != 0) {
            throw StandardException.newException("2200L", new Object[0]);
        }
        this.setValue(dataValueDescriptor);
    }

    @Override
    public int getTypeFormatId() {
        return 458;
    }

    @Override
    public boolean isNull() {
        return this.xmlStringValue == null || this.xmlStringValue.isNull();
    }

    @Override
    public void restoreToNull() {
        if (this.xmlStringValue != null) {
            this.xmlStringValue.restoreToNull();
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        if (this.xmlStringValue == null) {
            this.xmlStringValue = new SQLChar();
        }
        objectInput.readShort();
        this.xmlStringValue.readExternal(objectInput);
        this.setXType(0);
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeShort(0);
        this.xmlStringValue.writeExternal(objectOutput);
    }

    @Override
    public InputStream returnStream() {
        return this.xmlStringValue == null ? null : this.xmlStringValue.returnStream();
    }

    @Override
    public void setStream(InputStream inputStream) {
        if (this.xmlStringValue == null) {
            this.xmlStringValue = new SQLChar();
        }
        try {
            inputStream.read();
            inputStream.read();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.xmlStringValue.setStream(inputStream);
        this.setXType(0);
    }

    @Override
    public void loadStream() throws StandardException {
        this.getString();
    }

    @Override
    public XMLDataValue XMLParse(StringDataValue stringDataValue, boolean bl2, SqlXmlUtil sqlXmlUtil) throws StandardException {
        if (stringDataValue.isNull()) {
            this.setToNull();
            return this;
        }
        String string = stringDataValue.getString();
        try {
            if (bl2) {
                string = sqlXmlUtil.serializeToString(string);
            }
        }
        catch (Throwable throwable) {
            throw StandardException.newException("2200M", throwable, throwable.getMessage());
        }
        this.setXType(0);
        if (this.xmlStringValue == null) {
            this.xmlStringValue = new SQLChar();
        }
        this.xmlStringValue.setValue(string);
        return this;
    }

    @Override
    public StringDataValue XMLSerialize(StringDataValue stringDataValue, int n2, int n3, int n4) throws StandardException {
        if (stringDataValue == null) {
            switch (n2) {
                case 1: {
                    stringDataValue = new SQLChar();
                    break;
                }
                case 12: {
                    stringDataValue = new SQLVarchar();
                    break;
                }
                case -1: {
                    stringDataValue = new SQLLongvarchar();
                    break;
                }
                case 2005: {
                    stringDataValue = new SQLClob();
                    break;
                }
                default: {
                    return null;
                }
            }
            try {
                RuleBasedCollator ruleBasedCollator = ConnectionUtil.getCurrentLCC().getDataValueFactory().getCharacterCollator(n4);
                stringDataValue = stringDataValue.getValue(ruleBasedCollator);
            }
            catch (SQLException sQLException) {
                throw StandardException.plainWrapException(sQLException);
            }
        }
        if (this.isNull()) {
            stringDataValue.setToNull();
            return stringDataValue;
        }
        if (this.hasTopLevelAttr()) {
            throw StandardException.newException("2200W", new Object[0]);
        }
        stringDataValue.setValue(this.getString());
        stringDataValue.setWidth(n3, 0, true);
        return stringDataValue;
    }

    @Override
    public BooleanDataValue XMLExists(SqlXmlUtil sqlXmlUtil) throws StandardException {
        if (this.isNull()) {
            return SQLBoolean.unknownTruthValue();
        }
        try {
            return new SQLBoolean(null != sqlXmlUtil.evalXQExpression(this, false, new int[1]));
        }
        catch (StandardException standardException) {
            throw standardException;
        }
        catch (Throwable throwable) {
            throw StandardException.newException("10000", throwable, "XMLEXISTS", throwable.getMessage());
        }
    }

    @Override
    public XMLDataValue XMLQuery(SqlXmlUtil sqlXmlUtil, XMLDataValue xMLDataValue) throws StandardException {
        if (this.isNull()) {
            if (xMLDataValue == null) {
                xMLDataValue = (XMLDataValue)this.getNewNull();
            } else {
                xMLDataValue.setToNull();
            }
            return xMLDataValue;
        }
        try {
            int[] nArray = new int[1];
            List list = sqlXmlUtil.evalXQExpression(this, true, nArray);
            if (xMLDataValue == null) {
                xMLDataValue = new XML();
            }
            String string = sqlXmlUtil.serializeToString(list, xMLDataValue);
            xMLDataValue.setValue(new SQLChar(string));
            xMLDataValue.setXType(nArray[0]);
            return xMLDataValue;
        }
        catch (StandardException standardException) {
            throw standardException;
        }
        catch (Throwable throwable) {
            throw StandardException.newException("10000", throwable, "XMLQUERY", throwable.getMessage());
        }
    }

    @Override
    public void setXType(int n2) {
        this.xType = n2;
        if (n2 == 0) {
            this.containsTopLevelAttr = false;
        }
    }

    @Override
    public int getXType() {
        return this.xType;
    }

    @Override
    public void markAsHavingTopLevelAttr() {
        this.containsTopLevelAttr = true;
    }

    @Override
    public boolean hasTopLevelAttr() {
        return this.containsTopLevelAttr;
    }

    public static void checkXMLRequirements() throws StandardException {
        if (xmlReqCheck == null) {
            xmlReqCheck = "";
            if (!XML.checkJAXPRequirement()) {
                xmlReqCheck = "JAXP";
            } else if (!XML.checkXPathRequirement()) {
                xmlReqCheck = "XPath";
            }
        }
        if (xmlReqCheck.length() != 0) {
            throw StandardException.newException("XML00", xmlReqCheck);
        }
    }

    private static boolean checkJAXPRequirement() {
        try {
            Class.forName("javax.xml.parsers.DocumentBuilderFactory");
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static boolean checkXPathRequirement() {
        try {
            Class.forName("javax.xml.xpath.XPathFactory");
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }
}

