/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.types.BooleanDataValue;
import org.apache.derby.iapi.types.DataType;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLBoolean;
import org.apache.derby.iapi.types.SQLDate;
import org.apache.derby.iapi.types.SQLTime;
import org.apache.derby.iapi.types.SQLTimestamp;
import org.apache.derby.iapi.types.UserDataValue;

public class UserType
extends DataType
implements UserDataValue {
    private Object value;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(UserType.class);

    @Override
    public int estimateMemoryUsage() {
        int n2 = BASE_MEMORY_USAGE;
        if (null != this.value) {
            n2 += ClassSize.estimateAndCatalogBase(this.value.getClass());
        }
        return n2;
    }

    @Override
    public String getString() {
        if (!this.isNull()) {
            return this.value.toString();
        }
        return null;
    }

    @Override
    public boolean getBoolean() throws StandardException {
        if (!this.isNull() && this.value instanceof Boolean) {
            return (Boolean)this.value;
        }
        return super.getBoolean();
    }

    @Override
    public byte getByte() throws StandardException {
        if (!this.isNull() && this.value instanceof Number) {
            return ((Number)this.value).byteValue();
        }
        return super.getByte();
    }

    @Override
    public short getShort() throws StandardException {
        if (!this.isNull() && this.value instanceof Number) {
            return ((Number)this.value).shortValue();
        }
        return super.getShort();
    }

    @Override
    public int getInt() throws StandardException {
        if (!this.isNull() && this.value instanceof Number) {
            return ((Number)this.value).intValue();
        }
        return super.getInt();
    }

    @Override
    public long getLong() throws StandardException {
        if (!this.isNull() && this.value instanceof Number) {
            return ((Number)this.value).longValue();
        }
        return super.getLong();
    }

    @Override
    public float getFloat() throws StandardException {
        if (!this.isNull() && this.value instanceof Number) {
            return ((Number)this.value).floatValue();
        }
        return super.getFloat();
    }

    @Override
    public double getDouble() throws StandardException {
        if (!this.isNull() && this.value instanceof Number) {
            return ((Number)this.value).doubleValue();
        }
        return super.getDouble();
    }

    @Override
    public byte[] getBytes() throws StandardException {
        if (!this.isNull() && this.value instanceof byte[]) {
            return (byte[])this.value;
        }
        return super.getBytes();
    }

    @Override
    public Date getDate(Calendar calendar) throws StandardException {
        if (!this.isNull()) {
            if (this.value instanceof Date) {
                return (Date)this.value;
            }
            if (this.value instanceof Timestamp) {
                return new SQLTimestamp((Timestamp)this.value).getDate(calendar);
            }
        }
        return super.getDate(calendar);
    }

    @Override
    public Time getTime(Calendar calendar) throws StandardException {
        if (!this.isNull()) {
            if (this.value instanceof Time) {
                return (Time)this.value;
            }
            if (this.value instanceof Timestamp) {
                return new SQLTimestamp((Timestamp)this.value).getTime(calendar);
            }
        }
        return super.getTime(calendar);
    }

    @Override
    public Timestamp getTimestamp(Calendar calendar) throws StandardException {
        if (!this.isNull()) {
            if (this.value instanceof Timestamp) {
                return (Timestamp)this.value;
            }
            if (this.value instanceof Date) {
                return new SQLDate((Date)this.value).getTimestamp(calendar);
            }
            if (this.value instanceof Time) {
                return new SQLTime((Time)this.value).getTimestamp(calendar);
            }
        }
        return super.getTimestamp(calendar);
    }

    @Override
    void setObject(Object object) {
        this.setValue(object);
    }

    @Override
    public Object getObject() {
        return this.value;
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public String getTypeName() {
        return this.isNull() ? "JAVA_OBJECT" : ClassInspector.readableClassName(this.value.getClass());
    }

    @Override
    String getTypeName(String string) {
        return string;
    }

    @Override
    public int getTypeFormatId() {
        return 266;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.value);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.value = objectInput.readObject();
    }

    @Override
    public DataValueDescriptor cloneValue(boolean bl2) {
        return new UserType(this.value);
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return new UserType();
    }

    @Override
    public void restoreToNull() {
        this.value = null;
    }

    @Override
    public void setValueFromResultSet(ResultSet resultSet, int n2, boolean bl2) throws SQLException {
        this.value = resultSet.getObject(n2);
    }

    @Override
    public int compare(DataValueDescriptor dataValueDescriptor) throws StandardException {
        int n2;
        if (this.typePrecedence() < dataValueDescriptor.typePrecedence()) {
            return -dataValueDescriptor.compare(this);
        }
        boolean bl2 = this.isNull();
        boolean bl3 = dataValueDescriptor.isNull();
        if (bl2 || bl3) {
            if (!bl2) {
                return -1;
            }
            if (!bl3) {
                return 1;
            }
            return 0;
        }
        try {
            n2 = ((Comparable)this.value).compareTo(dataValueDescriptor.getObject());
        }
        catch (ClassCastException classCastException) {
            throw StandardException.newException("XCL15.S", this.getTypeName(), ClassInspector.readableClassName(dataValueDescriptor.getObject().getClass()));
        }
        if (n2 < 0) {
            n2 = -1;
        } else if (n2 > 0) {
            n2 = 1;
        }
        return n2;
    }

    @Override
    public boolean compare(int n2, DataValueDescriptor dataValueDescriptor, boolean bl2, boolean bl3) throws StandardException {
        Object object;
        if (!bl2 && (this.isNull() || dataValueDescriptor.isNull())) {
            return bl3;
        }
        if (!(n2 != 2 || this.isNull() || dataValueDescriptor.isNull() || (object = this.getObject()) instanceof Comparable)) {
            return object.equals(dataValueDescriptor.getObject());
        }
        return super.compare(n2, dataValueDescriptor, bl2, bl3);
    }

    public UserType() {
    }

    public UserType(Object object) {
        this.value = object;
    }

    @Override
    public void setValue(Object object) {
        this.value = object;
    }

    @Override
    protected void setFrom(DataValueDescriptor dataValueDescriptor) throws StandardException {
        this.setValue(dataValueDescriptor.getObject());
    }

    @Override
    public void setBigDecimal(BigDecimal bigDecimal) {
        this.setValue(bigDecimal);
    }

    @Override
    public void setValue(String string) {
        this.value = string == null ? null : string;
    }

    @Override
    public BooleanDataValue equals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.compare(2, dataValueDescriptor2, true, false));
    }

    @Override
    public BooleanDataValue notEquals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, !dataValueDescriptor.compare(2, dataValueDescriptor2, true, false));
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        return this.value.toString();
    }

    public int hashCode() {
        if (this.isNull()) {
            return 0;
        }
        return this.value.hashCode();
    }

    @Override
    public int typePrecedence() {
        return 1000;
    }

    @Override
    public final boolean isNull() {
        return this.value == null;
    }
}

