/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLBit;
import org.apache.derby.iapi.util.StringUtil;

public class SQLVarbit
extends SQLBit {
    @Override
    public String getTypeName() {
        return "VARCHAR () FOR BIT DATA";
    }

    @Override
    int getMaxMemoryUsage() {
        return 32672;
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return new SQLVarbit();
    }

    @Override
    public int getTypeFormatId() {
        return 88;
    }

    @Override
    public void normalize(DataTypeDescriptor dataTypeDescriptor, DataValueDescriptor dataValueDescriptor) throws StandardException {
        int n2 = dataTypeDescriptor.getMaximumWidth();
        byte[] byArray = dataValueDescriptor.getBytes();
        this.setValue(byArray);
        if (byArray.length > n2) {
            this.setWidth(n2, 0, true);
        }
    }

    @Override
    public void setWidth(int n2, int n3, boolean bl2) throws StandardException {
        if (this.getValue() == null) {
            return;
        }
        int n4 = this.dataValue.length;
        if (n4 > n2) {
            if (bl2) {
                for (int i2 = n2; i2 < this.dataValue.length; ++i2) {
                    if (this.dataValue[i2] == 32) continue;
                    throw StandardException.newException("22001", this.getTypeName(), StringUtil.formatForPrint(this.toString()), String.valueOf(n2));
                }
            }
            this.truncate(n4, n2, !bl2);
        }
    }

    public SQLVarbit() {
    }

    public SQLVarbit(byte[] byArray) {
        super(byArray);
    }

    @Override
    public int typePrecedence() {
        return 150;
    }
}

