/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.types.BooleanDataValue;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.NumberDataType;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.SQLBoolean;
import org.apache.derby.iapi.types.SQLDouble;
import org.apache.derby.iapi.types.StringDataValue;

public final class SQLReal
extends NumberDataType {
    static final int REAL_LENGTH = 16;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(SQLReal.class);
    private float value;
    private boolean isnull;

    @Override
    public int getInt() throws StandardException {
        if ((double)this.value > 2.147483648E9 || (double)this.value < -2.147483649E9) {
            throw StandardException.newException("22003", "INTEGER");
        }
        return (int)this.value;
    }

    @Override
    public byte getByte() throws StandardException {
        if ((double)this.value > 128.0 || (double)this.value < -129.0) {
            throw StandardException.newException("22003", "TINYINT");
        }
        return (byte)this.value;
    }

    @Override
    public short getShort() throws StandardException {
        if ((double)this.value > 32768.0 || (double)this.value < -32769.0) {
            throw StandardException.newException("22003", "SMALLINT");
        }
        return (short)this.value;
    }

    @Override
    public long getLong() throws StandardException {
        if ((double)this.value > 9.223372036854776E18 || (double)this.value < -9.223372036854776E18) {
            throw StandardException.newException("22003", "BIGINT");
        }
        return (long)this.value;
    }

    @Override
    public float getFloat() {
        return this.value;
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    @Override
    public int typeToBigDecimal() {
        return 1;
    }

    @Override
    public boolean getBoolean() {
        return this.value != 0.0f;
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return null;
        }
        return Float.toString(this.value);
    }

    @Override
    public int getLength() {
        return 16;
    }

    @Override
    public Object getObject() {
        if (this.isNull()) {
            return null;
        }
        return Float.valueOf(this.value);
    }

    @Override
    public String getTypeName() {
        return "REAL";
    }

    @Override
    public int getTypeFormatId() {
        return 81;
    }

    @Override
    public boolean isNull() {
        return this.isnull;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeFloat(this.value);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        this.value = objectInput.readFloat();
        this.isnull = false;
    }

    @Override
    public void restoreToNull() {
        this.value = 0.0f;
        this.isnull = true;
    }

    @Override
    protected int typeCompare(DataValueDescriptor dataValueDescriptor) throws StandardException {
        float f2;
        float f3 = this.getFloat();
        if (f3 == (f2 = NumberDataType.normalizeREAL(dataValueDescriptor.getFloat()))) {
            return 0;
        }
        if (f3 > f2) {
            return 1;
        }
        return -1;
    }

    @Override
    public DataValueDescriptor cloneValue(boolean bl2) {
        SQLReal sQLReal = new SQLReal();
        sQLReal.value = this.value;
        sQLReal.isnull = this.isnull;
        return sQLReal;
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return new SQLReal();
    }

    @Override
    public void setValueFromResultSet(ResultSet resultSet, int n2, boolean bl2) throws StandardException, SQLException {
        float f2 = resultSet.getFloat(n2);
        if (bl2 && resultSet.wasNull()) {
            this.restoreToNull();
        } else {
            this.setValue(f2);
        }
    }

    @Override
    public final void setInto(PreparedStatement preparedStatement, int n2) throws SQLException {
        if (this.isNull()) {
            preparedStatement.setNull(n2, 7);
            return;
        }
        preparedStatement.setFloat(n2, this.value);
    }

    @Override
    public final void setInto(ResultSet resultSet, int n2) throws SQLException, StandardException {
        resultSet.updateFloat(n2, this.value);
    }

    public SQLReal() {
        this.isnull = true;
    }

    public SQLReal(float f2) throws StandardException {
        this.value = NumberDataType.normalizeREAL(f2);
    }

    public SQLReal(Float f2) throws StandardException {
        this.isnull = f2 == null;
        if (!this.isnull) {
            this.value = NumberDataType.normalizeREAL(f2.floatValue());
        }
    }

    @Override
    public void setValue(String string) throws StandardException {
        if (string == null) {
            this.value = 0.0f;
            this.isnull = true;
        } else {
            try {
                this.setValue(Double.parseDouble(string.trim()));
            }
            catch (NumberFormatException numberFormatException) {
                throw this.invalidFormat();
            }
        }
    }

    @Override
    public void setValue(Number number) throws StandardException {
        if (this.objectNull(number)) {
            return;
        }
        this.setValue(number.floatValue());
    }

    @Override
    public void setBigDecimal(BigDecimal bigDecimal) throws StandardException {
        if (this.objectNull(bigDecimal)) {
            return;
        }
        float f2 = bigDecimal.floatValue();
        if (f2 == 0.0f) {
            boolean bl2;
            boolean bl3 = bl2 = bigDecimal.compareTo(BigDecimal.ZERO) == 0;
            if (!bl2) {
                throw StandardException.newException("22003", "REAL");
            }
        }
        this.setValue(f2);
    }

    @Override
    public void setValue(float f2) throws StandardException {
        this.value = NumberDataType.normalizeREAL(f2);
        this.isnull = false;
    }

    @Override
    public void setValue(int n2) {
        this.value = n2;
        this.isnull = false;
    }

    @Override
    public void setValue(long l2) {
        this.value = l2;
        this.isnull = false;
    }

    @Override
    public void setValue(double d2) throws StandardException {
        float f2 = (float)d2;
        if (f2 == 0.0f && d2 != 0.0) {
            throw StandardException.newException("22003", "REAL");
        }
        this.setValue(f2);
    }

    @Override
    public void setValue(boolean bl2) {
        this.value = bl2 ? 1.0f : 0.0f;
        this.isnull = false;
    }

    @Override
    void setObject(Object object) throws StandardException {
        this.setValue(((Float)object).floatValue());
    }

    @Override
    protected void setFrom(DataValueDescriptor dataValueDescriptor) throws StandardException {
        if (dataValueDescriptor instanceof StringDataValue) {
            this.setValue(dataValueDescriptor.getString());
        } else if (dataValueDescriptor instanceof SQLDouble) {
            this.setValue(dataValueDescriptor.getDouble());
        } else {
            this.setValue(dataValueDescriptor.getFloat());
        }
    }

    @Override
    public int typePrecedence() {
        return 80;
    }

    @Override
    public BooleanDataValue equals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getFloat() == dataValueDescriptor2.getFloat());
    }

    @Override
    public BooleanDataValue notEquals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getFloat() != dataValueDescriptor2.getFloat());
    }

    @Override
    public BooleanDataValue lessThan(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getFloat() < dataValueDescriptor2.getFloat());
    }

    @Override
    public BooleanDataValue greaterThan(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getFloat() > dataValueDescriptor2.getFloat());
    }

    @Override
    public BooleanDataValue lessOrEquals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getFloat() <= dataValueDescriptor2.getFloat());
    }

    @Override
    public BooleanDataValue greaterOrEquals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getFloat() >= dataValueDescriptor2.getFloat());
    }

    @Override
    public NumberDataValue plus(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        if (numberDataValue3 == null) {
            numberDataValue3 = new SQLReal();
        }
        if (numberDataValue.isNull() || numberDataValue2.isNull()) {
            numberDataValue3.setToNull();
            return numberDataValue3;
        }
        double d2 = numberDataValue.getDouble() + numberDataValue2.getDouble();
        numberDataValue3.setValue(d2);
        return numberDataValue3;
    }

    @Override
    public NumberDataValue minus(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        if (numberDataValue3 == null) {
            numberDataValue3 = new SQLReal();
        }
        if (numberDataValue.isNull() || numberDataValue2.isNull()) {
            numberDataValue3.setToNull();
            return numberDataValue3;
        }
        double d2 = numberDataValue.getDouble() - numberDataValue2.getDouble();
        numberDataValue3.setValue(d2);
        return numberDataValue3;
    }

    @Override
    public NumberDataValue times(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        double d2;
        if (numberDataValue3 == null) {
            numberDataValue3 = new SQLReal();
        }
        if (numberDataValue.isNull() || numberDataValue2.isNull()) {
            numberDataValue3.setToNull();
            return numberDataValue3;
        }
        double d3 = numberDataValue.getDouble();
        double d4 = d3 * (d2 = numberDataValue2.getDouble());
        if (d4 == 0.0 && d3 != 0.0 && d2 != 0.0) {
            throw StandardException.newException("22003", "REAL");
        }
        numberDataValue3.setValue(d4);
        return numberDataValue3;
    }

    @Override
    public NumberDataValue divide(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        if (numberDataValue3 == null) {
            numberDataValue3 = new SQLReal();
        }
        if (numberDataValue.isNull() || numberDataValue2.isNull()) {
            numberDataValue3.setToNull();
            return numberDataValue3;
        }
        double d2 = numberDataValue2.getDouble();
        if (d2 == 0.0) {
            throw StandardException.newException("22012", new Object[0]);
        }
        double d3 = numberDataValue.getDouble();
        double d4 = d3 / d2;
        if (Double.isNaN(d4)) {
            throw StandardException.newException("22012", new Object[0]);
        }
        if (d4 == 0.0 && d3 != 0.0) {
            throw StandardException.newException("22003", "REAL");
        }
        numberDataValue3.setValue(d4);
        return numberDataValue3;
    }

    @Override
    public NumberDataValue minus(NumberDataValue numberDataValue) throws StandardException {
        if (numberDataValue == null) {
            numberDataValue = new SQLReal();
        }
        if (this.isNull()) {
            numberDataValue.setToNull();
            return numberDataValue;
        }
        float f2 = -this.getFloat();
        numberDataValue.setValue(f2);
        return numberDataValue;
    }

    @Override
    protected boolean isNegative() {
        return !this.isNull() && this.value < 0.0f;
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        return Float.toString(this.value);
    }

    public int hashCode() {
        long l2 = (long)this.value;
        if ((float)l2 != this.value) {
            l2 = Double.doubleToLongBits(this.value);
        }
        return (int)(l2 ^ l2 >> 32);
    }

    @Override
    public int estimateMemoryUsage() {
        return BASE_MEMORY_USAGE;
    }
}

