/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.apache.derby.iapi.db.DatabaseContext;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.services.i18n.LocaleFinder;
import org.apache.derby.iapi.types.DataType;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.DataValueFactoryImpl;
import org.apache.derby.iapi.types.DateTimeDataValue;
import org.apache.derby.iapi.types.DateTimeParser;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.SQLInteger;
import org.apache.derby.iapi.types.SQLTimestamp;
import org.apache.derby.iapi.util.StringUtil;

public final class SQLDate
extends DataType
implements DateTimeDataValue {
    private int encodedDate;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(SQLDate.class);
    static final char ISO_SEPARATOR = '-';
    private static final char[] ISO_SEPARATOR_ONLY = new char[]{'-'};
    private static final char IBM_USA_SEPARATOR = '/';
    private static final char[] IBM_USA_SEPARATOR_ONLY = new char[]{'/'};
    private static final char IBM_EUR_SEPARATOR = '.';
    private static final char[] IBM_EUR_SEPARATOR_ONLY = new char[]{'.'};
    private static final char[] END_OF_STRING = new char[]{'\u0000'};

    @Override
    public int estimateMemoryUsage() {
        return BASE_MEMORY_USAGE;
    }

    int getEncodedDate() {
        return this.encodedDate;
    }

    @Override
    public String getString() {
        if (!this.isNull()) {
            return SQLDate.encodedDateToString(this.encodedDate);
        }
        return null;
    }

    @Override
    public Timestamp getTimestamp(Calendar calendar) {
        if (this.isNull()) {
            return null;
        }
        return new Timestamp(this.getTimeInMillis(calendar));
    }

    private long getTimeInMillis(Calendar calendar) {
        if (calendar == null) {
            calendar = new GregorianCalendar();
        }
        calendar.clear();
        SQLDate.setDateInCalendar(calendar, this.encodedDate);
        return calendar.getTimeInMillis();
    }

    static void setDateInCalendar(Calendar calendar, int n2) {
        calendar.set(SQLDate.getYear(n2), SQLDate.getMonth(n2) - 1, SQLDate.getDay(n2));
    }

    @Override
    public Object getObject() {
        return this.getDate((Calendar)null);
    }

    @Override
    public int getLength() {
        return 4;
    }

    @Override
    public String getTypeName() {
        return "DATE";
    }

    @Override
    public int getTypeFormatId() {
        return 298;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.encodedDate);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        this.encodedDate = objectInput.readInt();
    }

    @Override
    public DataValueDescriptor cloneValue(boolean bl2) {
        return new SQLDate(this.encodedDate);
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return new SQLDate();
    }

    @Override
    public void restoreToNull() {
        this.encodedDate = 0;
    }

    @Override
    public void setValueFromResultSet(ResultSet resultSet, int n2, boolean bl2) throws SQLException, StandardException {
        this.setValue(resultSet.getDate(n2), (Calendar)null);
    }

    @Override
    public int compare(DataValueDescriptor dataValueDescriptor) throws StandardException {
        if (this.typePrecedence() < dataValueDescriptor.typePrecedence()) {
            return -dataValueDescriptor.compare(this);
        }
        boolean bl2 = this.isNull();
        boolean bl3 = dataValueDescriptor.isNull();
        if (bl2 || bl3) {
            if (!bl2) {
                return -1;
            }
            if (!bl3) {
                return 1;
            }
            return 0;
        }
        int n2 = 0;
        n2 = dataValueDescriptor instanceof SQLDate ? ((SQLDate)dataValueDescriptor).encodedDate : SQLDate.computeEncodedDate(dataValueDescriptor.getDate(new GregorianCalendar()));
        int n3 = this.encodedDate > n2 ? 1 : (this.encodedDate < n2 ? -1 : 0);
        return n3;
    }

    @Override
    public boolean compare(int n2, DataValueDescriptor dataValueDescriptor, boolean bl2, boolean bl3) throws StandardException {
        if (!bl2 && (this.isNull() || dataValueDescriptor.isNull())) {
            return bl3;
        }
        return super.compare(n2, dataValueDescriptor, bl2, bl3);
    }

    public SQLDate() {
    }

    public SQLDate(Date date) throws StandardException {
        this.parseDate(date);
    }

    private void parseDate(java.util.Date date) throws StandardException {
        this.encodedDate = SQLDate.computeEncodedDate(date);
    }

    private SQLDate(int n2) {
        this.encodedDate = n2;
    }

    public SQLDate(String string, boolean bl2, LocaleFinder localeFinder) throws StandardException {
        this.parseDate(string, bl2, localeFinder, null);
    }

    public SQLDate(String string, boolean bl2, LocaleFinder localeFinder, Calendar calendar) throws StandardException {
        this.parseDate(string, bl2, localeFinder, calendar);
    }

    private void parseDate(String string, boolean bl2, LocaleFinder localeFinder, Calendar calendar) throws StandardException {
        boolean bl3 = true;
        DateTimeParser dateTimeParser = new DateTimeParser(string);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        StandardException standardException = null;
        try {
            switch (dateTimeParser.nextSeparator()) {
                case '-': {
                    this.encodedDate = SQLTimestamp.parseDateOrTimestamp(dateTimeParser, false)[0];
                    return;
                }
                case '/': {
                    if (bl2) {
                        bl3 = false;
                        break;
                    }
                    n3 = dateTimeParser.parseInt(2, true, IBM_USA_SEPARATOR_ONLY, false);
                    n4 = dateTimeParser.parseInt(2, true, IBM_USA_SEPARATOR_ONLY, false);
                    n2 = dateTimeParser.parseInt(4, false, END_OF_STRING, false);
                    break;
                }
                case '.': {
                    if (bl2) {
                        bl3 = false;
                        break;
                    }
                    n4 = dateTimeParser.parseInt(2, true, IBM_EUR_SEPARATOR_ONLY, false);
                    n3 = dateTimeParser.parseInt(2, true, IBM_EUR_SEPARATOR_ONLY, false);
                    n2 = dateTimeParser.parseInt(4, false, END_OF_STRING, false);
                    break;
                }
                default: {
                    bl3 = false;
                    break;
                }
            }
        }
        catch (StandardException standardException2) {
            bl3 = false;
            standardException = standardException2;
        }
        if (bl3) {
            this.encodedDate = SQLDate.computeEncodedDate(n2, n3, n4);
        } else {
            string = StringUtil.trimTrailing(string);
            DateFormat dateFormat = null;
            dateFormat = localeFinder == null ? DateFormat.getDateInstance() : (calendar == null ? localeFinder.getDateFormat() : (DateFormat)localeFinder.getDateFormat().clone());
            if (calendar != null) {
                dateFormat.setCalendar(calendar);
            }
            try {
                this.encodedDate = SQLDate.computeEncodedDate(dateFormat.parse(string), calendar);
            }
            catch (ParseException parseException) {
                try {
                    this.encodedDate = SQLTimestamp.parseLocalTimestamp(string, localeFinder, calendar)[0];
                }
                catch (ParseException parseException2) {
                    if (standardException != null) {
                        throw standardException;
                    }
                    throw StandardException.newException("22007.S.181", new Object[0]);
                }
            }
        }
    }

    @Override
    void setObject(Object object) throws StandardException {
        this.setValue((Date)object);
    }

    @Override
    protected void setFrom(DataValueDescriptor dataValueDescriptor) throws StandardException {
        if (dataValueDescriptor instanceof SQLDate) {
            this.restoreToNull();
            this.encodedDate = ((SQLDate)dataValueDescriptor).encodedDate;
        } else {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            this.setValue(dataValueDescriptor.getDate(gregorianCalendar), (Calendar)gregorianCalendar);
        }
    }

    @Override
    public void setValue(Date date, Calendar calendar) throws StandardException {
        this.restoreToNull();
        this.encodedDate = SQLDate.computeEncodedDate(date, calendar);
    }

    @Override
    public void setValue(Timestamp timestamp, Calendar calendar) throws StandardException {
        this.restoreToNull();
        this.encodedDate = SQLDate.computeEncodedDate(timestamp, calendar);
    }

    @Override
    public void setValue(String string) throws StandardException {
        this.restoreToNull();
        if (string != null) {
            DatabaseContext databaseContext = (DatabaseContext)DataValueFactoryImpl.getContext("Database");
            this.parseDate(string, false, databaseContext == null ? null : databaseContext.getDatabase(), null);
        }
    }

    NumberDataValue nullValueInt() {
        return new SQLInteger();
    }

    @Override
    public NumberDataValue getYear(NumberDataValue numberDataValue) throws StandardException {
        if (this.isNull()) {
            return this.nullValueInt();
        }
        return SQLDate.setSource(SQLDate.getYear(this.encodedDate), numberDataValue);
    }

    @Override
    public NumberDataValue getMonth(NumberDataValue numberDataValue) throws StandardException {
        if (this.isNull()) {
            return this.nullValueInt();
        }
        return SQLDate.setSource(SQLDate.getMonth(this.encodedDate), numberDataValue);
    }

    @Override
    public NumberDataValue getDate(NumberDataValue numberDataValue) throws StandardException {
        if (this.isNull()) {
            return this.nullValueInt();
        }
        return SQLDate.setSource(SQLDate.getDay(this.encodedDate), numberDataValue);
    }

    @Override
    public NumberDataValue getHours(NumberDataValue numberDataValue) throws StandardException {
        throw StandardException.newException("42X25", "getHours", "Date");
    }

    @Override
    public NumberDataValue getMinutes(NumberDataValue numberDataValue) throws StandardException {
        throw StandardException.newException("42X25", "getMinutes", "Date");
    }

    @Override
    public NumberDataValue getSeconds(NumberDataValue numberDataValue) throws StandardException {
        throw StandardException.newException("42X25", "getSeconds", "Date");
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        return this.getDate((Calendar)null).toString();
    }

    public int hashCode() {
        return this.encodedDate;
    }

    @Override
    public int typePrecedence() {
        return 100;
    }

    @Override
    public final boolean isNull() {
        return this.encodedDate == 0;
    }

    @Override
    public Date getDate(Calendar calendar) {
        if (this.isNull()) {
            return null;
        }
        return new Date(this.getTimeInMillis(calendar));
    }

    static int getYear(int n2) {
        return n2 >>> 16;
    }

    static int getMonth(int n2) {
        return n2 >>> 8 & 0xFF;
    }

    static int getDay(int n2) {
        return n2 & 0xFF;
    }

    static int computeEncodedDate(Calendar calendar) throws StandardException {
        return SQLDate.computeEncodedDate(calendar.get(1), calendar.get(2) + 1, calendar.get(5));
    }

    static int computeEncodedDate(int n2, int n3, int n4) throws StandardException {
        int n5 = 31;
        switch (n3) {
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                n5 = 30;
                break;
            }
            case 2: {
                int n6 = n5 = n2 % 4 == 0 && (n2 % 100 != 0 || n2 % 400 == 0) ? 29 : 28;
            }
        }
        if (n2 < 1 || n2 > 9999 || n3 < 1 || n3 > 12 || n4 < 1 || n4 > n5) {
            throw StandardException.newException("22007.S.180", new Object[0]);
        }
        return (n2 << 16) + (n3 << 8) + n4;
    }

    static void dateToString(int n2, int n3, int n4, StringBuffer stringBuffer) {
        String string = Integer.toString(n2);
        for (int i2 = string.length(); i2 < 4; ++i2) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string);
        stringBuffer.append('-');
        String string2 = Integer.toString(n3);
        String string3 = Integer.toString(n4);
        if (string2.length() == 1) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string2);
        stringBuffer.append('-');
        if (string3.length() == 1) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string3);
    }

    static String encodedDateToString(int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        SQLDate.dateToString(SQLDate.getYear(n2), SQLDate.getMonth(n2), SQLDate.getDay(n2), stringBuffer);
        return stringBuffer.toString();
    }

    static NumberDataValue setSource(int n2, NumberDataValue numberDataValue) throws StandardException {
        if (numberDataValue == null) {
            numberDataValue = new SQLInteger();
        }
        numberDataValue.setValue(n2);
        return numberDataValue;
    }

    private static int computeEncodedDate(java.util.Date date) throws StandardException {
        return SQLDate.computeEncodedDate(date, null);
    }

    static int computeEncodedDate(java.util.Date date, Calendar calendar) throws StandardException {
        if (date == null) {
            return 0;
        }
        if (calendar == null) {
            calendar = new GregorianCalendar();
        }
        calendar.setTime(date);
        return SQLDate.computeEncodedDate(calendar);
    }

    public static DateTimeDataValue computeDateFunction(DataValueDescriptor dataValueDescriptor, DataValueFactory dataValueFactory) throws StandardException {
        try {
            if (dataValueDescriptor.isNull()) {
                return new SQLDate();
            }
            if (dataValueDescriptor instanceof SQLDate) {
                return (SQLDate)dataValueDescriptor.cloneValue(false);
            }
            if (dataValueDescriptor instanceof SQLTimestamp) {
                SQLDate sQLDate = new SQLDate();
                sQLDate.setValue(dataValueDescriptor);
                return sQLDate;
            }
            if (dataValueDescriptor instanceof NumberDataValue) {
                int n2 = dataValueDescriptor.getInt();
                if (n2 <= 0 || n2 > 3652059) {
                    throw StandardException.newException("22008.S", dataValueDescriptor.getString(), "date");
                }
                GregorianCalendar gregorianCalendar = new GregorianCalendar(1970, 0, 1, 12, 0, 0);
                ((Calendar)gregorianCalendar).add(5, n2 - 1);
                return new SQLDate(SQLDate.computeEncodedDate(gregorianCalendar.get(1), gregorianCalendar.get(2) + 1, gregorianCalendar.get(5)));
            }
            String string = dataValueDescriptor.getString();
            if (string.length() == 7) {
                int n3 = SQLTimestamp.parseDateTimeInteger(string, 0, 4);
                int n4 = SQLTimestamp.parseDateTimeInteger(string, 4, 3);
                if (n4 < 1 || n4 > 366) {
                    throw StandardException.newException("22008.S", dataValueDescriptor.getString(), "date");
                }
                GregorianCalendar gregorianCalendar = new GregorianCalendar(n3, 0, 1, 2, 0, 0);
                ((Calendar)gregorianCalendar).add(6, n4 - 1);
                int n5 = gregorianCalendar.get(1);
                if (n5 != n3) {
                    throw StandardException.newException("22008.S", dataValueDescriptor.getString(), "date");
                }
                return new SQLDate(SQLDate.computeEncodedDate(n3, gregorianCalendar.get(2) + 1, gregorianCalendar.get(5)));
            }
            return dataValueFactory.getDateValue(string, false);
        }
        catch (StandardException standardException) {
            if ("22007.S.181".startsWith(standardException.getSQLState())) {
                throw StandardException.newException("22008.S", dataValueDescriptor.getString(), "date");
            }
            throw standardException;
        }
    }

    @Override
    public void setInto(PreparedStatement preparedStatement, int n2) throws SQLException, StandardException {
        preparedStatement.setDate(n2, this.getDate((Calendar)null));
    }

    @Override
    public DateTimeDataValue timestampAdd(int n2, NumberDataValue numberDataValue, Date date, DateTimeDataValue dateTimeDataValue) throws StandardException {
        return this.toTimestamp().timestampAdd(n2, numberDataValue, date, dateTimeDataValue);
    }

    private SQLTimestamp toTimestamp() throws StandardException {
        return new SQLTimestamp(this.getEncodedDate(), 0, 0);
    }

    @Override
    public NumberDataValue timestampDiff(int n2, DateTimeDataValue dateTimeDataValue, Date date, NumberDataValue numberDataValue) throws StandardException {
        return this.toTimestamp().timestampDiff(n2, dateTimeDataValue, date, numberDataValue);
    }
}

