/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PushbackInputStream;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.RuleBasedCollator;
import java.util.Calendar;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.CharacterStreamDescriptor;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.services.io.CloneableStream;
import org.apache.derby.iapi.services.io.FormatIdInputStream;
import org.apache.derby.iapi.services.io.InputStreamUtil;
import org.apache.derby.iapi.types.ClobStreamHeaderGenerator;
import org.apache.derby.iapi.types.CollatorSQLClob;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.HarmonySerialClob;
import org.apache.derby.iapi.types.ReaderToUTF8Stream;
import org.apache.derby.iapi.types.Resetable;
import org.apache.derby.iapi.types.SQLVarchar;
import org.apache.derby.iapi.types.StreamHeaderGenerator;
import org.apache.derby.iapi.types.StringDataValue;
import org.apache.derby.iapi.util.UTF8Util;

public class SQLClob
extends SQLVarchar {
    private static final StreamHeaderGenerator TEN_FOUR_CLOB_HEADER_GENERATOR = new ClobStreamHeaderGenerator(true);
    private static final StreamHeaderGenerator TEN_FIVE_CLOB_HEADER_GENERATOR = new ClobStreamHeaderGenerator(false);
    private static final int MAX_STREAM_HEADER_LENGTH = TEN_FIVE_CLOB_HEADER_GENERATOR.getMaxHeaderLength();
    private CharacterStreamDescriptor csd;
    private Boolean inSoftUpgradeMode = null;

    @Override
    public String getTypeName() {
        return "CLOB";
    }

    @Override
    public DataValueDescriptor cloneValue(boolean bl2) {
        SQLClob sQLClob = new SQLClob();
        sQLClob.inSoftUpgradeMode = this.inSoftUpgradeMode;
        if (this.isNull()) {
            return sQLClob;
        }
        if (!bl2) {
            if (this.stream != null && this.stream instanceof CloneableStream) {
                int n2 = -1;
                if (this.csd != null && this.csd.getCharLength() > 0L) {
                    n2 = (int)this.csd.getCharLength();
                }
                sQLClob.setValue(((CloneableStream)((Object)this.stream)).cloneStream(), n2);
            } else if (this._clobValue != null) {
                sQLClob.setValue(this._clobValue);
            }
        }
        if (sQLClob.isNull() || bl2) {
            try {
                sQLClob.setValue(this.getString());
            }
            catch (StandardException standardException) {
                return null;
            }
        }
        return sQLClob;
    }

    @Override
    public DataValueDescriptor getNewNull() {
        SQLClob sQLClob = new SQLClob();
        sQLClob.inSoftUpgradeMode = this.inSoftUpgradeMode;
        return sQLClob;
    }

    @Override
    public StringDataValue getValue(RuleBasedCollator ruleBasedCollator) {
        if (ruleBasedCollator == null) {
            return this;
        }
        CollatorSQLClob collatorSQLClob = new CollatorSQLClob(ruleBasedCollator);
        collatorSQLClob.copyState(this);
        return collatorSQLClob;
    }

    @Override
    public int getTypeFormatId() {
        return 447;
    }

    public SQLClob() {
    }

    public SQLClob(String string) {
        super(string);
    }

    public SQLClob(Clob clob) {
        super(clob);
    }

    @Override
    public int typePrecedence() {
        return 14;
    }

    @Override
    public boolean getBoolean() throws StandardException {
        throw this.dataTypeConversion("boolean");
    }

    @Override
    public byte getByte() throws StandardException {
        throw this.dataTypeConversion("byte");
    }

    @Override
    public short getShort() throws StandardException {
        throw this.dataTypeConversion("short");
    }

    @Override
    public int getInt() throws StandardException {
        throw this.dataTypeConversion("int");
    }

    @Override
    public int getLength() throws StandardException {
        boolean bl2;
        if (this.stream == null) {
            return super.getLength();
        }
        if (!(this.stream instanceof Resetable)) {
            return super.getLength();
        }
        boolean bl3 = bl2 = this.csd != null;
        if (this.csd == null) {
            this.getStreamWithDescriptor();
        }
        if (this.csd.getCharLength() != 0L) {
            return (int)this.csd.getCharLength();
        }
        long l2 = 0L;
        try {
            if (bl2) {
                this.rewindStream(this.stream, this.csd.getDataOffset());
            }
            l2 = UTF8Util.skipUntilEOF(this.stream);
            this.rewindStream(this.stream, 0L);
        }
        catch (IOException iOException) {
            this.throwStreamingIOException(iOException);
        }
        this.csd = new CharacterStreamDescriptor.Builder().copyState(this.csd).charLength(l2).curBytePos(0L).curCharPos(0L).build();
        return (int)l2;
    }

    @Override
    public long getLong() throws StandardException {
        throw this.dataTypeConversion("long");
    }

    @Override
    public float getFloat() throws StandardException {
        throw this.dataTypeConversion("float");
    }

    @Override
    public double getDouble() throws StandardException {
        throw this.dataTypeConversion("double");
    }

    @Override
    public int typeToBigDecimal() throws StandardException {
        throw this.dataTypeConversion("java.math.BigDecimal");
    }

    @Override
    public byte[] getBytes() throws StandardException {
        throw this.dataTypeConversion("byte[]");
    }

    @Override
    public Date getDate(Calendar calendar) throws StandardException {
        throw this.dataTypeConversion("java.sql.Date");
    }

    @Override
    public Object getObject() throws StandardException {
        if (this._clobValue != null) {
            return this._clobValue;
        }
        String string = this.getString();
        if (string == null) {
            return null;
        }
        return new HarmonySerialClob(string.toCharArray());
    }

    @Override
    public CharacterStreamDescriptor getStreamWithDescriptor() throws StandardException {
        if (this.stream == null) {
            this.csd = null;
            throw StandardException.newException("42Z12.U", this.getTypeName());
        }
        if (this.csd != null && this.stream instanceof Resetable) {
            try {
                ((Resetable)((Object)this.stream)).resetStream();
                InputStreamUtil.skipFully(this.stream, this.csd.getCurBytePos());
            }
            catch (IOException iOException) {
                this.throwStreamingIOException(iOException);
            }
        }
        if (this.csd == null) {
            try {
                byte[] byArray = new byte[MAX_STREAM_HEADER_LENGTH];
                int n2 = this.stream.read(byArray);
                HeaderInfo headerInfo = this.investigateHeader(byArray, n2);
                if (n2 > headerInfo.headerLength()) {
                    n2 = headerInfo.headerLength();
                    this.rewindStream(this.stream, n2);
                }
                this.csd = new CharacterStreamDescriptor.Builder().stream(this.stream).bufferable(false).positionAware(false).curCharPos(n2 == 0 ? 0L : 1L).curBytePos(n2).dataOffset(headerInfo.headerLength()).byteLength(headerInfo.byteLength()).charLength(headerInfo.charLength()).build();
            }
            catch (IOException iOException) {
                StandardException standardException;
                Throwable throwable = iOException;
                while (throwable.getCause() != null) {
                    throwable = throwable.getCause();
                }
                if (throwable instanceof StandardException && (standardException = (StandardException)throwable).getMessageId().equals("40XD0")) {
                    throw StandardException.newException("XJ073.S", iOException, new Object[0]);
                }
                this.throwStreamingIOException(iOException);
            }
        }
        return this.csd;
    }

    @Override
    public boolean hasStream() {
        return this.stream != null;
    }

    @Override
    public Time getTime(Calendar calendar) throws StandardException {
        throw this.dataTypeConversion("java.sql.Time");
    }

    @Override
    public Timestamp getTimestamp(Calendar calendar) throws StandardException {
        throw this.dataTypeConversion("java.sql.Timestamp");
    }

    @Override
    public final String getTraceString() throws StandardException {
        if (this.isNull()) {
            return "NULL";
        }
        if (this.hasStream()) {
            return this.getTypeName() + "(" + this.getStream().toString() + ")";
        }
        return this.getTypeName() + "(" + this.getLength() + ")";
    }

    @Override
    public void normalize(DataTypeDescriptor dataTypeDescriptor, DataValueDescriptor dataValueDescriptor) throws StandardException {
        if (dataValueDescriptor instanceof SQLClob) {
            SQLClob sQLClob = (SQLClob)dataValueDescriptor;
            if (sQLClob.stream != null) {
                this.copyState(sQLClob);
                return;
            }
        }
        super.normalize(dataTypeDescriptor, dataValueDescriptor);
    }

    @Override
    public void setValue(Time time, Calendar calendar) throws StandardException {
        this.throwLangSetMismatch("java.sql.Time");
    }

    @Override
    public void setValue(Timestamp timestamp, Calendar calendar) throws StandardException {
        this.throwLangSetMismatch("java.sql.Timestamp");
    }

    @Override
    public void setValue(Date date, Calendar calendar) throws StandardException {
        this.throwLangSetMismatch("java.sql.Date");
    }

    @Override
    public void setBigDecimal(BigDecimal bigDecimal) throws StandardException {
        this.throwLangSetMismatch("java.math.BigDecimal");
    }

    @Override
    public final void setStream(InputStream inputStream) {
        super.setStream(inputStream);
        this.csd = null;
    }

    @Override
    public final void restoreToNull() {
        this.csd = null;
        super.restoreToNull();
    }

    @Override
    public void setValue(int n2) throws StandardException {
        this.throwLangSetMismatch("int");
    }

    @Override
    public void setValue(double d2) throws StandardException {
        this.throwLangSetMismatch("double");
    }

    @Override
    public void setValue(float f2) throws StandardException {
        this.throwLangSetMismatch("float");
    }

    @Override
    public void setValue(short s2) throws StandardException {
        this.throwLangSetMismatch("short");
    }

    @Override
    public void setValue(long l2) throws StandardException {
        this.throwLangSetMismatch("long");
    }

    @Override
    public void setValue(byte by) throws StandardException {
        this.throwLangSetMismatch("byte");
    }

    @Override
    public void setValue(boolean bl2) throws StandardException {
        this.throwLangSetMismatch("boolean");
    }

    @Override
    public void setValue(byte[] byArray) throws StandardException {
        this.throwLangSetMismatch("byte[]");
    }

    @Override
    final void setObject(Object object) throws StandardException {
        Clob clob = (Clob)object;
        try {
            long l2 = clob.length();
            if (l2 < 0L || l2 > Integer.MAX_VALUE) {
                throw this.outOfRange();
            }
            if (l2 < 32768L) {
                this.setValue(clob.getSubString(1L, (int)l2));
            } else {
                ReaderToUTF8Stream readerToUTF8Stream = new ReaderToUTF8Stream(clob.getCharacterStream(), (int)l2, 0, "CLOB", this.getStreamHeaderGenerator());
                this.setValue(readerToUTF8Stream, (int)l2);
            }
        }
        catch (SQLException sQLException) {
            throw this.dataTypeConversion("DAN-438-tmp");
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeClobUTF(objectOutput);
    }

    @Override
    public StreamHeaderGenerator getStreamHeaderGenerator() {
        if (this.inSoftUpgradeMode == null) {
            return new ClobStreamHeaderGenerator(this);
        }
        if (this.inSoftUpgradeMode == Boolean.TRUE) {
            return TEN_FOUR_CLOB_HEADER_GENERATOR;
        }
        return TEN_FIVE_CLOB_HEADER_GENERATOR;
    }

    @Override
    public void setStreamHeaderFormat(Boolean bl2) {
        this.inSoftUpgradeMode = bl2;
    }

    private HeaderInfo investigateHeader(byte[] byArray, int n2) throws IOException {
        int n3 = MAX_STREAM_HEADER_LENGTH;
        int n4 = -1;
        int n5 = -1;
        if (n2 < n3 || (byArray[2] & 0xF0) != 240) {
            n3 = 2;
        }
        if (n3 == 2) {
            n4 = (byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF;
            if (n2 < MAX_STREAM_HEADER_LENGTH && n3 + n4 != n2) {
                throw new IOException("Corrupted stream; headerLength=" + n3 + ", utfLen=" + n4 + ", bytesRead=" + n2);
            }
            if (n4 > 0) {
                n4 += n3;
            }
        } else if (n3 == 5) {
            int n6 = byArray[2] & 0xF;
            switch (n6) {
                case 0: {
                    n5 = (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[3] & 0xFF) << 8 | (byArray[4] & 0xFF) << 0;
                    break;
                }
                default: {
                    throw new IOException("Invalid header format identifier: " + n6 + "(magic byte is 0x" + Integer.toHexString(byArray[2] & 0xFF) + ")");
                }
            }
        }
        return new HeaderInfo(n3, n3 == 5 ? n5 : n4);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException {
        HeaderInfo headerInfo;
        int n2;
        if (this.csd != null) {
            n2 = (int)this.csd.getDataOffset();
            int n3 = n2 == 5 ? (int)this.csd.getCharLength() : (int)this.csd.getByteLength();
            headerInfo = new HeaderInfo(n2, n3);
            this.rewindStream((InputStream)((Object)objectInput), n2);
        } else {
            byte[] byArray;
            int n4;
            InputStream inputStream = (InputStream)((Object)objectInput);
            boolean bl2 = inputStream.markSupported();
            if (bl2) {
                inputStream.mark(MAX_STREAM_HEADER_LENGTH);
            }
            if ((n4 = objectInput.read(byArray = new byte[MAX_STREAM_HEADER_LENGTH])) > (headerInfo = this.investigateHeader(byArray, n4)).headerLength()) {
                if (bl2) {
                    inputStream.reset();
                    InputStreamUtil.skipFully(inputStream, headerInfo.headerLength());
                } else if (objectInput instanceof FormatIdInputStream) {
                    int n5 = n4 - headerInfo.headerLength();
                    FormatIdInputStream formatIdInputStream = (FormatIdInputStream)objectInput;
                    PushbackInputStream pushbackInputStream = new PushbackInputStream(formatIdInputStream.getInputStream(), n5);
                    pushbackInputStream.unread(byArray, headerInfo.headerLength(), n5);
                    formatIdInputStream.setInput(pushbackInputStream);
                } else {
                    this.rewindStream(inputStream, headerInfo.headerLength());
                }
            }
        }
        n2 = 0;
        if (headerInfo.byteLength() != 0) {
            n2 = headerInfo.byteLength() - headerInfo.headerLength();
        }
        super.readExternal(objectInput, n2, headerInfo.charLength());
    }

    @Override
    public void readExternalFromArray(ArrayInputStream arrayInputStream) throws IOException {
        HeaderInfo headerInfo;
        int n2 = arrayInputStream.getPosition();
        byte[] byArray = new byte[MAX_STREAM_HEADER_LENGTH];
        int n3 = arrayInputStream.read(byArray);
        if (n3 > (headerInfo = this.investigateHeader(byArray, n3)).headerLength()) {
            arrayInputStream.setPosition(n2);
            super.readExternalFromArray(arrayInputStream);
        } else {
            super.readExternalClobFromArray(arrayInputStream, headerInfo.charLength());
        }
    }

    private void rewindStream(InputStream inputStream, long l2) throws IOException {
        try {
            ((Resetable)((Object)inputStream)).resetStream();
            InputStreamUtil.skipFully(inputStream, l2);
        }
        catch (StandardException standardException) {
            IOException iOException = new IOException(standardException.getMessage());
            iOException.initCause(standardException);
            throw iOException;
        }
    }

    private static class HeaderInfo {
        private final int valueLength;
        private final int headerLength;

        HeaderInfo(int n2, int n3) {
            this.headerLength = n2;
            this.valueLength = n3;
        }

        int headerLength() {
            return this.headerLength;
        }

        int charLength() {
            return this.isCharLength() ? this.valueLength : 0;
        }

        int byteLength() {
            return this.isCharLength() ? 0 : this.valueLength;
        }

        boolean isCharLength() {
            return this.headerLength == 5;
        }

        public String toString() {
            return "headerLength=" + this.headerLength + ", valueLength= " + this.valueLength + ", isCharLength=" + this.isCharLength();
        }
    }
}

