/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLBinary;
import org.apache.derby.iapi.util.StringUtil;

public class SQLBit
extends SQLBinary {
    @Override
    public Object getObject() throws StandardException {
        return this.getBytes();
    }

    @Override
    public String getTypeName() {
        return "CHAR () FOR BIT DATA";
    }

    @Override
    int getMaxMemoryUsage() {
        return 254;
    }

    @Override
    public int getTypeFormatId() {
        return 87;
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return new SQLBit();
    }

    @Override
    public final void setValueFromResultSet(ResultSet resultSet, int n2, boolean bl2) throws SQLException {
        this.setValue(resultSet.getBytes(n2));
    }

    @Override
    public int typePrecedence() {
        return 140;
    }

    @Override
    final void setObject(Object object) throws StandardException {
        this.setValue((byte[])object);
    }

    public SQLBit() {
    }

    public SQLBit(byte[] byArray) {
        this.dataValue = byArray;
    }

    @Override
    public void normalize(DataTypeDescriptor dataTypeDescriptor, DataValueDescriptor dataValueDescriptor) throws StandardException {
        int n2 = dataTypeDescriptor.getMaximumWidth();
        this.setValue(dataValueDescriptor.getBytes());
        this.setWidth(n2, 0, true);
    }

    @Override
    public void setWidth(int n2, int n3, boolean bl2) throws StandardException {
        if (this.getValue() == null) {
            return;
        }
        int n4 = this.dataValue.length;
        if (n4 < n2) {
            byte[] byArray = new byte[n2];
            System.arraycopy(this.dataValue, 0, byArray, 0, this.dataValue.length);
            Arrays.fill(byArray, this.dataValue.length, byArray.length, (byte)32);
            this.dataValue = byArray;
        } else if (n4 > n2) {
            if (bl2) {
                for (int i2 = n2; i2 < this.dataValue.length; ++i2) {
                    if (this.dataValue[i2] == 32) continue;
                    throw StandardException.newException("22001", this.getTypeName(), StringUtil.formatForPrint(this.toString()), String.valueOf(n2));
                }
            }
            this.truncate(n4, n2, !bl2);
        }
    }
}

