/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.DerbyIOException;
import org.apache.derby.iapi.services.io.LimitReader;
import org.apache.derby.iapi.types.StreamHeaderGenerator;

public final class ReaderToUTF8Stream
extends InputStream {
    private LimitReader reader;
    private static final int FIRST_READ = Integer.MIN_VALUE;
    private static final int READ_BUFFER_RESERVATION = 6;
    private static final int MARK_UNSET_OR_EXCEEDED = -1;
    private byte[] buffer;
    private int boff;
    private int blen = -1;
    private int mark = -1;
    private int readAheadLimit;
    private boolean eof;
    private boolean multipleBuffer;
    private final StreamHeaderGenerator hdrGen;
    private int headerLength;
    private final int charsToTruncate;
    private static final char SPACE = ' ';
    private final int valueLength;
    private final String typeName;
    private int charCount;

    public ReaderToUTF8Stream(Reader reader, int n2, int n3, String string, StreamHeaderGenerator streamHeaderGenerator) {
        this.reader = new LimitReader(reader);
        this.charsToTruncate = n3;
        this.valueLength = n2;
        this.typeName = string;
        this.hdrGen = streamHeaderGenerator;
        int n4 = Math.abs(n2);
        this.reader.setLimit(n4);
        int n5 = 32768;
        if (n4 < n5 / 3) {
            n5 = this.hdrGen.getMaxHeaderLength() + Math.max(6, n4 * 3 + 3);
        }
        this.buffer = new byte[n5];
    }

    public ReaderToUTF8Stream(Reader reader, int n2, String string, StreamHeaderGenerator streamHeaderGenerator) {
        this(reader, -1 * n2, 0, string, streamHeaderGenerator);
        if (n2 < 0) {
            throw new IllegalArgumentException("Maximum length for a capped stream cannot be negative: " + n2);
        }
    }

    @Override
    public int read() throws IOException {
        if (this.buffer == null) {
            throw new EOFException(MessageService.getTextMessage("XJ085.S", new Object[0]));
        }
        if (this.blen < 0) {
            this.fillBuffer(Integer.MIN_VALUE);
        }
        while (this.boff == this.blen) {
            if (this.eof) {
                this.close();
                return -1;
            }
            this.fillBuffer(0);
        }
        return this.buffer[this.boff++] & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (this.buffer == null) {
            throw new EOFException(MessageService.getTextMessage("XJ085.S", new Object[0]));
        }
        if (this.blen < 0) {
            this.fillBuffer(Integer.MIN_VALUE);
        }
        int n4 = 0;
        while (n3 > 0) {
            int n5 = this.blen - this.boff;
            if (n5 == 0) {
                if (this.eof) {
                    if (n4 > 0) {
                        return n4;
                    }
                    this.close();
                    return -1;
                }
                this.fillBuffer(0);
                continue;
            }
            if (n3 < n5) {
                n5 = n3;
            }
            System.arraycopy(this.buffer, this.boff, byArray, n2, n5);
            this.boff += n5;
            n3 -= n5;
            n4 += n5;
            n2 += n5;
        }
        return n4;
    }

    private void fillBuffer(int n2) throws IOException {
        int n3;
        if (n2 == Integer.MIN_VALUE) {
            this.headerLength = this.hdrGen.expectsCharCount() && this.valueLength >= 0 ? this.hdrGen.generateInto(this.buffer, 0, this.valueLength) : this.hdrGen.generateInto(this.buffer, 0, -1L);
            n2 = this.headerLength;
        }
        int n4 = n2;
        this.boff = 0;
        if (n4 == 0) {
            this.multipleBuffer = true;
        }
        if (this.mark >= 0) {
            n3 = this.readAheadLimit + 6;
            if (this.mark + n3 > this.buffer.length) {
                if (this.blen != -1) {
                    this.boff = n4 = this.blen - this.mark;
                }
                byte[] byArray = this.buffer;
                if (n3 > this.buffer.length) {
                    this.buffer = new byte[n3];
                }
                System.arraycopy(byArray, this.mark, this.buffer, 0, n4);
                this.mark = 0;
            } else if (this.blen != -1) {
                this.mark = -1;
            }
        }
        while (n4 <= this.buffer.length - 6) {
            n3 = this.reader.read();
            if (n3 < 0) {
                this.eof = true;
                break;
            }
            ++this.charCount;
            if (n3 >= 1 && n3 <= 127) {
                this.buffer[n4++] = (byte)n3;
                continue;
            }
            if (n3 > 2047) {
                this.buffer[n4++] = (byte)(0xE0 | n3 >> 12 & 0xF);
                this.buffer[n4++] = (byte)(0x80 | n3 >> 6 & 0x3F);
                this.buffer[n4++] = (byte)(0x80 | n3 >> 0 & 0x3F);
                continue;
            }
            this.buffer[n4++] = (byte)(0xC0 | n3 >> 6 & 0x1F);
            this.buffer[n4++] = (byte)(0x80 | n3 >> 0 & 0x3F);
        }
        this.blen = n4;
        if (this.eof) {
            this.checkSufficientData();
        }
    }

    private void checkSufficientData() throws IOException {
        int n2;
        if (this.charsToTruncate > 0) {
            this.reader.setLimit(this.charsToTruncate);
            this.truncate();
        }
        if ((n2 = this.reader.clearLimit()) > 0 && this.valueLength > 0) {
            throw new DerbyIOException(MessageService.getTextMessage("XJ023.S", new Object[0]), "XJ023.S");
        }
        if (n2 == 0 && this.reader.read() >= 0) {
            if (this.valueLength > -1) {
                throw new DerbyIOException(MessageService.getTextMessage("XJ023.S", new Object[0]), "XJ023.S");
            }
            if (this.canTruncate()) {
                this.truncate();
            } else {
                throw new DerbyIOException(MessageService.getTextMessage("22001", this.typeName, "<stream-value>", String.valueOf(Math.abs(this.valueLength))), "22001");
            }
        }
        if (!this.multipleBuffer) {
            int n3 = -1;
            n3 = this.hdrGen.expectsCharCount() ? this.charCount : this.blen - this.headerLength;
            int n4 = this.hdrGen.generateInto(this.buffer, 0, n3);
            if (n4 != this.headerLength) {
                throw new IOException("Data corruption detected; user data overwritten by header bytes");
            }
            this.blen += this.hdrGen.writeEOF(this.buffer, this.blen, n3);
        } else {
            this.blen += this.hdrGen.writeEOF(this.buffer, this.blen, Math.max(this.valueLength, -1));
        }
    }

    private boolean canTruncate() {
        if (this.typeName.equals("CLOB")) {
            return true;
        }
        if (this.typeName.equals("VARCHAR")) {
            return true;
        }
        return this.typeName.equals("CHAR");
    }

    private void truncate() throws IOException {
        int n2 = 0;
        while ((n2 = this.reader.read()) >= 0) {
            if (n2 == 32) continue;
            throw new DerbyIOException(MessageService.getTextMessage("22001", this.typeName, "<stream-value>", String.valueOf(Math.abs(this.valueLength))), "22001");
        }
    }

    @Override
    public void close() {
        this.buffer = null;
    }

    @Override
    public final int available() {
        int n2 = this.reader.getLimit();
        return this.buffer.length > n2 ? n2 : this.buffer.length;
    }

    @Override
    public void mark(int n2) {
        if (n2 > 0) {
            this.readAheadLimit = n2;
            this.mark = this.boff;
        } else {
            this.mark = -1;
            this.readAheadLimit = -1;
        }
    }

    @Override
    public void reset() throws IOException {
        if (this.buffer == null) {
            throw new EOFException(MessageService.getTextMessage("XJ085.S", new Object[0]));
        }
        if (this.mark == -1) {
            throw new IOException(MessageService.getTextMessage("I027", new Object[0]));
        }
        this.boff = this.mark;
        this.mark = -1;
        this.readAheadLimit = -1;
    }

    @Override
    public boolean markSupported() {
        return true;
    }
}

