/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import org.apache.derby.iapi.types.HarmonySerialBlob;

public class HarmonySerialClob
implements Serializable,
Cloneable,
Clob {
    private static final long serialVersionUID = -1662519690087375313L;
    private char[] buf;
    private Clob clob;
    private long len;
    private long origLen;

    public HarmonySerialClob(String string) {
        this(string.toCharArray());
    }

    public HarmonySerialClob(char[] cArray) {
        this.buf = new char[cArray.length];
        this.len = this.origLen = (long)cArray.length;
        System.arraycopy(cArray, 0, this.buf, 0, (int)this.len);
    }

    public HarmonySerialClob(Clob clob) throws SQLException {
        if (clob == null) {
            throw new IllegalArgumentException();
        }
        Reader reader = clob.getCharacterStream();
        if (reader == null && clob.getAsciiStream() == null) {
            throw new IllegalArgumentException();
        }
        this.clob = clob;
        this.len = this.origLen = clob.length();
        this.buf = new char[(int)this.len];
        try {
            reader.read(this.buf);
        }
        catch (IOException iOException) {
            SQLException sQLException = new SQLException("SerialClob: " + iOException.getMessage());
            sQLException.initCause(iOException);
            throw sQLException;
        }
    }

    @Override
    public long length() throws SQLException {
        this.checkValidation();
        return this.len;
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        this.checkValidation();
        if (this.clob == null) {
            throw new IllegalStateException();
        }
        return this.clob.getAsciiStream();
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        this.checkValidation();
        return new CharArrayReader(this.buf);
    }

    @Override
    public String getSubString(long l2, int n2) throws SQLException {
        this.checkValidation();
        if (n2 < 0) {
            throw HarmonySerialBlob.makeSQLException("XJ071.S", new Object[]{n2});
        }
        if (l2 < 1L || l2 > this.len || l2 + (long)n2 > this.len + 1L) {
            throw HarmonySerialBlob.makeSQLException("XJ070.S", new Object[]{l2});
        }
        try {
            return new String(this.buf, (int)(l2 - 1L), n2);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new SQLException();
        }
    }

    @Override
    public long position(Clob clob, long l2) throws SQLException {
        this.checkValidation();
        String string = clob.getSubString(1L, (int)clob.length());
        return this.position(string, l2);
    }

    @Override
    public long position(String string, long l2) throws SQLException, SQLException {
        this.checkValidation();
        if (l2 < 1L || this.len - (l2 - 1L) < (long)string.length()) {
            return -1L;
        }
        char[] cArray = string.toCharArray();
        int n2 = (int)l2 - 1;
        while ((long)n2 < this.len) {
            if (this.match(this.buf, n2, cArray)) {
                return n2 + 1;
            }
            ++n2;
        }
        return -1L;
    }

    private boolean match(char[] cArray, int n2, char[] cArray2) {
        int n3 = 0;
        while (n3 < cArray2.length) {
            if (cArray[n2++] == cArray2[n3++]) continue;
            return false;
        }
        return true;
    }

    @Override
    public OutputStream setAsciiStream(long l2) throws SQLException {
        this.checkValidation();
        if (this.clob == null) {
            throw new IllegalStateException();
        }
        OutputStream outputStream = this.clob.setAsciiStream(l2);
        if (outputStream == null) {
            throw new IllegalStateException();
        }
        return outputStream;
    }

    @Override
    public Writer setCharacterStream(long l2) throws SQLException {
        this.checkValidation();
        if (this.clob == null) {
            throw new IllegalStateException();
        }
        Writer writer = this.clob.setCharacterStream(l2);
        if (writer == null) {
            throw new IllegalStateException();
        }
        return writer;
    }

    @Override
    public int setString(long l2, String string) throws SQLException {
        this.checkValidation();
        return this.setString(l2, string, 0, string.length());
    }

    @Override
    public int setString(long l2, String string, int n2, int n3) throws SQLException {
        this.checkValidation();
        if (l2 < 1L) {
            throw HarmonySerialBlob.makeSQLException("XJ070.S", new Object[]{l2});
        }
        if (n3 < 0) {
            throw HarmonySerialBlob.makeSQLException("XJ071.S", null);
        }
        if (l2 > this.len - (long)n3 + 1L) {
            throw HarmonySerialBlob.makeSQLException("XJ076.S", null);
        }
        if (n2 < 0 || n2 > string.length() - n3) {
            throw HarmonySerialBlob.makeSQLException("XJ078.S", null);
        }
        if ((long)n3 > this.len + (long)n2) {
            throw HarmonySerialBlob.makeSQLException("XJ078.S", null);
        }
        string.getChars(n2, n2 + n3, this.buf, (int)l2 - 1);
        return n3;
    }

    @Override
    public void truncate(long l2) throws SQLException {
        this.checkValidation();
        if (l2 < 0L) {
            throw HarmonySerialBlob.makeSQLException("XJ071.S", new Object[]{l2});
        }
        if (l2 > this.len) {
            throw HarmonySerialBlob.makeSQLException("XJ079.S", new Object[]{l2});
        }
        char[] cArray = new char[(int)l2];
        System.arraycopy(this.buf, 0, cArray, 0, (int)l2);
        this.buf = cArray;
        this.len = l2;
    }

    @Override
    public void free() throws SQLException {
        if (this.len != -1L) {
            this.len = -1L;
            this.clob = null;
            this.buf = null;
        }
    }

    @Override
    public Reader getCharacterStream(long l2, long l3) throws SQLException {
        this.checkValidation();
        return new CharArrayReader(this.buf, (int)l2, (int)l3);
    }

    private void checkValidation() throws SQLException {
        if (this.len == -1L) {
            throw HarmonySerialBlob.makeSQLException("XJ215.S", null);
        }
    }
}

