/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;

public class HarmonySerialBlob
implements Serializable,
Cloneable,
Blob {
    private static final long serialVersionUID = -8144641928112860441L;
    private byte[] buf;
    private Blob blob;
    private long len;
    private long origLen;

    public HarmonySerialBlob(Blob blob) throws SQLException {
        if (blob == null) {
            throw new IllegalArgumentException();
        }
        this.blob = blob;
        this.buf = blob.getBytes(1L, (int)blob.length());
        this.origLen = this.len = (long)this.buf.length;
    }

    public HarmonySerialBlob(byte[] byArray) {
        this.buf = new byte[byArray.length];
        this.origLen = this.len = (long)byArray.length;
        System.arraycopy(byArray, 0, this.buf, 0, (int)this.len);
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        return new ByteArrayInputStream(this.buf);
    }

    @Override
    public byte[] getBytes(long l2, int n2) throws SQLException {
        if (l2 < 1L || l2 > this.len) {
            throw HarmonySerialBlob.makeSQLException("XJ070.S", new Object[]{l2});
        }
        if (n2 < 0) {
            throw HarmonySerialBlob.makeSQLException("XJ071.S", new Object[]{n2});
        }
        if ((long)n2 > this.len - l2 + 1L) {
            n2 = (int)(this.len - l2 + 1L);
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(this.buf, (int)l2 - 1, byArray, 0, n2);
        return byArray;
    }

    @Override
    public long length() throws SQLException {
        return this.len;
    }

    @Override
    public long position(Blob blob, long l2) throws SQLException {
        byte[] byArray = blob.getBytes(1L, (int)blob.length());
        return this.position(byArray, l2);
    }

    @Override
    public long position(byte[] byArray, long l2) throws SQLException {
        if (l2 < 1L || this.len - (l2 - 1L) < (long)byArray.length) {
            return -1L;
        }
        int n2 = (int)(l2 - 1L);
        while ((long)n2 <= this.len - (long)byArray.length) {
            if (this.match(this.buf, n2, byArray)) {
                return n2 + 1;
            }
            ++n2;
        }
        return -1L;
    }

    private boolean match(byte[] byArray, int n2, byte[] byArray2) {
        int n3 = 0;
        while (n3 < byArray2.length) {
            if (byArray[n2++] == byArray2[n3++]) continue;
            return false;
        }
        return true;
    }

    @Override
    public OutputStream setBinaryStream(long l2) throws SQLException {
        if (this.blob == null) {
            throw new IllegalStateException();
        }
        OutputStream outputStream = this.blob.setBinaryStream(l2);
        if (outputStream == null) {
            throw new IllegalStateException();
        }
        return outputStream;
    }

    @Override
    public int setBytes(long l2, byte[] byArray) throws SQLException {
        return this.setBytes(l2, byArray, 0, byArray.length);
    }

    @Override
    public int setBytes(long l2, byte[] byArray, int n2, int n3) throws SQLException {
        if (l2 < 1L || n3 < 0 || l2 > this.len - (long)n3 + 1L) {
            throw HarmonySerialBlob.makeSQLException("XJ070.S", new Object[]{l2});
        }
        if (n2 < 0 || n3 < 0 || n2 > byArray.length - n3) {
            throw HarmonySerialBlob.makeSQLException("XJ078.S", new Object[]{n2});
        }
        System.arraycopy(byArray, n2, this.buf, (int)l2 - 1, n3);
        return n3;
    }

    @Override
    public void truncate(long l2) throws SQLException {
        if (l2 > this.len) {
            throw HarmonySerialBlob.makeSQLException("XJ079.S", new Object[]{this.len});
        }
        this.buf = this.getBytes(1L, (int)l2);
        this.len = l2;
    }

    @Override
    public void free() throws SQLException {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public InputStream getBinaryStream(long l2, long l3) throws SQLException {
        if (this.len < 0L) {
            throw HarmonySerialBlob.makeSQLException("XJ071.S", new Object[]{this.len});
        }
        if (l3 < 0L) {
            throw HarmonySerialBlob.makeSQLException("XJ071.S", new Object[]{l3});
        }
        if (l2 < 1L || l2 + l3 > this.len) {
            throw HarmonySerialBlob.makeSQLException("XJ087.S", new Object[]{l2, l3});
        }
        return new ByteArrayInputStream(this.buf, (int)(l2 - 1L), (int)l3);
    }

    public static SQLException makeSQLException(String string, Object[] objectArray) {
        StandardException standardException = StandardException.newException(string, objectArray);
        return new SQLException(standardException.getMessage(), standardException.getSQLState());
    }
}

