/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.ObjectOutput;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.derby.iapi.db.DatabaseContext;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.Context;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.types.CharStreamHeaderGenerator;
import org.apache.derby.iapi.types.StreamHeaderGenerator;
import org.apache.derby.iapi.types.StringDataValue;

public final class ClobStreamHeaderGenerator
implements StreamHeaderGenerator {
    private static final byte MAGIC_BYTE = -16;
    private static final byte[] UNKNOWN_LENGTH = new byte[]{0, 0, -16, 0, 0};
    private static final CharStreamHeaderGenerator CHARHDRGEN = new CharStreamHeaderGenerator();
    private final StringDataValue callbackDVD;
    private Boolean isPreDerbyTenFive;

    public ClobStreamHeaderGenerator(StringDataValue stringDataValue) {
        if (stringDataValue == null) {
            throw new IllegalStateException("dvd cannot be null");
        }
        this.callbackDVD = stringDataValue;
    }

    public ClobStreamHeaderGenerator(boolean bl2) {
        this.callbackDVD = null;
        this.isPreDerbyTenFive = bl2;
    }

    @Override
    public boolean expectsCharCount() {
        if (this.callbackDVD != null && this.isPreDerbyTenFive == null) {
            this.determineHeaderFormat();
        }
        return this.isPreDerbyTenFive == false;
    }

    @Override
    public int generateInto(byte[] byArray, int n2, long l2) {
        if (this.callbackDVD != null && this.isPreDerbyTenFive == null) {
            this.determineHeaderFormat();
        }
        int n3 = 0;
        if (this.isPreDerbyTenFive == Boolean.FALSE) {
            if (l2 >= 0L) {
                byArray[n2 + n3++] = (byte)(l2 >>> 24);
                byArray[n2 + n3++] = (byte)(l2 >>> 16);
                byArray[n2 + n3++] = -16;
                byArray[n2 + n3++] = (byte)(l2 >>> 8);
                byArray[n2 + n3++] = (byte)(l2 >>> 0);
            } else {
                n3 = UNKNOWN_LENGTH.length;
                System.arraycopy(UNKNOWN_LENGTH, 0, byArray, n2, n3);
            }
        } else {
            n3 = CHARHDRGEN.generateInto(byArray, n2, l2);
        }
        return n3;
    }

    @Override
    public int generateInto(ObjectOutput objectOutput, long l2) throws IOException {
        if (this.callbackDVD != null && this.isPreDerbyTenFive == null) {
            this.determineHeaderFormat();
        }
        int n2 = 0;
        if (this.isPreDerbyTenFive == Boolean.FALSE) {
            n2 = 5;
            if (l2 > 0L) {
                objectOutput.writeByte((byte)(l2 >>> 24));
                objectOutput.writeByte((byte)(l2 >>> 16));
                objectOutput.writeByte(-16);
                objectOutput.writeByte((byte)(l2 >>> 8));
                objectOutput.writeByte((byte)(l2 >>> 0));
            } else {
                objectOutput.write(UNKNOWN_LENGTH);
            }
        } else {
            n2 = CHARHDRGEN.generateInto(objectOutput, l2);
        }
        return n2;
    }

    @Override
    public int writeEOF(byte[] byArray, int n2, long l2) {
        if (this.callbackDVD != null && this.isPreDerbyTenFive == null) {
            this.determineHeaderFormat();
        }
        if (!this.isPreDerbyTenFive.booleanValue()) {
            if (l2 < 0L) {
                return CharStreamHeaderGenerator.writeEOFMarker(byArray, n2);
            }
            return 0;
        }
        return CHARHDRGEN.writeEOF(byArray, n2, l2);
    }

    @Override
    public int writeEOF(ObjectOutput objectOutput, long l2) throws IOException {
        if (this.callbackDVD != null && this.isPreDerbyTenFive == null) {
            this.determineHeaderFormat();
        }
        if (!this.isPreDerbyTenFive.booleanValue()) {
            if (l2 < 0L) {
                return CharStreamHeaderGenerator.writeEOFMarker(objectOutput);
            }
            return 0;
        }
        return CHARHDRGEN.writeEOF(objectOutput, l2);
    }

    @Override
    public int getMaxHeaderLength() {
        return 5;
    }

    private void determineHeaderFormat() {
        DatabaseContext databaseContext = (DatabaseContext)ClobStreamHeaderGenerator.getContext("Database");
        if (databaseContext == null) {
            throw new IllegalStateException("No context, unable to determine which stream header format to generate");
        }
        DataDictionary dataDictionary = databaseContext.getDatabase().getDataDictionary();
        try {
            this.isPreDerbyTenFive = !dataDictionary.checkVersion(170, null);
        }
        catch (StandardException standardException) {
            IllegalStateException illegalStateException = new IllegalStateException(standardException.getMessage());
            illegalStateException.initCause(standardException);
            throw illegalStateException;
        }
        this.callbackDVD.setStreamHeaderFormat(this.isPreDerbyTenFive);
    }

    private static Context getContext(final String string) {
        if (System.getSecurityManager() == null) {
            return ContextService.getContext(string);
        }
        return AccessController.doPrivileged(new PrivilegedAction<Context>(){

            @Override
            public Context run() {
                return ContextService.getContext(string);
            }
        });
    }
}

