/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.ObjectOutput;
import org.apache.derby.iapi.types.StreamHeaderGenerator;

public final class CharStreamHeaderGenerator
implements StreamHeaderGenerator {
    private static final byte[] DERBY_EOF_MARKER = new byte[]{-32, 0, 0};
    private static final int MAX_ENCODABLE_LENGTH = 65535;

    @Override
    public boolean expectsCharCount() {
        return false;
    }

    public static int writeEOFMarker(byte[] byArray, int n2) {
        System.arraycopy(DERBY_EOF_MARKER, 0, byArray, n2, DERBY_EOF_MARKER.length);
        return DERBY_EOF_MARKER.length;
    }

    public static int writeEOFMarker(ObjectOutput objectOutput) throws IOException {
        objectOutput.write(DERBY_EOF_MARKER);
        return DERBY_EOF_MARKER.length;
    }

    @Override
    public int generateInto(byte[] byArray, int n2, long l2) {
        if (l2 > 0L && l2 <= 65535L) {
            byArray[n2] = (byte)(l2 >>> 8);
            byArray[n2 + 1] = (byte)(l2 >>> 0);
        } else {
            byArray[n2] = 0;
            byArray[n2 + 1] = 0;
        }
        return 2;
    }

    @Override
    public int generateInto(ObjectOutput objectOutput, long l2) throws IOException {
        if (l2 > 0L && l2 <= 65535L) {
            objectOutput.writeByte((byte)(l2 >>> 8));
            objectOutput.writeByte((byte)(l2 >>> 0));
        } else {
            objectOutput.writeByte(0);
            objectOutput.writeByte(0);
        }
        return 2;
    }

    @Override
    public int writeEOF(byte[] byArray, int n2, long l2) {
        if (l2 < 0L || l2 > 65535L) {
            System.arraycopy(DERBY_EOF_MARKER, 0, byArray, n2, DERBY_EOF_MARKER.length);
            return DERBY_EOF_MARKER.length;
        }
        return 0;
    }

    @Override
    public int writeEOF(ObjectOutput objectOutput, long l2) throws IOException {
        if (l2 < 0L || l2 > 65535L) {
            objectOutput.write(DERBY_EOF_MARKER);
            return DERBY_EOF_MARKER.length;
        }
        return 0;
    }

    @Override
    public int getMaxHeaderLength() {
        return 2;
    }
}

