/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.store.raw;

import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.store.access.Qualifier;

public final class FetchDescriptor {
    private int row_length;
    private FormatableBitSet validColumns;
    private Qualifier[][] qualifier_list;
    private int[] materialized_cols;
    private int maxFetchColumnId;
    private static final int ZERO_FILL_LENGTH = 100;
    private static final int[] zero_fill_array = new int[100];
    private int[] validColumnsArray;

    FetchDescriptor() {
    }

    public FetchDescriptor(int n2) {
        this.row_length = n2;
    }

    public FetchDescriptor(int n2, int n3) {
        this.row_length = n2;
        this.maxFetchColumnId = n3;
        this.validColumnsArray = new int[this.maxFetchColumnId + 1];
        this.validColumnsArray[n3] = 1;
    }

    public FetchDescriptor(int n2, FormatableBitSet formatableBitSet, Qualifier[][] qualifierArray) {
        this.row_length = n2;
        this.qualifier_list = qualifierArray;
        if (this.qualifier_list != null) {
            this.materialized_cols = new int[this.row_length];
        }
        this.setValidColumns(formatableBitSet);
    }

    public final FormatableBitSet getValidColumns() {
        return this.validColumns;
    }

    public final int[] getValidColumnsArray() {
        return this.validColumnsArray;
    }

    public final void setValidColumns(FormatableBitSet formatableBitSet) {
        this.validColumns = formatableBitSet;
        this.setMaxFetchColumnId();
        if (this.validColumns != null) {
            this.validColumnsArray = new int[this.maxFetchColumnId + 1];
            for (int i2 = this.maxFetchColumnId; i2 >= 0; --i2) {
                this.validColumnsArray[i2] = this.validColumns.isSet(i2) ? 1 : 0;
            }
        }
    }

    public final Qualifier[][] getQualifierList() {
        return this.qualifier_list;
    }

    public final int[] getMaterializedColumns() {
        return this.materialized_cols;
    }

    public final int getMaxFetchColumnId() {
        return this.maxFetchColumnId;
    }

    private final void setMaxFetchColumnId() {
        this.maxFetchColumnId = this.row_length - 1;
        if (this.validColumns != null) {
            int n2 = this.validColumns.getLength();
            if (n2 < this.maxFetchColumnId + 1) {
                this.maxFetchColumnId = n2 - 1;
            }
            while (this.maxFetchColumnId >= 0 && !this.validColumns.isSet(this.maxFetchColumnId)) {
                --this.maxFetchColumnId;
            }
        }
    }

    public final void reset() {
        int[] nArray = this.materialized_cols;
        if (nArray != null) {
            if (nArray.length <= 100) {
                System.arraycopy(zero_fill_array, 0, nArray, 0, nArray.length);
            } else {
                int n2 = 0;
                int n3 = nArray.length;
                while (n3 > 0) {
                    int n4 = n3 > zero_fill_array.length ? zero_fill_array.length : n3;
                    System.arraycopy(zero_fill_array, 0, nArray, n2, n4);
                    n3 -= n4;
                    n2 += n4;
                }
            }
        }
    }
}

