/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.store.access;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.store.access.DiskHashtable;
import org.apache.derby.iapi.store.access.KeyHasher;
import org.apache.derby.iapi.store.access.RowSource;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.LocatedRow;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.util.PropertyUtil;

public class BackingStoreHashtable {
    private TransactionController tc;
    private HashMap<Object, Object> hash_table;
    private int[] key_column_numbers;
    private boolean remove_duplicates;
    private boolean skipNullKeyColumns;
    private Properties auxillary_runtimestats;
    private RowSource row_source;
    private long max_inmemory_rowcnt;
    private long inmemory_rowcnt;
    private long max_inmemory_size;
    private boolean keepAfterCommit;
    private static final int ARRAY_LIST_SIZE = ClassSize.estimateBaseFromCatalog(ArrayList.class);
    private DiskHashtable diskHashtable;

    private BackingStoreHashtable() {
    }

    public BackingStoreHashtable(TransactionController transactionController, RowSource rowSource, int[] nArray, boolean bl2, long l2, long l3, int n2, float f2, boolean bl3, boolean bl4) throws StandardException {
        this.key_column_numbers = nArray;
        this.remove_duplicates = bl2;
        this.row_source = rowSource;
        this.skipNullKeyColumns = bl3;
        this.max_inmemory_rowcnt = l3;
        this.max_inmemory_size = l3 > 0L ? Long.MAX_VALUE : Runtime.getRuntime().totalMemory() / 100L;
        this.tc = transactionController;
        this.keepAfterCommit = bl4;
        if (n2 != -1) {
            this.hash_table = f2 == -1.0f ? new HashMap(n2) : new HashMap(n2, f2);
        } else {
            HashMap<Object, Object> hashMap = l2 <= 0L || rowSource == null ? new HashMap() : (this.hash_table = l2 < this.max_inmemory_size ? new HashMap((int)l2) : null);
        }
        if (rowSource != null) {
            DataValueDescriptor[] dataValueDescriptorArray;
            boolean bl5 = rowSource.needsToClone();
            while ((dataValueDescriptorArray = this.getNextRowFromRowSource()) != null) {
                if (this.hash_table == null) {
                    double d2 = this.getEstimatedMemUsage(dataValueDescriptorArray);
                    this.hash_table = new HashMap((int)((double)this.max_inmemory_size / d2));
                }
                this.add_row_to_hash_table(dataValueDescriptorArray, null, bl5);
            }
        }
        if (this.hash_table == null) {
            this.hash_table = new HashMap();
        }
    }

    public boolean includeRowLocations() {
        return false;
    }

    private DataValueDescriptor[] getNextRowFromRowSource() throws StandardException {
        DataValueDescriptor[] dataValueDescriptorArray = this.row_source.getNextRowFromRowSource();
        if (this.skipNullKeyColumns) {
            while (dataValueDescriptorArray != null) {
                int n2;
                for (n2 = 0; n2 < this.key_column_numbers.length && !dataValueDescriptorArray[this.key_column_numbers[n2]].isNull(); ++n2) {
                }
                if (n2 == this.key_column_numbers.length) {
                    return dataValueDescriptorArray;
                }
                dataValueDescriptorArray = this.row_source.getNextRowFromRowSource();
            }
        }
        return dataValueDescriptorArray;
    }

    private static DataValueDescriptor[] cloneRow(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        DataValueDescriptor[] dataValueDescriptorArray2 = new DataValueDescriptor[dataValueDescriptorArray.length];
        for (int i2 = 0; i2 < dataValueDescriptorArray.length; ++i2) {
            if (dataValueDescriptorArray[i2] == null) continue;
            dataValueDescriptorArray2[i2] = dataValueDescriptorArray[i2].cloneValue(false);
        }
        return dataValueDescriptorArray2;
    }

    static DataValueDescriptor[] shallowCloneRow(DataValueDescriptor[] dataValueDescriptorArray) throws StandardException {
        DataValueDescriptor[] dataValueDescriptorArray2 = new DataValueDescriptor[dataValueDescriptorArray.length];
        for (int i2 = 0; i2 < dataValueDescriptorArray.length; ++i2) {
            if (dataValueDescriptorArray[i2] == null) continue;
            dataValueDescriptorArray2[i2] = dataValueDescriptorArray[i2].cloneHolder();
        }
        return dataValueDescriptorArray2;
    }

    private void add_row_to_hash_table(DataValueDescriptor[] dataValueDescriptorArray, RowLocation rowLocation, boolean bl2) throws StandardException {
        Object object;
        Object object2;
        Object object3;
        if (this.spillToDisk(dataValueDescriptorArray, rowLocation)) {
            return;
        }
        if (bl2) {
            dataValueDescriptorArray = BackingStoreHashtable.cloneRow(dataValueDescriptorArray);
        }
        if ((object3 = this.hash_table.put(object2 = KeyHasher.buildHashKey(dataValueDescriptorArray, this.key_column_numbers), object = !this.includeRowLocations() ? dataValueDescriptorArray : new LocatedRow(dataValueDescriptorArray, rowLocation))) == null) {
            this.doSpaceAccounting(object, false);
        } else if (!this.remove_duplicates) {
            RowList rowList;
            if (object3 instanceof RowList) {
                this.doSpaceAccounting(object, false);
                rowList = (RowList)object3;
            } else {
                rowList = new RowList(2);
                rowList.add(object3);
                this.doSpaceAccounting(object, true);
            }
            rowList.add(object);
            this.hash_table.put(object2, rowList);
        }
    }

    private void doSpaceAccounting(Object object, boolean bl2) {
        ++this.inmemory_rowcnt;
        if (this.max_inmemory_rowcnt <= 0L) {
            this.max_inmemory_size -= this.getEstimatedMemUsage(object);
            if (bl2) {
                this.max_inmemory_size -= (long)ARRAY_LIST_SIZE;
            }
        }
    }

    private boolean spillToDisk(DataValueDescriptor[] dataValueDescriptorArray, RowLocation rowLocation) throws StandardException {
        Object object;
        Object object2;
        Object[] objectArray = null;
        if (this.diskHashtable == null) {
            if (this.max_inmemory_rowcnt > 0L ? this.inmemory_rowcnt < this.max_inmemory_rowcnt : this.max_inmemory_size > this.getEstimatedMemUsage(!this.includeRowLocations() ? dataValueDescriptorArray : new LocatedRow(dataValueDescriptorArray, rowLocation))) {
                return false;
            }
            objectArray = this.makeDiskRow(dataValueDescriptorArray, rowLocation);
            this.diskHashtable = new DiskHashtable(this.tc, (DataValueDescriptor[])objectArray, null, this.key_column_numbers, this.remove_duplicates, this.keepAfterCommit);
        }
        if ((object2 = this.hash_table.get(object = KeyHasher.buildHashKey(dataValueDescriptorArray, this.key_column_numbers))) != null) {
            if (this.remove_duplicates) {
                return true;
            }
            if (object2 instanceof List) {
                List list = (List)object2;
                for (int i2 = list.size() - 1; i2 >= 0; --i2) {
                    this.diskHashtable.put(object, this.makeDiskRow(list.get(i2)));
                }
            } else {
                this.diskHashtable.put(object, this.makeDiskRow(object2));
            }
            this.hash_table.remove(object);
        }
        if (objectArray == null) {
            objectArray = this.makeDiskRow(dataValueDescriptorArray, rowLocation);
        }
        this.diskHashtable.put(object, objectArray);
        return true;
    }

    private DataValueDescriptor[] makeDiskRow(Object object) {
        DataValueDescriptor[] dataValueDescriptorArray = null;
        if (this.includeRowLocations()) {
            LocatedRow locatedRow = (LocatedRow)object;
            dataValueDescriptorArray = this.makeDiskRow(locatedRow.columnValues(), locatedRow.rowLocation());
        } else {
            dataValueDescriptorArray = (DataValueDescriptor[])object;
        }
        return dataValueDescriptorArray;
    }

    private List makeInMemoryRows(List list) {
        if (!this.includeRowLocations()) {
            return list;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object e2 : list) {
            arrayList.add(this.makeInMemoryRow((DataValueDescriptor[])e2));
        }
        return arrayList;
    }

    private Object makeInMemoryRow(DataValueDescriptor[] dataValueDescriptorArray) {
        if (!this.includeRowLocations()) {
            return dataValueDescriptorArray;
        }
        return new LocatedRow(dataValueDescriptorArray);
    }

    private DataValueDescriptor[] makeDiskRow(DataValueDescriptor[] dataValueDescriptorArray, RowLocation rowLocation) {
        if (!this.includeRowLocations()) {
            return dataValueDescriptorArray;
        }
        return LocatedRow.flatten(dataValueDescriptorArray, rowLocation);
    }

    private long getEstimatedMemUsage(Object object) {
        long l2 = 0L;
        DataValueDescriptor[] dataValueDescriptorArray = null;
        if (object instanceof DataValueDescriptor[]) {
            dataValueDescriptorArray = (DataValueDescriptor[])object;
        } else {
            LocatedRow locatedRow = (LocatedRow)object;
            dataValueDescriptorArray = locatedRow.columnValues();
            RowLocation rowLocation = locatedRow.rowLocation();
            if (rowLocation != null) {
                l2 += (long)locatedRow.rowLocation().estimateMemoryUsage();
                l2 += (long)ClassSize.refSize;
            }
            l2 += (long)ClassSize.refSize;
        }
        for (int i2 = 0; i2 < dataValueDescriptorArray.length; ++i2) {
            l2 += (long)dataValueDescriptorArray[i2].estimateMemoryUsage();
            l2 += (long)ClassSize.refSize;
        }
        return l2 += (long)ClassSize.refSize;
    }

    public void close() throws StandardException {
        this.hash_table = null;
        if (this.diskHashtable != null) {
            this.diskHashtable.close();
            this.diskHashtable = null;
        }
    }

    public Enumeration<Object> elements() throws StandardException {
        if (this.diskHashtable == null) {
            return Collections.enumeration(this.hash_table.values());
        }
        return new BackingStoreHashtableEnumeration();
    }

    public Object get(Object object) throws StandardException {
        Object object2 = this.hash_table.get(object);
        if (this.diskHashtable == null || object2 != null) {
            return object2;
        }
        Object object3 = this.diskHashtable.get(object);
        if (object3 == null) {
            return null;
        }
        if (object3 instanceof List) {
            return this.makeInMemoryRows((List)object3);
        }
        return this.makeInMemoryRow((DataValueDescriptor[])object3);
    }

    public void getAllRuntimeStats(Properties properties) throws StandardException {
        if (this.auxillary_runtimestats != null) {
            PropertyUtil.copyProperties(this.auxillary_runtimestats, properties);
        }
    }

    public Object remove(Object object) throws StandardException {
        Object object2 = this.hash_table.remove(object);
        if (object2 != null || this.diskHashtable == null) {
            return object2;
        }
        return this.diskHashtable.remove(object);
    }

    public void setAuxillaryRuntimeStats(Properties properties) throws StandardException {
        this.auxillary_runtimestats = properties;
    }

    public boolean putRow(boolean bl2, DataValueDescriptor[] dataValueDescriptorArray, RowLocation rowLocation) throws StandardException {
        if (this.skipNullKeyColumns) {
            for (int i2 = 0; i2 < this.key_column_numbers.length; ++i2) {
                if (!dataValueDescriptorArray[this.key_column_numbers[i2]].isNull()) continue;
                return false;
            }
        }
        Object object = KeyHasher.buildHashKey(dataValueDescriptorArray, this.key_column_numbers);
        if (this.remove_duplicates && this.get(object) != null) {
            return false;
        }
        this.add_row_to_hash_table(dataValueDescriptorArray, rowLocation, bl2);
        return true;
    }

    public int size() throws StandardException {
        if (this.diskHashtable == null) {
            return this.hash_table.size();
        }
        return this.hash_table.size() + this.diskHashtable.size();
    }

    private static class RowList
    extends ArrayList<Object> {
        private RowList(int n2) {
            super(n2);
        }
    }

    private class BackingStoreHashtableEnumeration
    implements Enumeration<Object> {
        private Iterator<Object> memoryIterator;
        private Enumeration<Object> diskEnumeration;

        BackingStoreHashtableEnumeration() {
            this.memoryIterator = BackingStoreHashtable.this.hash_table.values().iterator();
            if (BackingStoreHashtable.this.diskHashtable != null) {
                try {
                    this.diskEnumeration = BackingStoreHashtable.this.diskHashtable.elements();
                }
                catch (StandardException standardException) {
                    this.diskEnumeration = null;
                }
            }
        }

        @Override
        public boolean hasMoreElements() {
            if (this.memoryIterator != null) {
                if (this.memoryIterator.hasNext()) {
                    return true;
                }
                this.memoryIterator = null;
            }
            if (this.diskEnumeration == null) {
                return false;
            }
            return this.diskEnumeration.hasMoreElements();
        }

        @Override
        public Object nextElement() throws NoSuchElementException {
            if (this.memoryIterator != null) {
                if (this.memoryIterator.hasNext()) {
                    return this.memoryIterator.next();
                }
                this.memoryIterator = null;
            }
            return BackingStoreHashtable.this.makeInMemoryRow((DataValueDescriptor[])this.diskEnumeration.nextElement());
        }
    }
}

