/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Timestamp;
import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.Context;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.io.ArrayUtil;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.Parser;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Dependent;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SPSDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.UniqueSQLObjectDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataTypeUtilities;

public class TriggerDescriptor
extends UniqueSQLObjectDescriptor
implements Formatable,
Dependent,
Provider {
    public static final int SYSTRIGGERS_STATE_FIELD = 8;
    public static final int TRIGGER_EVENT_UPDATE = 1;
    public static final int TRIGGER_EVENT_DELETE = 2;
    public static final int TRIGGER_EVENT_INSERT = 4;
    private UUID id;
    private String name;
    private String oldReferencingName;
    private String newReferencingName;
    private String triggerDefinition;
    private SchemaDescriptor sd;
    private int eventMask;
    private boolean isBefore;
    private boolean isRow;
    private boolean referencingOld;
    private boolean referencingNew;
    private TableDescriptor td;
    private UUID actionSPSId;
    private SPSDescriptor actionSPS;
    private UUID whenSPSId;
    private SPSDescriptor whenSPS;
    private boolean isEnabled;
    private int[] referencedCols;
    private int[] referencedColsInTriggerAction;
    private Timestamp creationTimestamp;
    private UUID triggerSchemaId;
    private UUID triggerTableId;
    private String whenClauseText;

    public TriggerDescriptor() {
    }

    TriggerDescriptor(DataDictionary dataDictionary, SchemaDescriptor schemaDescriptor, UUID uUID, String string, int n2, boolean bl2, boolean bl3, boolean bl4, TableDescriptor tableDescriptor, UUID uUID2, UUID uUID3, Timestamp timestamp, int[] nArray, int[] nArray2, String string2, boolean bl5, boolean bl6, String string3, String string4, String string5) {
        super(dataDictionary);
        this.id = uUID;
        this.sd = schemaDescriptor;
        this.name = string;
        this.eventMask = n2;
        this.isBefore = bl2;
        this.isRow = bl3;
        this.td = tableDescriptor;
        this.actionSPSId = uUID3;
        this.whenSPSId = uUID2;
        this.isEnabled = bl4;
        this.referencedCols = nArray;
        this.setReferencedColsInTriggerAction(nArray2);
        this.creationTimestamp = DataTypeUtilities.clone(timestamp);
        this.triggerDefinition = string2;
        this.referencingOld = bl5;
        this.referencingNew = bl6;
        this.oldReferencingName = string3;
        this.newReferencingName = string4;
        this.whenClauseText = string5;
        this.triggerSchemaId = schemaDescriptor.getUUID();
        this.triggerTableId = tableDescriptor.getUUID();
    }

    @Override
    public UUID getUUID() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public UUID getTableId() {
        return this.triggerTableId;
    }

    @Override
    public SchemaDescriptor getSchemaDescriptor() throws StandardException {
        if (this.sd == null) {
            this.sd = this.getDataDictionary().getSchemaDescriptor(this.triggerSchemaId, null);
        }
        return this.sd;
    }

    public boolean listensForEvent(int n2) {
        return (n2 & this.eventMask) == n2;
    }

    public int getTriggerEventMask() {
        return this.eventMask;
    }

    public Timestamp getCreationTimestamp() {
        return DataTypeUtilities.clone(this.creationTimestamp);
    }

    public boolean isBeforeTrigger() {
        return this.isBefore;
    }

    public boolean isRowTrigger() {
        return this.isRow;
    }

    public UUID getActionId() {
        return this.actionSPSId;
    }

    public SPSDescriptor getActionSPS(LanguageConnectionContext languageConnectionContext) throws StandardException {
        return this.getSPS(languageConnectionContext, false);
    }

    private SPSDescriptor getSPS(LanguageConnectionContext languageConnectionContext, boolean bl2) throws StandardException {
        boolean bl3;
        boolean bl4;
        String string;
        DataDictionary dataDictionary = this.getDataDictionary();
        SPSDescriptor sPSDescriptor = bl2 ? this.whenSPS : this.actionSPS;
        UUID uUID = bl2 ? this.whenSPSId : this.actionSPSId;
        String string2 = string = bl2 ? this.whenClauseText : this.triggerDefinition;
        if (sPSDescriptor == null) {
            languageConnectionContext.beginNestedTransaction(true);
            sPSDescriptor = dataDictionary.getSPSDescriptor(uUID);
            languageConnectionContext.commitNestedTransaction();
        }
        boolean bl5 = (bl4 = dataDictionary.checkVersion(210, null)) ? this.referencedColsInTriggerAction != null : (bl3 = this.referencingOld || this.referencingNew);
        if ((!sPSDescriptor.isValid() || sPSDescriptor.getPreparedStatement() == null) && this.isRow && bl3) {
            CompilerContext compilerContext = languageConnectionContext.pushCompilerContext(dataDictionary.getSchemaDescriptor(sPSDescriptor.getCompSchemaId(), null));
            Parser parser = compilerContext.getParser();
            Visitable visitable = bl2 ? parser.parseSearchCondition(string) : parser.parseStatement(string);
            languageConnectionContext.popCompilerContext(compilerContext);
            int[] nArray = dataDictionary.examineTriggerNodeAndCols(visitable, this.oldReferencingName, this.newReferencingName, string, this.referencedCols, this.referencedColsInTriggerAction, 0, this.getTableDescriptor(), -1, false, null);
            String string3 = dataDictionary.getTriggerActionString(visitable, this.oldReferencingName, this.newReferencingName, string, this.referencedCols, this.referencedColsInTriggerAction, 0, this.getTableDescriptor(), -1, false, null, nArray);
            if (bl2) {
                string3 = "VALUES " + string3;
            }
            sPSDescriptor.setText(string3);
        }
        return sPSDescriptor;
    }

    public UUID getWhenClauseId() {
        return this.whenSPSId;
    }

    public String getWhenClauseText() {
        return this.whenClauseText;
    }

    public SPSDescriptor getWhenClauseSPS(LanguageConnectionContext languageConnectionContext) throws StandardException {
        if (this.whenSPSId == null) {
            return null;
        }
        return this.getSPS(languageConnectionContext, true);
    }

    public TableDescriptor getTableDescriptor() throws StandardException {
        if (this.td == null) {
            this.td = this.getDataDictionary().getTableDescriptor(this.triggerTableId);
        }
        return this.td;
    }

    public int[] getReferencedCols() {
        return ArrayUtil.copy(this.referencedCols);
    }

    public void setReferencedCols(int[] nArray) {
        this.referencedCols = ArrayUtil.copy(nArray);
    }

    public int[] getReferencedColsInTriggerAction() {
        return ArrayUtil.copy(this.referencedColsInTriggerAction);
    }

    public void setReferencedColsInTriggerAction(int[] nArray) {
        this.referencedColsInTriggerAction = ArrayUtil.copy(nArray);
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled() {
        this.isEnabled = true;
    }

    public void setDisabled() {
        this.isEnabled = false;
    }

    public boolean needsToFire(int n2, int[] nArray) throws StandardException {
        if (!this.isEnabled) {
            return false;
        }
        if (n2 == 1) {
            return (this.eventMask & 4) == this.eventMask;
        }
        if (n2 == 4) {
            return (this.eventMask & 2) == this.eventMask;
        }
        if (n2 == 2) {
            throw StandardException.newException("42Z08", this.getTableDescriptor().getQualifiedName(), this.name);
        }
        return (this.eventMask & 1) == this.eventMask && ConstraintDescriptor.doColumnsIntersect(nArray, this.referencedCols);
    }

    public String getTriggerDefinition() {
        return this.triggerDefinition;
    }

    public boolean getReferencingOld() {
        return this.referencingOld;
    }

    public boolean getReferencingNew() {
        return this.referencingNew;
    }

    public String getOldReferencingName() {
        return this.oldReferencingName;
    }

    public String getNewReferencingName() {
        return this.newReferencingName;
    }

    public String toString() {
        return "";
    }

    @Override
    public DependableFinder getDependableFinder() {
        return this.getDependableFinder(320);
    }

    @Override
    public String getObjectName() {
        return this.name;
    }

    @Override
    public UUID getObjectID() {
        return this.id;
    }

    @Override
    public String getClassType() {
        return "Trigger";
    }

    @Override
    public synchronized boolean isValid() {
        return true;
    }

    @Override
    public void prepareToInvalidate(Provider provider, int n2, LanguageConnectionContext languageConnectionContext) throws StandardException {
        switch (n2) {
            case 1: 
            case 6: 
            case 9: 
            case 13: 
            case 34: 
            case 43: 
            case 45: {
                DependencyManager dependencyManager = this.getDataDictionary().getDependencyManager();
                throw StandardException.newException("X0Y25.S", dependencyManager.getActionString(n2), provider.getObjectName(), "TRIGGER", this.name);
            }
        }
    }

    @Override
    public void makeInvalid(int n2, LanguageConnectionContext languageConnectionContext) throws StandardException {
        switch (n2) {
            case 14: {
                DependencyManager dependencyManager = this.getDataDictionary().getDependencyManager();
                dependencyManager.invalidateFor(this, 11, languageConnectionContext);
                break;
            }
            case 44: 
            case 47: {
                this.drop(languageConnectionContext);
                languageConnectionContext.getLastActivation().addWarning(StandardException.newWarning("01502", this.getObjectName()));
                break;
            }
        }
    }

    public void drop(LanguageConnectionContext languageConnectionContext) throws StandardException {
        DataDictionary dataDictionary = this.getDataDictionary();
        DependencyManager dependencyManager = this.getDataDictionary().getDependencyManager();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        dependencyManager.invalidateFor(this, 27, languageConnectionContext);
        dataDictionary.dropTriggerDescriptor(this, transactionController);
        dependencyManager.clearDependencies(languageConnectionContext, this);
        SPSDescriptor sPSDescriptor = dataDictionary.getSPSDescriptor(this.getActionId());
        dependencyManager.invalidateFor(sPSDescriptor, 27, languageConnectionContext);
        dependencyManager.clearDependencies(languageConnectionContext, sPSDescriptor);
        dataDictionary.dropSPSDescriptor(sPSDescriptor, transactionController);
        if (this.getWhenClauseId() != null) {
            sPSDescriptor = dataDictionary.getSPSDescriptor(this.getWhenClauseId());
            dependencyManager.invalidateFor(sPSDescriptor, 27, languageConnectionContext);
            dependencyManager.clearDependencies(languageConnectionContext, sPSDescriptor);
            dataDictionary.dropSPSDescriptor(sPSDescriptor, transactionController);
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n2;
        this.id = (UUID)objectInput.readObject();
        this.name = (String)objectInput.readObject();
        this.triggerSchemaId = (UUID)objectInput.readObject();
        this.triggerTableId = (UUID)objectInput.readObject();
        this.eventMask = objectInput.readInt();
        this.isBefore = objectInput.readBoolean();
        this.isRow = objectInput.readBoolean();
        this.isEnabled = objectInput.readBoolean();
        this.whenSPSId = (UUID)objectInput.readObject();
        this.actionSPSId = (UUID)objectInput.readObject();
        int n3 = objectInput.readInt();
        if (n3 != 0) {
            this.referencedCols = new int[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                this.referencedCols[n2] = objectInput.readInt();
            }
        }
        if ((n3 = objectInput.readInt()) != 0) {
            this.referencedColsInTriggerAction = new int[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                this.referencedColsInTriggerAction[n2] = objectInput.readInt();
            }
        }
        this.triggerDefinition = (String)objectInput.readObject();
        this.referencingOld = objectInput.readBoolean();
        this.referencingNew = objectInput.readBoolean();
        this.oldReferencingName = (String)objectInput.readObject();
        this.newReferencingName = (String)objectInput.readObject();
        this.whenClauseText = (String)objectInput.readObject();
    }

    @Override
    protected DataDictionary getDataDictionary() {
        DataDictionary dataDictionary = super.getDataDictionary();
        if (dataDictionary == null) {
            LanguageConnectionContext languageConnectionContext = (LanguageConnectionContext)TriggerDescriptor.getContext("LanguageConnectionContext");
            dataDictionary = languageConnectionContext.getDataDictionary();
            this.setDataDictionary(dataDictionary);
        }
        return dataDictionary;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n2;
        objectOutput.writeObject(this.id);
        objectOutput.writeObject(this.name);
        objectOutput.writeObject(this.triggerSchemaId);
        objectOutput.writeObject(this.triggerTableId);
        objectOutput.writeInt(this.eventMask);
        objectOutput.writeBoolean(this.isBefore);
        objectOutput.writeBoolean(this.isRow);
        objectOutput.writeBoolean(this.isEnabled);
        objectOutput.writeObject(this.whenSPSId);
        objectOutput.writeObject(this.actionSPSId);
        if (this.referencedCols == null) {
            objectOutput.writeInt(0);
        } else {
            objectOutput.writeInt(this.referencedCols.length);
            for (n2 = 0; n2 < this.referencedCols.length; ++n2) {
                objectOutput.writeInt(this.referencedCols[n2]);
            }
        }
        if (this.referencedColsInTriggerAction == null) {
            objectOutput.writeInt(0);
        } else {
            objectOutput.writeInt(this.referencedColsInTriggerAction.length);
            for (n2 = 0; n2 < this.referencedColsInTriggerAction.length; ++n2) {
                objectOutput.writeInt(this.referencedColsInTriggerAction[n2]);
            }
        }
        objectOutput.writeObject(this.triggerDefinition);
        objectOutput.writeBoolean(this.referencingOld);
        objectOutput.writeBoolean(this.referencingNew);
        objectOutput.writeObject(this.oldReferencingName);
        objectOutput.writeObject(this.newReferencingName);
        objectOutput.writeObject(this.whenClauseText);
    }

    @Override
    public int getTypeFormatId() {
        return 316;
    }

    @Override
    public String getDescriptorType() {
        return "Trigger";
    }

    @Override
    public String getDescriptorName() {
        return this.name;
    }

    private static Context getContext(final String string) {
        if (System.getSecurityManager() == null) {
            return ContextService.getContext(string);
        }
        return AccessController.doPrivileged(new PrivilegedAction<Context>(){

            @Override
            public Context run() {
                return ContextService.getContext(string);
            }
        });
    }
}

